/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.designer.tools;

import com.jaspersoft.ireport.designer.IReportManager;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.filechooser.FileFilter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassPathDialog
extends JDialog {
    private int dialogResult = 2;
    private boolean modifiedPath = false;
    private JButton jButtonAdd;
    private JButton jButtonAdd1;
    private JButton jButtonCancel;
    private JButton jButtonMoveDown;
    private JButton jButtonMoveUp;
    private JButton jButtonRemove;
    private JButton jButtonSave;
    private JLabel jLabelClasspath;
    private JList jList1;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JScrollPane jScrollPane1;

    public ClassPathDialog(Dialog parent, boolean modal) {
        super(parent, modal);
        this.initAll();
    }

    public ClassPathDialog(Frame parent, boolean modal) {
        super(parent, modal);
        this.initAll();
    }

    public void initAll() {
        this.initComponents();
        this.jList1.setModel(new DefaultListModel());
        this.setLocationRelativeTo(null);
        KeyStroke escape = KeyStroke.getKeyStroke(27, 0, false);
        AbstractAction escapeAction = new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                ClassPathDialog.this.jButtonCancelActionPerformed(e);
            }
        };
        this.getRootPane().getInputMap(2).put(escape, "ESCAPE");
        this.getRootPane().getActionMap().put("ESCAPE", escapeAction);
        this.getRootPane().setDefaultButton(this.jButtonSave);
    }

    private void initComponents() {
        this.jLabelClasspath = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.jList1 = new JList();
        this.jPanel1 = new JPanel();
        this.jButtonAdd = new JButton();
        this.jButtonAdd1 = new JButton();
        this.jButtonRemove = new JButton();
        this.jButtonMoveUp = new JButton();
        this.jButtonMoveDown = new JButton();
        this.jPanel2 = new JPanel();
        this.jButtonSave = new JButton();
        this.jButtonCancel = new JButton();
        this.setDefaultCloseOperation(0);
        this.setTitle("IReport classpath");
        this.addWindowListener(new WindowAdapter(){

            public void windowClosed(WindowEvent evt) {
                ClassPathDialog.this.formWindowClosed(evt);
            }

            public void windowClosing(WindowEvent evt) {
                ClassPathDialog.this.formWindowClosing(evt);
            }
        });
        this.getContentPane().setLayout(new GridBagLayout());
        this.jLabelClasspath.setHorizontalAlignment(2);
        this.jLabelClasspath.setText("Classpath");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.ipadx = 1;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.jLabelClasspath, gridBagConstraints);
        this.jScrollPane1.setPreferredSize(new Dimension(359, 260));
        this.jScrollPane1.setViewportView(this.jList1);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 4, 4, 4);
        this.getContentPane().add((Component)this.jScrollPane1, gridBagConstraints);
        this.jPanel1.setMinimumSize(new Dimension(120, 10));
        this.jPanel1.setPreferredSize(new Dimension(120, 10));
        this.jPanel1.setLayout(new GridBagLayout());
        this.jButtonAdd.setText("Add JAR");
        this.jButtonAdd.setMaximumSize(new Dimension(200, 26));
        this.jButtonAdd.setMinimumSize(new Dimension(90, 26));
        this.jButtonAdd.setPreferredSize(new Dimension(120, 26));
        this.jButtonAdd.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ClassPathDialog.this.jButtonAddActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 4, 0);
        this.jPanel1.add((Component)this.jButtonAdd, gridBagConstraints);
        this.jButtonAdd1.setText("Add Folder");
        this.jButtonAdd1.setMaximumSize(new Dimension(200, 26));
        this.jButtonAdd1.setMinimumSize(new Dimension(90, 26));
        this.jButtonAdd1.setPreferredSize(new Dimension(120, 26));
        this.jButtonAdd1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ClassPathDialog.this.jButtonAddActionPerformed1(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 4, 0);
        this.jPanel1.add((Component)this.jButtonAdd1, gridBagConstraints);
        this.jButtonRemove.setText("Remove");
        this.jButtonRemove.setMaximumSize(new Dimension(200, 26));
        this.jButtonRemove.setMinimumSize(new Dimension(90, 26));
        this.jButtonRemove.setPreferredSize(new Dimension(120, 26));
        this.jButtonRemove.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ClassPathDialog.this.jButtonRemoveActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 4, 0);
        this.jPanel1.add((Component)this.jButtonRemove, gridBagConstraints);
        this.jButtonMoveUp.setText("Move up");
        this.jButtonMoveUp.setMaximumSize(new Dimension(200, 26));
        this.jButtonMoveUp.setMinimumSize(new Dimension(90, 26));
        this.jButtonMoveUp.setPreferredSize(new Dimension(120, 26));
        this.jButtonMoveUp.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ClassPathDialog.this.jButtonMoveUpActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 4, 0);
        this.jPanel1.add((Component)this.jButtonMoveUp, gridBagConstraints);
        this.jButtonMoveDown.setText("Move down");
        this.jButtonMoveDown.setMaximumSize(new Dimension(200, 26));
        this.jButtonMoveDown.setMinimumSize(new Dimension(90, 26));
        this.jButtonMoveDown.setPreferredSize(new Dimension(120, 26));
        this.jButtonMoveDown.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ClassPathDialog.this.jButtonMoveDownActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 4, 0);
        this.jPanel1.add((Component)this.jButtonMoveDown, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.weighty = 1.0;
        this.jPanel1.add((Component)this.jPanel2, gridBagConstraints);
        this.jButtonSave.setText("Save classpath");
        this.jButtonSave.setMaximumSize(new Dimension(200, 26));
        this.jButtonSave.setMinimumSize(new Dimension(90, 26));
        this.jButtonSave.setPreferredSize(new Dimension(120, 26));
        this.jButtonSave.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ClassPathDialog.this.jButtonSaveActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 4, 0);
        this.jPanel1.add((Component)this.jButtonSave, gridBagConstraints);
        this.jButtonCancel.setText("Cancel");
        this.jButtonCancel.setMaximumSize(new Dimension(200, 26));
        this.jButtonCancel.setMinimumSize(new Dimension(90, 26));
        this.jButtonCancel.setPreferredSize(new Dimension(120, 26));
        this.jButtonCancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ClassPathDialog.this.jButtonCancelActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 4, 0);
        this.jPanel1.add((Component)this.jButtonCancel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 4, 4);
        this.getContentPane().add((Component)this.jPanel1, gridBagConstraints);
        this.pack();
    }

    private void jButtonAddActionPerformed1(ActionEvent evt) {
        JFileChooser jfc = new JFileChooser(IReportManager.getInstance().getCurrentDirectory());
        jfc.setDialogTitle("Add JAR(s) / path to the classpath");
        jfc.setDialogTitle("Add JAR(s) / path to the classpath");
        jfc.setAcceptAllFileFilterUsed(true);
        jfc.setFileSelectionMode(1);
        jfc.setMultiSelectionEnabled(true);
        jfc.setDialogType(0);
        if (jfc.showOpenDialog(this) == 0) {
            File[] files = jfc.getSelectedFiles();
            for (int i = 0; i < files.length; ++i) {
                ((DefaultListModel)this.jList1.getModel()).addElement(files[i]);
            }
            IReportManager.getInstance().setCurrentDirectory(jfc.getSelectedFile(), true);
            this.modifiedPath = true;
        }
    }

    private void formWindowClosed(WindowEvent evt) {
    }

    private void formWindowClosing(WindowEvent evt) {
        if (this.modifiedPath) {
            int ret = JOptionPane.showConfirmDialog(this, "Do you want save the classpath ?");
            if (ret == 2) {
                return;
            }
            if (ret == 0) {
                this.setDialogResult(0);
            }
        }
        this.setVisible(false);
    }

    private void jButtonCancelActionPerformed(ActionEvent evt) {
        this.setVisible(false);
    }

    private void jButtonSaveActionPerformed(ActionEvent evt) {
        this.setDialogResult(0);
        this.setVisible(false);
    }

    private void jButtonMoveUpActionPerformed(ActionEvent evt) {
        if (this.jList1.getSelectedValues() != null) {
            int[] indices = this.jList1.getSelectedIndices();
            for (int i = 0; i < indices.length; ++i) {
                if (indices[i] == 0) continue;
                Object val = ((DefaultListModel)this.jList1.getModel()).remove(indices[i]);
                ((DefaultListModel)this.jList1.getModel()).insertElementAt(val, indices[i] - 1);
                int n = i;
                indices[n] = indices[n] - 1;
            }
            this.jList1.setSelectedIndices(indices);
            this.modifiedPath = true;
        }
    }

    private void jButtonMoveDownActionPerformed(ActionEvent evt) {
        if (this.jList1.getSelectedValues() != null) {
            int[] indices = this.jList1.getSelectedIndices();
            for (int i = indices.length - 1; i >= 0; --i) {
                if (indices[i] >= ((DefaultListModel)this.jList1.getModel()).size() - 1) continue;
                Object val = ((DefaultListModel)this.jList1.getModel()).remove(indices[i]);
                ((DefaultListModel)this.jList1.getModel()).insertElementAt(val, indices[i] + 1);
                int n = i;
                indices[n] = indices[n] + 1;
            }
            this.jList1.setSelectedIndices(indices);
            this.modifiedPath = true;
        }
    }

    private void jButtonRemoveActionPerformed(ActionEvent evt) {
        if (this.jList1.getSelectedValues() != null) {
            Object[] values = this.jList1.getSelectedValues();
            for (int i = 0; i < values.length; ++i) {
                ((DefaultListModel)this.jList1.getModel()).removeElement(values[i]);
            }
            this.modifiedPath = true;
        }
    }

    private void jButtonAddActionPerformed(ActionEvent evt) {
        String fileName = "";
        JFileChooser jfc = new JFileChooser(IReportManager.getInstance().getCurrentDirectory());
        jfc.setDialogTitle("Add JAR(s) / path to the classpath");
        jfc.setDialogTitle("Add JAR(s) / path to the classpath");
        jfc.setAcceptAllFileFilterUsed(true);
        jfc.setFileSelectionMode(0);
        jfc.addChoosableFileFilter(new FileFilter(){

            public boolean accept(File file) {
                String filename = file.getName();
                return filename.toLowerCase().endsWith(".jar") || file.isDirectory() || filename.toLowerCase().endsWith(".zip");
            }

            public String getDescription() {
                return "*.jar, *.zip";
            }
        });
        jfc.setMultiSelectionEnabled(true);
        jfc.setDialogType(0);
        if (jfc.showOpenDialog(this) == 0) {
            File[] files = jfc.getSelectedFiles();
            for (int i = 0; i < files.length; ++i) {
                ((DefaultListModel)this.jList1.getModel()).addElement(files[i]);
            }
            IReportManager.getInstance().setCurrentDirectory(jfc.getSelectedFile(), true);
            this.modifiedPath = true;
        }
    }

    public void setClasspath(List<String> cp) {
        for (String path : cp) {
            ((DefaultListModel)this.jList1.getModel()).addElement(path);
        }
    }

    public List<String> getClasspath() {
        ArrayList<String> cp = new ArrayList<String>();
        for (int i = 0; i < ((DefaultListModel)this.jList1.getModel()).size(); ++i) {
            cp.add("" + ((DefaultListModel)this.jList1.getModel()).elementAt(i));
        }
        return cp;
    }

    public int getDialogResult() {
        return this.dialogResult;
    }

    public void setDialogResult(int dialogResult) {
        this.dialogResult = dialogResult;
    }
}

