/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.designer.outline.nodes.properties.charts;

import com.jaspersoft.ireport.designer.IReportManager;
import com.jaspersoft.ireport.designer.sheet.Tag;
import com.jaspersoft.ireport.designer.sheet.editors.ComboBoxPropertyEditor;
import com.jaspersoft.ireport.designer.undo.ObjectPropertyUndoableEdit;
import java.beans.PropertyEditor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import net.sf.jasperreports.charts.design.JRDesignThermometerPlot;
import org.openide.nodes.PropertySupport;

public final class ThermometerValueLocationProperty
extends PropertySupport {
    private final JRDesignThermometerPlot element;
    private ComboBoxPropertyEditor editor;

    public ThermometerValueLocationProperty(JRDesignThermometerPlot element) {
        super("valueLocation", Byte.class, "Value Location", "Value Location", true, true);
        this.element = element;
        this.setValue("suppressCustomEditor", Boolean.TRUE);
    }

    public PropertyEditor getPropertyEditor() {
        if (this.editor == null) {
            ArrayList<Tag> l = new ArrayList<Tag>();
            l.add(new Tag(new Byte(3), "Bulb"));
            l.add(new Tag(new Byte(1), "Left"));
            l.add(new Tag(new Byte(2), "Right"));
            l.add(new Tag(new Byte(0), "None"));
            this.editor = new ComboBoxPropertyEditor(false, l);
        }
        return this.editor;
    }

    public Object getValue() throws IllegalAccessException, InvocationTargetException {
        return new Byte(this.element.getValueLocation());
    }

    public void setValue(Object val) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        this.setPropertyValue(val);
    }

    private void setPropertyValue(Object val) {
        if (val instanceof Byte) {
            byte oldValue = this.element.getValueLocation();
            byte newValue = (Byte)val;
            this.element.setValueLocation(newValue);
            ObjectPropertyUndoableEdit urob = new ObjectPropertyUndoableEdit(this.element, "ValueLocation", Byte.TYPE, oldValue, newValue);
            IReportManager.getInstance().addUndoableEdit(urob);
        }
    }

    public boolean isDefaultValue() {
        return this.element.getValueLocation() == 3;
    }

    public void restoreDefaultValue() throws IllegalAccessException, InvocationTargetException {
        this.setValue(new Byte(3));
    }

    public boolean supportsDefaultValue() {
        return true;
    }
}

