/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.designer.outline.nodes.properties.charts;

import com.jaspersoft.ireport.designer.IReportManager;
import com.jaspersoft.ireport.designer.sheet.Tag;
import com.jaspersoft.ireport.designer.sheet.editors.ComboBoxPropertyEditor;
import com.jaspersoft.ireport.designer.undo.ObjectPropertyUndoableEdit;
import java.beans.PropertyEditor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import net.sf.jasperreports.charts.design.JRDesignMeterPlot;
import net.sf.jasperreports.engine.JRException;
import org.openide.nodes.PropertySupport;
import org.openide.util.Exceptions;

public final class MeterShapeProperty
extends PropertySupport {
    private final JRDesignMeterPlot element;
    private ComboBoxPropertyEditor editor;

    public MeterShapeProperty(JRDesignMeterPlot element) {
        super("shape", Byte.class, "Shape", "Shape", true, true);
        this.element = element;
        this.setValue("suppressCustomEditor", Boolean.TRUE);
    }

    public PropertyEditor getPropertyEditor() {
        if (this.editor == null) {
            ArrayList<Tag> l = new ArrayList<Tag>();
            l.add(new Tag(new Byte(2), "Pie"));
            l.add(new Tag(new Byte(1), "Circle"));
            l.add(new Tag(new Byte(0), "Chord"));
            this.editor = new ComboBoxPropertyEditor(false, l);
        }
        return this.editor;
    }

    public Object getValue() throws IllegalAccessException, InvocationTargetException {
        return new Byte(this.element.getShape());
    }

    public void setValue(Object val) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        this.setPropertyValue(val);
    }

    private void setPropertyValue(Object val) {
        if (val instanceof Byte) {
            try {
                byte oldValue = this.element.getShape();
                byte newValue = (Byte)val;
                this.element.setShape(newValue);
                ObjectPropertyUndoableEdit urob = new ObjectPropertyUndoableEdit(this.element, "Shape", Byte.TYPE, oldValue, newValue);
                IReportManager.getInstance().addUndoableEdit(urob);
            }
            catch (JRException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
    }

    public boolean isDefaultValue() {
        return this.element.getShape() == 2;
    }

    public void restoreDefaultValue() throws IllegalAccessException, InvocationTargetException {
        this.setValue(new Byte(2));
    }

    public boolean supportsDefaultValue() {
        return true;
    }
}

