/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.designer.outline.nodes.properties;

import com.jaspersoft.ireport.designer.IRFont;
import com.jaspersoft.ireport.designer.IReportManager;
import com.jaspersoft.ireport.designer.ModelUtils;
import com.jaspersoft.ireport.designer.editor.ExpressionContext;
import com.jaspersoft.ireport.designer.sheet.ExpressionProperty;
import com.jaspersoft.ireport.designer.sheet.FieldPatternProperty;
import com.jaspersoft.ireport.designer.sheet.Tag;
import com.jaspersoft.ireport.designer.sheet.editors.ComboBoxPropertyEditor;
import com.jaspersoft.ireport.designer.undo.ObjectPropertyUndoableEdit;
import java.awt.GraphicsEnvironment;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyEditor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.JRGroup;
import net.sf.jasperreports.engine.JRReportFont;
import net.sf.jasperreports.engine.design.JRDesignDataset;
import net.sf.jasperreports.engine.design.JRDesignElement;
import net.sf.jasperreports.engine.design.JRDesignExpression;
import net.sf.jasperreports.engine.design.JRDesignGroup;
import net.sf.jasperreports.engine.design.JRDesignStaticText;
import net.sf.jasperreports.engine.design.JRDesignTextElement;
import net.sf.jasperreports.engine.design.JRDesignTextField;
import net.sf.jasperreports.engine.design.JasperDesign;
import org.openide.ErrorManager;
import org.openide.nodes.Node;
import org.openide.nodes.PropertySupport;
import org.openide.nodes.Sheet;
import org.openide.util.WeakListeners;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TextElementPropertiesFactory {
    public static Sheet.Set getTextPropertySet(JRDesignTextElement element, JasperDesign jd) {
        JRDesignDataset dataset = ModelUtils.getElementDataset((JRDesignElement)element, jd);
        Sheet.Set propertySet = Sheet.createPropertiesSet();
        propertySet.setName("TEXT_ELEMENT_PROPERTIES");
        propertySet.setDisplayName("Text properties");
        propertySet.put((Node.Property)new FontNameProperty(element));
        propertySet.put((Node.Property)new FontSizeProperty(element));
        propertySet.put((Node.Property)new BoldProperty(element));
        propertySet.put((Node.Property)new ItalicProperty(element));
        propertySet.put((Node.Property)new UnderlineProperty(element));
        propertySet.put((Node.Property)new StrikeThroughProperty(element));
        propertySet.put((Node.Property)new PdfFontNameProperty(element));
        propertySet.put((Node.Property)new PdfEmbeddedProperty(element));
        propertySet.put((Node.Property)new PdfEncodingProperty(element));
        propertySet.put((Node.Property)new HorizontalAlignmentProperty(element));
        propertySet.put((Node.Property)new VerticalAlignmentProperty(element));
        propertySet.put((Node.Property)new RotationProperty(element));
        propertySet.put((Node.Property)new LineSpacingProperty(element));
        propertySet.put((Node.Property)new StyledTextProperty(element));
        propertySet.put((Node.Property)new ReportFontProperty(element, jd));
        return propertySet;
    }

    public static Sheet.Set getStaticTextPropertySet(JRDesignStaticText element, JasperDesign jd) {
        Sheet.Set propertySet = Sheet.createPropertiesSet();
        propertySet.setName("STATIC_TEXT_ELEMENT_PROPERTIES");
        propertySet.setDisplayName("Static text properties");
        propertySet.put((Node.Property)new TextProperty(element));
        return propertySet;
    }

    public static Sheet.Set getTextFieldPropertySet(JRDesignTextField element, JasperDesign jd) {
        JRDesignDataset dataset = ModelUtils.getElementDataset((JRDesignElement)element, jd);
        Sheet.Set propertySet = Sheet.createPropertiesSet();
        propertySet.setName("TEXTFIELD_ELEMENT_PROPERTIES");
        propertySet.setDisplayName("Text field properties");
        propertySet.put((Node.Property)new TextFieldExpressionProperty(element, dataset));
        propertySet.put((Node.Property)new TextFieldExpressionClassNameProperty(element));
        propertySet.put((Node.Property)new BlankWhenNullProperty(element));
        propertySet.put((Node.Property)new PatternProperty(element));
        propertySet.put((Node.Property)new StretchWithOverflowProperty(element));
        propertySet.put((Node.Property)new EvaluationTimeProperty(element, dataset));
        propertySet.put((Node.Property)new EvaluationGroupProperty(element, dataset));
        return propertySet;
    }

    public static List<Sheet.Set> getPropertySets(JRDesignElement element, JasperDesign jd) {
        ArrayList<Sheet.Set> sets = new ArrayList<Sheet.Set>();
        if (element instanceof JRDesignStaticText) {
            sets.add(TextElementPropertiesFactory.getStaticTextPropertySet((JRDesignStaticText)element, jd));
        } else if (element instanceof JRDesignTextField) {
            sets.add(TextElementPropertiesFactory.getTextFieldPropertySet((JRDesignTextField)element, jd));
        }
        if (element instanceof JRDesignTextElement) {
            sets.add(TextElementPropertiesFactory.getTextPropertySet((JRDesignTextElement)element, jd));
        }
        return sets;
    }

    private static final class TextFieldExpressionClassNameProperty
    extends PropertySupport.ReadWrite {
        private final JRDesignTextField element;
        PropertyEditor editor = null;

        public TextFieldExpressionClassNameProperty(JRDesignTextField element) {
            super("valueClassName", String.class, "Expression Class", "Expression Class");
            this.element = element;
            this.setValue("canEditAsText", true);
            this.setValue("oneline", true);
            this.setValue("suppressCustomEditor", false);
        }

        public Object getValue() throws IllegalAccessException, InvocationTargetException {
            if (this.element.getExpression() == null) {
                return "java.lang.String";
            }
            if (this.element.getExpression().getValueClassName() == null) {
                return "java.lang.String";
            }
            return this.element.getExpression().getValueClassName();
        }

        public void setValue(Object val) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
            JRDesignExpression oldExp = (JRDesignExpression)this.element.getExpression();
            JRDesignExpression newExp = null;
            String newVal = val != null ? val + "" : "";
            if ((newVal = newVal.trim()).equals("")) {
                newVal = null;
            }
            newExp = new JRDesignExpression();
            newExp.setText(oldExp != null ? oldExp.getText() : null);
            newExp.setValueClassName(newVal);
            this.element.setExpression((JRExpression)newExp);
            ObjectPropertyUndoableEdit urob = new ObjectPropertyUndoableEdit(this.element, "Expression", JRExpression.class, oldExp, newExp);
            IReportManager.getInstance().addUndoableEdit(urob);
        }

        public boolean isDefaultValue() {
            return this.element.getExpression() == null || this.element.getExpression().getValueClassName() == null || this.element.getExpression().getValueClassName().equals("java.lang.String");
        }

        public void restoreDefaultValue() throws IllegalAccessException, InvocationTargetException {
            this.setValue(null);
            this.editor.setValue("java.lang.String");
        }

        public boolean supportsDefaultValue() {
            return true;
        }

        public PropertyEditor getPropertyEditor() {
            if (this.editor == null) {
                ArrayList<Tag> classes = new ArrayList<Tag>();
                classes.add(new Tag("java.lang.String"));
                classes.add(new Tag("java.lang.Boolean"));
                classes.add(new Tag("java.lang.Byte"));
                classes.add(new Tag("java.util.Date"));
                classes.add(new Tag("java.sql.Timestamp"));
                classes.add(new Tag("java.sql.Time"));
                classes.add(new Tag("java.lang.Double"));
                classes.add(new Tag("java.lang.Float"));
                classes.add(new Tag("java.lang.Integer"));
                classes.add(new Tag("java.lang.Long"));
                classes.add(new Tag("java.lang.Short"));
                classes.add(new Tag("java.math.BigDecimal"));
                classes.add(new Tag("java.lang.Number"));
                this.editor = new ComboBoxPropertyEditor(false, classes);
            }
            return this.editor;
        }
    }

    public static final class TextFieldExpressionProperty
    extends ExpressionProperty {
        private final JRDesignDataset dataset;
        private final JRDesignTextField element;

        public TextFieldExpressionProperty(JRDesignTextField element, JRDesignDataset dataset) {
            super("expression", "Expression", "Expression");
            this.element = element;
            this.dataset = dataset;
            this.setValue("expressionContext", new ExpressionContext(dataset));
        }

        public Object getValue() throws IllegalAccessException, InvocationTargetException {
            if (this.element.getExpression() == null) {
                return "";
            }
            return this.element.getExpression().getText();
        }

        public void setValue(Object val) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
            JRDesignExpression oldExp = (JRDesignExpression)this.element.getExpression();
            JRDesignExpression newExp = null;
            if ((val == null || val.equals("")) && (oldExp == null || oldExp.getValueClassName() == null || oldExp.getValueClassName().equals("java.lang.String"))) {
                this.element.setExpression(null);
            } else {
                String s = val != null ? val + "" : "";
                newExp = new JRDesignExpression();
                newExp.setText(s);
                newExp.setValueClassName(oldExp != null ? oldExp.getValueClassName() : null);
                this.element.setExpression((JRExpression)newExp);
            }
            ObjectPropertyUndoableEdit urob = new ObjectPropertyUndoableEdit(this.element, "Expression", JRExpression.class, oldExp, newExp);
            IReportManager.getInstance().addUndoableEdit(urob);
        }

        public IllegalArgumentException annotateException(String msg) {
            IllegalArgumentException iae = new IllegalArgumentException(msg);
            ErrorManager.getDefault().annotate((Throwable)iae, 4096, msg, msg, null, null);
            return iae;
        }

        public boolean isDefaultValue() {
            return this.element.getExpression() == null || this.element.getExpression().getText() == null || this.element.getExpression().getText().length() == 0;
        }

        public void restoreDefaultValue() throws IllegalAccessException, InvocationTargetException {
            this.setValue(null);
        }

        public boolean supportsDefaultValue() {
            return true;
        }
    }

    public static final class BlankWhenNullProperty
    extends PropertySupport.ReadWrite {
        private final JRDesignTextField element;

        public BlankWhenNullProperty(JRDesignTextField element) {
            super("blankWhenNull", Boolean.class, "Blank When Null", "Print a blank string instead of null.");
            this.element = element;
        }

        public Object getValue() throws IllegalAccessException, InvocationTargetException {
            return this.element.isBlankWhenNull();
        }

        public void setValue(Object val) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
            if (val == null || val instanceof Boolean) {
                Boolean oldValue = this.element.isOwnBlankWhenNull();
                Boolean newValue = (Boolean)val;
                this.element.setBlankWhenNull(newValue);
                ObjectPropertyUndoableEdit urob = new ObjectPropertyUndoableEdit(this.element, "BlankWhenNull", Boolean.class, oldValue, newValue);
                IReportManager.getInstance().addUndoableEdit(urob);
            }
        }

        public boolean isDefaultValue() {
            return this.element.isOwnBlankWhenNull() == null;
        }

        public void restoreDefaultValue() throws IllegalAccessException, InvocationTargetException {
            this.setValue(null);
        }

        public boolean supportsDefaultValue() {
            return true;
        }
    }

    private static final class PatternProperty
    extends FieldPatternProperty {
        private final JRDesignTextField element;

        public PatternProperty(JRDesignTextField element) {
            super("pattern", "Pattern", "Patter to use to format numbers and dates.");
            this.element = element;
        }

        public Object getValue() throws IllegalAccessException, InvocationTargetException {
            return this.element.getPattern() == null ? "" : this.element.getPattern();
        }

        public void setValue(Object val) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
            if (val == null || val instanceof String) {
                String oldValue = this.element.getOwnPattern();
                String newValue = (String)val;
                if (newValue != null && newValue.length() == 0) {
                    newValue = null;
                }
                this.element.setPattern(newValue);
                ObjectPropertyUndoableEdit urob = new ObjectPropertyUndoableEdit(this.element, "Pattern", String.class, oldValue, newValue);
                IReportManager.getInstance().addUndoableEdit(urob);
            }
        }

        public boolean isDefaultValue() {
            return this.element.getPattern() == null;
        }

        public void restoreDefaultValue() throws IllegalAccessException, InvocationTargetException {
            this.setValue(null);
        }

        public boolean supportsDefaultValue() {
            return true;
        }
    }

    private static final class EvaluationGroupProperty
    extends PropertySupport
    implements PropertyChangeListener {
        private final JRDesignDataset dataset;
        private final JRDesignTextField element;
        private ComboBoxPropertyEditor editor;

        public EvaluationGroupProperty(JRDesignTextField element, JRDesignDataset dataset) {
            super("evaluationGroup", JRGroup.class, "Evaluation group", "Evaluate the image expression when the specified group changes", true, true);
            this.element = element;
            this.dataset = dataset;
            this.setValue("suppressCustomEditor", Boolean.TRUE);
            dataset.getEventSupport().addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)dataset.getEventSupport()));
        }

        public boolean canWrite() {
            return this.element.getEvaluationTime() == 5;
        }

        public PropertyEditor getPropertyEditor() {
            if (this.editor == null) {
                this.editor = new ComboBoxPropertyEditor(false, this.getListOfTags());
            }
            return this.editor;
        }

        public Object getValue() throws IllegalAccessException, InvocationTargetException {
            return this.element.getEvaluationGroup() == null ? "" : this.element.getEvaluationGroup();
        }

        public void setValue(Object val) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
            if (val instanceof JRGroup) {
                JRGroup oldValue = this.element.getEvaluationGroup();
                JRGroup newValue = (JRGroup)val;
                this.element.setEvaluationGroup(newValue);
                ObjectPropertyUndoableEdit urob = new ObjectPropertyUndoableEdit(this.element, "EvaluationGroup", JRGroup.class, oldValue, newValue);
                IReportManager.getInstance().addUndoableEdit(urob);
            }
        }

        public void propertyChange(PropertyChangeEvent evt) {
            if (this.editor == null) {
                return;
            }
            if (evt.getPropertyName() == null) {
                return;
            }
            if (evt.getPropertyName().equals("groups") || evt.getPropertyName().equals("name")) {
                this.editor.setTagValues(this.getListOfTags());
            }
        }

        private ArrayList getListOfTags() {
            ArrayList<Tag> l = new ArrayList<Tag>();
            List groups = this.dataset.getGroupsList();
            for (int i = 0; i < groups.size(); ++i) {
                JRDesignGroup group = (JRDesignGroup)groups.get(i);
                l.add(new Tag(group, group.getName()));
                group.getEventSupport().addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)group.getEventSupport()));
            }
            return l;
        }
    }

    private static final class EvaluationTimeProperty
    extends PropertySupport {
        private final JRDesignDataset dataset;
        private final JRDesignTextField element;
        private ComboBoxPropertyEditor editor;

        public EvaluationTimeProperty(JRDesignTextField element, JRDesignDataset dataset) {
            super("evaluationTime", Byte.class, "Evaluation Time", "When the image expression should be evaluated.", true, true);
            this.element = element;
            this.dataset = dataset;
            this.setValue("suppressCustomEditor", Boolean.TRUE);
        }

        public boolean isDefaultValue() {
            return this.element.getEvaluationTime() == 1;
        }

        public void restoreDefaultValue() throws IllegalAccessException, InvocationTargetException {
            this.setPropertyValue((byte)1);
        }

        public boolean supportsDefaultValue() {
            return true;
        }

        public PropertyEditor getPropertyEditor() {
            if (this.editor == null) {
                ArrayList<Tag> l = new ArrayList<Tag>();
                l.add(new Tag(new Byte(1), "Now"));
                l.add(new Tag(new Byte(2), "Report"));
                l.add(new Tag(new Byte(3), "Page"));
                l.add(new Tag(new Byte(4), "Column"));
                l.add(new Tag(new Byte(5), "Group"));
                l.add(new Tag(new Byte(6), "Band"));
                l.add(new Tag(new Byte(7), "Auto"));
                this.editor = new ComboBoxPropertyEditor(false, l);
            }
            return this.editor;
        }

        public Object getValue() throws IllegalAccessException, InvocationTargetException {
            return new Byte(this.element.getEvaluationTime());
        }

        public void setValue(Object val) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
            if (val instanceof Byte) {
                this.setPropertyValue((Byte)val);
            }
        }

        private void setPropertyValue(Byte val) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
            Byte oldValue = this.element.getEvaluationTime();
            Byte newValue = val;
            ObjectPropertyUndoableEdit urob = new ObjectPropertyUndoableEdit(this.element, "EvaluationTime", Byte.TYPE, oldValue, newValue);
            JRGroup oldGroupValue = this.element.getEvaluationGroup();
            JRGroup newGroupValue = null;
            if (val == 5) {
                if (this.dataset.getGroupsList().size() == 0) {
                    IllegalArgumentException iae = this.annotateException("No groups are defined to be used with this element");
                    throw iae;
                }
                newGroupValue = (JRGroup)this.dataset.getGroupsList().get(0);
            }
            this.element.setEvaluationTime(newValue.byteValue());
            if (oldGroupValue != newGroupValue) {
                ObjectPropertyUndoableEdit urobGroup = new ObjectPropertyUndoableEdit(this.element, "EvaluationGroup", JRGroup.class, oldGroupValue, newGroupValue);
                this.element.setEvaluationGroup(newGroupValue);
                urob.concatenate(urobGroup);
            }
            IReportManager.getInstance().addUndoableEdit(urob);
        }

        public IllegalArgumentException annotateException(String msg) {
            IllegalArgumentException iae = new IllegalArgumentException(msg);
            ErrorManager.getDefault().annotate((Throwable)iae, 4096, msg, msg, null, null);
            return iae;
        }
    }

    public static final class StretchWithOverflowProperty
    extends PropertySupport.ReadWrite {
        private final JRDesignTextField element;

        public StretchWithOverflowProperty(JRDesignTextField element) {
            super("stretchWithOverflow", Boolean.class, "Stretch With Overflow", "Stretch the field vertically it the text does not fit in the element.");
            this.element = element;
        }

        public Object getValue() throws IllegalAccessException, InvocationTargetException {
            return this.element.isStretchWithOverflow();
        }

        public void setValue(Object val) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
            if (val instanceof Boolean) {
                boolean oldValue = this.element.isStretchWithOverflow();
                boolean newValue = (Boolean)val;
                this.element.setStretchWithOverflow(newValue);
                ObjectPropertyUndoableEdit urob = new ObjectPropertyUndoableEdit(this.element, "StretchWithOverflow", Boolean.TYPE, oldValue, newValue);
                IReportManager.getInstance().addUndoableEdit(urob);
            }
        }

        public boolean isDefaultValue() {
            return !this.element.isStretchWithOverflow();
        }

        public void restoreDefaultValue() throws IllegalAccessException, InvocationTargetException {
            this.setValue(false);
        }

        public boolean supportsDefaultValue() {
            return true;
        }
    }

    private static final class PdfEncodingProperty
    extends PropertySupport.ReadWrite {
        private final JRDesignTextElement element;
        PropertyEditor editor = null;

        public PdfEncodingProperty(JRDesignTextElement element) {
            super("pdfEncoding", String.class, "Pdf Encoding", "Pdf Encoding");
            this.element = element;
            this.setValue("canEditAsText", true);
            this.setValue("oneline", true);
            this.setValue("suppressCustomEditor", false);
        }

        public Object getValue() throws IllegalAccessException, InvocationTargetException {
            return this.element.getPdfEncoding();
        }

        public void setValue(Object val) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
            if (val == null || val instanceof String) {
                if ((val + "").trim().length() == 0) {
                    val = null;
                }
                String oldValue = this.element.getOwnPdfEncoding();
                String newValue = (String)val;
                this.element.setPdfEncoding(newValue);
                ObjectPropertyUndoableEdit urob = new ObjectPropertyUndoableEdit(this.element, "PdfEncoding", String.class, oldValue, newValue);
                IReportManager.getInstance().addUndoableEdit(urob);
            }
        }

        public boolean isDefaultValue() {
            return this.element.getOwnPdfEncoding() == null;
        }

        public void restoreDefaultValue() throws IllegalAccessException, InvocationTargetException {
            this.setValue(null);
        }

        public boolean supportsDefaultValue() {
            return true;
        }

        public PropertyEditor getPropertyEditor() {
            if (this.editor == null) {
                ArrayList<Tag> encodings = new ArrayList<Tag>();
                encodings.add(new Tag("Cp1250", "CP1250 (Central European)"));
                encodings.add(new Tag("Cp1251", "CP1251 (Cyrillic)"));
                encodings.add(new Tag("Cp1252", "CP1252 (Western European ANSI aka WinAnsi)"));
                encodings.add(new Tag("Cp1253", "CP1253 (Greek)"));
                encodings.add(new Tag("Cp1254", "CP1254 (Turkish)"));
                encodings.add(new Tag("Cp1255", "CP1255 (Hebrew)"));
                encodings.add(new Tag("Cp1256", "CP1256 (Arabic)"));
                encodings.add(new Tag("Cp1257", "CP1257 (Baltic)"));
                encodings.add(new Tag("Cp1258", "CP1258 (Vietnamese)"));
                encodings.add(new Tag("UniGB-UCS2-H", "UniGB-UCS2-H (Chinese Simplified)"));
                encodings.add(new Tag("UniGB-UCS2-V", "UniGB-UCS2-V (Chinese Simplified)"));
                encodings.add(new Tag("UniCNS-UCS2-H", "UniCNS-UCS2-H (Chinese traditional)"));
                encodings.add(new Tag("UniCNS-UCS2-V", "UniCNS-UCS2-V (Chinese traditional)"));
                encodings.add(new Tag("UniJIS-UCS2-H", "UniJIS-UCS2-H (Japanese)"));
                encodings.add(new Tag("UniJIS-UCS2-V", "UniJIS-UCS2-V (Japanese)"));
                encodings.add(new Tag("UniJIS-UCS2-HW-H", "UniJIS-UCS2-HW-H (Japanese)"));
                encodings.add(new Tag("UniJIS-UCS2-HW-V", "UniJIS-UCS2-HW-V (Japanese)"));
                encodings.add(new Tag("UniKS-UCS2-H", "UniKS-UCS2-H (Korean)"));
                encodings.add(new Tag("UniKS-UCS2-V", "UniKS-UCS2-V (Korean)"));
                encodings.add(new Tag("Identity-H", "Identity-H (Unicode with horizontal writing)"));
                encodings.add(new Tag("Identity-V", "Identity-V (Unicode with vertical writing)"));
                this.editor = new ComboBoxPropertyEditor(true, encodings);
            }
            return this.editor;
        }
    }

    private static final class PdfFontNameProperty
    extends PropertySupport.ReadWrite {
        private final JRDesignTextElement element;
        PropertyEditor editor = null;

        public PdfFontNameProperty(JRDesignTextElement element) {
            super("pdfFontName", String.class, "Pdf Font name", "Pdf Font name");
            this.element = element;
            this.setValue("canEditAsText", true);
            this.setValue("oneline", true);
            this.setValue("suppressCustomEditor", true);
        }

        public Object getValue() throws IllegalAccessException, InvocationTargetException {
            return this.element.getPdfFontName();
        }

        public void setValue(Object val) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
            if (val == null || val instanceof String) {
                String oldValue = this.element.getOwnPdfFontName();
                String newValue = (String)val;
                this.element.setPdfFontName(newValue);
                ObjectPropertyUndoableEdit urob = new ObjectPropertyUndoableEdit(this.element, "PdfFontName", String.class, oldValue, newValue);
                IReportManager.getInstance().addUndoableEdit(urob);
            }
        }

        public boolean isDefaultValue() {
            return this.element.getOwnPdfFontName() == null;
        }

        public void restoreDefaultValue() throws IllegalAccessException, InvocationTargetException {
            this.setValue(null);
        }

        public boolean supportsDefaultValue() {
            return true;
        }

        public PropertyEditor getPropertyEditor() {
            if (this.editor == null) {
                ArrayList<Tag> classes = new ArrayList<Tag>();
                classes.add(new Tag("Helvetica"));
                classes.add(new Tag("Helvetica-Bold"));
                classes.add(new Tag("Helvetica-BoldOblique"));
                classes.add(new Tag("Helvetica-Oblique"));
                classes.add(new Tag("Courier"));
                classes.add(new Tag("Courier-Bold"));
                classes.add(new Tag("Courier-BoldOblique"));
                classes.add(new Tag("Courier-Oblique"));
                classes.add(new Tag("Symbol"));
                classes.add(new Tag("Times-Roman"));
                classes.add(new Tag("Times-Bold"));
                classes.add(new Tag("Times-BoldItalic"));
                classes.add(new Tag("Times-Italic"));
                classes.add(new Tag("ZapfDingbats"));
                classes.add(new Tag("STSong-Light"));
                classes.add(new Tag("MHei-Medium"));
                classes.add(new Tag("MSung-Light"));
                classes.add(new Tag("HeiseiKakuGo-W5"));
                classes.add(new Tag("HeiseiMin-W3"));
                classes.add(new Tag("HYGoThic-Medium"));
                classes.add(new Tag("HYSMyeongJo-Medium"));
                List<IRFont> fonts = IReportManager.getInstance().getIRFonts();
                for (IRFont f : fonts) {
                    classes.add(new Tag(f.getFile(), f.toString()));
                }
                this.editor = new ComboBoxPropertyEditor(true, classes);
            }
            return this.editor;
        }
    }

    private static final class ReportFontProperty
    extends PropertySupport.ReadWrite {
        private final JRDesignTextElement element;
        private final JasperDesign jd;
        PropertyEditor editor = null;

        public ReportFontProperty(JRDesignTextElement element, JasperDesign jd) {
            super("reportFont", JRReportFont.class, "Report font", "Report font");
            this.element = element;
            this.jd = jd;
            this.setValue("canEditAsText", false);
            this.setValue("oneline", true);
            this.setValue("suppressCustomEditor", true);
        }

        public Object getValue() throws IllegalAccessException, InvocationTargetException {
            return this.element.getReportFont() == null ? "" : this.element.getReportFont();
        }

        public void setValue(Object val) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
            if (val == null || val instanceof JRReportFont) {
                JRReportFont oldValue = this.element.getReportFont();
                JRReportFont newValue = (JRReportFont)val;
                this.element.setReportFont(newValue);
                ObjectPropertyUndoableEdit urob = new ObjectPropertyUndoableEdit(this.element, "ReportFont", JRReportFont.class, oldValue, newValue);
                IReportManager.getInstance().addUndoableEdit(urob);
            }
        }

        public boolean isDefaultValue() {
            return this.element.getReportFont() == null;
        }

        public void restoreDefaultValue() throws IllegalAccessException, InvocationTargetException {
            this.setValue(null);
        }

        public boolean supportsDefaultValue() {
            return true;
        }

        public PropertyEditor getPropertyEditor() {
            if (this.editor == null) {
                ArrayList<Tag> classes = new ArrayList<Tag>();
                List fonts = this.jd.getFontsList();
                for (int i = 0; i < fonts.size(); ++i) {
                    JRReportFont font = (JRReportFont)fonts.get(i);
                    classes.add(new Tag(font, font.getName()));
                }
                this.editor = new ComboBoxPropertyEditor(false, classes);
            }
            return this.editor;
        }

        public String getHtmlDisplayName() {
            return "<s>" + super.getDisplayName() + "</s>";
        }
    }

    private static final class FontSizeProperty
    extends PropertySupport.ReadWrite {
        private final JRDesignTextElement element;
        PropertyEditor editor = null;

        public FontSizeProperty(JRDesignTextElement element) {
            super("fontSize", Integer.class, "Size", "Size");
            this.element = element;
            this.setValue("canEditAsText", true);
            this.setValue("oneline", true);
            this.setValue("suppressCustomEditor", false);
        }

        public Object getValue() throws IllegalAccessException, InvocationTargetException {
            return this.element.getFontSize();
        }

        public void setValue(Object val) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
            if (val != null && !(val instanceof Integer)) {
                try {
                    val = new Integer(val + "");
                }
                catch (Exception ex) {
                    return;
                }
            }
            if (val == null || val instanceof Integer) {
                Integer oldValue = this.element.getOwnFontSize();
                Integer newValue = (Integer)val;
                this.element.setFontSize(newValue);
                ObjectPropertyUndoableEdit urob = new ObjectPropertyUndoableEdit(this.element, "FontSize", Integer.class, oldValue, newValue);
                IReportManager.getInstance().addUndoableEdit(urob);
            }
        }

        public boolean isDefaultValue() {
            return this.element.getOwnFontSize() == null;
        }

        public void restoreDefaultValue() throws IllegalAccessException, InvocationTargetException {
            this.setValue(null);
        }

        public boolean supportsDefaultValue() {
            return true;
        }

        public PropertyEditor getPropertyEditor() {
            if (this.editor == null) {
                ArrayList<Tag> classes = new ArrayList<Tag>();
                int i = 6;
                while (i < 100) {
                    classes.add(new Tag(new Integer(i), "" + i));
                    if (i < 16) {
                        ++i;
                        continue;
                    }
                    if (i < 32) {
                        i += 2;
                        continue;
                    }
                    if (i < 48) {
                        i += 4;
                        continue;
                    }
                    if (i < 72) {
                        i += 6;
                        continue;
                    }
                    i += 8;
                }
                this.editor = new ComboBoxPropertyEditor(true, classes);
            }
            return this.editor;
        }
    }

    private static final class FontNameProperty
    extends PropertySupport.ReadWrite {
        private final JRDesignTextElement element;
        PropertyEditor editor = null;

        public FontNameProperty(JRDesignTextElement element) {
            super("fontName", String.class, "Font name", "Font name");
            this.element = element;
            this.setValue("canEditAsText", true);
            this.setValue("oneline", true);
            this.setValue("suppressCustomEditor", false);
        }

        public Object getValue() throws IllegalAccessException, InvocationTargetException {
            return this.element.getFontName();
        }

        public void setValue(Object val) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
            if (val == null || val instanceof String) {
                String oldValue = this.element.getOwnFontName();
                String newValue = (String)val;
                this.element.setFontName(newValue);
                ObjectPropertyUndoableEdit urob = new ObjectPropertyUndoableEdit(this.element, "FontName", String.class, oldValue, newValue);
                IReportManager.getInstance().addUndoableEdit(urob);
            }
        }

        public boolean isDefaultValue() {
            return this.element.getOwnFontName() == null;
        }

        public void restoreDefaultValue() throws IllegalAccessException, InvocationTargetException {
            this.setValue(null);
        }

        public boolean supportsDefaultValue() {
            return true;
        }

        public PropertyEditor getPropertyEditor() {
            if (this.editor == null) {
                ArrayList<Tag> classes = new ArrayList<Tag>();
                String[] names = GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames();
                for (int i = 0; i < names.length; ++i) {
                    String name = names[i];
                    classes.add(new Tag(name));
                }
                this.editor = new ComboBoxPropertyEditor(true, classes);
            }
            return this.editor;
        }
    }

    public static final class PdfEmbeddedProperty
    extends PropertySupport.ReadWrite {
        private final JRDesignTextElement element;

        public PdfEmbeddedProperty(JRDesignTextElement element) {
            super("pdfEmbedded", Boolean.class, "Pdf Embedded", "");
            this.element = element;
        }

        public Object getValue() throws IllegalAccessException, InvocationTargetException {
            return this.element.isPdfEmbedded();
        }

        public void setValue(Object val) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
            if (val == null || val instanceof Boolean) {
                Boolean oldValue = this.element.isOwnPdfEmbedded();
                Boolean newValue = (Boolean)val;
                this.element.setPdfEmbedded(newValue);
                ObjectPropertyUndoableEdit urob = new ObjectPropertyUndoableEdit(this.element, "PdfEmbedded", Boolean.class, oldValue, newValue);
                IReportManager.getInstance().addUndoableEdit(urob);
            }
        }

        public boolean isDefaultValue() {
            return this.element.isOwnPdfEmbedded() == null;
        }

        public void restoreDefaultValue() throws IllegalAccessException, InvocationTargetException {
            this.setValue(null);
        }

        public boolean supportsDefaultValue() {
            return true;
        }
    }

    public static final class UnderlineProperty
    extends PropertySupport.ReadWrite {
        private final JRDesignTextElement element;

        public UnderlineProperty(JRDesignTextElement element) {
            super("underline", Boolean.class, "Underline", "");
            this.element = element;
        }

        public Object getValue() throws IllegalAccessException, InvocationTargetException {
            return this.element.isUnderline();
        }

        public void setValue(Object val) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
            if (val == null || val instanceof Boolean) {
                Boolean oldValue = this.element.isOwnUnderline();
                Boolean newValue = (Boolean)val;
                this.element.setUnderline(newValue);
                ObjectPropertyUndoableEdit urob = new ObjectPropertyUndoableEdit(this.element, "Underline", Boolean.class, oldValue, newValue);
                IReportManager.getInstance().addUndoableEdit(urob);
            }
        }

        public boolean isDefaultValue() {
            return this.element.isOwnUnderline() == null;
        }

        public void restoreDefaultValue() throws IllegalAccessException, InvocationTargetException {
            this.setValue(null);
        }

        public boolean supportsDefaultValue() {
            return true;
        }
    }

    public static final class StrikeThroughProperty
    extends PropertySupport.ReadWrite {
        private final JRDesignTextElement element;

        public StrikeThroughProperty(JRDesignTextElement element) {
            super("strikeThrough", Boolean.class, "Strike Through", "");
            this.element = element;
        }

        public Object getValue() throws IllegalAccessException, InvocationTargetException {
            return this.element.isStrikeThrough();
        }

        public void setValue(Object val) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
            if (val == null || val instanceof Boolean) {
                Boolean oldValue = this.element.isOwnStrikeThrough();
                Boolean newValue = (Boolean)val;
                this.element.setStrikeThrough(newValue);
                ObjectPropertyUndoableEdit urob = new ObjectPropertyUndoableEdit(this.element, "StrikeThrough", Boolean.class, oldValue, newValue);
                IReportManager.getInstance().addUndoableEdit(urob);
            }
        }

        public boolean isDefaultValue() {
            return this.element.isOwnStrikeThrough() == null;
        }

        public void restoreDefaultValue() throws IllegalAccessException, InvocationTargetException {
            this.setValue(null);
        }

        public boolean supportsDefaultValue() {
            return true;
        }
    }

    public static final class ItalicProperty
    extends PropertySupport.ReadWrite {
        private final JRDesignTextElement element;

        public ItalicProperty(JRDesignTextElement element) {
            super("italic", Boolean.class, "Italic", "");
            this.element = element;
        }

        public Object getValue() throws IllegalAccessException, InvocationTargetException {
            return this.element.isItalic();
        }

        public void setValue(Object val) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
            if (val == null || val instanceof Boolean) {
                Boolean oldValue = this.element.isOwnItalic();
                Boolean newValue = (Boolean)val;
                this.element.setItalic(newValue);
                ObjectPropertyUndoableEdit urob = new ObjectPropertyUndoableEdit(this.element, "Italic", Boolean.class, oldValue, newValue);
                IReportManager.getInstance().addUndoableEdit(urob);
            }
        }

        public boolean isDefaultValue() {
            return this.element.isOwnItalic() == null;
        }

        public void restoreDefaultValue() throws IllegalAccessException, InvocationTargetException {
            this.setValue(null);
        }

        public boolean supportsDefaultValue() {
            return true;
        }
    }

    public static final class BoldProperty
    extends PropertySupport.ReadWrite {
        private final JRDesignTextElement element;

        public BoldProperty(JRDesignTextElement element) {
            super("bold", Boolean.class, "Bold", "");
            this.element = element;
        }

        public Object getValue() throws IllegalAccessException, InvocationTargetException {
            return this.element.isBold();
        }

        public void setValue(Object val) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
            if (val == null || val instanceof Boolean) {
                Boolean oldValue = this.element.isOwnBold();
                Boolean newValue = (Boolean)val;
                this.element.setBold(newValue);
                ObjectPropertyUndoableEdit urob = new ObjectPropertyUndoableEdit(this.element, "Bold", Boolean.class, oldValue, newValue);
                IReportManager.getInstance().addUndoableEdit(urob);
            }
        }

        public boolean isDefaultValue() {
            return this.element.isOwnBold() == null;
        }

        public void restoreDefaultValue() throws IllegalAccessException, InvocationTargetException {
            this.setValue(null);
        }

        public boolean supportsDefaultValue() {
            return true;
        }
    }

    public static final class StyledTextProperty
    extends PropertySupport.ReadWrite {
        private final JRDesignTextElement element;

        public StyledTextProperty(JRDesignTextElement element) {
            super("isStyledText", Boolean.class, "Is Styled Text", "Set if the value should be parsed as styled text.");
            this.element = element;
        }

        public Object getValue() throws IllegalAccessException, InvocationTargetException {
            return this.element.isStyledText();
        }

        public void setValue(Object val) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
            if (val == null || val instanceof Boolean) {
                Boolean oldValue = this.element.isOwnStyledText();
                Boolean newValue = (Boolean)val;
                this.element.setStyledText(newValue);
                ObjectPropertyUndoableEdit urob = new ObjectPropertyUndoableEdit(this.element, "StyledText", Boolean.class, oldValue, newValue);
                IReportManager.getInstance().addUndoableEdit(urob);
            }
        }

        public boolean isDefaultValue() {
            return this.element.isOwnStyledText() == null;
        }

        public void restoreDefaultValue() throws IllegalAccessException, InvocationTargetException {
            this.setValue(null);
        }

        public boolean supportsDefaultValue() {
            return true;
        }
    }

    private static final class LineSpacingProperty
    extends PropertySupport {
        private final JRDesignTextElement element;
        private ComboBoxPropertyEditor editor;

        public LineSpacingProperty(JRDesignTextElement element) {
            super("lineSpacing", Byte.class, "Line Spacing", "The space to put between lines of text.", true, true);
            this.element = element;
            this.setValue("suppressCustomEditor", Boolean.TRUE);
        }

        public PropertyEditor getPropertyEditor() {
            if (this.editor == null) {
                ArrayList<Tag> l = new ArrayList<Tag>();
                l.add(new Tag(new Byte(0), "Single"));
                l.add(new Tag(new Byte(1), "1.5"));
                l.add(new Tag(new Byte(2), "Double"));
                this.editor = new ComboBoxPropertyEditor(false, l);
            }
            return this.editor;
        }

        public Object getValue() throws IllegalAccessException, InvocationTargetException {
            return new Byte(this.element.getLineSpacing());
        }

        public void setValue(Object val) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
            this.setPropertyValue(val);
        }

        private void setPropertyValue(Object val) {
            if (val == null || val instanceof Byte) {
                Byte oldValue = this.element.getOwnLineSpacing();
                Byte newValue = (Byte)val;
                this.element.setLineSpacing(newValue);
                ObjectPropertyUndoableEdit urob = new ObjectPropertyUndoableEdit(this.element, "LineSpacing", Byte.class, oldValue, newValue);
                IReportManager.getInstance().addUndoableEdit(urob);
            }
        }

        public boolean isDefaultValue() {
            return this.element.getOwnLineSpacing() == null;
        }

        public void restoreDefaultValue() throws IllegalAccessException, InvocationTargetException {
            this.setValue(null);
        }

        public boolean supportsDefaultValue() {
            return true;
        }
    }

    private static final class RotationProperty
    extends PropertySupport {
        private final JRDesignTextElement element;
        private ComboBoxPropertyEditor editor;

        public RotationProperty(JRDesignTextElement element) {
            super("rotation", Byte.class, "Rotation", "How to rotate the text.", true, true);
            this.element = element;
            this.setValue("suppressCustomEditor", Boolean.TRUE);
        }

        public PropertyEditor getPropertyEditor() {
            if (this.editor == null) {
                ArrayList<Tag> l = new ArrayList<Tag>();
                l.add(new Tag(new Byte(0), "None"));
                l.add(new Tag(new Byte(1), "Left"));
                l.add(new Tag(new Byte(2), "Right"));
                l.add(new Tag(new Byte(3), "Upside Down"));
                this.editor = new ComboBoxPropertyEditor(false, l);
            }
            return this.editor;
        }

        public Object getValue() throws IllegalAccessException, InvocationTargetException {
            return new Byte(this.element.getRotation());
        }

        public void setValue(Object val) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
            this.setPropertyValue(val);
        }

        private void setPropertyValue(Object val) {
            if (val == null || val instanceof Byte) {
                Byte oldValue = this.element.getOwnRotation();
                Byte newValue = (Byte)val;
                this.element.setRotation(newValue);
                ObjectPropertyUndoableEdit urob = new ObjectPropertyUndoableEdit(this.element, "Rotation", Byte.class, oldValue, newValue);
                IReportManager.getInstance().addUndoableEdit(urob);
            }
        }

        public boolean isDefaultValue() {
            return this.element.getOwnRotation() == null;
        }

        public void restoreDefaultValue() throws IllegalAccessException, InvocationTargetException {
            this.setValue(null);
        }

        public boolean supportsDefaultValue() {
            return true;
        }
    }

    private static final class VerticalAlignmentProperty
    extends PropertySupport {
        private final JRDesignTextElement element;
        private ComboBoxPropertyEditor editor;

        public VerticalAlignmentProperty(JRDesignTextElement element) {
            super("verticalAlignment", Byte.class, "Vertical Alignment", "How to align the text.", true, true);
            this.element = element;
            this.setValue("suppressCustomEditor", Boolean.TRUE);
        }

        public PropertyEditor getPropertyEditor() {
            if (this.editor == null) {
                ArrayList<Tag> l = new ArrayList<Tag>();
                l.add(new Tag(new Byte(1), "Top"));
                l.add(new Tag(new Byte(2), "Middle"));
                l.add(new Tag(new Byte(3), "Bottom"));
                l.add(new Tag(new Byte(4), "Justified"));
                this.editor = new ComboBoxPropertyEditor(false, l);
            }
            return this.editor;
        }

        public Object getValue() throws IllegalAccessException, InvocationTargetException {
            return new Byte(this.element.getVerticalAlignment());
        }

        public void setValue(Object val) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
            this.setPropertyValue(val);
        }

        private void setPropertyValue(Object val) {
            if (val == null || val instanceof Byte) {
                Byte oldValue = this.element.getOwnVerticalAlignment();
                Byte newValue = (Byte)val;
                this.element.setVerticalAlignment(newValue);
                ObjectPropertyUndoableEdit urob = new ObjectPropertyUndoableEdit(this.element, "VerticalAlignment", Byte.class, oldValue, newValue);
                IReportManager.getInstance().addUndoableEdit(urob);
            }
        }

        public boolean isDefaultValue() {
            return this.element.getOwnVerticalAlignment() == null;
        }

        public void restoreDefaultValue() throws IllegalAccessException, InvocationTargetException {
            this.setValue(null);
        }

        public boolean supportsDefaultValue() {
            return true;
        }
    }

    private static final class HorizontalAlignmentProperty
    extends PropertySupport {
        private final JRDesignTextElement element;
        private ComboBoxPropertyEditor editor;

        public HorizontalAlignmentProperty(JRDesignTextElement element) {
            super("horizontalAlignment", Byte.class, "Horizontal Alignment", "How to align the text.", true, true);
            this.element = element;
            this.setValue("suppressCustomEditor", Boolean.TRUE);
        }

        public PropertyEditor getPropertyEditor() {
            if (this.editor == null) {
                ArrayList<Tag> l = new ArrayList<Tag>();
                l.add(new Tag(new Byte(1), "Left"));
                l.add(new Tag(new Byte(2), "Center"));
                l.add(new Tag(new Byte(3), "Right"));
                l.add(new Tag(new Byte(4), "Justified"));
                this.editor = new ComboBoxPropertyEditor(false, l);
            }
            return this.editor;
        }

        public Object getValue() throws IllegalAccessException, InvocationTargetException {
            return new Byte(this.element.getHorizontalAlignment());
        }

        public void setValue(Object val) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
            this.setPropertyValue(val);
        }

        private void setPropertyValue(Object val) {
            if (val == null || val instanceof Byte) {
                Byte oldValue = this.element.getOwnHorizontalAlignment();
                Byte newValue = (Byte)val;
                this.element.setHorizontalAlignment(newValue);
                ObjectPropertyUndoableEdit urob = new ObjectPropertyUndoableEdit(this.element, "HorizontalAlignment", Byte.class, oldValue, newValue);
                IReportManager.getInstance().addUndoableEdit(urob);
            }
        }

        public boolean isDefaultValue() {
            return this.element.getOwnHorizontalAlignment() == null;
        }

        public void restoreDefaultValue() throws IllegalAccessException, InvocationTargetException {
            this.setValue(null);
        }

        public boolean supportsDefaultValue() {
            return true;
        }
    }

    public static final class TextProperty
    extends PropertySupport.ReadWrite {
        final JRDesignStaticText element;

        public TextProperty(JRDesignStaticText element) {
            super("key", String.class, "Text", "The text to show in this label.");
            this.element = element;
        }

        public Object getValue() throws IllegalAccessException, InvocationTargetException {
            return this.element.getText() != null ? this.element.getText() : "";
        }

        public void setValue(Object val) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
            String oldValue = this.element.getText();
            String newValue = val + "";
            if (val == null) {
                newValue = "";
            }
            this.element.setText(newValue);
            ObjectPropertyUndoableEdit opue = new ObjectPropertyUndoableEdit(this.element, "Text", String.class, oldValue, newValue);
            IReportManager.getInstance().addUndoableEdit(opue);
        }
    }
}

