/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.designer.outline.nodes.properties;

import com.jaspersoft.ireport.designer.IReportManager;
import com.jaspersoft.ireport.designer.sheet.Tag;
import com.jaspersoft.ireport.designer.sheet.editors.ComboBoxPropertyEditor;
import com.jaspersoft.ireport.designer.undo.ObjectPropertyUndoableEdit;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyEditor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import net.sf.jasperreports.engine.JRStyle;
import net.sf.jasperreports.engine.design.JRDesignElement;
import net.sf.jasperreports.engine.design.JRDesignStyle;
import net.sf.jasperreports.engine.design.JasperDesign;
import org.openide.nodes.PropertySupport;
import org.openide.util.WeakListeners;

public final class StyleProperty
extends PropertySupport
implements PropertyChangeListener {
    final JRDesignElement element;
    final JasperDesign jasperDesign;
    private ComboBoxPropertyEditor editor;

    public StyleProperty(JRDesignElement element, JasperDesign jasperDesign) {
        super("parentStyleNameReference", String.class, "Style", "The optional style to use for this element. Can be the name of a locally defined style or the name of a style defined in an external style template file.", true, true);
        this.element = element;
        this.jasperDesign = jasperDesign;
        this.setValue("canEditAsText", Boolean.TRUE);
        this.setValue("oneline", Boolean.TRUE);
        this.setValue("suppressCustomEditor", Boolean.FALSE);
        jasperDesign.getEventSupport().addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)jasperDesign.getEventSupport()));
    }

    public PropertyEditor getPropertyEditor() {
        if (this.editor == null) {
            this.editor = new ComboBoxPropertyEditor(true, this.getListOfTags());
        }
        return this.editor;
    }

    public Object getValue() throws IllegalAccessException, InvocationTargetException {
        String name = this.element.getStyleNameReference();
        if (this.element.getStyle() != null) {
            name = this.element.getStyle().getName();
        }
        return name == null ? "" : name;
    }

    public void setValue(Object val) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        String newValue = "" + val;
        JRStyle newStyle = null;
        if (val instanceof JRStyle) {
            newValue = ((JRStyle)val).getName();
            newStyle = (JRStyle)val;
        } else if (val == null || newValue.length() == 0) {
            newValue = null;
        }
        String oldValue = this.element.getStyleNameReference();
        JRStyle oldStyle = this.element.getStyle();
        this.element.setStyleNameReference(newValue);
        this.element.setStyle(newStyle);
        ObjectPropertyUndoableEdit urob = new ObjectPropertyUndoableEdit(this.element, "StyleNameReference", String.class, oldValue, newValue);
        ObjectPropertyUndoableEdit urob_style = new ObjectPropertyUndoableEdit(this.element, "Style", JRStyle.class, oldStyle, newStyle);
        urob.concatenate(urob_style);
        IReportManager.getInstance().addUndoableEdit(urob);
    }

    public void propertyChange(PropertyChangeEvent evt) {
        if (this.editor == null) {
            return;
        }
        if (evt.getPropertyName() == null) {
            return;
        }
        if (evt.getPropertyName().equals("styles") || evt.getPropertyName().equals("name")) {
            this.editor.setTagValues(this.getListOfTags());
        }
    }

    private ArrayList getListOfTags() {
        ArrayList<Tag> l = new ArrayList<Tag>();
        l.add(new Tag(null, ""));
        List styles = this.jasperDesign.getStylesList();
        for (int i = 0; i < styles.size(); ++i) {
            JRDesignStyle style = (JRDesignStyle)styles.get(i);
            l.add(new Tag(style, style.getName()));
            style.getEventSupport().addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)style.getEventSupport()));
        }
        return l;
    }
}

