/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.designer.outline.nodes.properties;

import com.jaspersoft.ireport.designer.IReportManager;
import com.jaspersoft.ireport.designer.undo.ObjectPropertyUndoableEdit;
import java.lang.reflect.InvocationTargetException;
import net.sf.jasperreports.engine.design.JRDesignImage;
import org.openide.nodes.PropertySupport;

public final class LazyProperty
extends PropertySupport.ReadWrite {
    private final JRDesignImage element;

    public LazyProperty(JRDesignImage element) {
        super("lazy", Boolean.class, "Is Lazy", "If set to true, this property avoid the load of the image at fill time.");
        this.element = element;
    }

    public Object getValue() throws IllegalAccessException, InvocationTargetException {
        return new Boolean(this.element.isLazy());
    }

    public void setValue(Object val) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        if (val != null && val instanceof Boolean) {
            Boolean oldValue = this.element.isLazy();
            Boolean newValue = (Boolean)val;
            this.element.setLazy(newValue.booleanValue());
            ObjectPropertyUndoableEdit urob = new ObjectPropertyUndoableEdit(this.element, "Lazy", Boolean.TYPE, oldValue, newValue);
            IReportManager.getInstance().addUndoableEdit(urob);
        }
    }

    public boolean isDefaultValue() {
        return !this.element.isLazy();
    }

    public void restoreDefaultValue() throws IllegalAccessException, InvocationTargetException {
        this.setValue(false);
    }

    public boolean supportsDefaultValue() {
        return true;
    }
}

