/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.designer.outline.nodes;

import com.jaspersoft.ireport.designer.IReportManager;
import com.jaspersoft.ireport.designer.ModelUtils;
import com.jaspersoft.ireport.designer.dnd.DnDUtilities;
import com.jaspersoft.ireport.designer.outline.NewTypesUtils;
import com.jaspersoft.ireport.designer.outline.nodes.IRIndexedNode;
import com.jaspersoft.ireport.designer.outline.nodes.StyleNode;
import com.jaspersoft.ireport.designer.outline.nodes.StylesChildren;
import com.jaspersoft.ireport.designer.undo.AddStyleUndoableEdit;
import java.awt.datatransfer.Transferable;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.swing.Action;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRStyle;
import net.sf.jasperreports.engine.design.JRDesignStyle;
import net.sf.jasperreports.engine.design.JasperDesign;
import org.openide.actions.NewAction;
import org.openide.actions.PasteAction;
import org.openide.actions.ReorderAction;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.nodes.NodeEvent;
import org.openide.nodes.NodeListener;
import org.openide.nodes.NodeMemberEvent;
import org.openide.nodes.NodeReorderEvent;
import org.openide.nodes.NodeTransfer;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.actions.SystemAction;
import org.openide.util.datatransfer.NewType;
import org.openide.util.datatransfer.PasteType;
import org.openide.util.lookup.Lookups;
import org.openide.util.lookup.ProxyLookup;

public class StylesNode
extends IRIndexedNode
implements PropertyChangeListener {
    private JasperDesign jd = null;

    public StylesNode(JasperDesign jd, Lookup doLkp) {
        this(new StylesChildren(jd, doLkp), jd, doLkp);
    }

    public StylesNode(StylesChildren pc, JasperDesign jd, Lookup doLkp) {
        super((Children)pc, pc.getIndex(), (Lookup)new ProxyLookup(new Lookup[]{doLkp, Lookups.singleton((Object)jd)}));
        this.addNodeListener(new NodeListener(){

            public void childrenAdded(NodeMemberEvent ev) {
            }

            public void childrenRemoved(NodeMemberEvent ev) {
            }

            public void childrenReordered(NodeReorderEvent ev) {
                List list = StylesNode.this.getJasperDesign().getStylesList();
                ArrayList<JRDesignStyle> newList = new ArrayList<JRDesignStyle>();
                Node[] nodes = StylesNode.this.getChildren().getNodes();
                for (int i = 0; i < nodes.length; ++i) {
                    JRDesignStyle s = ((StyleNode)nodes[i]).getStyle();
                    newList.add(s);
                }
                list.clear();
                list.addAll(newList);
                StylesNode.this.getJasperDesign().getEventSupport().firePropertyChange(new PropertyChangeEvent(StylesNode.this.getJasperDesign(), "styles", null, null));
            }

            public void nodeDestroyed(NodeEvent ev) {
            }

            public void propertyChange(PropertyChangeEvent evt) {
            }
        });
        this.jd = jd;
        jd.getEventSupport().addPropertyChangeListener((PropertyChangeListener)this);
        this.setDisplayName("Styles");
        this.setIconBaseWithExtension("com/jaspersoft/ireport/designer/resources/styles-16.png");
    }

    public PasteType getDropType(Transferable t, int action, int index) {
        JRDesignStyle style;
        Node dropNode = NodeTransfer.node((Transferable)t, (int)7);
        final int dropAction = DnDUtilities.getTransferAction(t);
        if (null != dropNode && null != (style = (JRDesignStyle)dropNode.getLookup().lookup(JRDesignStyle.class))) {
            return new PasteType(){

                public Transferable paste() throws IOException {
                    List list = StylesNode.this.getJasperDesign().getStylesList();
                    int currentIndex = -1;
                    for (int i = 0; i < list.size(); ++i) {
                        JRDesignStyle s = (JRDesignStyle)list.get(i);
                        if (s != style) continue;
                        currentIndex = i;
                    }
                    if ((dropAction & 6) != 0) {
                        int newIndex = -1;
                        if (currentIndex != -1) {
                            Node[] nodes = StylesNode.this.getChildren().getNodes();
                            for (int i = 0; i < nodes.length; ++i) {
                                if (((StyleNode)nodes[i]).getStyle() != style) continue;
                                newIndex = i;
                                break;
                            }
                            list.remove(style);
                            if (newIndex == -1) {
                                list.add(style);
                                newIndex = list.indexOf(style);
                            } else {
                                list.add(newIndex, style);
                            }
                            AddStyleUndoableEdit undo = new AddStyleUndoableEdit(style, StylesNode.this.getJasperDesign());
                            IReportManager.getInstance().addUndoableEdit(undo);
                        }
                    } else {
                        try {
                            JRDesignStyle newStyle = ModelUtils.cloneStyle(style);
                            Map map = StylesNode.this.getJasperDesign().getStylesMap();
                            int k = 1;
                            while (map.containsKey(newStyle.getName())) {
                                newStyle.setName(style.getName() + "_" + k);
                                ++k;
                            }
                            StylesNode.this.getJasperDesign().addStyle((JRStyle)newStyle);
                            AddStyleUndoableEdit undo = new AddStyleUndoableEdit(style, StylesNode.this.getJasperDesign());
                            IReportManager.getInstance().addUndoableEdit(undo);
                        }
                        catch (JRException ex) {
                            Exceptions.printStackTrace((Throwable)ex);
                        }
                    }
                    return null;
                }
            };
        }
        return null;
    }

    protected void createPasteTypes(Transferable t, List s) {
        super.createPasteTypes(t, s);
        PasteType paste = this.getDropType(t, 2, -1);
        if (null != paste) {
            s.add(paste);
        }
    }

    public Action[] getActions(boolean context) {
        return new Action[]{SystemAction.get(NewAction.class), SystemAction.get(PasteAction.class), SystemAction.get(ReorderAction.class)};
    }

    public boolean canDestroy() {
        return false;
    }

    public boolean hasCustomizer() {
        return true;
    }

    public JasperDesign getJasperDesign() {
        return this.jd;
    }

    public NewType[] getNewTypes() {
        return NewTypesUtils.getNewType(8, (Node)this);
    }

    public void propertyChange(PropertyChangeEvent evt) {
        IReportManager.getInstance().notifyReportChange();
        if (evt.getPropertyName().equals("styles")) {
            ((StylesChildren)this.getChildren()).recalculateKeys();
        }
    }
}

