/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.designer.dnd;

import com.jaspersoft.ireport.designer.IReportManager;
import com.jaspersoft.ireport.designer.ModelUtils;
import com.jaspersoft.ireport.designer.ReportObjectScene;
import com.jaspersoft.ireport.designer.outline.OutlineTopComponent;
import com.jaspersoft.ireport.designer.palette.PaletteItem;
import com.jaspersoft.ireport.designer.palette.PaletteUtils;
import java.awt.Point;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.io.IOException;

class DesignerDropTargetListener
implements DropTargetListener {
    public DesignerDropTargetListener(ReportObjectScene scene) {
    }

    public void dragEnter(DropTargetDragEvent dtde) {
        if (!this.acceptDataFlavor(dtde.getCurrentDataFlavors())) {
            dtde.rejectDrag();
            return;
        }
        if (!this.isInDocument(dtde.getLocation())) {
            dtde.rejectDrag();
            return;
        }
        dtde.acceptDrag(3);
    }

    public void dragOver(DropTargetDragEvent dtde) {
        if (!this.acceptDataFlavor(dtde.getCurrentDataFlavors())) {
            dtde.rejectDrag();
            return;
        }
        if (!this.isInDocument(dtde.getLocation())) {
            dtde.rejectDrag();
            return;
        }
        PaletteItem paletteItem = null;
        try {
            paletteItem = (PaletteItem)dtde.getTransferable().getTransferData(PaletteUtils.PALETTE_ITEM_DATA_FLAVOR);
            dtde.acceptDrag(3);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            dtde.rejectDrag();
        }
    }

    public void dropActionChanged(DropTargetDragEvent dtde) {
    }

    public void dragExit(DropTargetEvent dte) {
    }

    public void drop(DropTargetDropEvent dtde) {
        PaletteItem paletteItem = null;
        try {
            paletteItem = (PaletteItem)dtde.getTransferable().getTransferData(PaletteUtils.PALETTE_ITEM_DATA_FLAVOR);
            dtde.acceptDrop(3);
            paletteItem.drop(dtde);
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        catch (UnsupportedFlavorException ex) {
            ex.printStackTrace();
        }
    }

    private void doDragOver(DropTargetDragEvent dtde) {
        dtde.acceptDrag(3);
    }

    private void doDrop(DropTargetDropEvent dtde) {
        dtde.acceptDrop(3);
    }

    private boolean acceptDataFlavor(DataFlavor[] falvors) {
        for (int i = 0; i < falvors.length; ++i) {
            DataFlavor dataFlavor = falvors[i];
            if (!dataFlavor.match(PaletteUtils.PALETTE_ITEM_DATA_FLAVOR)) continue;
            return true;
        }
        return false;
    }

    private boolean isInDocument(Point location) {
        ReportObjectScene scene = OutlineTopComponent.getDefault().getCurrentJrxmlVisualView().getReportDesignerPanel().getScene();
        Point p = scene.convertViewToScene(location);
        return ModelUtils.getBandAt(IReportManager.getInstance().getActiveReport(), p) != null;
    }
}

