/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.designer.data.fieldsproviders;

import com.jaspersoft.ireport.designer.FieldsProviderEditor;
import com.jaspersoft.ireport.designer.IReportManager;
import com.jaspersoft.ireport.designer.data.FieldClassWrapper;
import com.jaspersoft.ireport.designer.data.JBTreeCellRenderer;
import com.jaspersoft.ireport.designer.data.ReportQueryDialog;
import com.jaspersoft.ireport.designer.data.TreeJRField;
import com.jaspersoft.ireport.designer.data.fieldsproviders.hibernate.HQLFieldsReader;
import com.jaspersoft.ireport.designer.utils.Misc;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyDescriptor;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.table.DefaultTableModel;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import net.sf.jasperreports.engine.design.JRDesignField;
import org.apache.commons.beanutils.PropertyUtils;

public class BeanInspectorPanel
extends JPanel
implements FieldsProviderEditor {
    private boolean pathOnDescription = false;
    private JTable jTableFields = null;
    private boolean comboVisible = true;
    private ReportQueryDialog reportQueryDialog = null;
    private JButton jButton2;
    private JButton jButton3;
    private JComboBox jComboBox1;
    private JLabel jLabel1;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JScrollPane jScrollPane1;
    private JTree jTree1;
    int lastExecution = 0;

    public BeanInspectorPanel() {
        this.initComponents();
        DefaultTreeModel dttm = (DefaultTreeModel)this.jTree1.getModel();
        DefaultMutableTreeNode root = new DefaultMutableTreeNode();
        this.jTree1.setModel(new DefaultTreeModel(root));
        this.jTree1.setCellRenderer(new JBTreeCellRenderer());
    }

    public void setClassNames(List classNames) {
        if (classNames == null) {
            return;
        }
        this.jComboBox1.removeAllItems();
        for (int i = 0; i < classNames.size(); ++i) {
            this.jComboBox1.addItem(classNames.get(i));
        }
        this.jComboBox1ActionPerformed(null);
    }

    public void setClassName(String className) {
        DefaultMutableTreeNode root = (DefaultMutableTreeNode)this.jTree1.getModel().getRoot();
        root.removeAllChildren();
        this.jTree1.updateUI();
        if (className != null && className.trim().length() > 0) {
            this.exploreBean(root, className, "");
        }
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.jLabel1 = new JLabel();
        this.jComboBox1 = new JComboBox();
        this.jScrollPane1 = new JScrollPane();
        this.jTree1 = new JTree();
        this.jPanel2 = new JPanel();
        this.jButton2 = new JButton();
        this.jButton3 = new JButton();
        this.setLayout(new GridBagLayout());
        this.jPanel1.setLayout(new GridBagLayout());
        this.jLabel1.setText("Bean");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.jPanel1.add((Component)this.jLabel1, gridBagConstraints);
        this.jComboBox1.setMinimumSize(new Dimension(51, 22));
        this.jComboBox1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                BeanInspectorPanel.this.jComboBox1ActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(4, 0, 4, 0);
        this.jPanel1.add((Component)this.jComboBox1, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.jPanel1, gridBagConstraints);
        this.jTree1.setRootVisible(false);
        this.jTree1.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                BeanInspectorPanel.this.jTree1MouseClicked1(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.jTree1);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 4, 0, 0);
        this.add((Component)this.jScrollPane1, gridBagConstraints);
        this.jPanel2.setLayout(new GridBagLayout());
        this.jButton2.setText("Add selected field(s)");
        this.jButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                BeanInspectorPanel.this.jButton2ActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 12;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(2, 0, 2, 4);
        this.jPanel2.add((Component)this.jButton2, gridBagConstraints);
        this.jButton3.setText("Clear fields list");
        this.jButton3.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                BeanInspectorPanel.this.jButton2ActionPerformed1(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 12;
        gridBagConstraints.insets = new Insets(2, 0, 2, 0);
        this.jPanel2.add((Component)this.jButton3, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 4, 0, 0);
        this.add((Component)this.jPanel2, gridBagConstraints);
    }

    private void jButton2ActionPerformed1(ActionEvent evt) {
        DefaultTableModel dtm = (DefaultTableModel)this.getJTableFields().getModel();
        dtm.setRowCount(0);
    }

    private void jButton2ActionPerformed(ActionEvent evt) {
        DefaultTableModel dtm = (DefaultTableModel)this.getJTableFields().getModel();
        TreePath[] paths = this.jTree1.getSelectionPaths();
        if (paths == null) {
            return;
        }
        for (int i = 0; i < paths.length; ++i) {
            boolean valid = true;
            TreePath tp = paths[i];
            TreeJRField tjrf = (TreeJRField)((DefaultMutableTreeNode)tp.getLastPathComponent()).getUserObject();
            String returnType = Misc.getJRFieldType(tjrf.getObj().getName());
            JRDesignField field = new JRDesignField();
            field.setName(tjrf.getField().getName());
            field.setValueClassName(returnType);
            field.setDescription(tjrf.getField().getDescription());
            Vector<Object> row = new Vector<Object>();
            row.addElement(field);
            row.addElement(field.getValueClassName());
            row.addElement(field.getDescription());
            if (this.isComboVisible() && this.jComboBox1.getSelectedItem() instanceof FieldClassWrapper) {
                FieldClassWrapper cw = (FieldClassWrapper)this.jComboBox1.getSelectedItem();
                field.setName(cw.getFieldName() + "." + field.getDescription());
                field.setDescription(field.getName());
            }
            boolean found = this.fieldAlreadyExists(field);
            String baseName = field.getName();
            int j = 1;
            while (this.isPathOnDescription() && found) {
                field.setName(baseName + "_" + j);
                found = this.fieldAlreadyExists(field);
                ++j;
            }
            if (found) continue;
            dtm.addRow(row);
            this.getJTableFields().getSelectionModel().addSelectionInterval(this.getJTableFields().getRowCount() - 1, this.getJTableFields().getRowCount() - 1);
        }
    }

    private void jComboBox1ActionPerformed(ActionEvent evt) {
        Object obj = this.jComboBox1.getSelectedItem();
        if (obj == null) {
            this.setClassName(null);
            return;
        }
        if (obj instanceof String) {
            this.setClassName((String)obj);
        }
        if (obj instanceof FieldClassWrapper) {
            this.setClassName(((FieldClassWrapper)obj).getClassType());
        }
    }

    private boolean fieldAlreadyExists(JRDesignField field) {
        boolean found = false;
        for (int j = 0; j < this.getJTableFields().getRowCount(); ++j) {
            Object ff = this.getJTableFields().getValueAt(j, 0);
            if (!(ff instanceof JRDesignField) || !((JRDesignField)ff).getName().equals(field.getName())) continue;
            found = true;
            break;
        }
        return found;
    }

    private void jTree1MouseClicked1(MouseEvent evt) {
        if (evt.getClickCount() == 2 && evt.getButton() == 1) {
            TreeJRField jrf;
            DefaultMutableTreeNode tn = (DefaultMutableTreeNode)this.jTree1.getSelectionPath().getLastPathComponent();
            if (tn.getChildCount() > 0) {
                return;
            }
            if (tn.getUserObject() instanceof TreeJRField && !(jrf = (TreeJRField)tn.getUserObject()).getObj().isPrimitive() && !jrf.getObj().getName().startsWith("java.lang.")) {
                this.exploreBean(tn, jrf.getObj().getName(), this.isPathOnDescription() ? Misc.nvl(jrf.getField().getDescription(), "") : Misc.nvl(jrf.getField().getName(), ""));
            }
        }
    }

    public void exploreBean(DefaultMutableTreeNode root, String classname, String parentPath) {
        try {
            root.removeAllChildren();
            if (parentPath.length() > 0) {
                parentPath = parentPath + ".";
            }
            IReportManager.getInstance();
            Class<?> clazz = Class.forName(classname, true, IReportManager.getReportClassLoader());
            PropertyDescriptor[] pd = PropertyUtils.getPropertyDescriptors(clazz);
            for (int nd = 0; nd < pd.length; ++nd) {
                String fieldName = pd[nd].getName();
                if (pd[nd].getPropertyType() == null || pd[nd].getReadMethod() == null) continue;
                String returnType = pd[nd].getPropertyType().getName();
                JRDesignField field = new JRDesignField();
                field.setName(fieldName);
                field.setValueClassName(returnType);
                if (this.isPathOnDescription()) {
                    field.setDescription(parentPath + fieldName);
                } else {
                    field.setName(parentPath + fieldName);
                }
                TreeJRField jtf = new TreeJRField();
                jtf.setField(field);
                jtf.setObj(pd[nd].getPropertyType());
                boolean bChildrens = true;
                if (pd[nd].getPropertyType().isPrimitive() || pd[nd].getPropertyType().getName().startsWith("java.lang.")) {
                    bChildrens = false;
                }
                root.add(new DefaultMutableTreeNode(jtf, bChildrens));
            }
            this.jTree1.expandPath(new TreePath(root.getPath()));
            this.jTree1.updateUI();
        }
        catch (ClassNotFoundException cnf) {
            JOptionPane.showMessageDialog(this, Misc.formatString("Class not found error!!\nCheck your classpath and retry!\n{0}", new Object[]{cnf.getMessage()}), "Error", 0);
            return;
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(this, ex.getMessage(), "Error", 0);
            return;
        }
    }

    public JTable getJTableFields() {
        return this.jTableFields;
    }

    public void setJTableFields(JTable jTableFields) {
        this.jTableFields = jTableFields;
    }

    public boolean isComboVisible() {
        return this.comboVisible;
    }

    public void setComboVisible(boolean comboVisible) {
        this.comboVisible = comboVisible;
        this.jPanel1.setVisible(comboVisible);
    }

    public boolean isPathOnDescription() {
        return this.pathOnDescription;
    }

    public void setPathOnDescription(boolean pathOnDescription) {
        this.pathOnDescription = pathOnDescription;
    }

    public void queryChanged(String newQuery) {
        ++this.lastExecution;
        int thisExecution = this.lastExecution++;
        String error_msg = "";
        int in = this.lastExecution;
        if (this.getReportQueryDialog() == null) {
            return;
        }
        this.getReportQueryDialog().getJLabelStatusSQL().setText("Executing HQL query....");
        try {
            Thread thread = Thread.currentThread();
            IReportManager.getInstance();
            thread.setContextClassLoader(IReportManager.getReportClassLoader());
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        if (in < this.lastExecution) {
            return;
        }
        HQLFieldsReader hqlFR = new HQLFieldsReader(newQuery, this.getReportQueryDialog().getDataset().getParametersList());
        if (in < this.lastExecution) {
            return;
        }
        try {
            Vector fields = hqlFR.readFields();
            ArrayList<Object[]> columns = new ArrayList<Object[]>();
            for (int i = 0; i < fields.size(); ++i) {
                JRDesignField field = (JRDesignField)fields.elementAt(i);
                columns.add(new Object[]{field, field.getValueClassName(), field.getDescription()});
            }
            Vector v = hqlFR.getNotScalars();
            if (v.size() == 0) {
                v = null;
            }
            if (in < this.lastExecution) {
                return;
            }
            this.setBeanExplorerFromWorker(v, true, true);
            if (in < this.lastExecution) {
                return;
            }
            this.setColumnsFromWorker(columns);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            this.setBeanExplorerFromWorker(null, true, true);
            this.setColumnErrorFromWork("Error: " + ex.getMessage());
        }
        this.getReportQueryDialog().getJLabelStatusSQL().setText("Ready");
    }

    protected void setColumnErrorFromWork(final String error_msg) {
        try {
            Runnable r = new Runnable(){

                public void run() {
                    BeanInspectorPanel.this.getReportQueryDialog().setColumnsError(error_msg);
                    BeanInspectorPanel.this.getReportQueryDialog().getQueryEditorPane().requestFocusInWindow();
                }
            };
            if (SwingUtilities.isEventDispatchThread()) {
                r.run();
            } else {
                SwingUtilities.invokeAndWait(r);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void setColumnsFromWorker(final List columns) {
        try {
            Runnable r = new Runnable(){

                public void run() {
                    BeanInspectorPanel.this.getReportQueryDialog().setColumns(columns);
                    BeanInspectorPanel.this.getReportQueryDialog().getQueryEditorPane().requestFocusInWindow();
                }
            };
            if (SwingUtilities.isEventDispatchThread()) {
                r.run();
            } else {
                SwingUtilities.invokeAndWait(r);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void setBeanExplorerFromWorker(final Vector v, final boolean pathOnDescription, final boolean useCombo) {
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                public void run() {
                    Vector v1 = v;
                    if (v1 == null) {
                        v1 = new Vector();
                    }
                    BeanInspectorPanel.this.setComboVisible(useCombo);
                    BeanInspectorPanel.this.setPathOnDescription(pathOnDescription);
                    BeanInspectorPanel.this.setClassNames(v1);
                    BeanInspectorPanel.this.getReportQueryDialog().getQueryEditorPane().requestFocusInWindow();
                    BeanInspectorPanel.this.getReportQueryDialog().getQueryEditorPane().requestFocus();
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public ReportQueryDialog getReportQueryDialog() {
        return this.reportQueryDialog;
    }

    public void setReportQueryDialog(ReportQueryDialog reportQueryDialog) {
        this.reportQueryDialog = reportQueryDialog;
    }
}

