/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.designer.actions;

import com.jaspersoft.ireport.designer.IReportManager;
import com.jaspersoft.ireport.designer.outline.nodes.ReportNode;
import com.jaspersoft.ireport.designer.undo.AddDatasetUndoableEdit;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.design.JRDesignDataset;
import org.openide.nodes.Node;
import org.openide.util.Exceptions;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.actions.NodeAction;

public final class AddDatasetAction
extends NodeAction {
    private static AddDatasetAction instance = null;

    public static synchronized AddDatasetAction getInstance() {
        if (instance == null) {
            instance = new AddDatasetAction();
        }
        return instance;
    }

    private AddDatasetAction() {
    }

    public String getName() {
        return NbBundle.getMessage(AddDatasetAction.class, (String)"CTL_AddDatasetAction");
    }

    protected void initialize() {
        super.initialize();
        this.putValue("noIconInMenu", Boolean.TRUE);
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    protected boolean asynchronous() {
        return false;
    }

    protected void performAction(Node[] activatedNodes) {
        if (activatedNodes.length > 0 && activatedNodes[0] instanceof ReportNode) {
            try {
                ReportNode node = (ReportNode)activatedNodes[0];
                JRDesignDataset newDataset = new JRDesignDataset(false);
                String name = "dataset";
                int i = 1;
                while (true) {
                    if (!node.getJasperDesign().getDatasetMap().containsKey(name + i)) break;
                    ++i;
                }
                newDataset.setName(name + i);
                node.getJasperDesign().addDataset(newDataset);
                AddDatasetUndoableEdit edit = new AddDatasetUndoableEdit(newDataset, node.getJasperDesign());
                IReportManager.getInstance().addUndoableEdit(edit);
            }
            catch (JRException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
    }

    protected boolean enable(Node[] activatedNodes) {
        if (activatedNodes == null || activatedNodes.length == 0) {
            return false;
        }
        return activatedNodes.length > 0 && activatedNodes[0] instanceof ReportNode;
    }
}

