/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.designer;

import com.jaspersoft.ireport.designer.IReportManager;
import com.jaspersoft.ireport.designer.outline.nodes.ElementNode;
import java.awt.Point;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import net.sf.jasperreports.crosstabs.JRCellContents;
import net.sf.jasperreports.crosstabs.JRCrosstabDataset;
import net.sf.jasperreports.crosstabs.design.JRDesignCellContents;
import net.sf.jasperreports.engine.JRBand;
import net.sf.jasperreports.engine.JRElement;
import net.sf.jasperreports.engine.JRElementGroup;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.JRGroup;
import net.sf.jasperreports.engine.JRHyperlink;
import net.sf.jasperreports.engine.JRHyperlinkParameter;
import net.sf.jasperreports.engine.JROrigin;
import net.sf.jasperreports.engine.JRPropertiesMap;
import net.sf.jasperreports.engine.design.JRDesignBand;
import net.sf.jasperreports.engine.design.JRDesignChartDataset;
import net.sf.jasperreports.engine.design.JRDesignDataset;
import net.sf.jasperreports.engine.design.JRDesignElement;
import net.sf.jasperreports.engine.design.JRDesignExpression;
import net.sf.jasperreports.engine.design.JRDesignField;
import net.sf.jasperreports.engine.design.JRDesignFrame;
import net.sf.jasperreports.engine.design.JRDesignGroup;
import net.sf.jasperreports.engine.design.JRDesignParameter;
import net.sf.jasperreports.engine.design.JRDesignStyle;
import net.sf.jasperreports.engine.design.JRDesignVariable;
import net.sf.jasperreports.engine.design.JasperDesign;
import org.openide.nodes.Children;
import org.openide.nodes.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModelUtils {
    public static JRDesignStyle cloneStyle(JRDesignStyle style) {
        JRDesignStyle newStyle = new JRDesignStyle();
        newStyle.setName(style.getName());
        return newStyle;
    }

    public static List<JRBand> getBands(JasperDesign jd) {
        int i;
        ArrayList<JRBand> list = new ArrayList<JRBand>();
        if (jd == null) {
            return list;
        }
        JRGroup[] groups = jd.getGroups();
        if (null != jd.getBackground()) {
            list.add(jd.getBackground());
        }
        if (null != jd.getTitle()) {
            list.add(jd.getTitle());
        }
        if (null != jd.getPageHeader()) {
            list.add(jd.getPageHeader());
        }
        if (null != jd.getColumnHeader()) {
            list.add(jd.getColumnHeader());
        }
        for (i = 0; i < groups.length; ++i) {
            if (null == groups[i].getGroupHeader()) continue;
            list.add(groups[i].getGroupHeader());
        }
        if (null != jd.getDetail()) {
            list.add(jd.getDetail());
        }
        for (i = groups.length - 1; i >= 0; --i) {
            if (null == groups[i].getGroupFooter()) continue;
            list.add(groups[i].getGroupFooter());
        }
        if (null != jd.getColumnFooter()) {
            list.add(jd.getColumnFooter());
        }
        if (null != jd.getPageFooter()) {
            list.add(jd.getPageFooter());
        }
        if (null != jd.getLastPageFooter()) {
            list.add(jd.getLastPageFooter());
        }
        if (null != jd.getSummary()) {
            list.add(jd.getSummary());
        }
        if (null != jd.getNoData()) {
            list.add(jd.getNoData());
        }
        return list;
    }

    public static JRDesignDataset getElementDataset(JRDesignElement element, JasperDesign jd) {
        JRCrosstabDataset elementDataset;
        JRDesignCellContents cellContent;
        JRDesignDataset dataset = jd.getMainDesignDataset();
        JRElementGroup group = ModelUtils.getTopElementGroup(element);
        if (group instanceof JRDesignCellContents && (cellContent = (JRDesignCellContents)group).getOrigin().getCrosstab().getDataset() != null && (elementDataset = cellContent.getOrigin().getCrosstab().getDataset()).getDatasetRun() != null) {
            String datasetName = elementDataset.getDatasetRun().getDatasetName();
            dataset = (JRDesignDataset)jd.getDatasetMap().get(datasetName);
        }
        return dataset;
    }

    public static JRDesignGroup getGroupFromBand(JasperDesign jd, JRDesignBand band) {
        if (band == null || jd == null || band.getOrigin().getGroupName() == null) {
            return null;
        }
        String s = band.getOrigin().getGroupName();
        JRGroup[] groups = jd.getGroups();
        for (int i = 0; i < groups.length; ++i) {
            if (!groups[i].getName().equals(s)) continue;
            return (JRDesignGroup)groups[i];
        }
        return null;
    }

    public static boolean isAncestorElemenetGroup(JRElementGroup parent, JRElementGroup g) {
        while (g != null) {
            if (g instanceof JRDesignBand || g instanceof JRDesignCellContents) {
                return false;
            }
            if (g == parent) {
                return true;
            }
            g = g.getElementGroup();
        }
        return false;
    }

    public static boolean isChildOf(JRDesignElement element, JRElement[] elements) {
        for (int i = 0; i < elements.length; ++i) {
            if (element == elements[i]) {
                return true;
            }
            if (!(elements[i] instanceof JRDesignFrame) || !ModelUtils.isChildOf(element, ((JRDesignFrame)elements[i]).getElements())) continue;
            return true;
        }
        return false;
    }

    public static boolean isGroupHeader(JRBand b, JasperDesign jd) {
        if (b == null) {
            return false;
        }
        JRGroup[] groups = jd.getGroups();
        for (int i = 0; i < groups.length; ++i) {
            if (b != groups[i].getGroupHeader()) continue;
            return true;
        }
        return false;
    }

    public static boolean isGroupFooter(JRBand b, JasperDesign jd) {
        if (b == null) {
            return false;
        }
        JRGroup[] groups = jd.getGroups();
        for (int i = 0; i < groups.length; ++i) {
            if (b != groups[i].getGroupFooter()) continue;
            return true;
        }
        return false;
    }

    public static String nameOf(JROrigin origin) {
        if (origin != null) {
            switch (origin.getBandType()) {
                case 1: {
                    return "background";
                }
                case 2: {
                    return "title";
                }
                case 3: {
                    return "pageHeader";
                }
                case 4: {
                    return "columnHeader";
                }
                case 6: {
                    return "detail";
                }
                case 8: {
                    return "columnFooter";
                }
                case 9: {
                    return "pageFooter";
                }
                case 10: {
                    return "lastPageFooter";
                }
                case 11: {
                    return "summary";
                }
                case 12: {
                    return "noData";
                }
                case 5: {
                    return origin.getGroupName() + "GroupHeader";
                }
                case 7: {
                    return origin.getGroupName() + "GroupFooter";
                }
            }
        }
        return "unknow";
    }

    public static String nameOf(JRBand b, JasperDesign jd) {
        return ModelUtils.nameOf(((JRDesignBand)b).getOrigin());
    }

    public static JRBand getPreviousBand(JRBand b, JasperDesign jd) {
        if (b == null || jd == null) {
            return null;
        }
        List<JRBand> bands = ModelUtils.getBands(jd);
        JRBand previous = null;
        for (JRBand tmpBand : bands) {
            if (tmpBand == b) {
                return previous;
            }
            previous = tmpBand;
        }
        return previous;
    }

    public static int getBandLocation(JRBand b, JasperDesign jd) {
        int yLocation = jd.getTopMargin();
        List<JRBand> bands = ModelUtils.getBands(jd);
        for (JRBand tmpBand : bands) {
            if (tmpBand == b) {
                return yLocation;
            }
            yLocation += tmpBand.getHeight();
        }
        return yLocation;
    }

    public static int getBandHeight(JRBand b) {
        return b != null ? b.getHeight() : 0;
    }

    public static int getMaxBandHeight(JRDesignBand b, JasperDesign jd) {
        if (b == null || jd == null) {
            return 0;
        }
        JROrigin origin = b.getOrigin();
        int topBottomMargins = jd.getTopMargin() + jd.getBottomMargin();
        if (origin.getBandType() == 2 && jd.isTitleNewPage() || origin.getBandType() == 11 && jd.isSummaryNewPage() || origin.getBandType() == 1 || origin.getBandType() == 12) {
            return jd.getPageHeight() - topBottomMargins;
        }
        int basicBandsHeight = 0;
        int titleHeight = jd.getTitle() != null ? jd.getTitle().getHeight() : 0;
        basicBandsHeight += topBottomMargins;
        basicBandsHeight += jd.getPageHeader() != null ? jd.getPageHeader().getHeight() : 0;
        basicBandsHeight += jd.getColumnHeader() != null ? jd.getColumnHeader().getHeight() : 0;
        basicBandsHeight += jd.getColumnFooter() != null ? jd.getColumnFooter().getHeight() : 0;
        basicBandsHeight += jd.getPageFooter() != null ? jd.getPageFooter().getHeight() : 0;
        if (origin.getBandType() == 7 || origin.getBandType() == 5) {
            return jd.getPageHeight() - basicBandsHeight - (jd.isTitleNewPage() ? 0 : titleHeight);
        }
        int detailHeight = jd.getDetail() != null ? jd.getDetail().getHeight() : 0;
        return jd.getPageHeight() - basicBandsHeight + b.getHeight() - detailHeight;
    }

    public static JRBand bandOfElement(JRElement element, JasperDesign jd) {
        if (element == null || jd == null) {
            return null;
        }
        List<JRBand> bands = ModelUtils.getBands(jd);
        for (JRBand tmpBand : bands) {
            JRElement[] elements = tmpBand.getElements();
            for (int i = 0; i < elements.length; ++i) {
                if (element != elements[i]) continue;
                return tmpBand;
            }
        }
        return null;
    }

    public static int getDesignHeight(JasperDesign jd) {
        int designHeight = 0;
        if (jd != null) {
            designHeight += jd.getTopMargin();
            List<JRBand> bands = ModelUtils.getBands(jd);
            for (JRBand b : bands) {
                designHeight += b.getHeight();
            }
            designHeight += jd.getBottomMargin();
        }
        return designHeight;
    }

    public static int getMaximumDesignHeight(JasperDesign jd) {
        int maxDesignHeight = 3 * jd.getPageHeight();
        if (jd.isTitleNewPage()) {
            maxDesignHeight += jd.getPageHeight();
        }
        if (jd.isSummaryNewPage()) {
            maxDesignHeight += jd.getPageHeight();
        }
        return maxDesignHeight;
    }

    public static Node findElementNode(Node rootNode, JRElement element) {
        if (rootNode instanceof ElementNode && ((ElementNode)rootNode).getElement().equals(element)) {
            return rootNode;
        }
        if (rootNode == null) {
            return null;
        }
        Children children = rootNode.getChildren();
        Node[] nodes = children.getNodes();
        for (int i = 0; i < nodes.length; ++i) {
            Node node = ModelUtils.findElementNode(nodes[i], element);
            if (node == null) continue;
            return node;
        }
        return null;
    }

    public static JRDesignParameter cloneParameter(JRDesignParameter param) {
        JRDesignParameter newParam = new JRDesignParameter();
        newParam.setName(param.getName());
        newParam.setForPrompting(param.isForPrompting());
        newParam.setSystemDefined(param.isSystemDefined());
        newParam.setValueClassName(param.getValueClassName());
        newParam.setDescription(param.getDescription());
        if (param.getDefaultValueExpression() != null) {
            newParam.setDefaultValueExpression((JRExpression)ModelUtils.cloneExpression((JRExpression)((JRDesignExpression)param.getDefaultValueExpression())));
        }
        ModelUtils.replacePropertiesMap(param.getPropertiesMap(), newParam.getPropertiesMap());
        return newParam;
    }

    public static void replacePropertiesMap(JRPropertiesMap source, JRPropertiesMap dest) {
        int i;
        String[] propertyNames = source.getPropertyNames();
        if (propertyNames != null && propertyNames.length > 0) {
            for (i = 0; i < propertyNames.length; ++i) {
                dest.setProperty(propertyNames[i], source.getProperty(propertyNames[i]));
            }
        }
        if ((propertyNames = dest.getPropertyNames()) != null && propertyNames.length > 0) {
            for (i = 0; i < propertyNames.length; ++i) {
                if (source.containsProperty(propertyNames[i])) continue;
                dest.removeProperty(propertyNames[i]);
            }
        }
    }

    public static JRDesignExpression cloneExpression(JRExpression exp) {
        if (exp == null) {
            return null;
        }
        JRDesignExpression newExp = new JRDesignExpression();
        newExp.setValueClassName(exp.getValueClassName());
        newExp.setText(exp.getText());
        return newExp;
    }

    public static Point getParentLocation(JasperDesign jd, JRDesignElement element) {
        Point base = new Point(0, 0);
        if (element == null) {
            return base;
        }
        for (JRElementGroup grp = element.getElementGroup(); grp != null; grp = grp.getElementGroup()) {
            if (grp instanceof JRDesignBand) {
                JRDesignBand band = (JRDesignBand)grp;
                base.x = jd.getLeftMargin();
                base.y = ModelUtils.getBandLocation((JRBand)band, jd);
                break;
            }
            if (grp instanceof JRCellContents) {
                JRCellContents cell = (JRCellContents)grp;
                base.x = 0;
                base.y = 0;
                break;
            }
            if (!(grp instanceof JRDesignFrame)) continue;
            JRDesignFrame frame = (JRDesignFrame)grp;
            base = ModelUtils.getParentLocation(jd, (JRDesignElement)frame);
            base.x += frame.getX();
            base.y += frame.getY();
            break;
        }
        return base;
    }

    public static JRDesignField cloneField(JRDesignField field) throws CloneNotSupportedException {
        return (JRDesignField)field.clone();
    }

    public static JRDesignVariable cloneVariable(JRDesignVariable variable) {
        JRDesignVariable newVariable = new JRDesignVariable();
        newVariable.setName(variable.getName());
        newVariable.setValueClassName(variable.getValueClassName());
        newVariable.setCalculation(variable.getCalculation());
        newVariable.setExpression((JRExpression)ModelUtils.cloneExpression(variable.getExpression()));
        newVariable.setIncrementGroup(variable.getIncrementGroup());
        newVariable.setIncrementType(variable.getIncrementType());
        newVariable.setIncrementerFactoryClassName(variable.getIncrementerFactoryClassName());
        newVariable.setInitialValueExpression((JRExpression)ModelUtils.cloneExpression(variable.getInitialValueExpression()));
        newVariable.setResetGroup(variable.getResetGroup());
        newVariable.setResetType(variable.getResetType());
        newVariable.setSystemDefined(variable.isSystemDefined());
        return newVariable;
    }

    public static boolean containsProperty(Node.PropertySet[] sets, String propertyName) {
        for (int i = 0; i < sets.length; ++i) {
            Node.Property[] pp = sets[i].getProperties();
            for (int j = 0; j < pp.length; ++j) {
                String name = pp[j].getName();
                if (name == null || !name.equals(propertyName)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isElementChildOf(JRDesignElement element, JRElementGroup group) {
        for (JRElementGroup g1 = element.getElementGroup(); g1 != null; g1 = g1.getElementGroup()) {
            if (g1 != group) continue;
            return true;
        }
        return false;
    }

    public static boolean isOrphan(JRDesignElement element) {
        return ModelUtils.getTopElementGroup(element) == null;
    }

    public static JRElementGroup getTopElementGroup(JRDesignElement element) {
        for (JRElementGroup g1 = element.getElementGroup(); g1 != null; g1 = g1.getElementGroup()) {
            if (!(g1 instanceof JRDesignBand) && !(g1 instanceof JRDesignCellContents)) continue;
            return g1;
        }
        return null;
    }

    public static JRDesignBand getBandAt(JasperDesign jd, Point p) {
        if (p.x < jd.getLeftMargin()) {
            return null;
        }
        if (p.x > jd.getPageWidth() - jd.getRightMargin()) {
            return null;
        }
        if (p.y < jd.getTopMargin()) {
            return null;
        }
        List<JRBand> bands = ModelUtils.getBands(jd);
        int currentHeight = jd.getTopMargin();
        for (JRBand tmpBand : bands) {
            if (p.y >= (currentHeight += tmpBand.getHeight())) continue;
            return (JRDesignBand)tmpBand;
        }
        return null;
    }

    public static JRDesignDataset getDatasetFromChartDataset(JRDesignChartDataset dataset, JasperDesign jd) {
        JRDesignDataset ds = (JRDesignDataset)jd.getMainDataset();
        if (dataset.getDatasetRun() != null && dataset.getDatasetRun().getDatasetName() != null) {
            ds = (JRDesignDataset)jd.getDatasetMap().get(dataset.getDatasetRun().getDatasetName());
        }
        return ds;
    }

    public static void copyHyperlink(JRHyperlink from, JRHyperlink to) {
        if (from == null || to == null) {
            return;
        }
        try {
            ModelUtils.setHyperlinkAttribute(to, "HyperlinkAnchorExpression", JRExpression.class, from.getHyperlinkAnchorExpression() == null ? null : from.getHyperlinkAnchorExpression().clone());
            ModelUtils.setHyperlinkAttribute(to, "HyperlinkPageExpression", JRExpression.class, from.getHyperlinkPageExpression() == null ? null : from.getHyperlinkPageExpression().clone());
            ModelUtils.setHyperlinkAttribute(to, "HyperlinkReferenceExpression", JRExpression.class, from.getHyperlinkReferenceExpression() == null ? null : from.getHyperlinkReferenceExpression().clone());
            ModelUtils.setHyperlinkAttribute(to, "HyperlinkTarget", Byte.TYPE, from.getHyperlinkTarget());
            ModelUtils.setHyperlinkAttribute(to, "HyperlinkTooltipExpression", JRExpression.class, from.getHyperlinkTooltipExpression() == null ? null : from.getHyperlinkTooltipExpression().clone());
            ModelUtils.setHyperlinkAttribute(to, "LinkType", String.class, from.getLinkType() == null ? null : from.getLinkType());
            JRHyperlinkParameter[] params = from.getHyperlinkParameters();
            List parameters = ModelUtils.getHyperlinkParametersList(to);
            for (int i = 0; i < params.length; ++i) {
                parameters.add(params[0].clone());
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    private static List getHyperlinkParametersList(JRHyperlink hyperlink) {
        if (hyperlink == null) {
            return null;
        }
        try {
            Method m = hyperlink.getClass().getMethod("getHyperlinkParametersList", new Class[0]);
            return (List)m.invoke((Object)hyperlink, new Object[0]);
        }
        catch (Throwable t) {
            t.printStackTrace();
            return null;
        }
    }

    private static void setHyperlinkAttribute(JRHyperlink hyperlink, String attribute, Class clazz, Object value) {
        if (hyperlink == null) {
            return;
        }
        try {
            Method m = hyperlink.getClass().getMethod("set" + attribute, clazz);
            m.invoke((Object)hyperlink, value);
            IReportManager.getInstance().notifyReportChange();
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }
}

