/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.scripting.bsh;

import bsh.EvalError;
import java.io.IOException;
import org.springframework.scripting.ScriptCompilationException;
import org.springframework.scripting.ScriptFactory;
import org.springframework.scripting.ScriptSource;
import org.springframework.scripting.bsh.BshScriptUtils;

public class BshScriptFactory
implements ScriptFactory {
    private String scriptSourceLocator;
    private Class[] scriptInterfaces;

    public BshScriptFactory(String scriptSourceLocator, Class[] scriptInterfaces) {
        this.scriptSourceLocator = scriptSourceLocator;
        this.scriptInterfaces = scriptInterfaces;
    }

    public String getScriptSourceLocator() {
        return this.scriptSourceLocator;
    }

    public Class[] getScriptInterfaces() {
        return this.scriptInterfaces;
    }

    public boolean requiresConfigInterface() {
        return true;
    }

    public Object getScriptedObject(ScriptSource actualScriptSource, Class[] actualInterfaces) throws IOException, ScriptCompilationException {
        try {
            return BshScriptUtils.createBshObject(actualScriptSource.getScriptAsString(), actualInterfaces);
        }
        catch (EvalError ex) {
            throw new ScriptCompilationException("Could not compile BeanShell script: " + actualScriptSource, ex);
        }
    }
}

