/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.context.support;

import java.io.IOException;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.AbstractApplicationContext;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.io.support.ResourcePatternResolver;

public class GenericApplicationContext
extends AbstractApplicationContext
implements BeanDefinitionRegistry {
    private final DefaultListableBeanFactory beanFactory;
    private ResourceLoader resourceLoader;
    private boolean refreshed = false;

    public GenericApplicationContext() {
        this(new DefaultListableBeanFactory());
    }

    public GenericApplicationContext(DefaultListableBeanFactory beanFactory) {
        this.beanFactory = beanFactory;
    }

    public GenericApplicationContext(ApplicationContext parent) {
        this(new DefaultListableBeanFactory(), parent);
    }

    public GenericApplicationContext(DefaultListableBeanFactory beanFactory, ApplicationContext parent) {
        this.beanFactory = beanFactory;
        this.setParent(parent);
    }

    public void setParent(ApplicationContext parent) {
        super.setParent(parent);
        this.beanFactory.setParentBeanFactory(this.getInternalParentBeanFactory());
    }

    public void setResourceLoader(ResourceLoader resourceLoader) {
        this.resourceLoader = resourceLoader;
    }

    public Resource getResource(String location) {
        if (this.resourceLoader != null) {
            return this.resourceLoader.getResource(location);
        }
        return super.getResource(location);
    }

    public Resource[] getResources(String locationPattern) throws IOException {
        if (this.resourceLoader instanceof ResourcePatternResolver) {
            return ((ResourcePatternResolver)this.resourceLoader).getResources(locationPattern);
        }
        return super.getResources(locationPattern);
    }

    protected void refreshBeanFactory() throws IllegalStateException {
        if (this.refreshed) {
            throw new IllegalStateException("Multiple refreshs not supported: just call 'refresh' once");
        }
        this.refreshed = true;
    }

    public ConfigurableListableBeanFactory getBeanFactory() {
        return this.beanFactory;
    }

    public DefaultListableBeanFactory getDefaultListableBeanFactory() {
        return this.beanFactory;
    }

    public BeanDefinition getBeanDefinition(String beanName) throws BeansException {
        return this.beanFactory.getBeanDefinition(beanName);
    }

    public void registerBeanDefinition(String beanName, BeanDefinition beanDefinition) throws BeansException {
        this.beanFactory.registerBeanDefinition(beanName, beanDefinition);
    }

    public void registerAlias(String beanName, String alias) throws BeansException {
        this.beanFactory.registerAlias(beanName, alias);
    }
}

