/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.aop.target;

import java.io.Serializable;
import org.springframework.aop.TargetSource;
import org.springframework.util.Assert;

public final class SingletonTargetSource
implements TargetSource,
Serializable {
    private final Object target;

    public SingletonTargetSource(Object target) {
        Assert.notNull(target, "target is required");
        this.target = target;
    }

    public Class getTargetClass() {
        return this.target.getClass();
    }

    public Object getTarget() {
        return this.target;
    }

    public void releaseTarget(Object target) {
    }

    public boolean isStatic() {
        return true;
    }

    public int hashCode() {
        return this.target.hashCode();
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof SingletonTargetSource)) {
            return false;
        }
        SingletonTargetSource otherTargetSource = (SingletonTargetSource)other;
        return this.target.equals(otherTargetSource.target);
    }

    public String toString() {
        return "SingletonTargetSource for target: " + this.target;
    }
}

