/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package com.jaspersoft.ireport.designer.wizards;

import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.JList;
import javax.swing.JPanel;
import net.sf.jasperreports.engine.design.JRDesignField;
import net.sf.jasperreports.engine.design.JRDesignField;
import net.sf.jasperreports.engine.design.JRDesignField;

public final class FieldsSelectionVisualPanel extends JPanel {
 
    private FieldsSelectionWizardPanel panel = null;
    private boolean selectionChanged = false;
            
    /** Creates new form NewJrxmlVisualPanel2 */
    public FieldsSelectionVisualPanel(FieldsSelectionWizardPanel panel) {
        this.panel = panel;
        initComponents();
        
        // Fill the list...
        FieldsSelectionVisualPanel.FieldListCellRenderer renderer = new FieldsSelectionVisualPanel.FieldListCellRenderer();
        jList1.setCellRenderer(renderer);
        jList1.setModel(new DefaultListModel());
                
        jList2.setCellRenderer(renderer);
        jList2.setModel(new DefaultListModel());
        
        updateLists();
    }

    @Override
    public String getName() {
        return "Fields";
    }
    
    public void updateLists()
    {
        ((DefaultListModel)jList1.getModel()).clear(); 
        ((DefaultListModel)jList2.getModel()).clear(); 
        List<JRDesignField> discoveredFields = (List<JRDesignField>) panel.getWizard().getProperty("discoveredFields");
        if (discoveredFields != null)
        {
            for (JRDesignField field : discoveredFields)
            {
               ((DefaultListModel)jList1.getModel()).addElement(field);
            }
        }
        
        if (jList1.getModel().getSize() > 0)
        {
            jList1.setSelectedIndex(0);
        }
        updateButtons();
    }

    private void moveSelection(JList l1, JList l2)
    {
        if (l1.getSelectedIndex() < 0) return;
        
        selectionChanged = true;
        
        DefaultListModel model = (DefaultListModel)l1.getModel();
        DefaultListModel model2 = (DefaultListModel)l2.getModel();
        
        int last = model2.getSize();
       
        int[] selectedIndexes = l1.getSelectedIndices();
        for (int i=selectedIndexes.length-1; i>=0; --i)
        {
            int index = selectedIndexes[i];
            Object ele = model.elementAt(index);
            model.removeElementAt(index);
            model2.add(last, ele);
        }
        
        if (!model.isEmpty())
        {
            l1.setSelectedIndex(0);
        }
        
        l2.setSelectionInterval(last, model2.size()-1);
        
        updateButtons();
    }
    
    private void moveAll(JList l1, JList l2)
    {
        if (l1.getModel().getSize() == 0) return;
        l1.setSelectionInterval(0, l1.getModel().getSize()-1);
        moveSelection(l1, l2);
    }
    
    public void updateButtons()
    {
        jButtonSelect.setEnabled( jList1.getSelectedIndex() >= 0);
        jButtonSelectAll.setEnabled( jList1.getSelectedIndex() >= 0);
        jButtonUnselect.setEnabled( jList2.getSelectedIndex() >= 0);
        jButtonUnselectAll.setEnabled( jList2.getSelectedIndex() >= 0);
    }
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {
        java.awt.GridBagConstraints gridBagConstraints;

        jScrollPane1 = new javax.swing.JScrollPane();
        jList1 = new javax.swing.JList();
        jPanel1 = new javax.swing.JPanel();
        jButtonSelect = new javax.swing.JButton();
        jButtonSelectAll = new javax.swing.JButton();
        jButtonUnselect = new javax.swing.JButton();
        jButtonUnselectAll = new javax.swing.JButton();
        jScrollPane2 = new javax.swing.JScrollPane();
        jList2 = new javax.swing.JList();

        setPreferredSize(new java.awt.Dimension(100, 130));
        setLayout(new java.awt.GridBagLayout());

        jList1.addListSelectionListener(new javax.swing.event.ListSelectionListener() {
            public void valueChanged(javax.swing.event.ListSelectionEvent evt) {
                jList1ValueChanged(evt);
            }
        });
        jScrollPane1.setViewportView(jList1);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 4);
        add(jScrollPane1, gridBagConstraints);

        jPanel1.setMinimumSize(new java.awt.Dimension(30, 0));
        jPanel1.setPreferredSize(new java.awt.Dimension(30, 100));
        jPanel1.setLayout(new java.awt.GridBagLayout());

        org.openide.awt.Mnemonics.setLocalizedText(jButtonSelect, ">");
        jButtonSelect.setMargin(new java.awt.Insets(2, 4, 2, 4));
        jButtonSelect.setMinimumSize(new java.awt.Dimension(30, 30));
        jButtonSelect.setPreferredSize(new java.awt.Dimension(30, 30));
        jButtonSelect.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButtonSelectActionPerformed(evt);
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.insets = new java.awt.Insets(4, 0, 4, 0);
        jPanel1.add(jButtonSelect, gridBagConstraints);

        org.openide.awt.Mnemonics.setLocalizedText(jButtonSelectAll, ">>");
        jButtonSelectAll.setMargin(new java.awt.Insets(2, 4, 2, 4));
        jButtonSelectAll.setMinimumSize(new java.awt.Dimension(30, 30));
        jButtonSelectAll.setPreferredSize(new java.awt.Dimension(30, 30));
        jButtonSelectAll.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButtonSelectAllActionPerformed(evt);
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.insets = new java.awt.Insets(4, 0, 4, 0);
        jPanel1.add(jButtonSelectAll, gridBagConstraints);

        org.openide.awt.Mnemonics.setLocalizedText(jButtonUnselect, "<");
        jButtonUnselect.setMargin(new java.awt.Insets(2, 4, 2, 4));
        jButtonUnselect.setMinimumSize(new java.awt.Dimension(30, 30));
        jButtonUnselect.setPreferredSize(new java.awt.Dimension(30, 30));
        jButtonUnselect.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButtonUnselectActionPerformed(evt);
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.insets = new java.awt.Insets(4, 0, 4, 0);
        jPanel1.add(jButtonUnselect, gridBagConstraints);

        org.openide.awt.Mnemonics.setLocalizedText(jButtonUnselectAll, "<<");
        jButtonUnselectAll.setMargin(new java.awt.Insets(2, 4, 2, 4));
        jButtonUnselectAll.setMinimumSize(new java.awt.Dimension(30, 30));
        jButtonUnselectAll.setPreferredSize(new java.awt.Dimension(30, 30));
        jButtonUnselectAll.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButtonUnselectAllActionPerformed(evt);
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.insets = new java.awt.Insets(4, 0, 4, 0);
        jPanel1.add(jButtonUnselectAll, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.insets = new java.awt.Insets(4, 0, 4, 0);
        add(jPanel1, gridBagConstraints);

        jList2.addListSelectionListener(new javax.swing.event.ListSelectionListener() {
            public void valueChanged(javax.swing.event.ListSelectionEvent evt) {
                jList2ValueChanged(evt);
            }
        });
        jScrollPane2.setViewportView(jList2);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 4);
        add(jScrollPane2, gridBagConstraints);
    }// </editor-fold>//GEN-END:initComponents

    private void jButtonSelectActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonSelectActionPerformed
        moveSelection(jList1, jList2);
    }//GEN-LAST:event_jButtonSelectActionPerformed

    private void jButtonSelectAllActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonSelectAllActionPerformed
        moveAll(jList1, jList2);
    }//GEN-LAST:event_jButtonSelectAllActionPerformed

    private void jButtonUnselectActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonUnselectActionPerformed
        moveSelection(jList2, jList1);
    }//GEN-LAST:event_jButtonUnselectActionPerformed

    private void jButtonUnselectAllActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonUnselectAllActionPerformed
        moveAll(jList2, jList1);
    }//GEN-LAST:event_jButtonUnselectAllActionPerformed

    private void jList1ValueChanged(javax.swing.event.ListSelectionEvent evt) {//GEN-FIRST:event_jList1ValueChanged
        updateButtons();
    }//GEN-LAST:event_jList1ValueChanged

    private void jList2ValueChanged(javax.swing.event.ListSelectionEvent evt) {//GEN-FIRST:event_jList2ValueChanged
       updateButtons();
    }//GEN-LAST:event_jList2ValueChanged

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JButton jButtonSelect;
    private javax.swing.JButton jButtonSelectAll;
    private javax.swing.JButton jButtonUnselect;
    private javax.swing.JButton jButtonUnselectAll;
    private javax.swing.JList jList1;
    private javax.swing.JList jList2;
    private javax.swing.JPanel jPanel1;
    private javax.swing.JScrollPane jScrollPane1;
    private javax.swing.JScrollPane jScrollPane2;
    // End of variables declaration//GEN-END:variables

    public boolean isSelectionChanged() {
        return selectionChanged;
    }

    public void setSelectionChanged(boolean selectionChanged) {
        this.selectionChanged = selectionChanged;
    }
    // End of variables declaration

    static class FieldListCellRenderer extends DefaultListCellRenderer
    {

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        
            if (value instanceof JRDesignField)
            {
                value = ((JRDesignField)value).getName();
            }
           
            return super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
        }
        
    }
    
    public List<JRDesignField> getSelectedFields()
    {
        List<JRDesignField> list = new ArrayList<JRDesignField>();
        for (int i=0; i< jList2.getModel().getSize(); ++i)
        {
            list.add( (JRDesignField)jList2.getModel().getElementAt(i));
        }
        return list;
    }
}

