package com.jaspersoft.ireport.designer.outline;

import com.jaspersoft.ireport.designer.JrxmlVisualView;
import java.awt.BorderLayout;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.io.Serializable;
import java.util.logging.Logger;
import javax.swing.ActionMap;
import javax.swing.text.DefaultEditorKit;
import org.openide.awt.UndoRedo;
import org.openide.explorer.ExplorerManager;
import org.openide.explorer.ExplorerUtils;
import org.openide.explorer.view.BeanTreeView;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.lookup.AbstractLookup;
import org.openide.util.lookup.InstanceContent;
import org.openide.util.lookup.ProxyLookup;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;
//import org.openide.util.Utilities;

/**
 * Top component which displays something.
 */
final public class OutlineTopComponent extends TopComponent implements ExplorerManager.Provider{

    private static OutlineTopComponent instance;
    /** path to the icon used by the component and its open action */
//    static final String ICON_PATH = "SET/PATH/TO/ICON/HERE";
    private static final String PREFERRED_ID = "OutlineTopComponent";
    
    /** Dynamic Lookup content */
    private final InstanceContent ic;
    /** Lookup instance */
    private final Lookup lookup;
            
    private BeanTreeView view;
    private final ExplorerManager manager = new ExplorerManager();
    private JrxmlVisualView currentJrxmlVisualView = null;
    private boolean updatingSelection = false;
    private AbstractNode noReportNode = null;

    public synchronized boolean isUpdatingSelection() {
        return updatingSelection;
    }

    public synchronized void setUpdatingSelection(boolean updatingSelection) {
        this.updatingSelection = updatingSelection;
    }
    
    private OutlineTopComponent() {
        initComponents();

        setName(NbBundle.getMessage(OutlineTopComponent.class, "CTL_OutlineTopComponent"));
        setToolTipText(NbBundle.getMessage(OutlineTopComponent.class, "HINT_OutlineTopComponent"));
//        setIcon(Utilities.loadImage(ICON_PATH, true));
    
        this.ic = new InstanceContent();
        this.lookup = new AbstractLookup(ic);
        
        noReportNode = new AbstractNode(Children.LEAF);
        noReportNode.setDisplayName("Outline not available");
                
        ActionMap map = getActionMap();
        map.put(DefaultEditorKit.copyAction, ExplorerUtils.actionCopy(manager));
        map.put(DefaultEditorKit.cutAction, ExplorerUtils.actionCut(manager));
        map.put(DefaultEditorKit.pasteAction, ExplorerUtils.actionPaste(manager));
        map.put("delete", ExplorerUtils.actionDelete(manager, true));

        associateLookup( new ProxyLookup(lookup, ExplorerUtils.createLookup(manager, map)) );

        setLayout(new BorderLayout());
        view = new BeanTreeView();
        //view.setRootVisible(false);
        add(view, BorderLayout.CENTER);
        
        manager.addPropertyChangeListener(new PropertyChangeListener() {
            public void propertyChange(PropertyChangeEvent evt) {
                if (ExplorerManager.PROP_SELECTED_NODES.equals(evt.getPropertyName()))
                {
                    if (isUpdatingSelection()) return;
                    if (getCurrentJrxmlVisualView() != null)
                    {
                        getCurrentJrxmlVisualView().setSelectedNodes( getExplorerManager().getSelectedNodes());
                    }
                    /*
                    // Remove old selected nodes...
                    Node[] oldSelection = (Node[])evt.getOldValue();
                    Node[] newSelection = (Node[])evt.getNewValue();
                    for (int i=0; i<oldSelection.length; ++i)
                    {
                        ic.remove(oldSelection[i]);
                    }
                    for (int i=0; i<newSelection.length; ++i)
                    {
                        ic.add(newSelection[i]);
                    }
                    */
                }
            }
        });
    
        getExplorerManager().setRootContext(noReportNode);
    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc=" Generated Code ">//GEN-BEGIN:initComponents
    private void initComponents() {

        org.jdesktop.layout.GroupLayout layout = new org.jdesktop.layout.GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(0, 466, Short.MAX_VALUE)
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(0, 411, Short.MAX_VALUE)
        );
    }// </editor-fold>//GEN-END:initComponents


    // Variables declaration - do not modify//GEN-BEGIN:variables
    // End of variables declaration//GEN-END:variables

    /**
     * Gets default instance. Do not use directly: reserved for *.settings files only,
     * i.e. deserialization routines; otherwise you could get a non-deserialized instance.
     * To obtain the singleton instance, use {@link findInstance}.
     */
    public static synchronized OutlineTopComponent getDefault() {
        if (instance == null) {
            instance = new OutlineTopComponent();
        }
        return instance;
    }

    /**
     * Obtain the OutlineTopComponent instance. Never call {@link #getDefault} directly!
     */
    public static synchronized OutlineTopComponent findInstance() {
        TopComponent win = WindowManager.getDefault().findTopComponent(PREFERRED_ID);
        if (win == null) {
            Logger.getLogger(OutlineTopComponent.class.getName()).warning(
                    "Cannot find " + PREFERRED_ID + " component. It will not be located properly in the window system.");
            return getDefault();
        }
        if (win instanceof OutlineTopComponent) {
            return (OutlineTopComponent)win;
        }
        Logger.getLogger(OutlineTopComponent.class.getName()).warning(
                "There seem to be multiple components with the '" + PREFERRED_ID +
                "' ID. That is a potential source of errors and unexpected behavior.");
        return getDefault();
    }

    public @Override int getPersistenceType() {
        return TopComponent.PERSISTENCE_ALWAYS;
    }

    public @Override void componentOpened() {
        // TODO add custom code on component opening
    }

    public @Override void componentClosed() {
        // TODO add custom code on component closing
    }

    /** replaces this in object stream */
    public @Override Object writeReplace() {
        return new ResolvableHelper();
    }

    protected @Override String preferredID() {
        return PREFERRED_ID;
    }

    final static class ResolvableHelper implements Serializable {
        private static final long serialVersionUID = 1L;
        public Object readResolve() {
            return OutlineTopComponent.getDefault();
        }
    }

    public ExplorerManager getExplorerManager() {
        return manager;
    }

    public JrxmlVisualView getCurrentJrxmlVisualView() {
        return currentJrxmlVisualView;
    }

    public void closingJrxmlVisualView(JrxmlVisualView jrxmlVisualView) {
        
        if (jrxmlVisualView != currentJrxmlVisualView) return;
        setCurrentJrxmlVisualView(null);
    }
    
    public void setCurrentJrxmlVisualView(JrxmlVisualView currentJrxmlVisualView) {
        
        if (this.currentJrxmlVisualView != null)
        {
            this.ic.remove( this.currentJrxmlVisualView.getReportDesignerPanel() );
        }
        
        if (currentJrxmlVisualView == null) 
        {
            this.currentJrxmlVisualView = null;
            getExplorerManager().setRootContext(noReportNode);
        }
        if (currentJrxmlVisualView != this.currentJrxmlVisualView)
        {
            try {
                this.currentJrxmlVisualView = currentJrxmlVisualView;
                this.ic.add( this.currentJrxmlVisualView.getReportDesignerPanel() );
                setUpdatingSelection(true);
                if (currentJrxmlVisualView.getModel() != null)
                {
                    getExplorerManager().setRootContext(currentJrxmlVisualView.getModel());
                    getExplorerManager().setSelectedNodes(currentJrxmlVisualView.getExplorerManager().getSelectedNodes());
                }
                else if (currentJrxmlVisualView.isLoading())
                {
                    AbstractNode an = new AbstractNode(Children.LEAF);
                    an.setDisplayName("Loading report...");
                    getExplorerManager().setRootContext(an);
                } else
                {
                    getExplorerManager().setRootContext( currentJrxmlVisualView.getExplorerManager().getRootContext() );
                }
                
            } catch (PropertyVetoException ex) {
                Exceptions.printStackTrace(ex);
            } finally
            {
                setUpdatingSelection(false);
            }
        }
    }
    
    @Override
    public UndoRedo getUndoRedo(){   
        if (currentJrxmlVisualView != null) return currentJrxmlVisualView.getUndoRedo();
        return super.getUndoRedo();   
    } 
}
