/*
 * Decompiled with CFR 0.152.
 */
package mondrian.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.sql.DriverManager;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JDesktopPane;
import javax.swing.JEditorPane;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JLayeredPane;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JToolBar;
import javax.swing.event.InternalFrameAdapter;
import javax.swing.event.InternalFrameEvent;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileSystemView;
import javax.swing.plaf.basic.BasicArrowButton;
import javax.swing.text.DefaultEditorKit;
import mondrian.gui.JDBCExplorer;
import mondrian.gui.JDBCMetaData;
import mondrian.gui.MondrianGuiDef;
import mondrian.gui.PreferencesDialog;
import mondrian.gui.QueryPanel;
import mondrian.gui.SchemaExplorer;
import mondrian.olap.Connection;
import mondrian.olap.MondrianProperties;
import org.eigenbase.xom.XMLOutput;

public class Workbench
extends JFrame {
    private static final String LAST_USED1 = "lastUsed1";
    private static final String LAST_USED1_URL = "lastUsedUrl1";
    private static final String LAST_USED2 = "lastUsed2";
    private static final String LAST_USED2_URL = "lastUsedUrl2";
    private static final String LAST_USED3 = "lastUsed3";
    private static final String LAST_USED3_URL = "lastUsedUrl3";
    private static final String LAST_USED4 = "lastUsed4";
    private static final String LAST_USED4_URL = "lastUsedUrl4";
    private Connection connection;
    private String jdbcDriverClassName;
    private String jdbcConnectionUrl;
    private JDBCMetaData jdbcMetaData;
    private final ClassLoader myClassLoader;
    private final ResourceBundle resources;
    private Properties workbenchProperties;
    private static int newSchema = 1;
    private String openFile = null;
    private Map schemaWindowMap = new HashMap();
    private Vector mdxWindows = new Vector();
    private int windowMenuMapIndex = 1;
    private static ResourceBundle resBundle = null;
    private JButton toolbarSaveAsButton;
    private JMenuItem openMenuItem;
    private JMenuItem lastUsed1MenuItem;
    private JMenuItem lastUsed2MenuItem;
    private JMenuItem lastUsed3MenuItem;
    private JMenuItem lastUsed4MenuItem;
    private JMenu fileMenu;
    private JMenuItem newQueryMenuItem;
    private JMenuItem newQueryMenuItem2;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JButton toolbarOpenButton;
    private JButton toolbarNewButton;
    private JButton toolbarNewArrowButton;
    private JSeparator jSeparator1;
    private JSeparator jSeparator2;
    private JSeparator jSeparator3;
    private JSeparator jSeparator4;
    private JMenuItem cutMenuItem;
    private JMenuBar menuBar;
    private JMenuItem saveMenuItem;
    private JMenuItem newJDBCExplorerMenuItem;
    private JMenuItem newJDBCExplorerMenuItem2;
    private JCheckBoxMenuItem viewCubesMenuItem;
    private JButton toolbarSaveButton;
    private JMenuItem copyMenuItem;
    private JDesktopPane desktopPane;
    private JMenu viewMenu;
    private JMenu toolsMenu;
    private JMenu newMenu;
    private JMenuItem deleteMenuItem;
    private JMenuItem newSchemaMenuItem;
    private JMenuItem newSchemaMenuItem2;
    private JMenuItem exitMenuItem;
    private JButton toolbarPreferencesButton;
    private JCheckBoxMenuItem viewMeasuresMenuItem;
    private JMenu editMenu;
    private JMenuItem pasteMenuItem;
    private JMenuItem preferencesMenuItem;
    private JCheckBoxMenuItem viewDimensionsMenuItem;
    private JCheckBoxMenuItem viewXMLMenuItem;
    private JMenuItem saveAsMenuItem;
    private JToolBar jToolBar1;
    private JToolBar jToolBar2;
    private JPopupMenu toolbarNewPopupMenu;
    private JMenu windowMenu;
    private JMenu helpMenu;
    private JMenuItem aboutMenuItem;
    private JMenuItem cascadeMenuItem;
    private JMenuItem tileMenuItem;
    private JMenuItem minimizeMenuItem;
    private JMenuItem maximizeMenuItem;
    private JMenuItem closeAllMenuItem;

    public Workbench() {
        this.myClassLoader = this.getClass().getClassLoader();
        this.loadWorkbenchProperties();
        this.initDataSource();
        this.initComponents();
        this.resources = ResourceBundle.getBundle("mondrian.gui.resources.gui", Locale.getDefault(), this.myClassLoader);
        ImageIcon icon = new ImageIcon(this.myClassLoader.getResource(this.resources.getString("cube")));
        this.setIconImage(icon.getImage());
    }

    private void loadWorkbenchProperties() {
        this.workbenchProperties = new Properties();
        try {
            this.workbenchProperties.load(new FileInputStream(new File("workbench.properties")));
            String resourceName = "mondrian.gui.resources.workbenchInfo";
            resBundle = ResourceBundle.getBundle(resourceName);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void storeWorkbenchProperties() {
        OutputStream out = null;
        try {
            out = new FileOutputStream(new File("workbench.properties"));
            this.workbenchProperties.store(out, "Workbench configuration");
        }
        catch (Exception e) {
        }
        finally {
            try {
                out.close();
            }
            catch (IOException eIO) {}
        }
    }

    private void initDataSource() {
        this.jdbcDriverClassName = this.workbenchProperties.getProperty("jdbcDriverClassName");
        this.jdbcConnectionUrl = this.workbenchProperties.getProperty("jdbcConnectionUrl");
    }

    private void initComponents() {
        this.desktopPane = new JDesktopPane();
        this.jToolBar1 = new JToolBar();
        this.jToolBar2 = new JToolBar();
        this.toolbarNewPopupMenu = new JPopupMenu();
        this.toolbarNewButton = new JButton();
        this.toolbarOpenButton = new JButton();
        this.toolbarSaveButton = new JButton();
        this.toolbarSaveAsButton = new JButton();
        this.jPanel1 = new JPanel();
        this.jPanel2 = new JPanel();
        this.toolbarPreferencesButton = new JButton();
        this.menuBar = new JMenuBar();
        this.fileMenu = new JMenu();
        this.newMenu = new JMenu();
        this.newSchemaMenuItem = new JMenuItem();
        this.newQueryMenuItem = new JMenuItem();
        this.newJDBCExplorerMenuItem = new JMenuItem();
        this.newSchemaMenuItem2 = new JMenuItem();
        this.newQueryMenuItem2 = new JMenuItem();
        this.newJDBCExplorerMenuItem2 = new JMenuItem();
        this.openMenuItem = new JMenuItem();
        this.preferencesMenuItem = new JMenuItem();
        this.lastUsed1MenuItem = new JMenuItem();
        this.lastUsed2MenuItem = new JMenuItem();
        this.lastUsed3MenuItem = new JMenuItem();
        this.lastUsed4MenuItem = new JMenuItem();
        this.saveMenuItem = new JMenuItem();
        this.saveAsMenuItem = new JMenuItem();
        this.jSeparator1 = new JSeparator();
        this.jSeparator2 = new JSeparator();
        this.jSeparator3 = new JSeparator();
        this.jSeparator4 = new JSeparator();
        this.exitMenuItem = new JMenuItem();
        this.windowMenu = new JMenu();
        this.helpMenu = new JMenu();
        this.editMenu = new JMenu();
        this.cutMenuItem = new JMenuItem(new DefaultEditorKit.CutAction());
        this.copyMenuItem = new JMenuItem(new DefaultEditorKit.CopyAction());
        this.pasteMenuItem = new JMenuItem(new DefaultEditorKit.PasteAction());
        this.deleteMenuItem = new JMenuItem();
        this.aboutMenuItem = new JMenuItem();
        this.toolsMenu = new JMenu();
        this.viewMenu = new JMenu();
        this.viewDimensionsMenuItem = new JCheckBoxMenuItem();
        this.viewMeasuresMenuItem = new JCheckBoxMenuItem();
        this.viewCubesMenuItem = new JCheckBoxMenuItem();
        this.viewXMLMenuItem = new JCheckBoxMenuItem();
        this.setTitle("Schema Workbench");
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                Workbench.this.closeAllSchemaFrames(true);
            }
        });
        this.getContentPane().add((Component)this.desktopPane, "Center");
        this.newSchemaMenuItem2.setText("Schema");
        this.newSchemaMenuItem2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Workbench.this.newSchemaMenuItemActionPerformed(evt);
            }
        });
        this.newQueryMenuItem2.setText("MDX Query");
        this.newQueryMenuItem2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Workbench.this.newQueryMenuItemActionPerformed(evt);
            }
        });
        this.newJDBCExplorerMenuItem2.setText("JDBC Explorer");
        this.newJDBCExplorerMenuItem2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Workbench.this.newJDBCExplorerMenuItemActionPerformed(evt);
            }
        });
        this.toolbarNewPopupMenu.add(this.newSchemaMenuItem2);
        this.toolbarNewPopupMenu.add(this.newQueryMenuItem2);
        this.toolbarNewPopupMenu.add(this.newJDBCExplorerMenuItem2);
        this.jPanel2.setLayout(new BorderLayout());
        this.jPanel2.setBorder(BorderFactory.createEtchedBorder());
        this.jPanel2.setMaximumSize(new Dimension(50, 28));
        this.toolbarNewButton.setIcon(new ImageIcon(this.getClass().getResource("/toolbarButtonGraphics/general/New16.gif")));
        this.toolbarNewButton.setToolTipText("New");
        this.toolbarNewButton.setBorderPainted(false);
        this.toolbarNewButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Workbench.this.toolbarNewPopupMenu.show(Workbench.this.jPanel2, 0, ((Workbench)Workbench.this).jPanel2.getSize().height);
            }
        });
        this.jToolBar2.setFloatable(false);
        this.jToolBar2.add(this.toolbarNewButton);
        this.jPanel2.add((Component)this.jToolBar2, "Center");
        this.toolbarNewArrowButton = new BasicArrowButton(5);
        this.toolbarNewArrowButton.setToolTipText("New");
        this.toolbarNewArrowButton.setBorderPainted(false);
        this.toolbarNewArrowButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Workbench.this.toolbarNewPopupMenu.show(Workbench.this.jPanel2, 0, ((Workbench)Workbench.this).jPanel2.getSize().height);
            }
        });
        this.jPanel2.add((Component)this.toolbarNewArrowButton, "East");
        this.jToolBar1.add((Component)this.jPanel2, 0);
        this.toolbarOpenButton.setIcon(new ImageIcon(this.getClass().getResource("/toolbarButtonGraphics/general/Open16.gif")));
        this.toolbarOpenButton.setToolTipText("Open");
        this.toolbarOpenButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Workbench.this.openMenuItemActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.toolbarOpenButton);
        this.toolbarSaveButton.setIcon(new ImageIcon(this.getClass().getResource("/toolbarButtonGraphics/general/Save16.gif")));
        this.toolbarSaveButton.setToolTipText("Save");
        this.toolbarSaveButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Workbench.this.saveMenuItemActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.toolbarSaveButton);
        this.toolbarSaveAsButton.setIcon(new ImageIcon(this.getClass().getResource("/toolbarButtonGraphics/general/SaveAs16.gif")));
        this.toolbarSaveAsButton.setToolTipText("Save As");
        this.toolbarSaveAsButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Workbench.this.saveAsMenuItemActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.toolbarSaveAsButton);
        this.jPanel1.setMaximumSize(new Dimension(8, 8));
        this.jToolBar1.add(this.jPanel1);
        this.toolbarPreferencesButton.setIcon(new ImageIcon(this.getClass().getResource("/toolbarButtonGraphics/general/Preferences16.gif")));
        this.toolbarPreferencesButton.setToolTipText("Preferences");
        this.toolbarPreferencesButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Workbench.this.toolbarPreferencesButtonActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.toolbarPreferencesButton);
        this.getContentPane().add((Component)this.jToolBar1, "North");
        this.fileMenu.setText("File");
        this.newMenu.setText("New");
        this.newSchemaMenuItem.setText("Schema");
        this.newSchemaMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Workbench.this.newSchemaMenuItemActionPerformed(evt);
            }
        });
        this.newMenu.add(this.newSchemaMenuItem);
        this.newQueryMenuItem.setText("MDX Query");
        this.newQueryMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Workbench.this.newQueryMenuItemActionPerformed(evt);
            }
        });
        this.newMenu.add(this.newQueryMenuItem);
        this.newJDBCExplorerMenuItem.setText("JDBC Explorer");
        this.newJDBCExplorerMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Workbench.this.newJDBCExplorerMenuItemActionPerformed(evt);
            }
        });
        this.newMenu.add(this.newJDBCExplorerMenuItem);
        this.fileMenu.add(this.newMenu);
        this.openMenuItem.setText("Open");
        this.openMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Workbench.this.openMenuItemActionPerformed(evt);
            }
        });
        this.fileMenu.add(this.openMenuItem);
        this.saveMenuItem.setText("Save");
        this.saveMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Workbench.this.saveMenuItemActionPerformed(evt);
            }
        });
        this.fileMenu.add(this.saveMenuItem);
        this.saveAsMenuItem.setText("Save As ...");
        this.saveAsMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Workbench.this.saveAsMenuItemActionPerformed(evt);
            }
        });
        this.fileMenu.add(this.saveAsMenuItem);
        this.fileMenu.add(this.jSeparator2);
        this.lastUsed1MenuItem.setText(this.workbenchProperties.getProperty(LAST_USED1));
        this.lastUsed1MenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Workbench.this.lastUsed1MenuItemActionPerformed(evt);
            }
        });
        this.fileMenu.add(this.lastUsed1MenuItem);
        this.lastUsed2MenuItem.setText(this.workbenchProperties.getProperty(LAST_USED2));
        this.lastUsed2MenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Workbench.this.lastUsed2MenuItemActionPerformed(evt);
            }
        });
        this.fileMenu.add(this.lastUsed2MenuItem);
        this.lastUsed3MenuItem.setText(this.workbenchProperties.getProperty(LAST_USED3));
        this.lastUsed3MenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Workbench.this.lastUsed3MenuItemActionPerformed(evt);
            }
        });
        this.fileMenu.add(this.lastUsed3MenuItem);
        this.lastUsed4MenuItem.setText(this.workbenchProperties.getProperty(LAST_USED4));
        this.lastUsed4MenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Workbench.this.lastUsed4MenuItemActionPerformed(evt);
            }
        });
        this.fileMenu.add(this.lastUsed4MenuItem);
        this.updateLastUsedMenu();
        this.fileMenu.add(this.jSeparator1);
        this.exitMenuItem.setText("Exit");
        this.exitMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Workbench.this.exitMenuItemActionPerformed(evt);
            }
        });
        this.fileMenu.add(this.exitMenuItem);
        this.menuBar.add(this.fileMenu);
        this.editMenu.setText("Edit");
        this.cutMenuItem.setText("Cut");
        this.editMenu.add(this.cutMenuItem);
        this.copyMenuItem.setText("Copy");
        this.editMenu.add(this.copyMenuItem);
        this.pasteMenuItem.setText("Paste");
        this.editMenu.add(this.pasteMenuItem);
        this.deleteMenuItem.setText("Delete");
        this.editMenu.add(this.deleteMenuItem);
        this.menuBar.add(this.editMenu);
        this.editMenu.add(this.pasteMenuItem);
        this.viewMenu.setText("View");
        this.viewXMLMenuItem.setText("View XML");
        this.viewXMLMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Workbench.this.viewXMLMenuItemActionPerformed(evt);
            }
        });
        this.viewMenu.add(this.viewXMLMenuItem);
        this.menuBar.add(this.viewMenu);
        this.toolsMenu.setText("Tools");
        this.preferencesMenuItem.setText("Preferences");
        this.preferencesMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Workbench.this.toolbarPreferencesButtonActionPerformed(evt);
            }
        });
        this.toolsMenu.add(this.preferencesMenuItem);
        this.menuBar.add(this.toolsMenu);
        this.windowMenu.setText("Windows");
        this.cascadeMenuItem = new JMenuItem();
        this.cascadeMenuItem.setText("Cascade Windows");
        this.cascadeMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Workbench.this.cascadeMenuItemActionPerformed(evt);
            }
        });
        this.tileMenuItem = new JMenuItem();
        this.tileMenuItem.setText("Tile Windows");
        this.tileMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Workbench.this.tileMenuItemActionPerformed(evt);
            }
        });
        this.closeAllMenuItem = new JMenuItem();
        this.closeAllMenuItem.setText("Close All");
        this.closeAllMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Workbench.this.closeAllMenuItemActionPerformed(evt);
            }
        });
        this.minimizeMenuItem = new JMenuItem();
        this.minimizeMenuItem.setText("Minimize All");
        this.minimizeMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Workbench.this.minimizeMenuItemActionPerformed(evt);
            }
        });
        this.maximizeMenuItem = new JMenuItem();
        this.maximizeMenuItem.setText("Maximize All");
        this.maximizeMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Workbench.this.maximizeMenuItemActionPerformed(evt);
            }
        });
        this.menuBar.add(this.windowMenu);
        this.aboutMenuItem.setText("About");
        this.aboutMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Workbench.this.aboutMenuItemActionPerformed(evt);
            }
        });
        this.helpMenu.add(this.aboutMenuItem);
        this.helpMenu.setText("Help");
        this.menuBar.add(this.helpMenu);
        this.setJMenuBar(this.menuBar);
        this.pack();
    }

    private void tileMenuItemActionPerformed(ActionEvent evt) {
        Dimension dsize = this.desktopPane.getSize();
        int desktopW = (int)dsize.getWidth();
        int desktopH = (int)dsize.getHeight();
        int darea = desktopW * desktopH;
        double eacharea = darea / (this.schemaWindowMap.size() + this.mdxWindows.size());
        int wh = (int)Math.sqrt(eacharea);
        Iterator[] its = new Iterator[]{this.schemaWindowMap.keySet().iterator(), this.mdxWindows.iterator()};
        JInternalFrame sf = null;
        int x = 0;
        int y = 0;
        try {
            for (int i = 0; i < its.length; ++i) {
                Iterator it = its[i];
                while (it.hasNext()) {
                    sf = (JInternalFrame)it.next();
                    if (sf == null || sf.isIcon()) continue;
                    sf.setMaximum(false);
                    sf.moveToFront();
                    if (x >= desktopW || (double)((desktopW - x) * wh) < eacharea / 2.0) {
                        y += wh;
                        x = 0;
                    }
                    int sfwidth = x + wh < desktopW ? wh : desktopW - x;
                    int sfheight = y + wh < desktopH ? wh : desktopH - y;
                    sf.setBounds(x, y, sfwidth, sfheight);
                    x += sfwidth;
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void cascadeMenuItemActionPerformed(ActionEvent evt) {
        Iterator[] its = new Iterator[]{this.schemaWindowMap.keySet().iterator(), this.mdxWindows.iterator()};
        int sfi = 1;
        JInternalFrame sf = null;
        try {
            for (int i = 0; i < its.length; ++i) {
                Iterator it = its[i];
                while (it.hasNext()) {
                    sf = (JInternalFrame)it.next();
                    if (sf == null || sf.isIcon()) continue;
                    sf.setMaximum(false);
                    sf.setLocation(30 * sfi, 30 * sfi);
                    sf.moveToFront();
                    sf.setSelected(true);
                    ++sfi;
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void closeAllMenuItemActionPerformed(ActionEvent evt) {
        this.closeAllSchemaFrames(false);
    }

    private void closeAllSchemaFrames(boolean exitAfterClose) {
        Object[][] its = new Object[][]{this.schemaWindowMap.keySet().toArray(), this.mdxWindows.toArray()};
        JInternalFrame sf = null;
        try {
            for (int i = 0; i < its.length; ++i) {
                for (int j = 0; j < its[i].length; ++j) {
                    sf = (JInternalFrame)its[i][j];
                    if (sf == null || !(sf.getContentPane().getComponent(0) instanceof SchemaExplorer)) continue;
                    SchemaExplorer se = (SchemaExplorer)sf.getContentPane().getComponent(0);
                    sf.setSelected(true);
                    int response = this.confirmFrameClose(sf, se);
                    if (response == 2) {
                        return;
                    }
                    if (response != 3) continue;
                    sf.setClosed(true);
                }
            }
            if (this.schemaWindowMap.keySet().size() == 0 && exitAfterClose) {
                System.exit(0);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private int confirmFrameClose(JInternalFrame schemaFrame, SchemaExplorer se) {
        if (se.isDirty()) {
            JMenuItem schemaMenuItem = (JMenuItem)this.schemaWindowMap.get(this.desktopPane.getSelectedFrame());
            int answer = JOptionPane.showConfirmDialog(null, "Save changes to " + se.getSchemaFile() + "?", "Schema", 1);
            switch (answer) {
                case 0: {
                    this.saveMenuItemActionPerformed(null);
                    this.schemaWindowMap.remove(schemaFrame);
                    this.updateMDXCatalogList();
                    schemaFrame.dispose();
                    this.windowMenu.remove(schemaMenuItem);
                    break;
                }
                case 1: {
                    schemaFrame.dispose();
                    this.schemaWindowMap.remove(schemaFrame);
                    this.windowMenu.remove(schemaMenuItem);
                    break;
                }
                case 2: {
                    try {
                        schemaFrame.setClosed(false);
                        schemaFrame.show();
                        break;
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
            }
            return answer;
        }
        return 3;
    }

    private void minimizeMenuItemActionPerformed(ActionEvent evt) {
        Iterator[] its = new Iterator[]{this.schemaWindowMap.keySet().iterator(), this.mdxWindows.iterator()};
        try {
            for (int i = 0; i < its.length; ++i) {
                Iterator it = its[i];
                while (it.hasNext()) {
                    JInternalFrame sf = (JInternalFrame)it.next();
                    if (sf == null || sf.isIcon()) continue;
                    sf.setIcon(true);
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void maximizeMenuItemActionPerformed(ActionEvent evt) {
        Iterator[] its = new Iterator[]{this.schemaWindowMap.keySet().iterator(), this.mdxWindows.iterator()};
        try {
            for (int i = 0; i < its.length; ++i) {
                Iterator it = its[i];
                while (it.hasNext()) {
                    JInternalFrame sf = (JInternalFrame)it.next();
                    if (sf == null) continue;
                    sf.setIcon(false);
                    sf.setMaximum(true);
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void aboutMenuItemActionPerformed(ActionEvent evt) {
        try {
            JEditorPane jEditorPane = new JEditorPane(this.myClassLoader.getResource(this.resources.getString("version")).toString());
            jEditorPane.setEditable(false);
            JScrollPane jScrollPane = new JScrollPane(jEditorPane);
            JPanel jPanel = new JPanel();
            jPanel.setLayout(new BorderLayout());
            jPanel.add((Component)jScrollPane, "Center");
            JInternalFrame jf = new JInternalFrame();
            jf.setTitle("About");
            jf.getContentPane().add(jPanel);
            Dimension screenSize = this.getSize();
            int aboutW = 400;
            int aboutH = 300;
            int width = screenSize.width / 2 - aboutW / 2;
            int height = screenSize.height / 2 - aboutH / 2 - 100;
            jf.setBounds(width, height, aboutW, aboutH);
            jf.setClosable(true);
            this.desktopPane.add(jf);
            jf.setVisible(true);
            jf.show();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void newJDBCExplorerMenuItemActionPerformed(ActionEvent evt) {
        try {
            if (this.jdbcDriverClassName == null || this.jdbcConnectionUrl == null) {
                throw new Exception("Driver=" + this.jdbcDriverClassName + "\nConn Url=" + this.jdbcConnectionUrl);
            }
            JInternalFrame jf = new JInternalFrame();
            jf.setTitle("JDBC Explorer - " + this.jdbcConnectionUrl);
            Class.forName(this.jdbcDriverClassName);
            java.sql.Connection con = DriverManager.getConnection(this.jdbcConnectionUrl);
            JDBCExplorer jdbce = new JDBCExplorer(con);
            jf.getContentPane().add(jdbce);
            jf.setBounds(0, 0, 500, 480);
            jf.setClosable(true);
            jf.setIconifiable(true);
            jf.setMaximizable(true);
            jf.setResizable(true);
            jf.setVisible(true);
            this.desktopPane.add(jf);
            jf.show();
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(this, "Database connection could not be done.\n" + ex.getMessage(), "Database Connection Error", 0);
        }
    }

    private void toolbarPreferencesButtonActionPerformed(ActionEvent evt) {
        PreferencesDialog pd = new PreferencesDialog((Frame)this, true);
        pd.setJDBCConnectionUrl(this.jdbcConnectionUrl);
        pd.setJDBCDriverClassName(this.jdbcDriverClassName);
        pd.show();
        if (pd.accepted()) {
            this.jdbcConnectionUrl = pd.getJDBCConnectionUrl();
            this.jdbcDriverClassName = pd.getJDBCDriverClassName();
            this.workbenchProperties.setProperty("jdbcDriverClassName", this.jdbcDriverClassName);
            this.workbenchProperties.setProperty("jdbcConnectionUrl", this.jdbcConnectionUrl);
        }
    }

    private void newSchemaMenuItemActionPerformed(ActionEvent evt) {
        File outputFile;
        MondrianProperties.instance();
        File defaultDir = FileSystemView.getFileSystemView().getDefaultDirectory();
        while ((outputFile = new File(defaultDir, "Schema" + newSchema++ + ".xml")).exists()) {
        }
        this.openSchemaFrame(outputFile, true);
    }

    private void newQueryMenuItemActionPerformed(ActionEvent evt) {
        JMenuItem schemaMenuItem = (JMenuItem)this.schemaWindowMap.get(this.desktopPane.getSelectedFrame());
        final JInternalFrame jf = new JInternalFrame();
        jf.setTitle("MDX Query");
        QueryPanel qp = new QueryPanel();
        jf.getContentPane().add(qp);
        jf.setBounds(0, 0, 500, 480);
        jf.setClosable(true);
        jf.setIconifiable(true);
        jf.setMaximizable(true);
        jf.setResizable(true);
        jf.setVisible(true);
        this.desktopPane.add(jf);
        jf.show();
        try {
            jf.setSelected(true);
        }
        catch (Exception ex) {
            // empty catch block
        }
        this.mdxWindows.add(jf);
        final JMenuItem queryMenuItem = new JMenuItem();
        queryMenuItem.setText(this.windowMenuMapIndex + " MDX");
        queryMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                try {
                    if (jf.isIcon()) {
                        jf.setIcon(false);
                    } else {
                        jf.setSelected(true);
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        });
        jf.setDefaultCloseOperation(0);
        jf.addInternalFrameListener(new InternalFrameAdapter(){

            public void internalFrameClosing(InternalFrameEvent e) {
                Workbench.this.mdxWindows.remove(jf);
                jf.dispose();
                Workbench.this.windowMenu.remove(queryMenuItem);
            }
        });
        this.windowMenu.add((Component)queryMenuItem, -1);
        this.windowMenu.add((Component)this.jSeparator3, -1);
        this.windowMenu.add((Component)this.cascadeMenuItem, -1);
        this.windowMenu.add((Component)this.tileMenuItem, -1);
        this.windowMenu.add((Component)this.minimizeMenuItem, -1);
        this.windowMenu.add((Component)this.maximizeMenuItem, -1);
        this.windowMenu.add((Component)this.closeAllMenuItem, -1);
        qp.setMenuItem(queryMenuItem);
        qp.setSchemaWindowMap(this.schemaWindowMap);
        qp.setWindowMenuIndex(this.windowMenuMapIndex++);
        if (schemaMenuItem != null) {
            qp.initConnection(schemaMenuItem.getText());
        } else {
            JOptionPane.showMessageDialog(this, "No Mondrian connection. Select a Schema to connect.", "Alert", 2);
        }
    }

    private void updateMDXCatalogList() {
        for (JInternalFrame elem : this.mdxWindows) {
            QueryPanel qp = (QueryPanel)elem.getContentPane().getComponent(0);
            qp.setSchemaWindowMap(this.schemaWindowMap);
        }
    }

    private void saveAsMenuItemActionPerformed(ActionEvent evt) {
        JInternalFrame jf = this.desktopPane.getSelectedFrame();
        if (jf.getContentPane().getComponent(0) instanceof SchemaExplorer) {
            File schemaFile;
            SchemaExplorer se = (SchemaExplorer)jf.getContentPane().getComponent(0);
            File oldSchemaFile = schemaFile = se.getSchemaFile();
            File suggSchemaFile = new File(schemaFile, se.getSchema().name.trim() + ".xml");
            MondrianGuiDef.Schema schema = se.getSchema();
            JFileChooser jfc = new JFileChooser();
            MondrianProperties.instance();
            jfc.setSelectedFile(suggSchemaFile);
            if (jfc.showSaveDialog(this) == 0) {
                try {
                    int answer;
                    schemaFile = jfc.getSelectedFile();
                    if (!oldSchemaFile.equals(schemaFile) && schemaFile.exists() && (answer = JOptionPane.showConfirmDialog(null, schemaFile.getAbsolutePath() + " file already exists. Do you want to replace it?", "Save As", 0)) == 1) {
                        return;
                    }
                    if (se.isNewFile() && !oldSchemaFile.equals(schemaFile)) {
                        oldSchemaFile.delete();
                    }
                    if (se.isNewFile()) {
                        se.setNewFile(false);
                    }
                    se.setDirty(false);
                    se.setDirtyFlag(false);
                    XMLOutput out = new XMLOutput((Writer)new FileWriter(jfc.getSelectedFile()));
                    schema.displayXML(out);
                    se.setSchemaFile(schemaFile);
                    se.setTitle();
                    this.setLastUsed(jfc.getSelectedFile().getName(), jfc.getSelectedFile().toURI().toURL().toString());
                    JMenuItem sMenuItem = (JMenuItem)this.schemaWindowMap.get(jf);
                    String[] mtexttokens = sMenuItem.getText().split(" ");
                    sMenuItem.setText(mtexttokens[0] + " " + se.getSchemaFile().getName());
                    this.updateMDXCatalogList();
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }
    }

    private void viewXMLMenuItemActionPerformed(ActionEvent evt) {
        JInternalFrame jf = this.desktopPane.getSelectedFrame();
        boolean oldValue = this.viewXMLMenuItem.getState();
        if (jf != null && jf.getContentPane().getComponent(0) instanceof SchemaExplorer) {
            SchemaExplorer se = (SchemaExplorer)jf.getContentPane().getComponent(0);
            ((JCheckBoxMenuItem)evt.getSource()).setSelected(se.editMode(evt));
            return;
        }
        this.viewXMLMenuItem.setSelected(!oldValue);
    }

    private void saveMenuItemActionPerformed(ActionEvent evt) {
        JInternalFrame jf = this.desktopPane.getSelectedFrame();
        if (jf.getContentPane().getComponent(0) instanceof SchemaExplorer) {
            SchemaExplorer se = (SchemaExplorer)jf.getContentPane().getComponent(0);
            File schemaFile = se.getSchemaFile();
            if (se.isNewFile()) {
                this.saveAsMenuItemActionPerformed(evt);
                return;
            }
            se.setDirty(false);
            se.setDirtyFlag(false);
            se.setTitle();
            MondrianGuiDef.Schema schema = se.getSchema();
            MondrianProperties.instance();
            try {
                XMLOutput out = new XMLOutput((Writer)new FileWriter(schemaFile));
                schema.displayXML(out);
                this.setLastUsed(schemaFile.getName(), schemaFile.toURI().toURL().toString());
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    private void setLastUsed(String name, String url) {
        int i;
        int match = 4;
        String luName = null;
        String propname = null;
        String lastUsed = "lastUsed";
        String lastUsedUrl = "lastUsedUrl";
        for (i = 1; i <= 4; ++i) {
            propname = lastUsed + i;
            luName = this.workbenchProperties.getProperty(propname);
            if (luName == null || !luName.equals(name)) continue;
            match = i;
            break;
        }
        for (i = match; i > 1; --i) {
            if (this.workbenchProperties.getProperty(lastUsed + (i - 1)) == null) continue;
            this.workbenchProperties.setProperty(lastUsed + i, this.workbenchProperties.getProperty(lastUsed + (i - 1)));
            this.workbenchProperties.setProperty(lastUsedUrl + i, this.workbenchProperties.getProperty(lastUsedUrl + (i - 1)));
        }
        this.workbenchProperties.setProperty(LAST_USED1, name);
        this.workbenchProperties.setProperty(LAST_USED1_URL, url);
        this.updateLastUsedMenu();
        this.storeWorkbenchProperties();
    }

    private void updateLastUsedMenu() {
        if (this.workbenchProperties.getProperty(LAST_USED1) == null) {
            this.jSeparator2.setVisible(false);
        } else {
            this.jSeparator2.setVisible(true);
        }
        if (this.workbenchProperties.getProperty(LAST_USED1) != null) {
            this.lastUsed1MenuItem.setVisible(true);
        } else {
            this.lastUsed1MenuItem.setVisible(false);
        }
        if (this.workbenchProperties.getProperty(LAST_USED2) != null) {
            this.lastUsed2MenuItem.setVisible(true);
        } else {
            this.lastUsed2MenuItem.setVisible(false);
        }
        if (this.workbenchProperties.getProperty(LAST_USED3) != null) {
            this.lastUsed3MenuItem.setVisible(true);
        } else {
            this.lastUsed3MenuItem.setVisible(false);
        }
        if (this.workbenchProperties.getProperty(LAST_USED4) != null) {
            this.lastUsed4MenuItem.setVisible(true);
        } else {
            this.lastUsed4MenuItem.setVisible(false);
        }
        this.lastUsed1MenuItem.setText(this.workbenchProperties.getProperty(LAST_USED1));
        this.lastUsed2MenuItem.setText(this.workbenchProperties.getProperty(LAST_USED2));
        this.lastUsed3MenuItem.setText(this.workbenchProperties.getProperty(LAST_USED3));
        this.lastUsed4MenuItem.setText(this.workbenchProperties.getProperty(LAST_USED4));
    }

    private void lastUsed1MenuItemActionPerformed(ActionEvent evt) {
        try {
            this.openSchemaFrame(new File(new URI(this.workbenchProperties.getProperty(LAST_USED1_URL))), false);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void lastUsed2MenuItemActionPerformed(ActionEvent evt) {
        try {
            this.openSchemaFrame(new File(new URI(this.workbenchProperties.getProperty(LAST_USED2_URL))), false);
            this.setLastUsed(this.workbenchProperties.getProperty(LAST_USED2), this.workbenchProperties.getProperty(LAST_USED2_URL));
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
        }
    }

    private void lastUsed3MenuItemActionPerformed(ActionEvent evt) {
        try {
            this.openSchemaFrame(new File(new URI(this.workbenchProperties.getProperty(LAST_USED3_URL))), false);
            this.setLastUsed(this.workbenchProperties.getProperty(LAST_USED3), this.workbenchProperties.getProperty(LAST_USED3_URL));
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
        }
    }

    private void lastUsed4MenuItemActionPerformed(ActionEvent evt) {
        try {
            this.openSchemaFrame(new File(new URI(this.workbenchProperties.getProperty(LAST_USED4_URL))), false);
            this.setLastUsed(this.workbenchProperties.getProperty(LAST_USED4), this.workbenchProperties.getProperty(LAST_USED4_URL));
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
        }
    }

    private void openSchemaFrame(File file, boolean newFile) {
        try {
            if (!newFile) {
                if (this.checkFileOpen(file)) {
                    return;
                }
                if (!file.exists()) {
                    JOptionPane.showMessageDialog(this, file.getAbsolutePath() + " File not found.", "Alert", 2);
                    return;
                }
                if (!file.canWrite()) {
                    JOptionPane.showMessageDialog(this, file.getAbsolutePath() + " File is locked by another application.", "Alert", 2);
                    return;
                }
                try {
                    String connectString = "Provider=mondrian;Jdbc=" + this.jdbcConnectionUrl + ";" + "Catalog=" + file.toURL().toString();
                    this.connection = mondrian.olap.DriverManager.getConnection(connectString, null, false);
                }
                catch (Exception ex) {
                    System.out.println("Exception  : Schema file is invalid." + ex.getMessage());
                }
                catch (Error err) {
                    System.out.println("Error : Schema file is invalid." + err.getMessage());
                }
            }
            final JInternalFrame schemaFrame = new JInternalFrame();
            schemaFrame.setTitle("Schema - " + file.getName());
            this.jdbcMetaData = new JDBCMetaData(this.jdbcDriverClassName, this.jdbcConnectionUrl);
            schemaFrame.getContentPane().add(new SchemaExplorer(file, this.jdbcMetaData, newFile, schemaFrame));
            String errorOpening = ((SchemaExplorer)schemaFrame.getContentPane().getComponent(0)).getErrMsg();
            if (errorOpening != null) {
                JOptionPane.showMessageDialog(this, errorOpening, "Error", 0);
                schemaFrame.setClosed(true);
                return;
            }
            schemaFrame.setBounds(0, 0, 1000, 650);
            schemaFrame.setClosable(true);
            schemaFrame.setIconifiable(true);
            schemaFrame.setMaximizable(true);
            schemaFrame.setResizable(true);
            schemaFrame.setVisible(true);
            this.desktopPane.add((Component)schemaFrame, JLayeredPane.DEFAULT_LAYER);
            schemaFrame.show();
            schemaFrame.setMaximum(true);
            if (this.jdbcMetaData.getErrMsg() != null) {
                JOptionPane.showMessageDialog(this, "Database connection could not be done.\n" + this.jdbcMetaData.getErrMsg() + "\n All validations related to database will be ignored.", "Alert", 2);
            }
            final JMenuItem schemaMenuItem = new JMenuItem();
            schemaMenuItem.setText(this.windowMenuMapIndex++ + " " + file.getName());
            schemaMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent evt) {
                    try {
                        if (schemaFrame.isIcon()) {
                            schemaFrame.setIcon(false);
                        } else {
                            schemaFrame.setSelected(true);
                        }
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
            });
            this.windowMenu.add((Component)schemaMenuItem, 0);
            this.windowMenu.setEnabled(true);
            this.windowMenu.add((Component)this.jSeparator3, -1);
            this.windowMenu.add((Component)this.cascadeMenuItem, -1);
            this.windowMenu.add((Component)this.tileMenuItem, -1);
            this.windowMenu.add((Component)this.minimizeMenuItem, -1);
            this.windowMenu.add((Component)this.maximizeMenuItem, -1);
            this.windowMenu.add((Component)this.closeAllMenuItem, -1);
            this.schemaWindowMap.put(schemaFrame, schemaMenuItem);
            this.updateMDXCatalogList();
            schemaFrame.setDefaultCloseOperation(0);
            schemaFrame.addInternalFrameListener(new InternalFrameAdapter(){

                public void internalFrameClosing(InternalFrameEvent e) {
                    SchemaExplorer se;
                    int response;
                    if (schemaFrame.getContentPane().getComponent(0) instanceof SchemaExplorer && (response = Workbench.this.confirmFrameClose(schemaFrame, se = (SchemaExplorer)schemaFrame.getContentPane().getComponent(0))) == 3) {
                        if (se.isNewFile()) {
                            se.getSchemaFile().delete();
                        }
                        Workbench.this.schemaWindowMap.remove(schemaFrame);
                        Workbench.this.updateMDXCatalogList();
                        schemaFrame.dispose();
                        Workbench.this.windowMenu.remove(schemaMenuItem);
                    }
                }
            });
            schemaFrame.setFocusable(true);
            schemaFrame.addFocusListener(new FocusAdapter(){

                public void focusGained(FocusEvent e) {
                    if (schemaFrame.getContentPane().getComponent(0) instanceof SchemaExplorer) {
                        SchemaExplorer se = (SchemaExplorer)schemaFrame.getContentPane().getComponent(0);
                        Workbench.this.viewXMLMenuItem.setSelected(se.isEditModeXML());
                    }
                }

                public void focusLost(FocusEvent e) {
                    if (schemaFrame.getContentPane().getComponent(0) instanceof SchemaExplorer) {
                        SchemaExplorer se = (SchemaExplorer)schemaFrame.getContentPane().getComponent(0);
                        Workbench.this.viewXMLMenuItem.setSelected(se.isEditModeXML());
                    }
                }
            });
            this.viewXMLMenuItem.setSelected(false);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void openMenuItemActionPerformed(ActionEvent evt) {
        JFileChooser jfc = new JFileChooser();
        try {
            jfc.setFileSelectionMode(0);
            jfc.setFileFilter(new FileFilter(){

                public boolean accept(File pathname) {
                    return pathname.getName().toLowerCase().endsWith(".xml") || pathname.isDirectory();
                }

                public String getDescription() {
                    return "Mondrian Schema files (*.xml)";
                }
            });
            jfc.setCurrentDirectory(new File(new URI(this.workbenchProperties.getProperty(LAST_USED1_URL))));
        }
        catch (Exception ex) {
            // empty catch block
        }
        MondrianProperties.instance();
        if (jfc.showOpenDialog(this) == 0) {
            try {
                this.setLastUsed(jfc.getSelectedFile().getName(), jfc.getSelectedFile().toURI().toURL().toString());
            }
            catch (MalformedURLException e) {
                e.printStackTrace();
            }
            this.openSchemaFrame(jfc.getSelectedFile(), false);
        }
    }

    private boolean checkFileOpen(File file) {
        for (JInternalFrame elem : this.schemaWindowMap.keySet()) {
            File f = ((SchemaExplorer)elem.getContentPane().getComponent(0)).getSchemaFile();
            if (!f.equals(file)) continue;
            try {
                elem.setSelected(true);
                return true;
            }
            catch (Exception ex) {
                this.schemaWindowMap.remove(elem);
                break;
            }
        }
        return false;
    }

    private void exitMenuItemActionPerformed(ActionEvent evt) {
        this.storeWorkbenchProperties();
        this.closeAllSchemaFrames(true);
    }

    private void parseArgs(String[] args) {
        for (int argNum = 0; argNum < args.length; ++argNum) {
            if (!args[argNum].startsWith("-f=")) continue;
            this.openFile = args[argNum].substring(3);
        }
    }

    public static String getTooltip(String titleName) {
        try {
            return resBundle.getString(titleName);
        }
        catch (MissingResourceException e) {
            return "No help available for '" + titleName + "'";
        }
    }

    public static void main(String[] args) {
        File f;
        Workbench w = new Workbench();
        w.parseArgs(args);
        w.setSize(800, 600);
        if (w.openFile != null && (f = new File(w.openFile)).canRead()) {
            w.openSchemaFrame(f.getAbsoluteFile(), false);
        }
        w.show();
    }

    public JCheckBoxMenuItem getViewXMLMenuItem() {
        return this.viewXMLMenuItem;
    }
}

