/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.designer.ruler;

import com.jaspersoft.ireport.designer.IReportManager;
import com.jaspersoft.ireport.designer.ReportDesignerPanel;
import com.jaspersoft.ireport.designer.utils.Unit;
import java.awt.Color;
import java.awt.Container;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import net.sf.jasperreports.engine.design.JasperDesign;
import org.netbeans.api.visual.widget.Scene;

public class Ruler
extends JComponent
implements Scene.SceneListener,
ComponentListener {
    public static final int TYPE_VERTICAL = 1;
    public static final int TYPE_HORIZONTAL = 0;
    private int type = 0;
    private int cursorPosition;
    private boolean dragging = false;
    private BufferedImage savedImage = null;
    private ImageIcon horizontalRuleStopIcon = null;
    private List guideLines = new ArrayList();
    private int lastTempGuidePosition = -1;
    private ReportDesignerPanel reportPanel = null;
    private JScrollPane sceneScrollPane = null;

    public List getGuideLines() {
        return this.guideLines;
    }

    public ReportDesignerPanel getReportPanel() {
        return this.reportPanel;
    }

    public void setReportPanel(ReportDesignerPanel reportPanel) {
        this.reportPanel = reportPanel;
    }

    public int getType() {
        return this.type;
    }

    public void setType(int type) {
        if (type != this.type) {
            this.horizontalRuleStopIcon = new ImageIcon(this.getClass().getResource("/com/jaspersoft/ireport/designer/tulers/rulestop" + (type == 1 ? "_vertical" : "_horizontal") + ".png"));
            this.type = type;
        }
    }

    public Ruler(int type, ReportDesignerPanel reportPanel) {
        this.setType(type);
        this.reportPanel = reportPanel;
        this.setOpaque(true);
    }

    public void addNotify() {
        super.addNotify();
        if (this.reportPanel == null) {
            return;
        }
        this.reportPanel.getScene().addSceneListener(this);
        JComponent viewComponent = this.reportPanel.getScene().getView();
        viewComponent.addComponentListener(this);
        this.repaint();
    }

    public void removeNotify() {
        if (this.reportPanel != null) {
            this.reportPanel.getScene().getView().removeComponentListener(this);
            this.reportPanel.getScene().removeSceneListener(this);
        }
        super.removeNotify();
    }

    public void paint(Graphics g) {
        boolean isMillimeters;
        g.setFont(this.getFont());
        g.setColor(this.getBackground());
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
        String unitName = IReportManager.getPreferences().get("Unit", "inches");
        double unit = 28.3464;
        if (unitName.equals("cm")) {
            unit = 28.3464;
        } else if (unitName.equals("pixels")) {
            unit = 1.0;
        } else if (unitName.equals("mm")) {
            unit = 2.83464;
        } else if (unitName.equals("inches")) {
            unit = 72.0;
        }
        g.setColor(new Color(255, 255, 255));
        double k = 0.0;
        double zoomfactor = this.getReportPanel().getScene().getZoomFactor();
        int line = 0;
        int i = 0;
        int oldi = -100;
        double module = 2.0;
        boolean bl = isMillimeters = unit == 2.83464;
        if (isMillimeters) {
            unit = 28.3464;
        }
        boolean isPixel = false;
        int tick_space = 50;
        if (unit == 1.0) {
            isPixel = true;
            unit = 50.0;
            tick_space = 100;
        }
        if ((int)((double)this.convertUnitToPixel(1.0, unit) * zoomfactor) >= tick_space) {
            module = 10.0;
        }
        JasperDesign jd = this.getJasperDesign();
        if (this.getReportPanel() == null) {
            return;
        }
        this.sceneScrollPane = this.findScrollPane(this.getReportPanel().getScene().getView());
        if (this.getType() == 0) {
            int w;
            String s;
            int x0 = 0;
            int x1 = 0;
            int x2 = 0;
            int x3 = 0;
            int hScrollBarVal = this.sceneScrollPane.getHorizontalScrollBar().getValue();
            if (jd != null) {
                x0 = this.getZoomedDim(10, zoomfactor) - hScrollBarVal;
                x1 = this.getZoomedDim(10 + jd.getLeftMargin(), zoomfactor) - hScrollBarVal;
                x2 = this.getZoomedDim(10 + jd.getPageWidth() - jd.getRightMargin(), zoomfactor) - hScrollBarVal;
                x3 = this.getZoomedDim(10 + jd.getPageWidth(), zoomfactor) - hScrollBarVal;
            }
            Color c = this.getBackground().darker();
            g.setColor(Color.WHITE);
            g.fillRect(Math.max(x0, 0), 0, x3 - Math.max(x0, 0), this.getHeight());
            if (x1 > 0) {
                g.setColor(c);
                g.fillRect(Math.max(x0, 0), 0, x1 - Math.max(x0, 0), this.getHeight());
            }
            if (x2 < this.getWidth()) {
                g.setColor(c);
                g.fillRect(x2, 0, Math.min(this.getWidth(), x3) - x2, this.getHeight());
                g.setColor(c.darker());
                g.drawRect(x2, 0, Math.min(this.getWidth(), x3) - x2, this.getHeight());
            }
            g.setColor(new Color(122, 150, 223));
            g.drawLine(0, this.getHeight() - 1, this.getWidth(), this.getHeight() - 1);
            GradientPaint p = new GradientPaint(0.0f, this.getHeight() / 2, new Color(255, 255, 255, 0), 0.0f, this.getHeight(), new Color(100, 100, 100, 128));
            ((Graphics2D)g).setPaint(p);
            g.fillRect(0, 0, this.getWidth(), this.getHeight());
            g.setColor(new Color(0, 0, 0));
            i = x1;
            int xk = x1;
            while (i < this.getWidth()) {
                if (i >= 0 && (i - xk > 8 || i == xk)) {
                    if ((double)line % module == 0.0) {
                        if (i - oldi > 20) {
                            s = "" + (int)k;
                            if (isMillimeters) {
                                s = s + "0";
                            }
                            if (isPixel) {
                                s = "" + (int)k * 50;
                            }
                            w = g.getFontMetrics().stringWidth(s);
                            g.drawString(s, i - w / 2, g.getFontMetrics().getHeight() / 2 + 3);
                            oldi = i;
                            g.drawLine(i, 16, i, 12);
                        } else if (i - xk > 4) {
                            g.drawLine(i, 5, i, 10);
                        }
                        if (i - xk > 4) {
                            xk = i;
                        }
                    } else if (i - xk > 4) {
                        if (module == 10.0 && line % 5 != 0) {
                            g.drawLine(i, 7, i, 8);
                        } else {
                            g.drawLine(i, 6, i, 9);
                        }
                        xk = i;
                    }
                }
                k = (double)(++line) * (1.0 / module);
                i = x1 + (int)((double)this.convertUnitToPixel(k, unit) * zoomfactor);
            }
            line = 1;
            k = 1.0 / module;
            oldi = x1;
            i = x1 - (int)((double)this.convertUnitToPixel(k, unit) * zoomfactor);
            while (x1 > 0 && i > -10) {
                if (i >= 0) {
                    if ((double)line % module == 0.0) {
                        if (oldi - i > 20) {
                            s = "" + (int)k;
                            if (isMillimeters) {
                                s = s + "0";
                            }
                            if (isPixel) {
                                s = "" + (int)k * 50;
                            }
                            w = g.getFontMetrics().stringWidth(s);
                            g.drawString(s, i - w / 2, g.getFontMetrics().getHeight() / 2 + 3);
                            oldi = i;
                            g.drawLine(i, 16, i, 12);
                        } else {
                            g.drawLine(i, 5, i, 10);
                        }
                    } else if (module == 10.0 && line % 5 != 0) {
                        g.drawLine(i, 7, i, 8);
                    } else {
                        g.drawLine(i, 6, i, 9);
                    }
                }
                k = (double)(++line) * (1.0 / module);
                i = x1 - (int)((double)this.convertUnitToPixel(k, unit) * zoomfactor);
            }
            for (i = 0; i < this.getGuideLines().size(); ++i) {
                Integer pos = (Integer)this.getGuideLines().get(i);
                int posI = pos;
                posI = 10 + (int)((double)posI * zoomfactor) - hScrollBarVal;
                g.drawImage(this.horizontalRuleStopIcon.getImage(), posI - 4, 7, this);
            }
        }
    }

    private JasperDesign getJasperDesign() {
        if (this.reportPanel != null) {
            return this.reportPanel.getJasperDesign();
        }
        return null;
    }

    public int convertUnitToPixel(double value, double unit) {
        if (unit == 1.0) {
            return (int)value;
        }
        return (int)Unit.convertToPixels(value, unit);
    }

    private JScrollPane findScrollPane(JComponent component) {
        while (component != null) {
            if (component instanceof JScrollPane) {
                return (JScrollPane)component;
            }
            Container parent = component.getParent();
            if (!(parent instanceof JComponent)) {
                return null;
            }
            component = (JComponent)parent;
        }
        return null;
    }

    public int getZoomedDim(int value, double zoomFactor) {
        if (zoomFactor == 1.0) {
            return value;
        }
        return (int)Math.round((double)value * zoomFactor);
    }

    public void sceneRepaint() {
        this.repaint();
    }

    public void sceneValidating() {
    }

    public void sceneValidated() {
    }

    public void componentResized(ComponentEvent e) {
        this.repaint();
    }

    public void componentMoved(ComponentEvent e) {
        this.repaint();
    }

    public void componentShown(ComponentEvent e) {
    }

    public void componentHidden(ComponentEvent e) {
    }
}

