/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.designer.outline.nodes.properties;

import com.jaspersoft.ireport.designer.IReportManager;
import com.jaspersoft.ireport.designer.sheet.Tag;
import com.jaspersoft.ireport.designer.sheet.editors.ComboBoxPropertyEditor;
import com.jaspersoft.ireport.designer.undo.ObjectPropertyUndoableEdit;
import java.beans.PropertyEditor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import net.sf.jasperreports.engine.design.JRDesignImage;
import org.openide.nodes.PropertySupport;

public final class VerticalAlignmentProperty
extends PropertySupport {
    private final JRDesignImage element;
    private ComboBoxPropertyEditor editor;

    public VerticalAlignmentProperty(JRDesignImage element) {
        super("verticalAlignment", Byte.class, "Vertical Alignment", "How to align the image.", true, true);
        this.element = element;
        this.setValue("suppressCustomEditor", Boolean.TRUE);
    }

    public PropertyEditor getPropertyEditor() {
        if (this.editor == null) {
            ArrayList<Tag> l = new ArrayList<Tag>();
            l.add(new Tag(new Byte(1), "Left"));
            l.add(new Tag(new Byte(2), "Center"));
            l.add(new Tag(new Byte(3), "Right"));
            l.add(new Tag(new Byte(4), "Justified"));
            this.editor = new ComboBoxPropertyEditor(false, l);
        }
        return this.editor;
    }

    public Object getValue() throws IllegalAccessException, InvocationTargetException {
        return this.element.getVerticalAlignment();
    }

    public void setValue(Object val) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        if (val == null || val instanceof Byte) {
            Byte oldValue = this.element.getOwnVerticalAlignment();
            Byte newValue = (Byte)val;
            this.element.setVerticalAlignment(newValue);
            ObjectPropertyUndoableEdit urob = new ObjectPropertyUndoableEdit(this.element, "VerticalAlignment", Byte.class, oldValue, newValue);
            IReportManager.getInstance().addUndoableEdit(urob);
        }
    }

    public boolean isDefaultValue() {
        return this.element.getOwnVerticalAlignment() == null;
    }

    public void restoreDefaultValue() throws IllegalAccessException, InvocationTargetException {
        this.setValue(null);
    }

    public boolean supportsDefaultValue() {
        return true;
    }
}

