/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.designer.outline.nodes.properties;

import com.jaspersoft.ireport.designer.IReportManager;
import com.jaspersoft.ireport.designer.sheet.Tag;
import com.jaspersoft.ireport.designer.sheet.editors.ComboBoxPropertyEditor;
import com.jaspersoft.ireport.designer.undo.ObjectPropertyUndoableEdit;
import java.beans.PropertyEditor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import net.sf.jasperreports.engine.design.JRDesignGraphicElement;
import org.openide.nodes.PropertySupport;

public final class PenProperty
extends PropertySupport {
    private final JRDesignGraphicElement element;
    private ComboBoxPropertyEditor editor;

    public PenProperty(JRDesignGraphicElement element) {
        super(null, Byte.class, "Pen", "Pen.", true, true);
        this.element = element;
        this.setValue("suppressCustomEditor", Boolean.TRUE);
    }

    public PropertyEditor getPropertyEditor() {
        if (this.editor == null) {
            ArrayList<Tag> l = new ArrayList<Tag>();
            l.add(new Tag(new Byte(5), "Thin"));
            l.add(new Tag(new Byte(1), "1 point"));
            l.add(new Tag(new Byte(2), "2 point"));
            l.add(new Tag(new Byte(3), "4 point"));
            l.add(new Tag(new Byte(4), "Dotted"));
            l.add(new Tag(new Byte(0), "None"));
            this.editor = new ComboBoxPropertyEditor(false, l);
        }
        return this.editor;
    }

    public Object getValue() throws IllegalAccessException, InvocationTargetException {
        return new Byte(this.element.getPen());
    }

    public void setValue(Object val) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        this.setPropertyValue(val);
    }

    private void setPropertyValue(Object val) {
        if (val == null || val instanceof Byte) {
            Byte oldValue = this.element.getOwnPen();
            Byte newValue = (Byte)val;
            this.element.setPen(newValue);
            ObjectPropertyUndoableEdit urob = new ObjectPropertyUndoableEdit(this.element, "Pen", Byte.class, oldValue, newValue);
            IReportManager.getInstance().addUndoableEdit(urob);
        }
    }

    public boolean isDefaultValue() {
        return this.element.getOwnPen() == null;
    }

    public void restoreDefaultValue() throws IllegalAccessException, InvocationTargetException {
        this.setValue(null);
    }

    public boolean supportsDefaultValue() {
        return true;
    }
}

