/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.designer.outline.nodes.properties;

import com.jaspersoft.ireport.designer.IReportManager;
import com.jaspersoft.ireport.designer.editor.ExpressionContext;
import com.jaspersoft.ireport.designer.sheet.ExpressionProperty;
import com.jaspersoft.ireport.designer.undo.ObjectPropertyUndoableEdit;
import java.lang.reflect.InvocationTargetException;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.design.JRDesignDataset;
import net.sf.jasperreports.engine.design.JRDesignExpression;
import net.sf.jasperreports.engine.design.JRDesignSubreport;
import org.openide.ErrorManager;

public final class ParametersMapExpressionProperty
extends ExpressionProperty {
    private final JRDesignDataset dataset;
    private final JRDesignSubreport element;

    public ParametersMapExpressionProperty(JRDesignSubreport element, JRDesignDataset dataset) {
        super("parametersMapExpression", "Parameters Map Expression", "Optional expression to set a Map of parameters for this subreport.");
        this.element = element;
        this.dataset = dataset;
        this.setValue("expressionContext", new ExpressionContext(dataset));
    }

    public Object getValue() throws IllegalAccessException, InvocationTargetException {
        if (this.element.getParametersMapExpression() == null) {
            return "";
        }
        return this.element.getParametersMapExpression().getText();
    }

    public void setValue(Object val) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        JRDesignExpression oldExp = (JRDesignExpression)this.element.getParametersMapExpression();
        JRDesignExpression newExp = null;
        if (val == null || val.equals("")) {
            this.element.setParametersMapExpression(null);
        } else {
            String s = val != null ? val + "" : "";
            newExp = new JRDesignExpression();
            newExp.setText(s);
            this.element.setParametersMapExpression((JRExpression)newExp);
        }
        ObjectPropertyUndoableEdit urob = new ObjectPropertyUndoableEdit(this.element, "ParametersMapExpression", JRExpression.class, oldExp, newExp);
        IReportManager.getInstance().addUndoableEdit(urob);
    }

    public IllegalArgumentException annotateException(String msg) {
        IllegalArgumentException iae = new IllegalArgumentException(msg);
        ErrorManager.getDefault().annotate((Throwable)iae, 4096, msg, msg, null, null);
        return iae;
    }

    public boolean isDefaultValue() {
        return this.element.getParametersMapExpression() == null || this.element.getParametersMapExpression().getText() == null || this.element.getParametersMapExpression().getText().length() == 0;
    }

    public void restoreDefaultValue() throws IllegalAccessException, InvocationTargetException {
        this.setValue(null);
    }

    public boolean supportsDefaultValue() {
        return true;
    }
}

