/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.designer;

import com.jaspersoft.ireport.designer.IReportManager;
import com.jaspersoft.ireport.designer.ModelUtils;
import com.jaspersoft.ireport.designer.ThreadUtils;
import com.jaspersoft.ireport.designer.actions.BandMoveAction;
import com.jaspersoft.ireport.designer.actions.BandSelectionAction;
import com.jaspersoft.ireport.designer.actions.KeyboardElementMoveAction;
import com.jaspersoft.ireport.designer.actions.ReportAlignWithMoveStrategyProvider;
import com.jaspersoft.ireport.designer.actions.ReportAlignWithResizeStrategyProvider;
import com.jaspersoft.ireport.designer.actions.ReportAlignWithWidgetCollector;
import com.jaspersoft.ireport.designer.actions.ReportElementPopupMenuProvider;
import com.jaspersoft.ireport.designer.actions.ReportPopupMenuProvider;
import com.jaspersoft.ireport.designer.actions.ReportTextElementInplaceEditorProvider;
import com.jaspersoft.ireport.designer.actions.TranslucentRectangularSelectDecorator;
import com.jaspersoft.ireport.designer.ruler.GuideLine;
import com.jaspersoft.ireport.designer.ruler.GuideLineChangedListener;
import com.jaspersoft.ireport.designer.undo.ObjectPropertyUndoableEdit;
import com.jaspersoft.ireport.designer.utils.Misc;
import com.jaspersoft.ireport.designer.widgets.BandSeparatorWidget;
import com.jaspersoft.ireport.designer.widgets.GuideLineWidget;
import com.jaspersoft.ireport.designer.widgets.JRDesignChartWidget;
import com.jaspersoft.ireport.designer.widgets.JRDesignElementWidget;
import com.jaspersoft.ireport.designer.widgets.JRDesignImageWidget;
import com.jaspersoft.ireport.designer.widgets.PageWidget;
import com.jaspersoft.ireport.designer.widgets.SelectionWidget;
import com.jaspersoft.ireport.designer.widgets.UnscaledDecoratorWidget;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Point;
import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.UIManager;
import net.sf.jasperreports.engine.JRBand;
import net.sf.jasperreports.engine.JRElement;
import net.sf.jasperreports.engine.JRElementGroup;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.JRReport;
import net.sf.jasperreports.engine.design.JRDesignBand;
import net.sf.jasperreports.engine.design.JRDesignChart;
import net.sf.jasperreports.engine.design.JRDesignElement;
import net.sf.jasperreports.engine.design.JRDesignElementGroup;
import net.sf.jasperreports.engine.design.JRDesignExpression;
import net.sf.jasperreports.engine.design.JRDesignFrame;
import net.sf.jasperreports.engine.design.JRDesignGroup;
import net.sf.jasperreports.engine.design.JRDesignImage;
import net.sf.jasperreports.engine.design.JRDesignStaticText;
import net.sf.jasperreports.engine.design.JRDesignTextElement;
import net.sf.jasperreports.engine.design.JRDesignTextField;
import net.sf.jasperreports.engine.design.JasperDesign;
import net.sf.jasperreports.engine.export.draw.DrawVisitor;
import org.netbeans.api.visual.action.ActionFactory;
import org.netbeans.api.visual.action.AlignWithMoveDecorator;
import org.netbeans.api.visual.action.InplaceEditorProvider;
import org.netbeans.api.visual.action.MoveProvider;
import org.netbeans.api.visual.action.MoveStrategy;
import org.netbeans.api.visual.action.PopupMenuProvider;
import org.netbeans.api.visual.action.RectangularSelectDecorator;
import org.netbeans.api.visual.action.RectangularSelectProvider;
import org.netbeans.api.visual.action.ResizeProvider;
import org.netbeans.api.visual.action.ResizeStrategy;
import org.netbeans.api.visual.action.TextFieldInplaceEditor;
import org.netbeans.api.visual.action.WidgetAction;
import org.netbeans.api.visual.model.ObjectScene;
import org.netbeans.api.visual.widget.ConnectionWidget;
import org.netbeans.api.visual.widget.EventProcessingType;
import org.netbeans.api.visual.widget.LayerWidget;
import org.netbeans.api.visual.widget.Scene;
import org.netbeans.api.visual.widget.Widget;

public class ReportObjectScene
extends ObjectScene
implements GuideLineChangedListener,
PropertyChangeListener {
    public static Color DESIGN_LINE_COLOR = new Color(170, 170, 255);
    public static Color EDITING_DESIGN_LINE_COLOR = Color.DARK_GRAY;
    public static Color GRID_LINE_COLOR = new Color(230, 230, 230);
    private static final BasicStroke STROKE = new BasicStroke(1.0f, 2, 0, 5.0f, new float[]{6.0f, 3.0f}, 0.0f);
    private static final AlignWithMoveDecorator ALIGN_WITH_MOVE_DECORATOR_DEFAULT = new AlignWithMoveDecorator(){

        public ConnectionWidget createLineWidget(Scene scene) {
            UnscaledDecoratorWidget widget = new UnscaledDecoratorWidget(scene);
            widget.setStroke(STROKE);
            widget.setForeground(Color.BLUE);
            return widget;
        }
    };
    private static final WidgetAction elementPopupMenuAction = ActionFactory.createPopupMenuAction((PopupMenuProvider)new ReportElementPopupMenuProvider());
    private static final WidgetAction reportPopupMenuAction = ActionFactory.createPopupMenuAction((PopupMenuProvider)new ReportPopupMenuProvider());
    final WidgetAction inplaceEditorAction = ActionFactory.createInplaceEditorAction((InplaceEditorProvider)new ReportTextElementInplaceEditorProvider(new TextFieldInplaceEditor(){

        public boolean isEnabled(Widget widget) {
            JRDesignElement element = this.getElement(widget);
            return element != null && element instanceof JRDesignTextElement;
        }

        public String getText(Widget widget) {
            JRDesignElement element = this.getElement(widget);
            if (element != null && element instanceof JRDesignStaticText) {
                return ((JRDesignStaticText)element).getText();
            }
            if (element != null && element instanceof JRDesignTextField) {
                return Misc.getExpressionText(((JRDesignTextField)element).getExpression());
            }
            return "";
        }

        public void setText(Widget widget, String text) {
            JRDesignElement element = this.getElement(widget);
            if (element != null && element instanceof JRDesignStaticText) {
                this.setValue((JRDesignStaticText)element, (Object)text);
            } else if (element != null && element instanceof JRDesignTextField) {
                this.setValue((JRDesignTextField)element, (Object)text);
            }
        }

        public JRDesignElement getElement(Widget widget) {
            if (widget instanceof JRDesignElementWidget) {
                return ((JRDesignElementWidget)widget).getElement();
            }
            if (widget instanceof SelectionWidget) {
                return this.getElement(((SelectionWidget)widget).getRealWidget());
            }
            return null;
        }

        public void setValue(JRDesignTextField element, Object val) {
            JRDesignExpression oldExp = (JRDesignExpression)element.getExpression();
            JRDesignExpression newExp = null;
            if ((val == null || val.equals("")) && (oldExp == null || oldExp.getValueClassName() == null || oldExp.getValueClassName().equals("java.lang.String"))) {
                element.setExpression(null);
            } else {
                String s = val != null ? val + "" : "";
                newExp = new JRDesignExpression();
                newExp.setText(s);
                newExp.setValueClassName(oldExp != null ? oldExp.getValueClassName() : null);
                element.setExpression((JRExpression)newExp);
            }
            ObjectPropertyUndoableEdit urob = new ObjectPropertyUndoableEdit(element, "Expression", JRExpression.class, oldExp, newExp);
            IReportManager.getInstance().addUndoableEdit(urob);
        }

        public void setValue(JRDesignStaticText element, Object val) {
            String oldValue = element.getText();
            String newValue = val + "";
            if (val == null) {
                newValue = "";
            }
            element.setText(newValue);
            ObjectPropertyUndoableEdit opue = new ObjectPropertyUndoableEdit(element, "Text", String.class, oldValue, newValue);
            IReportManager.getInstance().addUndoableEdit(opue);
        }
    }));
    private List<JRDesignElement> selectedElements = new ArrayList<JRDesignElement>();
    private ReportAlignWithWidgetCollector reportAlignWithWidgetCollector = null;
    private ReportAlignWithMoveStrategyProvider reportAlignWithMoveStrategyProvider = null;
    private ReportAlignWithResizeStrategyProvider reportAlignWithResizeStrategyProvider = null;
    private KeyboardElementMoveAction keyboardElementMoveAction = null;
    private BandSelectionAction bandSelectionAction = null;
    boolean gridVisible = false;
    boolean snapToGrid = false;
    private JComponent jComponent = null;
    private JasperDesign jasperDesign = null;
    private DrawVisitor drawVisitor = null;
    LayerWidget backgroundLayer = null;
    LayerWidget pageLayer = null;
    LayerWidget elementsLayer = null;
    LayerWidget interractionLayer = null;
    LayerWidget bandSeparatorsLayer = null;
    LayerWidget selectionLayer = null;
    LayerWidget guideLinesLayer = null;
    private HashMap guides_widgets = new HashMap();
    HashMap elementGroupListeners = new HashMap();

    public boolean isSnapToGrid() {
        return this.snapToGrid;
    }

    public void setSnapToGrid(boolean snapToGrid) {
        if (this.snapToGrid != snapToGrid) {
            this.snapToGrid = snapToGrid;
            this.reportAlignWithMoveStrategyProvider.setSnapToGrid(snapToGrid);
            this.reportAlignWithResizeStrategyProvider.setSnapToGrid(snapToGrid);
        }
    }

    public boolean isGridVisible() {
        return this.gridVisible;
    }

    public void setGridVisible(boolean gridVisible) {
        if (this.gridVisible != gridVisible) {
            this.gridVisible = gridVisible;
            this.pageLayer.revalidate(true);
            this.validate();
        }
    }

    public ReportAlignWithWidgetCollector getReportAlignWithWidgetCollector() {
        return this.reportAlignWithWidgetCollector;
    }

    public void setReportAlignWithWidgetCollector(ReportAlignWithWidgetCollector reportAlignWithWidgetCollector) {
        this.reportAlignWithWidgetCollector = reportAlignWithWidgetCollector;
    }

    public DrawVisitor getDrawVisitor() {
        return this.drawVisitor;
    }

    public void setDrawVisitor(DrawVisitor drawVisitor) {
        this.drawVisitor = drawVisitor;
    }

    public JasperDesign getJasperDesign() {
        return this.jasperDesign;
    }

    public void setJasperDesign(JasperDesign jasperDesign) {
        this.jasperDesign = jasperDesign;
        if (jasperDesign == null) {
            this.drawVisitor = null;
            this.rebuildDocument();
            return;
        }
        jasperDesign.getEventSupport().addPropertyChangeListener((PropertyChangeListener)this);
        for (int i = 0; i < this.jasperDesign.getGroupsList().size(); ++i) {
            JRDesignGroup grp = (JRDesignGroup)this.jasperDesign.getGroupsList().get(i);
            grp.getEventSupport().addPropertyChangeListener((PropertyChangeListener)this);
        }
        this.drawVisitor = new DrawVisitor((JRReport)jasperDesign, null);
        ThreadUtils.invokeInAWTThread(new Runnable(){

            public void run() {
                ReportObjectScene.this.rebuildDocument();
            }
        });
    }

    public void addBandSeparatorWidget(JRBand b, int yLocation) {
        if (b == null) {
            return;
        }
        BandSeparatorWidget bbw = new BandSeparatorWidget(this, b);
        bbw.getActions().addAction((WidgetAction)new BandMoveAction(true, 64));
        bbw.getActions().addAction((WidgetAction)new BandMoveAction());
        this.bandSeparatorsLayer.addChild((Widget)bbw);
    }

    public void addElementWidget(JRDesignElement de) {
        if (de == null) {
            return;
        }
        JRDesignElementWidget widget = null;
        widget = de instanceof JRDesignImage ? new JRDesignImageWidget(this, (JRDesignImage)de) : (de instanceof JRDesignChart ? new JRDesignChartWidget(this, (JRDesignChart)de) : new JRDesignElementWidget(this, de));
        widget.getActions().addAction(this.createSelectAction());
        widget.getSelectionWidget().getActions().addAction((WidgetAction)this.keyboardElementMoveAction);
        widget.getSelectionWidget().getActions().addAction(this.createObjectHoverAction());
        widget.getSelectionWidget().getActions().addAction(ActionFactory.createResizeAction((ResizeStrategy)this.reportAlignWithResizeStrategyProvider, (ResizeProvider)this.reportAlignWithResizeStrategyProvider));
        widget.getSelectionWidget().getActions().addAction(ActionFactory.createMoveAction((MoveStrategy)this.reportAlignWithMoveStrategyProvider, (MoveProvider)this.reportAlignWithMoveStrategyProvider));
        widget.getActions().addAction(ActionFactory.createResizeAction((ResizeStrategy)this.reportAlignWithResizeStrategyProvider, (ResizeProvider)this.reportAlignWithResizeStrategyProvider));
        widget.getActions().addAction(ActionFactory.createMoveAction((MoveStrategy)this.reportAlignWithMoveStrategyProvider, (MoveProvider)this.reportAlignWithMoveStrategyProvider));
        widget.getActions().addAction(this.inplaceEditorAction);
        widget.getSelectionWidget().getActions().addAction(this.inplaceEditorAction);
        widget.getActions().addAction(elementPopupMenuAction);
        widget.getSelectionWidget().getActions().addAction(elementPopupMenuAction);
        this.elementsLayer.addChild((Widget)widget);
        this.selectionLayer.addChild((Widget)widget.getSelectionWidget());
        this.addObject(de, new Widget[]{widget});
    }

    public void rebuildDocument() {
        this.pageLayer.removeChildren();
        this.elementsLayer.removeChildren();
        this.bandSeparatorsLayer.removeChildren();
        this.selectionLayer.removeChildren();
        this.backgroundLayer.removeChildren();
        this.interractionLayer.removeChildren();
        while (this.getObjects().size() > 0) {
            this.removeObject(this.getObjects().iterator().next());
        }
        if (this.jasperDesign == null) {
            return;
        }
        PageWidget pageWidget = new PageWidget(this);
        this.pageLayer.addChild((Widget)pageWidget);
        this.refreshBands();
    }

    public void refreshDocument() {
        if (this.pageLayer.getChildren().size() != 0) {
            PageWidget pageWidget = (PageWidget)((Object)this.pageLayer.getChildren().get(0));
            pageWidget.updateBounds();
            pageWidget.repaint();
            this.refreshBands();
        }
    }

    public void refreshBands() {
        int yLocation = this.getJasperDesign().getTopMargin();
        List bWidgets = this.bandSeparatorsLayer.getChildren();
        for (Widget w : bWidgets) {
            ((JRDesignBand)((BandSeparatorWidget)w).getBand()).getEventSupport().removePropertyChangeListener((PropertyChangeListener)((BandSeparatorWidget)w));
        }
        this.bandSeparatorsLayer.removeChildren();
        if (this.getSelectedObjects().size() > 0) {
            this.setSelectedObjects(Collections.EMPTY_SET);
        }
        List<JRBand> bands = ModelUtils.getBands(this.getJasperDesign());
        for (JRBand b : bands) {
            this.addBandSeparatorWidget(b, yLocation += b.getHeight());
            this.addElements(b.getChildren());
        }
        List widgets = this.elementsLayer.getChildren();
        ArrayList<Widget> toBeRemoved = new ArrayList<Widget>();
        ArrayList<SelectionWidget> toBeRemovedSelection = new ArrayList<SelectionWidget>();
        ArrayList toBeRemovedObject = new ArrayList();
        for (Widget widget : widgets) {
            JRDesignElementWidget dew;
            JRElementGroup grp;
            if (!(widget instanceof JRDesignElementWidget) || bands.contains(grp = ModelUtils.getTopElementGroup((dew = (JRDesignElementWidget)widget).getElement()))) continue;
            this.removeObject(dew.getElement());
            toBeRemoved.add(widget);
            toBeRemovedSelection.add(dew.getSelectionWidget());
        }
        if (toBeRemoved.size() > 0) {
            this.elementsLayer.removeChildren(toBeRemoved);
            this.selectionLayer.removeChildren(toBeRemovedSelection);
        }
        this.validate();
    }

    private void addElements(List children) {
        for (int i = 0; i < children.size(); ++i) {
            Object obj = children.get(i);
            if (obj instanceof JRDesignElementGroup) {
                if (!this.elementGroupListeners.containsKey(obj)) {
                    GroupChangeListener gcl = new GroupChangeListener((JRDesignElementGroup)obj);
                    ((JRDesignElementGroup)obj).getEventSupport().addPropertyChangeListener((PropertyChangeListener)gcl);
                    this.elementGroupListeners.put(obj, gcl);
                }
                this.addElements(((JRDesignElementGroup)obj).getChildren());
            }
            if (!(obj instanceof JRDesignElement)) continue;
            JRDesignElement de = (JRDesignElement)children.get(i);
            JRDesignElementWidget w = (JRDesignElementWidget)this.findWidget(de);
            if (w != null) {
                w.updateBounds();
            } else {
                this.addElementWidget(de);
            }
            if (!(de instanceof JRDesignFrame)) continue;
            this.addElements(((JRDesignFrame)de).getChildren());
        }
    }

    public void refreshElementGroup(JRElementGroup group) {
        HashSet selectedObjects = new HashSet();
        selectedObjects.addAll(this.getSelectedObjects());
        if (selectedObjects.size() == 0) {
            selectedObjects = null;
        }
        List children = this.getElementsLayer().getChildren();
        ArrayList<JRDesignElementWidget> toRemove = new ArrayList<JRDesignElementWidget>();
        for (Widget w : children) {
            JRDesignElementWidget dw;
            if (!(w instanceof JRDesignElementWidget) || !ModelUtils.isOrphan((dw = (JRDesignElementWidget)w).getElement()) && !ModelUtils.isElementChildOf(dw.getElement(), group)) continue;
            toRemove.add(dw);
            JRDesignElement element = dw.getElement();
            if (selectedObjects == null || !selectedObjects.contains(element)) continue;
            boolean found = false;
            JRElement[] ele = group.getElements();
            for (int i = 0; i < ele.length; ++i) {
                if (ele[i] != element) continue;
                found = true;
                break;
            }
            if (found) continue;
            selectedObjects.remove(element);
        }
        for (JRDesignElementWidget dw : toRemove) {
            dw.getSelectionWidget().removeFromParent();
            dw.removeFromParent();
            if (!this.getObjects().contains(dw.getElement())) continue;
            this.removeObject(dw.getElement());
        }
        this.addElements(group.getChildren());
        if (selectedObjects != null) {
            this.setSelectedObjects(selectedObjects);
        }
        this.validate();
    }

    public JComponent getJComponent() {
        if (this.jComponent == null) {
            this.jComponent = this.createView();
        }
        return this.jComponent;
    }

    public LayerWidget getBackgroundLayer() {
        return this.backgroundLayer;
    }

    public LayerWidget getPageLayer() {
        return this.pageLayer;
    }

    public LayerWidget getElementsLayer() {
        return this.elementsLayer;
    }

    public LayerWidget getInterractionLayer() {
        return this.interractionLayer;
    }

    public LayerWidget getBandSeparatorsLayer() {
        return this.bandSeparatorsLayer;
    }

    public void setBandSeparatorsLayer(LayerWidget bandSeparatorsLayer) {
        this.bandSeparatorsLayer = bandSeparatorsLayer;
    }

    public LayerWidget getSelectionLayer() {
        return this.selectionLayer;
    }

    public void setSelectionLayer(LayerWidget selectionLayer) {
        this.selectionLayer = selectionLayer;
    }

    public LayerWidget getGuideLinesLayer() {
        return this.guideLinesLayer;
    }

    public void setGuideLinesLayer(LayerWidget selectionLayer) {
        this.guideLinesLayer = this.guideLinesLayer;
    }

    public ReportObjectScene() {
        this.initScene();
    }

    private void initScene() {
        this.setBackground(UIManager.getColor("Panel.background"));
        this.setKeyEventProcessingType(EventProcessingType.FOCUSED_WIDGET_AND_ITS_PARENTS);
        this.backgroundLayer = new LayerWidget((Scene)this);
        this.addChild((Widget)this.backgroundLayer);
        this.pageLayer = new LayerWidget((Scene)this);
        this.addChild((Widget)this.pageLayer);
        this.elementsLayer = new LayerWidget((Scene)this);
        this.addChild((Widget)this.elementsLayer);
        this.bandSeparatorsLayer = new LayerWidget((Scene)this);
        this.addChild((Widget)this.bandSeparatorsLayer);
        this.selectionLayer = new LayerWidget((Scene)this);
        this.addChild((Widget)this.selectionLayer);
        this.guideLinesLayer = new LayerWidget((Scene)this);
        this.addChild((Widget)this.guideLinesLayer);
        this.interractionLayer = new LayerWidget((Scene)this);
        this.addChild((Widget)this.interractionLayer);
        this.reportAlignWithWidgetCollector = new ReportAlignWithWidgetCollector(this);
        this.reportAlignWithMoveStrategyProvider = new ReportAlignWithMoveStrategyProvider(this.reportAlignWithWidgetCollector, this.interractionLayer, ALIGN_WITH_MOVE_DECORATOR_DEFAULT, false);
        this.reportAlignWithResizeStrategyProvider = new ReportAlignWithResizeStrategyProvider(this.reportAlignWithWidgetCollector, this.interractionLayer, ALIGN_WITH_MOVE_DECORATOR_DEFAULT, false);
        this.bandSelectionAction = new BandSelectionAction();
        this.getActions().addAction(reportPopupMenuAction);
        this.getActions().addAction((WidgetAction)this.bandSelectionAction);
        this.getActions().addAction(ActionFactory.createRectangularSelectAction((RectangularSelectDecorator)new TranslucentRectangularSelectDecorator((Scene)this), (LayerWidget)this.interractionLayer, (RectangularSelectProvider)ActionFactory.createObjectSceneRectangularSelectProvider((ObjectScene)this)));
        this.getActions().addAction(ActionFactory.createMouseCenteredZoomAction((double)1.1));
        this.getActions().addAction(ActionFactory.createPanAction());
        this.keyboardElementMoveAction = new KeyboardElementMoveAction();
        this.getActions().addAction((WidgetAction)this.keyboardElementMoveAction);
        this.setMaximumBounds(new Rectangle(-10, -10, Integer.MAX_VALUE, Integer.MAX_VALUE));
    }

    public void guideLineAdded(GuideLine guideLine) {
        JComponent view = this.getView();
        GuideLineWidget guideLineWidget = new GuideLineWidget((Scene)this, guideLine);
        if (guideLine.isVertical()) {
            int y0 = 0;
            if (this.getJasperDesign() != null) {
                y0 = this.getJasperDesign().getTopMargin();
            }
            guideLineWidget.setPreferredLocation(new Point(-10, guideLine.getPosition() + y0));
            guideLineWidget.setPreferredBounds(new Rectangle(0, 0, this.getJasperDesign().getPageWidth() + 10, 1));
        } else {
            int x0 = 0;
            if (this.getJasperDesign() != null) {
                x0 = this.getJasperDesign().getLeftMargin();
            }
            guideLineWidget.setPreferredLocation(new Point(guideLine.getPosition() + x0, -10));
            guideLineWidget.setPreferredBounds(new Rectangle(0, 0, 1, ModelUtils.getDesignHeight(this.getJasperDesign()) + 10));
        }
        this.guideLinesLayer.addChild((Widget)guideLineWidget);
        this.guides_widgets.put(guideLine, guideLineWidget);
        guideLineWidget.repaint();
        this.validate();
    }

    public void guideLineRemoved(GuideLine guideLine) {
        GuideLineWidget w = (GuideLineWidget)((Object)this.guides_widgets.get(guideLine));
        if (w != null) {
            w.removeFromParent();
            this.validate();
        }
    }

    public void guideLineMoved(GuideLine guideLine) {
        GuideLineWidget w = (GuideLineWidget)((Object)this.guides_widgets.get(guideLine));
        if (w != null) {
            if (guideLine.isVertical()) {
                int y0 = 0;
                if (this.getJasperDesign() != null) {
                    y0 = this.getJasperDesign().getTopMargin();
                }
                w.setPreferredLocation(new Point(-10, guideLine.getPosition() + y0));
            } else {
                int x0 = 0;
                if (this.getJasperDesign() != null) {
                    x0 = this.getJasperDesign().getLeftMargin();
                }
                w.setPreferredLocation(new Point(guideLine.getPosition() + x0, -10));
            }
            this.validate();
        }
    }

    public void propertyChange(PropertyChangeEvent evt) {
        Runnable r = null;
        if (evt.getPropertyName() == null) {
            return;
        }
        if (evt.getPropertyName().equals("background") || evt.getPropertyName().equals("title") || evt.getPropertyName().equals("pageHeader") || evt.getPropertyName().equals("columnHeader") || evt.getPropertyName().equals("detail") || evt.getPropertyName().equals("columnFooter") || evt.getPropertyName().equals("pageFooter") || evt.getPropertyName().equals("lastPageFooter") || evt.getPropertyName().equals("summary") || evt.getPropertyName().equals("noData") || evt.getPropertyName().equals("pageWidth") || evt.getPropertyName().equals("pageHeight") || evt.getPropertyName().equals("topMargin") || evt.getPropertyName().equals("bottomMargin") || evt.getPropertyName().equals("leftMargin") || evt.getPropertyName().equals("rightMargin") || evt.getPropertyName().equals("columnCount") || evt.getPropertyName().equals("columnSpacing") || evt.getPropertyName().equals("columnWidth") || evt.getPropertyName().equals("groupHeader") || evt.getPropertyName().equals("groupFooter") || evt.getPropertyName().equals("groups")) {
            r = new Runnable(){

                public void run() {
                    ReportObjectScene.this.refreshDocument();
                }
            };
        }
        if (r != null) {
            ThreadUtils.invokeInAWTThread(r);
        }
        if (evt.getPropertyName().equals("groups")) {
            for (int i = 0; i < this.jasperDesign.getGroupsList().size(); ++i) {
                JRDesignGroup grp = (JRDesignGroup)this.jasperDesign.getGroupsList().get(i);
                grp.getEventSupport().removePropertyChangeListener((PropertyChangeListener)this);
                grp.getEventSupport().addPropertyChangeListener((PropertyChangeListener)this);
            }
        }
    }

    private final class GroupChangeListener
    implements PropertyChangeListener {
        WeakReference<JRDesignElementGroup> group = null;

        public GroupChangeListener(JRDesignElementGroup group) {
            this.group = new WeakReference<JRDesignElementGroup>(group);
        }

        public void propertyChange(PropertyChangeEvent evt) {
            if (this.group.get() != null) {
                ReportObjectScene.this.refreshElementGroup((JRElementGroup)this.group.get());
            }
        }
    }
}

