/*
 * Decompiled with CFR 0.152.
 */
package org.eigenbase.resgen;

import java.io.File;
import java.io.PrintWriter;
import org.eigenbase.resgen.AbstractGenerator;
import org.eigenbase.resgen.ResourceDef;
import org.eigenbase.resgen.ResourceDefinition;

abstract class AbstractJavaGenerator
extends AbstractGenerator {
    protected final String className;
    protected final ResourceDef.ResourceBundle resourceBundle;
    protected final String baseClassName;
    private static final String JAVA_STRING = "String";
    private static final String JAVA_NUMBER = "Number";
    private static final String JAVA_DATE_TIME = "java.util.Date";
    private static final String[] JAVA_TYPE_NAMES = new String[]{"String", "Number", "java.util.Date", "java.util.Date"};

    AbstractJavaGenerator(File file, File file2, String string, ResourceDef.ResourceBundle resourceBundle, String string2) {
        super(file, file2);
        this.className = string;
        this.baseClassName = string2;
        this.resourceBundle = resourceBundle;
    }

    protected String getErrorClass(ResourceDef.Exception exception) {
        if (exception.className != null) {
            return exception.className;
        }
        if (this.resourceBundle.exceptionClassName != null) {
            return this.resourceBundle.exceptionClassName;
        }
        return "java.lang.RuntimeException";
    }

    protected String getPackageName() {
        int n = this.className.lastIndexOf(46);
        if (n < 0) {
            return null;
        }
        return this.className.substring(0, n);
    }

    protected String[] getArgTypes(String string) {
        return ResourceDefinition.getArgTypes(string, JAVA_TYPE_NAMES);
    }

    protected void generateHeader(PrintWriter printWriter) {
        this.generateDoNotModifyHeader(printWriter);
        String string = this.getPackageName();
        if (string != null) {
            printWriter.println("package " + string + ";");
        }
        printWriter.println("import java.io.IOException;");
        printWriter.println("import java.util.Locale;");
        printWriter.println("import org.eigenbase.resgen.*;");
        printWriter.println();
        this.generateGeneratedByBlock(printWriter);
    }

    protected void generateFooter(PrintWriter printWriter, String string) {
        printWriter.println("// End " + string + ".java");
    }

    protected String getClassName() {
        return this.className;
    }

    protected String getBaseClassName() {
        return this.baseClassName;
    }
}

