/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.util;

import java.util.Enumeration;
import java.util.Vector;
import org.apache.tools.ant.util.TimeoutObserver;

public class Watchdog
implements Runnable {
    private Vector observers = new Vector(1);
    private long timeout = -1L;
    private boolean stopped = false;

    public Watchdog(long timeout) {
        if (timeout < 1L) {
            throw new IllegalArgumentException("timeout lesser than 1.");
        }
        this.timeout = timeout;
    }

    public void addTimeoutObserver(TimeoutObserver to) {
        this.observers.addElement(to);
    }

    public void removeTimeoutObserver(TimeoutObserver to) {
        this.observers.removeElement(to);
    }

    protected final void fireTimeoutOccured() {
        Enumeration enumeration = this.observers.elements();
        while (enumeration.hasMoreElements()) {
            ((TimeoutObserver)enumeration.nextElement()).timeoutOccured(this);
        }
    }

    public synchronized void start() {
        this.stopped = false;
        Thread t = new Thread((Runnable)this, "WATCHDOG");
        t.setDaemon(true);
        t.start();
    }

    public synchronized void stop() {
        this.stopped = true;
        this.notifyAll();
    }

    /*
     * WARNING - void declaration
     */
    public synchronized void run() {
        long now;
        long until = System.currentTimeMillis() + this.timeout;
        while (!this.stopped && until > (now = System.currentTimeMillis())) {
            try {
                void var3_2;
                this.wait(until - var3_2);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
        }
        if (!this.stopped) {
            this.fireTimeoutOccured();
        }
    }
}

