/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine;

import java.io.File;
import java.io.InputStream;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URL;
import java.net.URLStreamHandlerFactory;
import java.text.DateFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRExporter;
import net.sf.jasperreports.engine.JRExporterParameter;
import net.sf.jasperreports.engine.JRPrintFrame;
import net.sf.jasperreports.engine.JRPrintText;
import net.sf.jasperreports.engine.JRPropertiesMap;
import net.sf.jasperreports.engine.JRStyledTextAttributeSelector;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.export.ExporterFilter;
import net.sf.jasperreports.engine.export.data.BooleanTextValue;
import net.sf.jasperreports.engine.export.data.DateTextValue;
import net.sf.jasperreports.engine.export.data.NumberTextValue;
import net.sf.jasperreports.engine.export.data.StringTextValue;
import net.sf.jasperreports.engine.export.data.TextValue;
import net.sf.jasperreports.engine.util.DefaultFormatFactory;
import net.sf.jasperreports.engine.util.FileResolver;
import net.sf.jasperreports.engine.util.FormatFactory;
import net.sf.jasperreports.engine.util.JRClassLoader;
import net.sf.jasperreports.engine.util.JRDataUtils;
import net.sf.jasperreports.engine.util.JRLoader;
import net.sf.jasperreports.engine.util.JRProperties;
import net.sf.jasperreports.engine.util.JRResourcesUtil;
import net.sf.jasperreports.engine.util.JRStyledText;

public abstract class JRAbstractExporter
implements JRExporter {
    private ParameterResolver parameterResolver;
    protected Map parameters = new HashMap();
    protected List jasperPrintList = null;
    protected JasperPrint jasperPrint = null;
    protected boolean isModeBatch = true;
    protected int startPageIndex = 0;
    protected int endPageIndex = 0;
    protected int globalOffsetX = 0;
    protected int globalOffsetY = 0;
    protected ClassLoader classLoader = null;
    protected boolean classLoaderSet = false;
    protected URLStreamHandlerFactory urlHandlerFactory = null;
    protected boolean urlHandlerFactorySet = false;
    protected FileResolver fileResolver = null;
    protected boolean fileResolverSet = false;
    protected ExporterFilter filter = null;
    private LinkedList elementOffsetStack = new LinkedList();
    private int elementOffsetX = this.globalOffsetX;
    private int elementOffsetY = this.globalOffsetY;
    protected Map dateFormatCache = new HashMap();
    protected Map numberFormatCache = new HashMap();

    protected JRAbstractExporter() {
    }

    public void reset() {
        this.parameters = new HashMap();
        this.elementOffsetStack = new LinkedList();
    }

    public void setParameter(JRExporterParameter parameter, Object value) {
        this.parameters.put(parameter, value);
    }

    public Object getParameter(JRExporterParameter parameter) {
        return this.parameters.get(parameter);
    }

    public void setParameters(Map parameters) {
        this.parameters = parameters;
    }

    public Map getParameters() {
        return this.parameters;
    }

    protected ParameterResolver getParameterResolver() {
        if (this.parameterResolver == null) {
            Boolean param = (Boolean)this.parameters.get(JRExporterParameter.PARAMETERS_OVERRIDE_REPORT_HINTS);
            boolean parametersOverrideHints = param == null ? JRProperties.getBooleanProperty("net.sf.jasperreports.export.parameters.override.report.hints") : param;
            this.parameterResolver = parametersOverrideHints ? new ParameterOverrideResolver() : new ParameterOverriddenResolver();
        }
        return this.parameterResolver;
    }

    protected String getStringParameter(JRExporterParameter parameter, String property) {
        return this.getParameterResolver().getStringParameter(parameter, property);
    }

    protected String getStringParameterOrDefault(JRExporterParameter parameter, String property) {
        return this.getParameterResolver().getStringParameterOrDefault(parameter, property);
    }

    protected boolean getBooleanParameter(JRExporterParameter parameter, String property, boolean defaultValue) {
        return this.getParameterResolver().getBooleanParameter(parameter, property, defaultValue);
    }

    protected int getIntegerParameter(JRExporterParameter parameter, String property, int defaultValue) {
        return this.getParameterResolver().getIntegerParameter(parameter, property, defaultValue);
    }

    public abstract void exportReport() throws JRException;

    protected void setOffset() {
        this.setOffset(true);
    }

    protected void setOffset(boolean setElementOffsets) {
        Integer offsetX = (Integer)this.parameters.get(JRExporterParameter.OFFSET_X);
        this.globalOffsetX = offsetX != null ? offsetX : 0;
        Integer offsetY = (Integer)this.parameters.get(JRExporterParameter.OFFSET_Y);
        this.globalOffsetY = offsetY != null ? offsetY : 0;
        if (setElementOffsets) {
            this.elementOffsetX = this.globalOffsetX;
            this.elementOffsetY = this.globalOffsetY;
        }
    }

    protected void setExportContext() {
        this.classLoaderSet = false;
        this.urlHandlerFactorySet = false;
        this.fileResolverSet = false;
        this.classLoader = (ClassLoader)this.parameters.get(JRExporterParameter.CLASS_LOADER);
        if (this.classLoader != null) {
            JRResourcesUtil.setThreadClassLoader(this.classLoader);
            this.classLoaderSet = true;
        }
        this.urlHandlerFactory = (URLStreamHandlerFactory)this.parameters.get(JRExporterParameter.URL_HANDLER_FACTORY);
        if (this.urlHandlerFactory != null) {
            JRResourcesUtil.setThreadURLHandlerFactory(this.urlHandlerFactory);
            this.urlHandlerFactorySet = true;
        }
        this.fileResolver = (FileResolver)this.parameters.get(JRExporterParameter.FILE_RESOLVER);
        if (this.fileResolver != null) {
            JRResourcesUtil.setThreadFileResolver(this.fileResolver);
            this.fileResolverSet = true;
        }
    }

    protected void resetExportContext() {
        if (this.classLoaderSet) {
            JRResourcesUtil.resetClassLoader();
        }
        if (this.urlHandlerFactorySet) {
            JRResourcesUtil.resetThreadURLHandlerFactory();
        }
        if (this.fileResolverSet) {
            JRResourcesUtil.resetThreadFileResolver();
        }
    }

    protected void setClassLoader() {
        this.setExportContext();
    }

    protected void resetClassLoader() {
        this.resetExportContext();
    }

    protected void setInput() throws JRException {
        this.jasperPrintList = (List)this.parameters.get(JRExporterParameter.JASPER_PRINT_LIST);
        if (this.jasperPrintList == null) {
            this.isModeBatch = false;
            this.jasperPrint = (JasperPrint)this.parameters.get(JRExporterParameter.JASPER_PRINT);
            if (this.jasperPrint == null) {
                InputStream is = (InputStream)this.parameters.get(JRExporterParameter.INPUT_STREAM);
                if (is != null) {
                    this.jasperPrint = (JasperPrint)JRLoader.loadObject(is);
                } else {
                    URL url = (URL)this.parameters.get(JRExporterParameter.INPUT_URL);
                    if (url != null) {
                        this.jasperPrint = (JasperPrint)JRLoader.loadObject(url);
                    } else {
                        File file = (File)this.parameters.get(JRExporterParameter.INPUT_FILE);
                        if (file != null) {
                            this.jasperPrint = (JasperPrint)JRLoader.loadObject(file);
                        } else {
                            String fileName = (String)this.parameters.get(JRExporterParameter.INPUT_FILE_NAME);
                            if (fileName != null) {
                                this.jasperPrint = (JasperPrint)JRLoader.loadObject(fileName);
                            } else {
                                throw new JRException("No input source supplied to the exporter.");
                            }
                        }
                    }
                }
            }
            this.jasperPrintList = new ArrayList();
            this.jasperPrintList.add(this.jasperPrint);
        } else {
            this.isModeBatch = true;
            if (this.jasperPrintList.size() == 0) {
                throw new JRException("Empty input source supplied to the exporter in batch mode.");
            }
            this.jasperPrint = (JasperPrint)this.jasperPrintList.get(0);
        }
        this.filter = (ExporterFilter)this.parameters.get(JRExporterParameter.FILTER);
    }

    protected void setPageRange() throws JRException {
        Integer start;
        int lastPageIndex = -1;
        if (this.jasperPrint.getPages() != null) {
            lastPageIndex = this.jasperPrint.getPages().size() - 1;
        }
        if ((start = (Integer)this.parameters.get(JRExporterParameter.START_PAGE_INDEX)) == null) {
            this.startPageIndex = 0;
        } else {
            this.startPageIndex = start;
            if (this.startPageIndex < 0 || this.startPageIndex > lastPageIndex) {
                throw new JRException("Start page index out of range : " + this.startPageIndex + " of " + lastPageIndex);
            }
        }
        Integer end = (Integer)this.parameters.get(JRExporterParameter.END_PAGE_INDEX);
        if (end == null) {
            this.endPageIndex = lastPageIndex;
        } else {
            this.endPageIndex = end;
            if (this.endPageIndex < this.startPageIndex || this.endPageIndex > lastPageIndex) {
                throw new JRException("End page index out of range : " + this.endPageIndex + " (" + this.startPageIndex + " : " + lastPageIndex + ")");
            }
        }
        Integer index = (Integer)this.parameters.get(JRExporterParameter.PAGE_INDEX);
        if (index != null) {
            int pageIndex = index;
            if (pageIndex < 0 || pageIndex > lastPageIndex) {
                throw new JRException("Page index out of range : " + pageIndex + " of " + lastPageIndex);
            }
            this.startPageIndex = pageIndex;
            this.endPageIndex = pageIndex;
        }
    }

    protected JRStyledText getStyledText(JRPrintText textElement, boolean setBackcolor) {
        return textElement.getStyledText(setBackcolor ? JRStyledTextAttributeSelector.ALL : JRStyledTextAttributeSelector.NO_BACKCOLOR);
    }

    protected JRStyledText getStyledText(JRPrintText textElement) {
        return this.getStyledText(textElement, true);
    }

    protected void setOutput() {
    }

    protected int getOffsetX() {
        return this.elementOffsetX;
    }

    protected int getOffsetY() {
        return this.elementOffsetY;
    }

    protected void setFrameElementsOffset(JRPrintFrame frame, boolean relative) {
        if (relative) {
            this.setElementOffsets(0, 0);
        } else {
            int topPadding = frame.getLineBox().getTopPadding();
            int leftPadding = frame.getLineBox().getLeftPadding();
            this.setElementOffsets(this.getOffsetX() + frame.getX() + leftPadding, this.getOffsetY() + frame.getY() + topPadding);
        }
    }

    private void setElementOffsets(int offsetX, int offsetY) {
        this.elementOffsetStack.addLast(new int[]{this.elementOffsetX, this.elementOffsetY});
        this.elementOffsetX = offsetX;
        this.elementOffsetY = offsetY;
    }

    protected void restoreElementOffsets() {
        int[] offsets = (int[])this.elementOffsetStack.removeLast();
        this.elementOffsetX = offsets[0];
        this.elementOffsetY = offsets[1];
    }

    protected String getTextFormatFactoryClass(JRPrintText text) {
        String formatFactoryClass = text.getFormatFactoryClass();
        if (formatFactoryClass == null) {
            formatFactoryClass = this.jasperPrint.getFormatFactoryClass();
        }
        return formatFactoryClass;
    }

    protected Locale getTextLocale(JRPrintText text) {
        String localeCode = text.getLocaleCode();
        if (localeCode == null) {
            localeCode = this.jasperPrint.getLocaleCode();
        }
        return localeCode == null ? null : JRDataUtils.getLocale(localeCode);
    }

    protected TimeZone getTextTimeZone(JRPrintText text) {
        String tzId = text.getTimeZoneId();
        if (tzId == null) {
            tzId = this.jasperPrint.getTimeZoneId();
        }
        return tzId == null ? null : JRDataUtils.getTimeZone(tzId);
    }

    protected TextValue getTextValue(JRPrintText text, String textStr) {
        TextValue textValue;
        if (text.getValueClassName() == null) {
            textValue = this.getTextValueString(text, textStr);
        } else {
            try {
                Class valueClass = JRClassLoader.loadClassForRealName(text.getValueClassName());
                textValue = Number.class.isAssignableFrom(valueClass) ? this.getNumberCellValue(text, textStr) : (Date.class.isAssignableFrom(valueClass) ? this.getDateCellValue(text, textStr) : (Boolean.class.equals(valueClass) ? this.getBooleanCellValue(text, textStr) : this.getTextValueString(text, textStr)));
            }
            catch (ParseException e) {
                textValue = this.getTextValueString(text, textStr);
            }
            catch (ClassNotFoundException e) {
                textValue = this.getTextValueString(text, textStr);
            }
        }
        return textValue;
    }

    protected TextValue getTextValueString(JRPrintText text, String textStr) {
        return new StringTextValue(textStr);
    }

    protected TextValue getBooleanCellValue(JRPrintText text, String textStr) {
        Boolean value = null;
        if (textStr != null || textStr.length() > 0) {
            value = Boolean.valueOf(textStr);
        }
        return new BooleanTextValue(textStr, value);
    }

    protected TextValue getDateCellValue(JRPrintText text, String textStr) throws ParseException {
        TextValue textValue;
        String pattern = text.getPattern();
        if (pattern == null || pattern.trim().length() == 0) {
            textValue = this.getTextValueString(text, textStr);
        } else {
            DateFormat dateFormat = this.getDateFormat(this.getTextFormatFactoryClass(text), pattern, this.getTextLocale(text), this.getTextTimeZone(text));
            Date value = null;
            if (textStr != null && textStr.length() > 0) {
                value = dateFormat.parse(textStr);
            }
            textValue = new DateTextValue(textStr, value, pattern);
        }
        return textValue;
    }

    protected TextValue getNumberCellValue(JRPrintText text, String textStr) throws ParseException, ClassNotFoundException {
        TextValue textValue;
        String pattern = text.getPattern();
        if (pattern == null || pattern.trim().length() == 0) {
            Number value;
            textValue = textStr != null && textStr.length() > 0 ? ((value = this.defaultParseNumber(textStr, JRClassLoader.loadClassForRealName(text.getValueClassName()))) != null ? new NumberTextValue(textStr, value, null) : this.getTextValueString(text, textStr)) : new NumberTextValue(textStr, null, null);
        } else {
            NumberFormat numberFormat = this.getNumberFormat(this.getTextFormatFactoryClass(text), pattern, this.getTextLocale(text));
            Number value = null;
            if (textStr != null && textStr.length() > 0) {
                value = numberFormat.parse(textStr);
            }
            textValue = new NumberTextValue(textStr, value, pattern);
        }
        return textValue;
    }

    protected Number defaultParseNumber(String textStr, Class valueClass) {
        Number value = null;
        try {
            if (valueClass.equals(Byte.class)) {
                value = Byte.valueOf(textStr);
            } else if (valueClass.equals(Short.class)) {
                value = Short.valueOf(textStr);
            } else if (valueClass.equals(Integer.class)) {
                value = Integer.valueOf(textStr);
            } else if (valueClass.equals(Long.class)) {
                value = Long.valueOf(textStr);
            } else if (valueClass.equals(Float.class)) {
                value = Float.valueOf(textStr);
            } else if (valueClass.equals(Double.class)) {
                value = Double.valueOf(textStr);
            } else if (valueClass.equals(BigInteger.class)) {
                value = new BigInteger(textStr);
            } else if (valueClass.equals(BigDecimal.class)) {
                value = new BigDecimal(textStr);
            }
        }
        catch (NumberFormatException e) {
            // empty catch block
        }
        return value;
    }

    protected DateFormat getDateFormat(String formatFactoryClass, String pattern, Locale lc, TimeZone tz) {
        String key = formatFactoryClass + "|" + pattern + "|" + JRDataUtils.getLocaleCode(lc) + "|" + JRDataUtils.getTimeZoneId(tz);
        DateFormat dateFormat = (DateFormat)this.dateFormatCache.get(key);
        if (dateFormat == null) {
            FormatFactory formatFactory = DefaultFormatFactory.createFormatFactory(formatFactoryClass);
            dateFormat = formatFactory.createDateFormat(pattern, lc, tz);
            this.dateFormatCache.put(key, dateFormat);
        }
        return dateFormat;
    }

    protected NumberFormat getNumberFormat(String formatFactoryClass, String pattern, Locale lc) {
        String key = formatFactoryClass + "|" + pattern + "|" + JRDataUtils.getLocaleCode(lc);
        NumberFormat numberFormat = (NumberFormat)this.numberFormatCache.get(key);
        if (numberFormat == null) {
            FormatFactory formatFactory = DefaultFormatFactory.createFormatFactory(formatFactoryClass);
            numberFormat = formatFactory.createNumberFormat(pattern, lc);
            this.dateFormatCache.put(key, numberFormat);
        }
        return numberFormat;
    }

    protected class ParameterOverriddenResolver
    implements ParameterResolver {
        protected ParameterOverriddenResolver() {
        }

        public String getStringParameter(JRExporterParameter parameter, String property) {
            String value;
            JRPropertiesMap hintsMap = JRAbstractExporter.this.jasperPrint.getPropertiesMap();
            if (hintsMap != null && hintsMap.containsProperty(property)) {
                value = hintsMap.getProperty(property);
            } else {
                value = (String)JRAbstractExporter.this.parameters.get(parameter);
                if (value == null) {
                    value = JRProperties.getProperty(property);
                }
            }
            return value;
        }

        public String getStringParameterOrDefault(JRExporterParameter parameter, String property) {
            JRPropertiesMap hintsMap = JRAbstractExporter.this.jasperPrint.getPropertiesMap();
            String value = hintsMap != null && hintsMap.containsProperty(property) ? hintsMap.getProperty(property) : (String)JRAbstractExporter.this.parameters.get(parameter);
            if (value == null) {
                value = JRProperties.getProperty(property);
            }
            return value;
        }

        public boolean getBooleanParameter(JRExporterParameter parameter, String property, boolean defaultValue) {
            Boolean param;
            String prop;
            JRPropertiesMap hintsMap = JRAbstractExporter.this.jasperPrint.getPropertiesMap();
            boolean value = hintsMap != null && hintsMap.containsProperty(property) ? ((prop = hintsMap.getProperty(property)) == null ? JRProperties.getBooleanProperty(property) : JRProperties.asBoolean(prop)) : ((param = (Boolean)JRAbstractExporter.this.parameters.get(parameter)) == null ? JRProperties.getBooleanProperty(property) : param);
            return value;
        }

        public int getIntegerParameter(JRExporterParameter parameter, String property, int defaultValue) {
            Integer param;
            String prop;
            JRPropertiesMap hintsMap = JRAbstractExporter.this.jasperPrint.getPropertiesMap();
            int value = hintsMap != null && hintsMap.containsProperty(property) ? ((prop = hintsMap.getProperty(property)) == null ? JRProperties.getIntegerProperty(property) : JRProperties.asInteger(prop)) : ((param = (Integer)JRAbstractExporter.this.parameters.get(parameter)) == null ? JRProperties.getIntegerProperty(property) : param);
            return value;
        }
    }

    protected class ParameterOverrideResolver
    implements ParameterResolver {
        protected ParameterOverrideResolver() {
        }

        public String getStringParameter(JRExporterParameter parameter, String property) {
            if (JRAbstractExporter.this.parameters.containsKey(parameter)) {
                return (String)JRAbstractExporter.this.parameters.get(parameter);
            }
            return JRProperties.getProperty(JRAbstractExporter.this.jasperPrint.getPropertiesMap(), property);
        }

        public String getStringParameterOrDefault(JRExporterParameter parameter, String property) {
            if (JRAbstractExporter.this.parameters.containsKey(parameter)) {
                String value = (String)JRAbstractExporter.this.parameters.get(parameter);
                if (value == null) {
                    return JRProperties.getProperty(property);
                }
                return value;
            }
            return JRProperties.getProperty(JRAbstractExporter.this.jasperPrint.getPropertiesMap(), property);
        }

        public boolean getBooleanParameter(JRExporterParameter parameter, String property, boolean defaultValue) {
            if (JRAbstractExporter.this.parameters.containsKey(parameter)) {
                Boolean booleanValue = (Boolean)JRAbstractExporter.this.parameters.get(parameter);
                if (booleanValue == null) {
                    return JRProperties.getBooleanProperty(property);
                }
                return booleanValue;
            }
            return JRProperties.getBooleanProperty(JRAbstractExporter.this.jasperPrint.getPropertiesMap(), property, defaultValue);
        }

        public int getIntegerParameter(JRExporterParameter parameter, String property, int defaultValue) {
            if (JRAbstractExporter.this.parameters.containsKey(parameter)) {
                Integer integerValue = (Integer)JRAbstractExporter.this.parameters.get(parameter);
                if (integerValue == null) {
                    return JRProperties.getIntegerProperty(property);
                }
                return integerValue;
            }
            return JRProperties.getIntegerProperty(JRAbstractExporter.this.jasperPrint.getPropertiesMap(), property, defaultValue);
        }
    }

    protected static interface ParameterResolver {
        public String getStringParameter(JRExporterParameter var1, String var2);

        public String getStringParameterOrDefault(JRExporterParameter var1, String var2);

        public boolean getBooleanParameter(JRExporterParameter var1, String var2, boolean var3);

        public int getIntegerParameter(JRExporterParameter var1, String var2, int var3);
    }
}

