/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.decorator;

import java.awt.Color;
import java.awt.Component;
import org.jdesktop.swingx.decorator.AbstractHighlighter;
import org.jdesktop.swingx.decorator.ComponentAdapter;
import org.jdesktop.swingx.decorator.HighlightPredicate;

public class ColorHighlighter
extends AbstractHighlighter {
    private Color background = null;
    private Color foreground = null;
    private Color selectedBackground = null;
    private Color selectedForeground = null;

    public ColorHighlighter() {
        this(null, null);
    }

    public ColorHighlighter(Color cellBackground, Color cellForeground) {
        this(cellBackground, cellForeground, null, null, null);
    }

    public ColorHighlighter(Color cellBackground, Color cellForeground, HighlightPredicate predicate) {
        this(cellBackground, cellForeground, null, null, predicate);
    }

    public ColorHighlighter(Color cellBackground, Color cellForeground, Color selectedBackground, Color selectedForeground) {
        this(cellBackground, cellForeground, selectedBackground, selectedForeground, null);
    }

    public ColorHighlighter(Color cellBackground, Color cellForeground, Color selectedBackground, Color selectedForeground, HighlightPredicate predicate) {
        super(predicate);
        this.background = cellBackground;
        this.foreground = cellForeground;
        this.selectedBackground = selectedBackground;
        this.selectedForeground = selectedForeground;
    }

    protected Component doHighlight(Component renderer, ComponentAdapter adapter) {
        this.applyBackground(renderer, adapter);
        this.applyForeground(renderer, adapter);
        return renderer;
    }

    protected void applyBackground(Component renderer, ComponentAdapter adapter) {
        Color color;
        Color color2 = color = adapter.isSelected() ? this.getSelectedBackground() : this.getBackground();
        if (color != null) {
            renderer.setBackground(color);
        }
    }

    protected void applyForeground(Component renderer, ComponentAdapter adapter) {
        Color color;
        Color color2 = color = adapter.isSelected() ? this.getSelectedForeground() : this.getForeground();
        if (color != null) {
            renderer.setForeground(color);
        }
    }

    public Color getBackground() {
        return this.background;
    }

    public void setBackground(Color color) {
        this.background = color;
        this.fireStateChanged();
    }

    public Color getForeground() {
        return this.foreground;
    }

    public void setForeground(Color color) {
        this.foreground = color;
        this.fireStateChanged();
    }

    public Color getSelectedBackground() {
        return this.selectedBackground;
    }

    public void setSelectedBackground(Color color) {
        this.selectedBackground = color;
        this.fireStateChanged();
    }

    public Color getSelectedForeground() {
        return this.selectedForeground;
    }

    public void setSelectedForeground(Color color) {
        this.selectedForeground = color;
        this.fireStateChanged();
    }
}

