/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.lib;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Logger;
import org.netbeans.api.editor.mimelookup.MimePath;
import org.openide.util.Lookup;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class KitsTracker {
    private static final Logger LOG = Logger.getLogger(KitsTracker.class.getName());
    private static final Set<String> ALREADY_LOGGED = Collections.synchronizedSet(new HashSet(10));
    private static KitsTracker instance = null;
    private final PropertyChangeSupport PCS = new PropertyChangeSupport(this);

    public static synchronized KitsTracker getInstance() {
        if (instance == null && (instance = (KitsTracker)Lookup.getDefault().lookup(KitsTracker.class)) == null) {
            instance = new KitsTracker(){
                private final ThreadLocal<String> context = new ThreadLocal();

                @Override
                public List<String> getMimeTypesForKitClass(Class clazz) {
                    String string = this.findMimeType(clazz);
                    if (string != null) {
                        return Collections.singletonList(string);
                    }
                    return Collections.emptyList();
                }

                @Override
                public String findMimeType(Class clazz) {
                    if (clazz != null) {
                        return this.context.get();
                    }
                    return "";
                }

                @Override
                public Class<?> findKitClass(String string) {
                    return null;
                }

                @Override
                public Set<String> getMimeTypes() {
                    return Collections.emptySet();
                }

                @Override
                public String setContextMimeType(String string) {
                    if (string != null && MimePath.validate((CharSequence)string)) assert (false) : "Invalid mimeType: '" + string + "'";
                    String string2 = this.context.get();
                    this.context.set(string);
                    return string2;
                }
            };
        }
        return instance;
    }

    public static String getGenericPartOfCompoundMimeType(String string) {
        int n = string.lastIndexOf(43);
        if (n != -1 && n < string.length() - 1) {
            int n2 = string.indexOf(47);
            String string2 = string.substring(0, n2 + 1);
            String string3 = string.substring(n + 1);
            if (string3.equals("xml")) {
                string2 = "text/";
            }
            return string2 + string3;
        }
        return null;
    }

    public abstract List<String> getMimeTypesForKitClass(Class var1);

    public abstract String findMimeType(Class var1);

    public abstract Class findKitClass(String var1);

    public abstract Set<String> getMimeTypes();

    public abstract String setContextMimeType(String var1);

    public final void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.PCS.addPropertyChangeListener(propertyChangeListener);
    }

    public final void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.PCS.removePropertyChangeListener(propertyChangeListener);
    }

    protected final void firePropertyChange(String string, Object object, Object object2) {
        this.PCS.firePropertyChange(string, object, object2);
    }

    protected KitsTracker() {
    }
}

