/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.designer.actions;

import com.jaspersoft.ireport.designer.IReportManager;
import com.jaspersoft.ireport.designer.ModelUtils;
import com.jaspersoft.ireport.designer.outline.nodes.ElementNode;
import com.jaspersoft.ireport.designer.sheet.properties.AbstractProperty;
import com.jaspersoft.ireport.designer.tools.FieldPatternPanel;
import com.jaspersoft.ireport.designer.undo.PropertyUndoableEdit;
import com.jaspersoft.ireport.designer.utils.Misc;
import com.jaspersoft.ireport.locale.I18n;
import net.sf.jasperreports.engine.design.JRDesignTextField;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.actions.NodeAction;

public final class EditTextfieldPatternAction
extends NodeAction {
    public String getName() {
        return I18n.getString("EditTextfieldPatternAction.name");
    }

    protected void initialize() {
        super.initialize();
        this.putValue("noIconInMenu", Boolean.TRUE);
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    protected boolean asynchronous() {
        return false;
    }

    protected void performAction(Node[] activatedNodes) {
        ElementNode node = (ElementNode)activatedNodes[0];
        JRDesignTextField element = (JRDesignTextField)node.getElement();
        FieldPatternPanel fpd = new FieldPatternPanel();
        fpd.setPattern(element.getPattern());
        String newPattern = fpd.showFieldPatternDialog(Misc.getMainFrame());
        if (newPattern != null) {
            String oldPattern = element.getOwnPattern();
            element.setPattern(newPattern);
            Node.Property obj = ModelUtils.findProperty(node.getPropertySets(), "pattern");
            if (obj != null && obj instanceof AbstractProperty) {
                PropertyUndoableEdit edit = new PropertyUndoableEdit((AbstractProperty)obj, oldPattern, newPattern);
                IReportManager.getInstance().addUndoableEdit(edit);
                IReportManager.getInstance().notifyReportChange();
            } else {
                System.out.println("Unable to find property pattern");
                System.out.flush();
            }
        }
    }

    protected boolean enable(Node[] activatedNodes) {
        if (activatedNodes == null || activatedNodes.length != 1) {
            return false;
        }
        if (!(activatedNodes[0] instanceof ElementNode)) {
            return false;
        }
        ElementNode node = (ElementNode)activatedNodes[0];
        return node.getElement() instanceof JRDesignTextField;
    }
}

