/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.transaction.interceptor;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.BeanClassLoaderAware;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.transaction.interceptor.TransactionAttribute;
import org.springframework.transaction.interceptor.TransactionAttributeEditor;
import org.springframework.transaction.interceptor.TransactionAttributeSource;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.PatternMatchUtils;

public class MethodMapTransactionAttributeSource
implements TransactionAttributeSource,
BeanClassLoaderAware,
InitializingBean {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private Map methodMap;
    private ClassLoader beanClassLoader = ClassUtils.getDefaultClassLoader();
    private boolean eagerlyInitialized = false;
    private boolean initialized = false;
    private final Map transactionAttributeMap = new HashMap();
    private final Map methodNameMap = new HashMap();

    public void setMethodMap(Map methodMap) {
        this.methodMap = methodMap;
    }

    public void setBeanClassLoader(ClassLoader beanClassLoader) {
        this.beanClassLoader = beanClassLoader;
    }

    public void afterPropertiesSet() {
        this.initMethodMap(this.methodMap);
        this.eagerlyInitialized = true;
        this.initialized = true;
    }

    protected void initMethodMap(Map methodMap) {
        if (methodMap != null) {
            Iterator it = methodMap.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry entry = it.next();
                Object key = entry.getKey();
                if (!(key instanceof String)) {
                    throw new IllegalArgumentException("Invalid method map key [" + key + "]: only Strings allowed");
                }
                Object value = entry.getValue();
                TransactionAttribute attr = null;
                if (value instanceof TransactionAttribute) {
                    attr = (TransactionAttribute)value;
                } else if (value instanceof String) {
                    TransactionAttributeEditor editor = new TransactionAttributeEditor();
                    editor.setAsText((String)value);
                    attr = (TransactionAttribute)editor.getValue();
                } else {
                    throw new IllegalArgumentException("Value [" + value + "] is neither of type [" + TransactionAttribute.class.getName() + "] nor a String");
                }
                this.addTransactionalMethod((String)key, attr);
            }
        }
    }

    public void addTransactionalMethod(String name, TransactionAttribute attr) {
        Assert.notNull(name, "Name must not be null");
        int lastDotIndex = name.lastIndexOf(".");
        if (lastDotIndex == -1) {
            throw new IllegalArgumentException("'" + name + "' is not a valid method name: format is FQN.methodName");
        }
        String className = name.substring(0, lastDotIndex);
        String methodName = name.substring(lastDotIndex + 1);
        Class clazz = ClassUtils.resolveClassName(className, this.beanClassLoader);
        this.addTransactionalMethod(clazz, methodName, attr);
    }

    public void addTransactionalMethod(Class clazz, String mappedName, TransactionAttribute attr) {
        Assert.notNull(clazz, "Class must not be null");
        Assert.notNull(mappedName, "Mapped name must not be null");
        String name = clazz.getName() + '.' + mappedName;
        Method[] methods = clazz.getDeclaredMethods();
        ArrayList<Method> matchingMethods = new ArrayList<Method>();
        for (int i = 0; i < methods.length; ++i) {
            if (!this.isMatch(methods[i].getName(), mappedName)) continue;
            matchingMethods.add(methods[i]);
        }
        if (matchingMethods.isEmpty()) {
            throw new IllegalArgumentException("Couldn't find method '" + mappedName + "' on class [" + clazz.getName() + "]");
        }
        Iterator it = matchingMethods.iterator();
        while (it.hasNext()) {
            Method method = (Method)it.next();
            String regMethodName = (String)this.methodNameMap.get(method);
            if (regMethodName == null || !regMethodName.equals(name) && regMethodName.length() <= name.length()) {
                if (this.logger.isDebugEnabled() && regMethodName != null) {
                    this.logger.debug((Object)("Replacing attribute for transactional method [" + method + "]: current name '" + name + "' is more specific than '" + regMethodName + "'"));
                }
                this.methodNameMap.put(method, name);
                this.addTransactionalMethod(method, attr);
                continue;
            }
            if (!this.logger.isDebugEnabled() || regMethodName == null) continue;
            this.logger.debug((Object)("Keeping attribute for transactional method [" + method + "]: current name '" + name + "' is not more specific than '" + regMethodName + "'"));
        }
    }

    public void addTransactionalMethod(Method method, TransactionAttribute attr) {
        Assert.notNull(method, "Method must not be null");
        Assert.notNull(attr, "TransactionAttribute must not be null");
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Adding transactional method [" + method + "] with attribute [" + attr + "]"));
        }
        this.transactionAttributeMap.put(method, attr);
    }

    protected boolean isMatch(String methodName, String mappedName) {
        return PatternMatchUtils.simpleMatch(mappedName, methodName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TransactionAttribute getTransactionAttribute(Method method, Class targetClass) {
        if (this.eagerlyInitialized) {
            return (TransactionAttribute)this.transactionAttributeMap.get(method);
        }
        Map map = this.transactionAttributeMap;
        synchronized (map) {
            if (!this.initialized) {
                this.initMethodMap(this.methodMap);
                this.initialized = true;
            }
            return (TransactionAttribute)this.transactionAttributeMap.get(method);
        }
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof MethodMapTransactionAttributeSource)) {
            return false;
        }
        MethodMapTransactionAttributeSource otherTas = (MethodMapTransactionAttributeSource)other;
        return ObjectUtils.nullSafeEquals(this.methodMap, otherTas.methodMap);
    }

    public int hashCode() {
        return MethodMapTransactionAttributeSource.class.hashCode();
    }

    public String toString() {
        return this.getClass().getName() + ": " + this.methodMap;
    }
}

