/*
 * Decompiled with CFR 0.152.
 */
package rex.graphics.mdxeditor;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.GregorianCalendar;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.ListIterator;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import org.w3c.dom.Document;
import rex.graphics.CubeExplorer2;
import rex.graphics.IViewer;
import rex.graphics.StatusBar;
import rex.graphics.TupleMemberLabelPopUpActions;
import rex.graphics.charts.Chart;
import rex.graphics.dimensiontree.DimensionTree;
import rex.graphics.dimensiontree.DimensionTreeModel;
import rex.graphics.dimensiontree.dnd.TreeDragSource;
import rex.graphics.filtertree.FilterTree;
import rex.graphics.filtertree.FilterTreeModel;
import rex.graphics.filtertree.elements.FilterTreeRootElement;
import rex.graphics.mdxeditor.MdxEditor;
import rex.graphics.mdxeditor.MdxResultPage;
import rex.graphics.mdxeditor.mdxbuilder.MdxBuilderTree;
import rex.metadata.CubeSlicer;
import rex.metadata.ExecuteResult;
import rex.metadata.ExecuteResultParseException;
import rex.metadata.Query;
import rex.metadata.QueryElement;
import rex.metadata.ServerMetadata;
import rex.metadata.resultelements.Member;
import rex.metadata.resultelements.Tuple;
import rex.utils.I18n;
import rex.utils.S;
import rex.utils.UIPropertyManager;
import rex.xmla.XMLADiscoverProperties;
import rex.xmla.XMLADiscoverRestrictions;
import rex.xmla.XMLAExecuteProperties;
import rex.xmla.XMLAObjectsFactory;

public class MdxResultViewer
extends JPanel
implements IViewer {
    private JSplitPane splitPane;
    private JPanel rightPane;
    private JPanel leftPane;
    private LinkedList filterTrees;
    private LinkedList chartTabs;
    private TreeDragSource ds;
    private Query q;
    private LinkedList pages;
    private StatusBar statusBar;
    private XMLADiscoverRestrictions restrictions;
    private XMLADiscoverProperties properties;
    private XMLAExecuteProperties execProperties;
    private ServerMetadata smd;
    private Document d;
    private ExecuteResult er;
    private static int MAX_CHAPTER_COUNT = 10;
    private boolean errorOccured;
    private String errorMessage;
    private CubeExplorer2 cubeExplorer;
    private String mdxQuery;
    private static ImageIcon tableIcon = S.getAppIcon("table.gif");
    private static ImageIcon chartIcon = S.getAppIcon("chart.gif");
    private boolean showRowTotalsOn;
    private boolean showColumnTotalsOn;
    private MdxEditor parent;

    public MdxResultViewer(XMLADiscoverRestrictions _restrictions, XMLADiscoverProperties _properties, ServerMetadata _smd, String _mdxQuery, StatusBar _statusBar, boolean _showRowTotalsOn, boolean _showColumnTotalsOn, MdxEditor _parent) {
        this(_restrictions, _properties, _smd);
        this.mdxQuery = _mdxQuery;
        this.statusBar = _statusBar;
        this.showRowTotalsOn = _showRowTotalsOn;
        this.showColumnTotalsOn = _showColumnTotalsOn;
        this.parent = _parent;
        this.refreshQuery();
    }

    public MdxResultViewer(XMLADiscoverRestrictions _restrictions, XMLADiscoverProperties _properties, ServerMetadata _smd, String _mdxQuery, StatusBar _statusBar, boolean _showRowTotalsOn, boolean _showColumnTotalsOn, MdxEditor _parent, MdxBuilderTree _MdxBuilderTree, DimensionTree _DimensionTree) {
        this(_restrictions, _properties, _smd, _MdxBuilderTree, _DimensionTree);
        this.mdxQuery = _mdxQuery;
        this.statusBar = _statusBar;
        this.showRowTotalsOn = _showRowTotalsOn;
        this.showColumnTotalsOn = _showColumnTotalsOn;
        this.parent = _parent;
        this.refreshQuery();
    }

    public MdxResultViewer(XMLADiscoverRestrictions _restrictions, XMLADiscoverProperties _properties, ServerMetadata _smd) {
        this.restrictions = _restrictions;
        this.properties = _properties;
        this.smd = _smd;
        this.execProperties = XMLAObjectsFactory.newXMLAExecuteProperties();
        this.execProperties.setCatalog(this.properties.getCatalog());
        this.execProperties.setDataSourceInfo(this.properties.getDataSourceInfo());
        this.q = new Query(_restrictions.getCubeName(), this);
        this.rightPane = new JPanel(){
            {
                this.setOpaque(false);
            }

            public void paintComponent(Graphics g) {
                S.paintBackground(g, this);
                super.paintComponent(g);
            }
        };
        this.rightPane.setLayout(new BoxLayout(this.rightPane, 1));
        this.pages = new LinkedList();
        MdxResultPage c = new MdxResultPage();
        c.setCurrent(true);
        this.pages.add(c);
        this.rightPane.add(c);
        this.setLayout(new BoxLayout(this, 0));
        this.add(this.rightPane);
    }

    public MdxResultViewer(XMLADiscoverRestrictions _restrictions, XMLADiscoverProperties _properties, ServerMetadata _smd, MdxBuilderTree _MdxBuilderTree, DimensionTree _DimensionTree) {
        this.restrictions = _restrictions;
        this.properties = _properties;
        this.smd = _smd;
        this.execProperties = XMLAObjectsFactory.newXMLAExecuteProperties();
        this.execProperties.setCatalog(this.properties.getCatalog());
        this.execProperties.setDataSourceInfo(this.properties.getDataSourceInfo());
        this.q = new Query(_restrictions.getCubeName(), this, _MdxBuilderTree, _DimensionTree);
        this.rightPane = new JPanel(){
            {
                this.setOpaque(false);
            }

            public void paintComponent(Graphics g) {
                S.paintBackground(g, this);
                super.paintComponent(g);
            }
        };
        this.rightPane.setLayout(new BoxLayout(this.rightPane, 1));
        this.pages = new LinkedList();
        MdxResultPage c = new MdxResultPage();
        c.setCurrent(true);
        this.pages.add(c);
        this.rightPane.add(c);
        this.setLayout(new BoxLayout(this, 0));
        this.add(this.rightPane);
    }

    public void refreshQuery() {
        if (this.q.canExecute()) {
            this.q.updateMBTree(this.parent.getToolbar().getAppendGeneratedMDX());
            this.mdxQuery = this.q.getQuery();
            this.parent.appendGeneratedMDX("\n\n-- *** Generated(" + GregorianCalendar.getInstance().getTime() + "):  *** \n" + this.mdxQuery);
        }
        this.statusBar.startServerClock();
        this.statusBar.setStatus(I18n.getString("statusBar.execQuery"));
        this.errorOccured = false;
        this.statusBar.progressJob(new Runnable(){

            public void run() {
                try {
                    MdxResultViewer.this.d = MdxResultViewer.this.smd.execute(MdxResultViewer.this.mdxQuery, MdxResultViewer.this.execProperties);
                }
                catch (Exception e) {
                    MdxResultViewer.this.errorOccured = true;
                    MdxResultViewer.this.errorMessage = e.getMessage();
                    e.printStackTrace();
                    return;
                }
                catch (OutOfMemoryError mem) {
                    MdxResultViewer.this.errorOccured = true;
                    MdxResultViewer.this.errorMessage = mem.getMessage();
                    return;
                }
            }
        }, StatusBar.JOB_TYPE_CRITICAL);
        this.statusBar.stopServerClock();
        if (!this.errorOccured) {
            this.statusBar.setStatus(I18n.getString("statusBar.resultDisplay"));
            this.statusBar.startClientClock();
            this.statusBar.progressJob(new Runnable(){

                public void run() {
                    int chapterCount;
                    try {
                        MdxResultViewer.this.er = new ExecuteResult(MdxResultViewer.this.d, MdxResultViewer.this.q);
                    }
                    catch (ExecuteResultParseException e) {
                        MdxResultViewer.this.errorOccured = true;
                        MdxResultViewer.this.errorMessage = e.getMessage();
                        e.printStackTrace();
                        return;
                    }
                    catch (OutOfMemoryError mem) {
                        MdxResultViewer.this.errorOccured = true;
                        MdxResultViewer.this.errorMessage = mem.getMessage();
                        return;
                    }
                    if (!MdxResultViewer.this.er.isValid()) {
                        if ((MdxResultViewer.this.er.getAxis("Axis1") != null ? MdxResultViewer.this.er.getAxis("Axis1").getTupleCount() : 0) == 0) {
                            MdxResultViewer.this.statusBar.setStatus(I18n.getString("statusBar.errAxis1"));
                            MdxResultViewer.this.errorOccured = true;
                            MdxResultViewer.this.errorMessage = I18n.getString("statusBar.errAxis1");
                        } else if ((MdxResultViewer.this.er.getAxis("Axis0") != null ? MdxResultViewer.this.er.getAxis("Axis0").getTupleCount() : 0) == 0) {
                            MdxResultViewer.this.statusBar.setStatus(I18n.getString("statusBar.errAxis0"));
                            MdxResultViewer.this.errorOccured = true;
                            MdxResultViewer.this.errorMessage = I18n.getString("statusBar.errAxis0");
                        }
                        return;
                    }
                    MdxResultViewer.this.rightPane.removeAll();
                    if (MdxResultViewer.this.er.getAxis("Axis2") != null) {
                        chapterCount = MdxResultViewer.this.er.getAxis("Axis2").getTupleCount();
                        MdxResultViewer.this.pages.clear();
                        JTabbedPane jtp = new JTabbedPane(1);
                        for (int cc = 0; cc < chapterCount && cc < MAX_CHAPTER_COUNT; ++cc) {
                            CubeSlicer cs = new CubeSlicer(1, 0, new short[]{2}, new Tuple[]{MdxResultViewer.this.er.getAxis("Axis2").getTupleAt(cc)});
                            MdxResultViewer.this.cubeExplorer = new CubeExplorer2(MdxResultViewer.this.er, cs, MdxResultViewer.this.showColumnTotalsOn, MdxResultViewer.this.showRowTotalsOn);
                            MdxResultViewer.this.cubeExplorer.setMaximumSize(new Dimension(Short.MAX_VALUE, MdxResultViewer.this.cubeExplorer.getHeight()));
                            MdxResultPage c = new MdxResultPage(MdxResultViewer.this.cubeExplorer);
                            c.setMaximumSize(new Dimension(Short.MAX_VALUE, MdxResultViewer.this.cubeExplorer.getPrefferedHeight() + MdxResultPage.getAdditionalHeight()));
                            MdxResultViewer.this.pages.add(c);
                            if (MdxResultViewer.this.chartTabs != null && MdxResultViewer.this.chartTabs.size() > 0) {
                                JTabbedPane chartTabbedPane = new JTabbedPane(4);
                                chartTabbedPane.addTab(null, tableIcon, c);
                                Iterator it = MdxResultViewer.this.chartTabs.iterator();
                                while (it.hasNext()) {
                                    Integer type = (Integer)it.next();
                                    Chart pageChart = new Chart(MdxResultViewer.this.er, cs, type);
                                    chartTabbedPane.addTab(null, pageChart.getIcon(), pageChart);
                                }
                                jtp.addTab(MdxResultViewer.this.er.getAxis("Axis2").getTupleAt(cc).getShortCaption(), null, chartTabbedPane, MdxResultViewer.this.er.getAxis("Axis2").getTupleAt(cc).getToolTip());
                                continue;
                            }
                            JPanel holder = new JPanel(){
                                {
                                    this.setOpaque(false);
                                }

                                public void paintComponent(Graphics g) {
                                    S.paintBackground(g, this);
                                    super.paintComponent(g);
                                }
                            };
                            holder.setLayout(new BoxLayout(holder, 1));
                            holder.add(c);
                            jtp.addTab(MdxResultViewer.this.er.getAxis("Axis2").getTupleAt(cc).getShortCaption(), null, holder, MdxResultViewer.this.er.getAxis("Axis2").getTupleAt(cc).getToolTip());
                        }
                        jtp.addMouseListener(new PageLabelPopUpListener(jtp));
                        MdxResultViewer.this.rightPane.add(jtp);
                    } else {
                        chapterCount = 1;
                        MdxResultViewer.this.pages.clear();
                        CubeSlicer cs = new CubeSlicer(1, 0);
                        MdxResultViewer.this.cubeExplorer = new CubeExplorer2(MdxResultViewer.this.er, cs, MdxResultViewer.this.showColumnTotalsOn, MdxResultViewer.this.showRowTotalsOn);
                        MdxResultViewer.this.cubeExplorer.setMaximumSize(new Dimension(Short.MAX_VALUE, MdxResultViewer.this.cubeExplorer.getPrefferedHeight()));
                        MdxResultPage c = new MdxResultPage(MdxResultViewer.this.cubeExplorer);
                        c.setMaximumSize(new Dimension(Short.MAX_VALUE, MdxResultViewer.this.cubeExplorer.getPrefferedHeight() + MdxResultPage.getAdditionalHeight()));
                        c.setCurrent(true);
                        MdxResultViewer.this.pages.add(c);
                        if (MdxResultViewer.this.chartTabs != null && MdxResultViewer.this.chartTabs.size() > 0) {
                            JTabbedPane chartTabbedPane = new JTabbedPane(4);
                            chartTabbedPane.addTab(null, tableIcon, c);
                            Iterator it = MdxResultViewer.this.chartTabs.iterator();
                            while (it.hasNext()) {
                                Integer type = (Integer)it.next();
                                Chart chart = new Chart(MdxResultViewer.this.er, cs, type);
                                chartTabbedPane.addTab(null, chart.getIcon(), chart);
                            }
                            MdxResultViewer.this.rightPane.add(chartTabbedPane);
                        } else {
                            MdxResultViewer.this.rightPane.add(c);
                        }
                    }
                    MdxResultViewer.this.rightPane.repaint();
                    MdxResultViewer.this.rightPane.invalidate();
                    MdxResultViewer.this.rightPane.revalidate();
                    ListIterator it = MdxResultViewer.this.pages.listIterator();
                    while (it.hasNext()) {
                        if (!((MdxResultPage)it.next()).isCurrent()) continue;
                        ((MdxResultPage)it.previous()).getCubeExplorer().setPrefferedDividerLocation();
                        break;
                    }
                }
            }, StatusBar.JOB_TYPE_NORMAL);
        }
        if (!this.errorOccured) {
            this.statusBar.setDataCellsNumber(this.er.getAxis("Axis1").getTupleCount(), this.er.getAxis("Axis0").getTupleCount());
            this.statusBar.stopClientClock();
            this.statusBar.setStatus(I18n.getString("statusBar.ready"));
            this.q.setQuery(this.er);
            this.q.setQueryForWhere(this.mdxQuery);
        } else {
            JOptionPane.showMessageDialog(null, I18n.getString("msgText.errQueryExec") + this.errorMessage, I18n.getString("msgTitle.execQuery"), 0);
            this.statusBar.setStatus(I18n.getString("statusBar.errorExec"));
        }
    }

    public FilterTreeModel addMemberToFilter(Member filterMember) {
        if (this.filterTrees == null) {
            this.filterTrees = new LinkedList();
        }
        LinkedList<Member> eml = new LinkedList<Member>();
        eml.add(filterMember);
        ((DimensionTreeModel)this.parent.getDimensionTree().getTree().getModel()).addChildrenOneLevel(((DimensionTreeModel)this.parent.getDimensionTree().getTree().getModel()).getTreeElement(filterMember.getLname()));
        FilterTree filterTree = new FilterTree(this.smd, this.q, ((DimensionTreeModel)this.parent.getDimensionTree().getTree().getModel()).getDimensionTreeElement(filterMember.getDimensionUniqueName()), eml, this);
        this.filterTrees.add(filterTree);
        this.refreshLeftPane();
        return (FilterTreeModel)filterTree.getTree().getModel();
    }

    public void dropFilterTree(FilterTree filterToDrop) {
        ListIterator it = this.filterTrees.listIterator();
        while (it.hasNext()) {
            if ((FilterTree)it.next() != filterToDrop) continue;
            it.previous();
            it.remove();
            this.refreshLeftPane();
            return;
        }
        S.out("assert: Viewer:dropFilterTree:Couldn't find filter to drop!");
    }

    public void refreshFilterDisplay() {
        this.refreshLeftPane();
    }

    private void refreshLeftPane() {
        S.out(" In refreshLeftPane");
        if (this.filterTrees != null && this.filterTrees.size() > 0) {
            S.out(" In refreshLeftPane before RemoveAll");
            this.leftPane.removeAll();
            S.out(" In refreshLeftPane after RemoveAll");
            if (!((FilterTree)this.filterTrees.getFirst()).isDisplayedInTab()) {
                S.out(" In refreshLeftPane in isDisplayedInTab");
                JPanel filtersPane = new JPanel();
                filtersPane.setLayout(new BoxLayout(filtersPane, 1));
                Iterator it = this.filterTrees.iterator();
                S.out(" In refreshLeftPane after iterator");
                while (it.hasNext()) {
                    filtersPane.add((JPanel)it.next());
                }
                S.out(" In refreshLeftPane after while");
                this.leftPane.add(new JScrollPane(filtersPane));
            } else {
                S.out(" In refreshLeftPane in else");
                JTabbedPane dimFilterTabbedPane = new JTabbedPane(2);
                Iterator it = this.filterTrees.iterator();
                int i = 1;
                S.out(" In refreshLeftPane before (FilterTree)it.next()");
                while (it.hasNext()) {
                    FilterTree ft = (FilterTree)it.next();
                    dimFilterTabbedPane.addTab(null, FilterTreeRootElement.getFilterIcon(), ft, ft.getCaption());
                    ++i;
                }
                S.out(" In refreshLeftPane after (FilterTree)it.next()");
                this.leftPane.add(dimFilterTabbedPane);
            }
            S.out(" In refreshLeftPane before setPrefferedSize");
            this.leftPane.setPreferredSize(new Dimension(200, this.getHeight()));
            this.leftPane.setMaximumSize(new Dimension(250, Short.MAX_VALUE));
            S.out(" In refreshLeftPane after setPrefferedSize");
        } else {
            S.out(" In refreshLeftPane before leftPane.removAll");
            this.leftPane.removeAll();
            this.leftPane.setPreferredSize(new Dimension(0, 0));
            this.leftPane.setMaximumSize(new Dimension(0, Short.MAX_VALUE));
            S.out(" In refreshLeftPane after leftPane.setMaximumSize");
        }
        this.invalidate();
        this.revalidate();
        this.repaint();
    }

    public boolean getErrorOccured() {
        return this.errorOccured;
    }

    void setShowColumnTotalsOn(boolean _showColumnTotalsOn) {
        if (this.cubeExplorer != null) {
            this.cubeExplorer.setShowColumnTotalsOn(_showColumnTotalsOn);
        }
    }

    void setShowRowTotalsOn(boolean _showRowTotalsOn) {
        if (this.cubeExplorer != null) {
            this.cubeExplorer.setShowRowTotalsOn(_showRowTotalsOn);
        }
    }

    public void enableTreeElements(QueryElement elementToEnable) {
    }

    public static void main(String[] args) {
        ServerMetadata svm = new ServerMetadata("http://localhost:8080/xmla/msxisapi.dll");
        XMLADiscoverRestrictions restrictions = XMLAObjectsFactory.newXMLADiscoverRestrictions();
        XMLADiscoverProperties properties = XMLAObjectsFactory.newXMLADiscoverProperties();
        restrictions.setCatalog("Foodmart 2000");
        restrictions.setCubeName("Sales");
        properties.setDataSourceInfo("Local Analysis Server");
        properties.setCatalog("Sales");
        properties.setFormat("Tabular");
        properties.setContent("SchemaData");
        UIPropertyManager pm = new UIPropertyManager();
        pm.setSystemUI();
        MdxResultViewer v = new MdxResultViewer(restrictions, properties, svm, "SELECT NON EMPTY{ {[Measures].Members}} ON COLUMNS,  NON EMPTY {[Gender].[Gender].Members} ON ROWS,{ Time.Year.Members} on PAGES FROM Sales ", new StatusBar(), false, false, null);
        JFrame frame2 = new JFrame("Test viewer");
        frame2.getContentPane().add((Component)v, "Center");
        frame2.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                System.exit(0);
            }
        });
        frame2.pack();
        frame2.setExtendedState(6);
        frame2.setVisible(true);
    }

    class PageLabelPopUpListener
    extends MouseAdapter
    implements ActionListener {
        JTabbedPane jtp;
        JPopupMenu popup;
        JMenuItem menuItem;
        int idx;

        PageLabelPopUpListener(JTabbedPane _jtp) {
            this.jtp = _jtp;
            this.popup = new JPopupMenu();
            this.menuItem = new JMenuItem((String)TupleMemberLabelPopUpActions.popUpCaptions.get(TupleMemberLabelPopUpActions.KEEP_THIS_MEMBER_ONLY));
            this.menuItem.addActionListener(this);
            this.popup.add(this.menuItem);
            this.menuItem = new JMenuItem((String)TupleMemberLabelPopUpActions.popUpCaptions.get(TupleMemberLabelPopUpActions.REMOVE_MEMBER_FROM_QUERY));
            this.menuItem.addActionListener(this);
            this.popup.add(this.menuItem);
            this.menuItem = new JMenuItem((String)TupleMemberLabelPopUpActions.popUpCaptions.get(TupleMemberLabelPopUpActions.REMOVE_DIMENSION_FROM_QUERY));
            this.menuItem.addActionListener(this);
            this.popup.add(this.menuItem);
            this.menuItem = new JMenuItem((String)TupleMemberLabelPopUpActions.popUpCaptions.get(TupleMemberLabelPopUpActions.SEND_MEMBER_TO_FILTER));
            this.menuItem.addActionListener(this);
            this.popup.add(this.menuItem);
        }

        public void mouseClicked(MouseEvent e) {
            if (SwingUtilities.isRightMouseButton(e)) {
                this.idx = this.jtp.indexAtLocation(e.getX(), e.getY());
                this.popup.show(e.getComponent(), e.getX(), e.getY());
            }
            if (e.isPopupTrigger()) {
                // empty if block
            }
        }

        public void actionPerformed(ActionEvent e) {
            boolean i = false;
            if (e.getActionCommand().equals((String)TupleMemberLabelPopUpActions.popUpCaptions.get(TupleMemberLabelPopUpActions.REMOVE_DIMENSION_FROM_QUERY))) {
                MdxResultViewer.this.q.removePageDimensionFromQuery(MdxResultViewer.this.er.getAxis("Axis2").getTupleAt(this.idx).getMemberAt(0));
            } else if (e.getActionCommand().equals((String)TupleMemberLabelPopUpActions.popUpCaptions.get(TupleMemberLabelPopUpActions.REMOVE_MEMBER_FROM_QUERY))) {
                MdxResultViewer.this.q.removePageMemberFromQuery(MdxResultViewer.this.er.getAxis("Axis2").getTupleAt(this.idx).getMemberAt(0));
            } else if (e.getActionCommand().equals((String)TupleMemberLabelPopUpActions.popUpCaptions.get(TupleMemberLabelPopUpActions.KEEP_THIS_MEMBER_ONLY))) {
                MdxResultViewer.this.q.keepThisMemberOnlyOnPages(MdxResultViewer.this.er.getAxis("Axis2").getTupleAt(this.idx).getMemberAt(0));
            } else if (e.getActionCommand().equals((String)TupleMemberLabelPopUpActions.popUpCaptions.get(TupleMemberLabelPopUpActions.SEND_MEMBER_TO_FILTER))) {
                MdxResultViewer.this.q.addPageMemberToFilter(MdxResultViewer.this.er.getAxis("Axis2").getTupleAt(this.idx).getMemberAt(0));
            }
        }
    }
}

