/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.xml;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import net.sf.jasperreports.engine.DefaultJasperReportsContext;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.JRTemplate;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.xml.JRXmlDigester;
import net.sf.jasperreports.engine.xml.JRXmlTemplateDigesterFactory;
import net.sf.jasperreports.repo.RepositoryUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.xml.sax.SAXException;

public class JRXmlTemplateLoader {
    private static final Log log = LogFactory.getLog(JRXmlTemplateLoader.class);
    private JasperReportsContext jasperReportsContext;

    protected JRXmlTemplateLoader() {
        this(DefaultJasperReportsContext.getInstance());
    }

    private JRXmlTemplateLoader(JasperReportsContext jasperReportsContext) {
        this.jasperReportsContext = jasperReportsContext;
    }

    private static JRXmlTemplateLoader getDefaultInstance() {
        return new JRXmlTemplateLoader(DefaultJasperReportsContext.getInstance());
    }

    public static JRXmlTemplateLoader getInstance(JasperReportsContext jasperReportsContext) {
        return new JRXmlTemplateLoader(jasperReportsContext);
    }

    public JRTemplate loadTemplate(String location) throws JRException {
        byte[] data = RepositoryUtil.getInstance(this.jasperReportsContext).getBytesFromLocation(location);
        return JRXmlTemplateLoader.load(new ByteArrayInputStream(data));
    }

    public JRTemplate loadTemplate(File file) {
        BufferedInputStream fileIn;
        try {
            fileIn = new BufferedInputStream(new FileInputStream(file));
        }
        catch (FileNotFoundException e) {
            throw new JRRuntimeException("Template XML file not found", e);
        }
        try {
            JRTemplate jRTemplate = JRXmlTemplateLoader.load(fileIn);
            return jRTemplate;
        }
        finally {
            try {
                fileIn.close();
            }
            catch (IOException e) {
                log.warn((Object)"Error closing XML file", (Throwable)e);
            }
        }
    }

    public JRTemplate loadTemplate(URL url) {
        InputStream input;
        try {
            input = url.openStream();
        }
        catch (IOException e) {
            throw new JRRuntimeException("Error opening connection to template URL " + url, e);
        }
        try {
            JRTemplate jRTemplate = JRXmlTemplateLoader.load(input);
            return jRTemplate;
        }
        finally {
            try {
                input.close();
            }
            catch (IOException e) {
                log.warn((Object)("Error closing connection to template URL " + url), (Throwable)e);
            }
        }
    }

    public JRTemplate loadTemplate(InputStream data) {
        JRXmlDigester digester = JRXmlTemplateDigesterFactory.instance().createDigester(this.jasperReportsContext);
        try {
            return (JRTemplate)digester.parse(data);
        }
        catch (IOException e) {
            throw new JRRuntimeException("Error reading template XML", e);
        }
        catch (SAXException e) {
            throw new JRRuntimeException("Error parsing template XML", e);
        }
    }

    public static JRTemplate load(String location) throws JRException {
        return JRXmlTemplateLoader.getDefaultInstance().loadTemplate(location);
    }

    public static JRTemplate load(File file) {
        return JRXmlTemplateLoader.getDefaultInstance().loadTemplate(file);
    }

    public static JRTemplate load(URL url) {
        return JRXmlTemplateLoader.getDefaultInstance().loadTemplate(url);
    }

    public static JRTemplate load(InputStream data) {
        return JRXmlTemplateLoader.getDefaultInstance().loadTemplate(data);
    }
}

