/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.fill;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.JRVirtualizable;
import net.sf.jasperreports.engine.fill.JRAbstractLRUVirtualizer;
import net.sf.jasperreports.engine.util.JRProperties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JRFileVirtualizer
extends JRAbstractLRUVirtualizer {
    private static final Log log = LogFactory.getLog(JRFileVirtualizer.class);
    public static final String PROPERTY_TEMP_FILES_SET_DELETE_ON_EXIT = "net.sf.jasperreports.virtualizer.files.delete.on.exit";
    private final String directory;

    public JRFileVirtualizer(int maxSize) {
        this(maxSize, null);
    }

    public JRFileVirtualizer(int maxSize, String directory) {
        super(maxSize);
        this.directory = directory;
    }

    private String makeFilename(JRVirtualizable o) {
        String uid = o.getUID();
        return "virt" + uid;
    }

    private String makeFilename(String virtualId) {
        return "virt" + virtualId;
    }

    @Override
    protected void pageOut(JRVirtualizable o) throws IOException {
        block9: {
            String filename = this.makeFilename(o);
            File file = new File(this.directory, filename);
            if (file.createNewFile()) {
                boolean deleteOnExit = JRProperties.getBooleanProperty(PROPERTY_TEMP_FILES_SET_DELETE_ON_EXIT);
                if (deleteOnExit) {
                    file.deleteOnExit();
                }
                FileOutputStream fos = null;
                try {
                    try {
                        fos = new FileOutputStream(file);
                        BufferedOutputStream bufferedOut = new BufferedOutputStream(fos);
                        this.writeData(o, bufferedOut);
                        break block9;
                    }
                    catch (FileNotFoundException e) {
                        log.error((Object)"Error virtualizing object", (Throwable)e);
                        throw new JRRuntimeException(e);
                    }
                }
                finally {
                    if (fos != null) {
                        fos.close();
                    }
                }
            }
            if (!this.isReadOnly(o)) {
                throw new IllegalStateException("Cannot virtualize data because the file \"" + filename + "\" already exists.");
            }
        }
    }

    @Override
    protected void pageIn(JRVirtualizable o) throws IOException {
        String filename = this.makeFilename(o);
        File file = new File(this.directory, filename);
        FileInputStream fis = null;
        try {
            try {
                fis = new FileInputStream(file);
                BufferedInputStream bufferedIn = new BufferedInputStream(fis);
                this.readData(o, bufferedIn);
            }
            catch (FileNotFoundException e) {
                log.error((Object)"Error devirtualizing object", (Throwable)e);
                throw new JRRuntimeException(e);
            }
        }
        finally {
            if (fis != null) {
                fis.close();
            }
        }
        if (!this.isReadOnly(o)) {
            file.delete();
        }
    }

    @Override
    protected void dispose(String virtualId) {
        String filename = this.makeFilename(virtualId);
        File file = new File(this.directory, filename);
        file.delete();
    }

    @Override
    public synchronized void cleanup() {
        this.disposeAll();
        this.reset();
    }
}

