/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.design;

import java.awt.Color;
import java.io.IOException;
import java.io.ObjectInputStream;
import net.sf.jasperreports.engine.JRDefaultStyleProvider;
import net.sf.jasperreports.engine.JRGraphicElement;
import net.sf.jasperreports.engine.JRPen;
import net.sf.jasperreports.engine.base.JRBasePen;
import net.sf.jasperreports.engine.design.JRDesignElement;
import net.sf.jasperreports.engine.type.FillEnum;
import net.sf.jasperreports.engine.util.JRPenUtil;
import net.sf.jasperreports.engine.util.JRStyleResolver;

public abstract class JRDesignGraphicElement
extends JRDesignElement
implements JRGraphicElement {
    private static final long serialVersionUID = 10200L;
    protected JRPen linePen = new JRBasePen(this);
    protected FillEnum fillValue;
    private int PSEUDO_SERIAL_VERSION_UID = 30702;
    private Byte pen;
    private Byte fill;

    protected JRDesignGraphicElement(JRDefaultStyleProvider defaultStyleProvider) {
        super(defaultStyleProvider);
    }

    @Override
    public JRPen getLinePen() {
        return this.linePen;
    }

    @Override
    public FillEnum getFillValue() {
        return JRStyleResolver.getFillValue(this);
    }

    @Override
    public FillEnum getOwnFillValue() {
        return this.fillValue;
    }

    @Override
    public void setFill(FillEnum fillValue) {
        FillEnum old = this.fillValue;
        this.fillValue = fillValue;
        this.getEventSupport().firePropertyChange("fill", old, this.fillValue);
    }

    @Override
    public Float getDefaultLineWidth() {
        return JRPen.LINE_WIDTH_1;
    }

    @Override
    public Color getDefaultLineColor() {
        return this.getForecolor();
    }

    @Override
    public Object clone() {
        JRDesignGraphicElement clone = (JRDesignGraphicElement)super.clone();
        clone.linePen = this.linePen.clone(clone);
        return clone;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        if (this.PSEUDO_SERIAL_VERSION_UID < 30702) {
            this.fillValue = FillEnum.getByValue(this.fill);
            this.fill = null;
        }
        if (this.linePen == null) {
            this.linePen = new JRBasePen(this);
            JRPenUtil.setLinePenFromPen(this.pen, this.linePen);
            this.pen = null;
        }
    }
}

