/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.text.completion;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.SyntaxSupport;
import org.netbeans.editor.ext.CompletionQuery;
import org.netbeans.modules.xml.api.model.GrammarQuery;
import org.netbeans.modules.xml.api.model.GrammarResult;
import org.netbeans.modules.xml.api.model.HintContext;
import org.netbeans.modules.xml.spi.dom.UOException;
import org.netbeans.modules.xml.text.api.XMLDefaultTokenContext;
import org.netbeans.modules.xml.text.bracematch.XMLBraceMatcher;
import org.netbeans.modules.xml.text.completion.AttributeResultItem;
import org.netbeans.modules.xml.text.completion.ElementResultItem;
import org.netbeans.modules.xml.text.completion.EndTagAutocompletionResultItem;
import org.netbeans.modules.xml.text.completion.EntityRefResultItem;
import org.netbeans.modules.xml.text.completion.GrammarManager;
import org.netbeans.modules.xml.text.completion.SyntaxQueryHelper;
import org.netbeans.modules.xml.text.completion.ValueResultItem;
import org.netbeans.modules.xml.text.completion.XMLResultItem;
import org.netbeans.modules.xml.text.syntax.SyntaxElement;
import org.netbeans.modules.xml.text.syntax.XMLSyntaxSupport;
import org.netbeans.modules.xml.text.syntax.XMLTokenIDs;
import org.netbeans.modules.xml.text.syntax.dom.EndTag;
import org.netbeans.modules.xml.text.syntax.dom.StartTag;
import org.netbeans.modules.xml.text.syntax.dom.SyntaxNode;
import org.openide.ErrorManager;
import org.openide.util.NbBundle;
import org.w3c.dom.Node;

public class XMLCompletionQuery
implements CompletionQuery,
XMLTokenIDs {
    public static final String DOCUMENT_GRAMMAR_BINDING_PROP = "doc-bind-query";

    public CompletionQuery.Result query(JTextComponent jTextComponent, int n, SyntaxSupport syntaxSupport) {
        BaseDocument baseDocument = (BaseDocument)jTextComponent.getDocument();
        if (baseDocument == null) {
            return null;
        }
        XMLSyntaxSupport xMLSyntaxSupport = (XMLSyntaxSupport)syntaxSupport.get(XMLSyntaxSupport.class);
        if (xMLSyntaxSupport == null) {
            return null;
        }
        try {
            SyntaxQueryHelper syntaxQueryHelper = new SyntaxQueryHelper(xMLSyntaxSupport, n);
            XMLResultItem.substituteOffset = syntaxQueryHelper.getOffset() - syntaxQueryHelper.getEraseCount();
            if (syntaxQueryHelper.getCompletionType() != 6) {
                Object object;
                Object object2;
                ArrayList arrayList = new ArrayList();
                List list = null;
                switch (syntaxQueryHelper.getCompletionType()) {
                    case 1: {
                        list = this.queryAttributes(syntaxQueryHelper, (Document)baseDocument, xMLSyntaxSupport);
                        break;
                    }
                    case 2: {
                        list = this.queryValues(syntaxQueryHelper, (Document)baseDocument, xMLSyntaxSupport);
                        break;
                    }
                    case 3: {
                        list = this.queryElements(syntaxQueryHelper, (Document)baseDocument, xMLSyntaxSupport);
                        break;
                    }
                    case 4: {
                        list = this.queryEntities(syntaxQueryHelper, (Document)baseDocument, xMLSyntaxSupport);
                        break;
                    }
                    case 5: {
                        list = this.queryNotations(syntaxQueryHelper, (Document)baseDocument, xMLSyntaxSupport);
                    }
                    case 0: {
                        return null;
                    }
                }
                if (list == null) {
                    return XMLCompletionQuery.cannotSuggest(jTextComponent, xMLSyntaxSupport.requestedAutoCompletion());
                }
                if (syntaxQueryHelper.getCompletionType() == 2 && syntaxQueryHelper.getToken().getTokenID() == XMLDefaultTokenContext.TAG && (object2 = syntaxQueryHelper.getSyntaxElement()) instanceof StartTag && (object = ((StartTag)object2).getNodeName()) != null && !XMLBraceMatcher.hasEndTag((Document)baseDocument, n, (String)object)) {
                    list.add(new EndTagAutocompletionResultItem((String)object));
                }
                if (list.isEmpty() && syntaxQueryHelper.getPreText().startsWith("</") && (object2 = XMLCompletionQuery.findStartTag((SyntaxNode)syntaxQueryHelper.getSyntaxElement(), !syntaxQueryHelper.getPreText().endsWith("/") ? "/" : "")) != null && !object2.isEmpty() && !XMLBraceMatcher.hasEndTag((Document)baseDocument, n, ((XMLResultItem)(object = (ElementResultItem)object2.get(0))).getItemText()) && (!((XMLResultItem)object).getItemText().startsWith("/") || ((XMLResultItem)object).getItemText().startsWith(syntaxQueryHelper.getPreText().substring(1)))) {
                    String string = NbBundle.getMessage(XMLCompletionQuery.class, (String)"MSG_result", (Object)syntaxQueryHelper.getPreText());
                    return new XMLCompletionResult(jTextComponent, string, (List)object2, syntaxQueryHelper.getOffset(), 0);
                }
                object2 = Boolean.getBoolean("netbeans.debug.xml") ? " " + syntaxQueryHelper.getOffset() + "-" + syntaxQueryHelper.getEraseCount() : "";
                object = NbBundle.getMessage(XMLCompletionQuery.class, (String)"MSG_result", (Object)syntaxQueryHelper.getPreText()) + (String)object2;
                if (syntaxQueryHelper.getPreText().endsWith("<") && syntaxQueryHelper.getToken().getTokenID() == TEXT) {
                    EndTag endTag;
                    String string;
                    SyntaxElement syntaxElement;
                    List list2 = XMLCompletionQuery.findStartTag((SyntaxNode)syntaxQueryHelper.getSyntaxElement(), "/");
                    boolean bl = true;
                    SyntaxNode syntaxNode = (SyntaxNode)syntaxQueryHelper.getSyntaxElement();
                    SyntaxElement syntaxElement2 = syntaxElement = syntaxNode != null ? syntaxNode.getNext() : null;
                    if (syntaxElement instanceof EndTag && (string = (endTag = (EndTag)syntaxElement).getNodeName()) != null && !list2.isEmpty()) {
                        ElementResultItem elementResultItem = (ElementResultItem)list2.get(0);
                        if (("/" + string).equals(elementResultItem.getItemText())) {
                            bl = false;
                        }
                    }
                    if (bl && (!list.isEmpty() || list2.size() > 1)) {
                        arrayList.addAll(list2);
                    }
                }
                arrayList.addAll(list);
                if (arrayList.isEmpty()) {
                    return XMLCompletionQuery.noSuggestion(jTextComponent, xMLSyntaxSupport.requestedAutoCompletion());
                }
                return new XMLCompletionResult(jTextComponent, (String)object, arrayList, syntaxQueryHelper.getOffset() - syntaxQueryHelper.getEraseCount(), syntaxQueryHelper.getEraseCount());
            }
            if (syntaxQueryHelper.getToken().getTokenID() == PI_CONTENT && syntaxQueryHelper.getPreText().endsWith("encoding=")) {
                ArrayList<XMLResultItem> arrayList = new ArrayList<XMLResultItem>(2);
                arrayList.add(new XMLResultItem("\"UTF-8\""));
                arrayList.add(new XMLResultItem("\"UTF-16\""));
                return new XMLCompletionResult(jTextComponent, NbBundle.getMessage(XMLCompletionQuery.class, (String)"MSG_encoding_comp"), arrayList, syntaxQueryHelper.getOffset(), 0);
            }
            return XMLCompletionQuery.noSuggestion(jTextComponent, xMLSyntaxSupport.requestedAutoCompletion());
        }
        catch (BadLocationException badLocationException) {
            return XMLCompletionQuery.noSuggestion(jTextComponent, xMLSyntaxSupport.requestedAutoCompletion());
        }
    }

    private static CompletionQuery.Result cannotSuggest(JTextComponent jTextComponent, boolean bl) {
        if (bl) {
            return null;
        }
        return new XMLCompletionResult(jTextComponent, NbBundle.getMessage(XMLCompletionQuery.class, (String)"BK0002"), Collections.EMPTY_LIST, 0, 0);
    }

    private static CompletionQuery.Result noSuggestion(JTextComponent jTextComponent, boolean bl) {
        if (bl) {
            return null;
        }
        return new XMLCompletionResult(jTextComponent, NbBundle.getMessage(XMLCompletionQuery.class, (String)"BK0003"), Collections.EMPTY_LIST, 0, 0);
    }

    public static GrammarQuery getPerformer(Document document, XMLSyntaxSupport xMLSyntaxSupport) {
        Object object = document.getProperty(DOCUMENT_GRAMMAR_BINDING_PROP);
        if (object == null) {
            object = new GrammarManager(document, xMLSyntaxSupport);
            document.putProperty(DOCUMENT_GRAMMAR_BINDING_PROP, object);
        }
        return ((GrammarManager)object).getGrammar();
    }

    private List queryEntities(SyntaxQueryHelper syntaxQueryHelper, Document document, XMLSyntaxSupport xMLSyntaxSupport) {
        Enumeration enumeration = XMLCompletionQuery.getPerformer(document, xMLSyntaxSupport).queryEntities(syntaxQueryHelper.getContext().getCurrentPrefix());
        return this.translateEntityRefs(enumeration);
    }

    private List queryElements(SyntaxQueryHelper syntaxQueryHelper, Document document, XMLSyntaxSupport xMLSyntaxSupport) {
        try {
            GrammarQuery grammarQuery = XMLCompletionQuery.getPerformer(document, xMLSyntaxSupport);
            HintContext hintContext = syntaxQueryHelper.getContext();
            if (syntaxQueryHelper.getPreText().startsWith("</")) {
                return Collections.EMPTY_LIST;
            }
            String string = hintContext.getCurrentPrefix();
            Enumeration enumeration = grammarQuery.queryElements(hintContext);
            return this.translateElements(enumeration, string, grammarQuery);
        }
        catch (UOException uOException) {
            ErrorManager.getDefault().notify((Throwable)uOException);
            return null;
        }
    }

    private List queryAttributes(SyntaxQueryHelper syntaxQueryHelper, Document document, XMLSyntaxSupport xMLSyntaxSupport) {
        Enumeration enumeration = XMLCompletionQuery.getPerformer(document, xMLSyntaxSupport).queryAttributes(syntaxQueryHelper.getContext());
        return this.translateAttributes(enumeration, syntaxQueryHelper.isBoundary());
    }

    private List queryValues(SyntaxQueryHelper syntaxQueryHelper, Document document, XMLSyntaxSupport xMLSyntaxSupport) {
        try {
            Enumeration enumeration = XMLCompletionQuery.getPerformer(document, xMLSyntaxSupport).queryValues(syntaxQueryHelper.getContext());
            return this.translateValues(enumeration);
        }
        catch (Exception exception) {
            return null;
        }
    }

    private List queryNotations(SyntaxQueryHelper syntaxQueryHelper, Document document, XMLSyntaxSupport xMLSyntaxSupport) {
        Enumeration enumeration = XMLCompletionQuery.getPerformer(document, xMLSyntaxSupport).queryNotations(syntaxQueryHelper.getContext().getCurrentPrefix());
        return null;
    }

    private List translateEntityRefs(Enumeration enumeration) {
        ArrayList<EntityRefResultItem> arrayList = new ArrayList<EntityRefResultItem>(133);
        while (enumeration.hasMoreElements()) {
            GrammarResult grammarResult = (GrammarResult)enumeration.nextElement();
            if (grammarResult == null || grammarResult.getNodeName() == null) continue;
            EntityRefResultItem entityRefResultItem = new EntityRefResultItem(grammarResult);
            arrayList.add(entityRefResultItem);
        }
        return arrayList;
    }

    private List translateElements(Enumeration enumeration, String string, GrammarQuery grammarQuery) {
        ArrayList<ElementResultItem> arrayList = new ArrayList<ElementResultItem>(13);
        while (enumeration.hasMoreElements()) {
            GrammarResult grammarResult = (GrammarResult)enumeration.nextElement();
            if (string.equals(grammarResult.getNodeName()) || grammarResult == null || grammarResult.getNodeName() == null) continue;
            ElementResultItem elementResultItem = new ElementResultItem(grammarResult);
            arrayList.add(elementResultItem);
        }
        return arrayList;
    }

    private List translateAttributes(Enumeration enumeration, boolean bl) {
        ArrayList<AttributeResultItem> arrayList = new ArrayList<AttributeResultItem>(13);
        while (enumeration.hasMoreElements()) {
            GrammarResult grammarResult = (GrammarResult)enumeration.nextElement();
            if (grammarResult == null || grammarResult.getNodeName() == null) continue;
            AttributeResultItem attributeResultItem = new AttributeResultItem(grammarResult, false);
            arrayList.add(attributeResultItem);
        }
        return arrayList;
    }

    private List translateValues(Enumeration enumeration) {
        ArrayList<ValueResultItem> arrayList = new ArrayList<ValueResultItem>(3);
        while (enumeration.hasMoreElements()) {
            GrammarResult grammarResult = (GrammarResult)enumeration.nextElement();
            if (grammarResult == null || grammarResult.getDisplayName() == null) continue;
            ValueResultItem valueResultItem = new ValueResultItem(grammarResult);
            arrayList.add(valueResultItem);
        }
        return arrayList;
    }

    private static List findStartTag(SyntaxNode syntaxNode, String string) {
        Node node = syntaxNode.getParentNode();
        if (node == null) {
            return Collections.EMPTY_LIST;
        }
        String string2 = node.getNodeName();
        if (string2 == null) {
            return Collections.EMPTY_LIST;
        }
        ElementResultItem elementResultItem = new ElementResultItem(string + string2);
        ArrayList<ElementResultItem> arrayList = new ArrayList<ElementResultItem>(1);
        arrayList.add(elementResultItem);
        return arrayList;
    }

    private static List findStartTag(SyntaxNode syntaxNode) {
        return XMLCompletionQuery.findStartTag(syntaxNode, "");
    }

    public static class XMLCompletionResult
    extends CompletionQuery.DefaultResult {
        private int substituteOffset;

        public XMLCompletionResult(JTextComponent jTextComponent, String string, List list, int n, int n2) {
            super(jTextComponent, string, list, n, n2);
            this.substituteOffset = n;
        }

        public int getSubstituteOffset() {
            return this.substituteOffset;
        }
    }
}

