/*
 * Decompiled with CFR 0.152.
 */
package rex.graphics.datasourcetree;

import com.sun.net.ssl.internal.ssl.Provider;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.security.SecureRandom;
import java.security.Security;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTree;
import javax.swing.ToolTipManager;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreePath;
import rex.graphics.TreeElement;
import rex.graphics.Viewer;
import rex.graphics.datasourcetree.DataSourceTreeModel;
import rex.graphics.datasourcetree.elements.CubeElement;
import rex.graphics.datasourcetree.elements.DataSourceTreeElement;
import rex.graphics.mdxeditor.MdxEditor;
import rex.graphics.mdxeditor.mdxbuilder.dnd.DragElement;
import rex.utils.I18n;
import rex.utils.LanguageChangedEvent;
import rex.utils.LanguageChangedListener;
import rex.utils.LocaleOptionPane;
import rex.utils.S;
import rex.xmla.XMLADiscoverProperties;
import rex.xmla.XMLADiscoverRestrictions;
import rex.xmla.XMLAObjectsFactory;

public class DataSourceTree
extends JPanel
implements ActionListener,
LanguageChangedListener {
    final JTree tree;
    JFrame frame = new JFrame();
    JPopupMenu popup;
    private JComponent parent;
    private TreePath popUpSource;
    final HashMap trustedSites;
    static boolean mountedSSL;
    JMenuBar bnLocale;
    LocaleOptionPane localeMenu;

    public DataSourceTree(JComponent _parent) {
        this();
        this.parent = _parent;
    }

    public DataSourceTree() {
        I18n.addOnLanguageChangedListener(this);
        this.applyI18n();
        DataSourceTreeModel treeModel = new DataSourceTreeModel();
        this.trustedSites = new HashMap();
        this.tree = new JTree(treeModel);
        this.tree.getSelectionModel().setSelectionMode(1);
        ToolTipManager.sharedInstance().registerComponent(this.tree);
        this.tree.setCellRenderer(new MyRenderer());
        JScrollPane treeView = new JScrollPane(this.tree);
        treeView.setPreferredSize(new Dimension(400, 600));
        treeView.setMinimumSize(new Dimension(200, 600));
        treeView.setMaximumSize(new Dimension(800, 600));
        this.localeMenu = new LocaleOptionPane();
        this.bnLocale = new JMenuBar();
        this.bnLocale.add(this.localeMenu);
        this.setLayout(new BorderLayout());
        this.add((Component)treeView, "Center");
        this.add((Component)this.bnLocale, "South");
        this.popup = new JPopupMenu();
        this.tree.addMouseListener(new PopupListener());
        mountedSSL = false;
        try {
            String url;
            BufferedReader in = new BufferedReader(new FileReader("startup.datasources.txt"));
            while ((url = in.readLine()) != null) {
                if (url.toLowerCase().startsWith("https")) {
                    this.mountSSL();
                }
                treeModel.addDataSource(url);
            }
            in.close();
        }
        catch (FileNotFoundException e1) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public void languageChanged(LanguageChangedEvent evt) {
        this.applyI18n();
        this.localeMenu.setCurrentLocale(evt.getLocale());
    }

    @Override
    public void removeLanguageListener() {
        I18n.removeOnLanguageChangedListener(this);
    }

    public void applyI18n() {
        if (this.parent instanceof JComponent) {
            this.parent.setToolTipText(I18n.getString("toolTip.exploring"));
        }
    }

    private void mountSSL() {
        if (mountedSSL) {
            return;
        }
        mountedSSL = true;
        System.setProperty("java.protocol.handler.pkgs", "javax.net.ssl");
        Security.addProvider((java.security.Provider)new Provider());
        try {
            System.setProperty("javax.net.ssl.trustStore", ClassLoader.getSystemResource("sslkeys/client.ks").toString());
            System.setProperty("javax.net.ssl.trustStorePassword", "igorludi");
        }
        catch (Exception fnfe) {
            S.out("Couldn't find:  sslkeys/client.ks in your application directory.");
        }
        try {
            System.setProperty("javax.net.ssl.keyStore", ClassLoader.getSystemResource("sslkeys/servers.ks").toString());
            System.setProperty("javax.net.ssl.keyStorePassword", "changeit");
        }
        catch (Exception fnfe) {
            S.out("Couldn't find:  sslkeys/servers.ks in your application directory.");
        }
        TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(){

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                S.out("getAcceptedIssuers() called");
                return null;
            }

            @Override
            public void checkClientTrusted(X509Certificate[] certs, String s) {
                S.out("Checking isClientTrusted for X509Certificate");
            }

            @Override
            public void checkServerTrusted(X509Certificate[] certs, String s) throws CertificateException {
                String msg = new String("");
                for (int i = 0; i < certs.length; ++i) {
                    if (DataSourceTree.this.trustedSites.get(certs[i].getSubjectDN()) != null) {
                        S.out("already trusted... skipping...");
                        continue;
                    }
                    msg = msg + I18n.getString("str.issuerDN") + certs[i].getIssuerDN() + I18n.getString("str.subjectDN") + certs[i].getSubjectDN();
                    if (0 != JOptionPane.showConfirmDialog(null, I18n.getString("msgText.trustedUrl1") + msg + I18n.getString("msgText.trustedUrl2"), I18n.getString("msgTitle.securityWarning"), 0)) {
                        throw new CertificateException(I18n.getString("exception.trustCertificate"));
                    }
                    DataSourceTree.this.trustedSites.put(certs[i].getSubjectDN(), certs[i].getSubjectDN());
                }
            }
        }};
        try {
            SSLContext sc = SSLContext.getInstance("SSL");
            sc.init(null, trustAllCerts, new SecureRandom());
            HttpsURLConnection.setDefaultSSLSocketFactory(sc.getSocketFactory());
            HostnameVerifier hv = new HostnameVerifier(){

                @Override
                public boolean verify(String urlHostName, SSLSession session) {
                    return true;
                }
            };
            HttpsURLConnection.setDefaultHostnameVerifier(hv);
        }
        catch (Exception ex) {
            S.out("Could not set trustmanager");
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        boolean i = false;
        if (I18n.getString("menu.add").equals(e.getActionCommand())) {
            String url = JOptionPane.showInputDialog(I18n.getString("msgText.urlInput"), (Object)"http://localhost:8080/CincomBIServer/xmla");
            if (url != null && url.length() > 0) {
                if (url.toLowerCase().startsWith("https")) {
                    this.mountSSL();
                }
                ((DataSourceTreeModel)this.tree.getModel()).addDataSource(url);
            }
        } else if (I18n.getString("menu.explore1").equals(e.getActionCommand())) {
            if (this.parent != null) {
                XMLADiscoverRestrictions restrictions = XMLAObjectsFactory.newXMLADiscoverRestrictions();
                XMLADiscoverProperties properties = XMLAObjectsFactory.newXMLADiscoverProperties();
                CubeElement selectedItem = (CubeElement)((TreeElement)this.popUpSource.getPathComponent(this.popUpSource.getPathCount() - 1)).getUserObject();
                restrictions.setCatalog(selectedItem.getCatalogName());
                restrictions.setCubeName(selectedItem.getCubeName());
                properties.setDataSourceInfo(selectedItem.getDataSourceInfo());
                properties.setCatalog(selectedItem.getCatalogName());
                properties.setFormat("Tabular");
                properties.setContent("SchemaData");
                Viewer viewer = new Viewer(restrictions, properties, selectedItem.getServerMetaData(), (JTabbedPane)this.parent);
                ((JTabbedPane)this.parent).addTab(selectedItem.getCubeName(), selectedItem.getIcon(), viewer, I18n.getString("toolTip.exploring") + selectedItem.getDataSourceInfo() + ":" + selectedItem.getCatalogName() + ":" + selectedItem.getCubeName());
                ((JTabbedPane)this.parent).setSelectedComponent(viewer);
                viewer = null;
            }
        } else if (I18n.getString("menu.explore2").equals(e.getActionCommand())) {
            if (this.parent != null) {
                XMLADiscoverRestrictions restrictions = XMLAObjectsFactory.newXMLADiscoverRestrictions();
                XMLADiscoverProperties properties = XMLAObjectsFactory.newXMLADiscoverProperties();
                CubeElement selectedItem = (CubeElement)((TreeElement)this.popUpSource.getPathComponent(this.popUpSource.getPathCount() - 1)).getUserObject();
                restrictions.setCatalog(selectedItem.getCatalogName());
                restrictions.setCubeName(selectedItem.getCubeName());
                properties.setDataSourceInfo(selectedItem.getDataSourceInfo());
                properties.setCatalog(selectedItem.getCatalogName());
                properties.setFormat("Tabular");
                properties.setContent("SchemaData");
                MdxEditor editor = new MdxEditor(restrictions, properties, selectedItem.getServerMetaData(), selectedItem.getCubeName(), (JTabbedPane)this.parent);
                ((JTabbedPane)this.parent).addTab(selectedItem.getCubeName(), selectedItem.getIcon(), editor, I18n.getString("toolTip.exploring") + selectedItem.getDataSourceInfo() + ":" + selectedItem.getCatalogName() + ":" + selectedItem.getCubeName());
                ((JTabbedPane)this.parent).setSelectedComponent(editor);
                editor = null;
            }
        } else if (I18n.getString("menu.explore3").equals(e.getActionCommand()) && this.parent != null) {
            XMLADiscoverRestrictions restrictions = XMLAObjectsFactory.newXMLADiscoverRestrictions();
            XMLADiscoverProperties properties = XMLAObjectsFactory.newXMLADiscoverProperties();
            CubeElement selectedItem = (CubeElement)((TreeElement)this.popUpSource.getPathComponent(this.popUpSource.getPathCount() - 1)).getUserObject();
            restrictions.setCatalog(selectedItem.getCatalogName());
            restrictions.setCubeName(selectedItem.getCubeName());
            properties.setDataSourceInfo(selectedItem.getDataSourceInfo());
            properties.setCatalog(selectedItem.getCatalogName());
            properties.setFormat("Tabular");
            properties.setContent("SchemaData");
            this.frame = new JFrame(I18n.getString("frameTitle.mdxEditor2") + " " + selectedItem.getCatalogName() + ":" + selectedItem.getCubeName());
            this.frame.setGlassPane(new DragElement());
            final MdxEditor editor = new MdxEditor(restrictions, properties, selectedItem.getServerMetaData(), selectedItem.getCubeName());
            this.frame.getContentPane().add((Component)editor, "Center");
            this.frame.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent e) {
                    editor.removeLanguageListener();
                    JFrame frm = (JFrame)e.getSource();
                    frm.dispose();
                }
            });
            this.frame.pack();
            this.frame.setExtendedState(6);
            this.frame.setVisible(true);
        }
    }

    public static void main(String[] args) {
        JFrame frame = new JFrame("Testing DataSourceTree...");
        DataSourceTree dst = new DataSourceTree();
        frame.setContentPane(dst);
        frame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                System.exit(0);
            }
        });
        frame.pack();
        frame.setVisible(true);
    }

    class PopupListener
    extends MouseAdapter {
        PopupListener() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            this.maybeShowPopup(e);
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            this.maybeShowPopup(e);
        }

        private void maybeShowPopup(MouseEvent e) {
            int selRow = DataSourceTree.this.tree.getRowForLocation(e.getX(), e.getY());
            DataSourceTree.this.popUpSource = DataSourceTree.this.tree.getPathForLocation(e.getX(), e.getY());
            if (selRow != -1 && e.isPopupTrigger()) {
                DataSourceTree.this.popup.removeAll();
                String[] al = ((DataSourceTreeElement)((TreeElement)DataSourceTree.this.popUpSource.getPathComponent(DataSourceTree.this.popUpSource.getPathCount() - 1)).getUserObject()).getPopUpActionList();
                for (int i = 0; al != null && i < al.length; ++i) {
                    JMenuItem menuItem = new JMenuItem(al[i]);
                    menuItem.addActionListener(DataSourceTree.this);
                    DataSourceTree.this.popup.add(menuItem);
                }
                DataSourceTree.this.popup.show(e.getComponent(), e.getX(), e.getY());
            }
        }
    }

    private class MyRenderer
    extends DefaultTreeCellRenderer {
        ImageIcon tutorialIcon;

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
            this.setIcon(((DataSourceTreeElement)((TreeElement)value).getUserObject()).getIcon());
            this.setToolTipText(((DataSourceTreeElement)((TreeElement)value).getUserObject()).getToolTip());
            return this;
        }
    }
}

