/*
 * Decompiled with CFR 0.152.
 */
package mondrian.rolap;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import mondrian.calc.Calc;
import mondrian.calc.ParameterSlot;
import mondrian.calc.ResultStyle;
import mondrian.olap.Evaluator;
import mondrian.olap.Exp;
import mondrian.olap.MondrianProperties;
import mondrian.olap.NamedSet;
import mondrian.olap.Query;
import mondrian.olap.SchemaReader;
import mondrian.olap.Util;
import mondrian.rolap.HierarchyUsage;
import mondrian.rolap.RolapConnection;
import mondrian.rolap.RolapCube;
import mondrian.rolap.RolapHierarchy;
import mondrian.rolap.RolapMember;
import mondrian.rolap.RolapMemberBase;
import mondrian.rolap.ScenarioImpl;
import mondrian.spi.Dialect;
import mondrian.spi.DialectManager;

class RolapEvaluatorRoot {
    final Map<Object, Object> expResultCache = new HashMap<Object, Object>();
    final Map<Object, Object> tmpExpResultCache = new HashMap<Object, Object>();
    final RolapCube cube;
    final RolapConnection connection;
    final SchemaReader schemaReader;
    final Map<List<Object>, Calc> compiledExps = new HashMap<List<Object>, Calc>();
    final Query query;
    private final Date queryStartTime;
    final Dialect currentDialect;
    final RolapMember[] defaultMembers;
    final int[] nonAllPositions;
    int nonAllPositionCount;
    final MondrianProperties.SolveOrderModeEnum solveOrderMode;
    final Set<Exp> activeNativeExpansions;

    public RolapEvaluatorRoot(Query query) {
        this.solveOrderMode = Util.lookup(MondrianProperties.SolveOrderModeEnum.class, MondrianProperties.instance().SolveOrderMode.get().toUpperCase(), MondrianProperties.SolveOrderModeEnum.ABSOLUTE);
        this.activeNativeExpansions = new HashSet<Exp>();
        this.query = query;
        this.cube = (RolapCube)query.getCube();
        this.connection = (RolapConnection)query.getConnection();
        this.schemaReader = query.getSchemaReader(true);
        this.queryStartTime = new Date();
        ArrayList<RolapMember> list = new ArrayList<RolapMember>();
        this.nonAllPositions = new int[this.cube.getHierarchies().size()];
        this.nonAllPositionCount = 0;
        for (RolapHierarchy hierarchy : this.cube.getHierarchies()) {
            HierarchyUsage hierarchyUsage;
            RolapMember defaultMember = (RolapMember)this.schemaReader.getHierarchyDefaultMember(hierarchy);
            assert (defaultMember != null);
            if (ScenarioImpl.isScenario(hierarchy) && this.connection.getScenario() != null) {
                defaultMember = ((ScenarioImpl)this.connection.getScenario()).getMember();
            }
            if ((hierarchyUsage = this.cube.getFirstUsage(hierarchy)) != null && defaultMember instanceof RolapMemberBase) {
                ((RolapMemberBase)defaultMember).makeUniqueName(hierarchyUsage);
            }
            list.add(defaultMember);
            if (defaultMember.isAll()) continue;
            this.nonAllPositions[this.nonAllPositionCount] = hierarchy.getOrdinalInCube();
            ++this.nonAllPositionCount;
        }
        this.defaultMembers = list.toArray(new RolapMember[list.size()]);
        this.currentDialect = DialectManager.createDialect(this.schemaReader.getDataSource(), null);
    }

    final Calc getCompiled(Exp exp, boolean scalar, ResultStyle resultStyle) {
        List<Object> key = Arrays.asList(new Object[]{exp, scalar, resultStyle});
        Calc calc = this.compiledExps.get(key);
        if (calc == null) {
            calc = this.query.compileExpression(exp, scalar, resultStyle);
            this.compiledExps.put(key, calc);
        }
        return calc;
    }

    protected Evaluator.NamedSetEvaluator evaluateNamedSet(NamedSet namedSet, boolean create) {
        throw new UnsupportedOperationException();
    }

    protected void init(Evaluator evaluator) {
    }

    public Object getParameterValue(ParameterSlot slot) {
        throw new UnsupportedOperationException();
    }

    public final void putCacheResult(Object key, Object result, boolean isValidResult) {
        if (isValidResult) {
            this.expResultCache.put(key, result);
        } else {
            this.tmpExpResultCache.put(key, result);
        }
    }

    public final Object getCacheResult(Object key) {
        Object result = this.expResultCache.get(key);
        if (result == null) {
            result = this.tmpExpResultCache.get(key);
        }
        return result;
    }

    public final void clearResultCache(boolean clearValidResult) {
        if (clearValidResult) {
            this.expResultCache.clear();
        }
        this.tmpExpResultCache.clear();
    }

    public Date getQueryStartTime() {
        return this.queryStartTime;
    }
}

