/*
 * Decompiled with CFR 0.152.
 */
package rex.graphics.mdxeditor.mdxbuilder.nodes;

import java.awt.datatransfer.DataFlavor;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Enumeration;
import javax.swing.ImageIcon;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import rex.graphics.dimensiontree.elements.DimensionTreeElement;
import rex.graphics.mdxeditor.mdxbuilder.nodes.MBTCalculatedMemberNode;
import rex.graphics.mdxeditor.mdxbuilder.nodes.MBTFunctionNode;
import rex.graphics.mdxeditor.mdxbuilder.nodes.MBTImmutableMembersNode;
import rex.graphics.mdxeditor.mdxbuilder.nodes.MBTMakeTupleFunctionNode;
import rex.graphics.mdxeditor.mdxbuilder.nodes.MBTMembersNode;
import rex.graphics.mdxeditor.mdxbuilder.nodes.MBTNamedSetNode;
import rex.graphics.mdxeditor.mdxbuilder.nodes.MBTNode;
import rex.graphics.mdxeditor.mdxbuilder.nodes.MBTOperatorFunctionNode;
import rex.graphics.mdxeditor.mdxfunctions.MdxFunction;
import rex.graphics.mdxeditor.mdxfunctions.MdxMakeTupleFunction;
import rex.graphics.mdxeditor.mdxfunctions.MdxOperatorFunction;
import rex.utils.I18n;
import rex.utils.LanguageChangedListener;
import rex.utils.S;

public abstract class DefaultMBTNode
implements MBTNode,
Serializable {
    private ArrayList children;
    protected String[] acceptableFlavorsMimeTypes;

    public DefaultMBTNode() {
        this.setAcceptableFlavorsArray();
    }

    @Override
    public MBTNode[] getMdxBuilderTreeNodes() {
        if (this.children != null) {
            return this.children.toArray(new MBTNode[0]);
        }
        return null;
    }

    @Override
    public void addChild(MBTNode child) {
        if (this.children == null) {
            this.children = new ArrayList();
        }
        this.children.add(child);
    }

    @Override
    public void addChildAt(MBTNode child, int index) {
        if (this.children == null) {
            this.children = new ArrayList();
        }
        this.children.add(index, child);
    }

    @Override
    public void removeAllChildren() {
        if (this.children != null) {
            for (int i = this.children.size() - 1; i >= 0; --i) {
                MBTNode child = (MBTNode)this.children.remove(i);
                if (!(child instanceof LanguageChangedListener)) continue;
                ((LanguageChangedListener)((Object)child)).removeLanguageListener();
            }
            this.children = null;
        }
    }

    @Override
    public void removeChildFromParent(MBTNode child) {
        if (this.children != null) {
            this.children.remove(child);
        }
        if (this.children.size() == 0) {
            this.removeAllChildren();
        }
    }

    void addChildAndMBTMembersNode(Object droppedObject, DefaultMutableTreeNode parentNode, DefaultTreeModel treeModel) throws Exception {
        DefaultMBTNode dd;
        if (droppedObject instanceof DimensionTreeElement) {
            dd = new MBTMembersNode((DimensionTreeElement)droppedObject);
        } else if (droppedObject instanceof MBTCalculatedMemberNode) {
            dd = new MBTImmutableMembersNode(((MBTCalculatedMemberNode)droppedObject).getName(), ((MBTCalculatedMemberNode)droppedObject).getDimensionUniqueName());
        } else if (droppedObject instanceof MBTNamedSetNode) {
            dd = new MBTImmutableMembersNode(((MBTNamedSetNode)droppedObject).getName(), I18n.getString("str.noParent"));
        } else {
            throw new Exception(I18n.getString("exception.unsupportObj"));
        }
        ((MBTNode)parentNode.getUserObject()).addChild(dd);
        DefaultMutableTreeNode childNode = new DefaultMutableTreeNode(dd);
        treeModel.insertNodeInto(childNode, parentNode, parentNode.getChildCount());
    }

    void addMdxFunctionChild(MdxFunction droppedFunction, DefaultMutableTreeNode parentNode, DefaultTreeModel treeModel) {
        MBTFunctionNode func = droppedFunction instanceof MdxOperatorFunction ? new MBTOperatorFunctionNode(droppedFunction.getName(), droppedFunction.getDescription(), droppedFunction.getSyntax(), droppedFunction.getFlavor()) : (droppedFunction instanceof MdxMakeTupleFunction ? new MBTMakeTupleFunctionNode(droppedFunction.getName(), droppedFunction.getDescription(), droppedFunction.getSyntax(), droppedFunction.getFlavor()) : new MBTFunctionNode(droppedFunction.getName(), droppedFunction.getDescription(), droppedFunction.getSyntax(), droppedFunction.getFlavor()));
        DefaultMutableTreeNode funcNode = new DefaultMutableTreeNode(func);
        ((MBTNode)parentNode.getUserObject()).addChild(func);
        treeModel.insertNodeInto(funcNode, parentNode, parentNode.getChildCount());
        MBTNode[] args = droppedFunction.getFunctionArguments();
        for (int i = 0; args != null && i < args.length; ++i) {
            func.addChild(args[i]);
            treeModel.insertNodeInto(new DefaultMutableTreeNode(args[i]), funcNode, funcNode.getChildCount());
        }
    }

    void moveMBTFunctionNode(MBTFunctionNode fNode, DefaultMutableTreeNode parentNode, DefaultTreeModel treeModel) {
        DefaultMutableTreeNode root = (DefaultMutableTreeNode)treeModel.getRoot();
        DefaultMutableTreeNode nodeToMove = null;
        if (root != null) {
            Enumeration<TreeNode> e = root.breadthFirstEnumeration();
            while (e.hasMoreElements()) {
                DefaultMutableTreeNode current = (DefaultMutableTreeNode)e.nextElement();
                if (!fNode.equals(current.getUserObject())) continue;
                nodeToMove = current;
                break;
            }
        }
        if (nodeToMove == null) {
            S.out("ERROR - Could not find a node to move!");
        }
        this.removeMySelfFromTheParent(nodeToMove, treeModel);
        treeModel.insertNodeInto(nodeToMove, parentNode, parentNode.getChildCount());
        ((MBTNode)parentNode.getUserObject()).addChild(fNode);
    }

    void removeMySelfFromTheParent(DefaultMutableTreeNode actionNode, DefaultTreeModel treeModel) {
        MBTNode node = (MBTNode)actionNode.getUserObject();
        ((MBTNode)((DefaultMutableTreeNode)actionNode.getParent()).getUserObject()).removeChildFromParent(node);
        treeModel.removeNodeFromParent(actionNode);
    }

    public void removeAllChildrenFromTheTree(DefaultMutableTreeNode actionNode, DefaultTreeModel treeModel) {
        ((MBTNode)actionNode.getUserObject()).removeAllChildren();
        int cnt = actionNode.getChildCount();
        for (int i = 0; i < cnt; ++i) {
            treeModel.removeNodeFromParent((DefaultMutableTreeNode)actionNode.getChildAt(0));
        }
    }

    protected int membersFromDifferentDimensionPresent(MBTNode parent, String dimName) {
        MBTNode[] children = parent.getMdxBuilderTreeNodes();
        for (int i = 0; children != null && i < children.length; ++i) {
            if (children[i] instanceof MBTMembersNode && !((MBTMembersNode)children[i]).getDimensionUniqueName().equals(dimName)) {
                return 1;
            }
            if (children[i] instanceof MBTCalculatedMemberNode && !((MBTCalculatedMemberNode)children[i]).getDimensionUniqueName().equals(dimName)) {
                return 1;
            }
            if (!(children[i] instanceof MBTFunctionNode) || !((MBTFunctionNode)children[i]).getFunctionName().equals("Crossjoin")) continue;
            int rv = this.membersFromDifferentDimensionPresent(children[i].getMdxBuilderTreeNodes()[0], dimName);
            if (rv > 0) {
                return 1 + rv;
            }
            rv = this.membersFromDifferentDimensionPresent(children[i].getMdxBuilderTreeNodes()[1], dimName);
            if (rv <= 0) continue;
            return 2 + rv;
        }
        return 0;
    }

    public ArrayList getChildren() {
        return this.children;
    }

    public MBTNode getChild(int i) {
        return this.children == null ? null : (MBTNode)this.children.get(i);
    }

    @Override
    public boolean acceptDrop(DataFlavor flavor) {
        for (int i = 0; this.acceptableFlavorsMimeTypes != null && i < this.acceptableFlavorsMimeTypes.length; ++i) {
            if (!flavor.getMimeType().equalsIgnoreCase(this.acceptableFlavorsMimeTypes[i])) continue;
            return true;
        }
        return false;
    }

    boolean acceptDropOnlyOneChild(DataFlavor flavor) {
        for (int i = 0; this.acceptableFlavorsMimeTypes != null && i < this.acceptableFlavorsMimeTypes.length; ++i) {
            if (this.getChildren() != null || !flavor.getMimeType().equalsIgnoreCase(this.acceptableFlavorsMimeTypes[i])) continue;
            return true;
        }
        return false;
    }

    String addCommaAfterBlanks(String mdx) {
        int i = 0;
        if (mdx.length() == 0) {
            return mdx;
        }
        while (mdx.charAt(i) == ' ') {
            ++i;
        }
        if (i > 0) {
            return mdx.substring(0, i) + ", " + mdx.substring(i);
        }
        return ", " + mdx.substring(i);
    }

    @Override
    public String getToolTip() {
        return this.toString();
    }

    @Override
    public boolean isComplete() {
        return true;
    }

    @Override
    public abstract String getMdx(String var1);

    @Override
    public abstract String toString();

    abstract void setAcceptableFlavorsArray();

    @Override
    public abstract void handleDrop(Object var1, DefaultMutableTreeNode var2, DefaultTreeModel var3);

    @Override
    public abstract ImageIcon getIcon();

    @Override
    public abstract String[] getPopUpActionList();

    @Override
    public abstract void handlePopUpAction(String var1, DefaultMutableTreeNode var2, DefaultTreeModel var3);
}

