/*
 * Decompiled with CFR 0.152.
 */
package org.joda.time;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import org.joda.convert.FromString;
import org.joda.convert.ToString;
import org.joda.time.Chronology;
import org.joda.time.DateTimeUtils;
import org.joda.time.Instant;
import org.joda.time.JodaTimePermission;
import org.joda.time.LocalDateTime;
import org.joda.time.ReadableInstant;
import org.joda.time.chrono.BaseChronology;
import org.joda.time.field.FieldUtils;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.DateTimeFormatterBuilder;
import org.joda.time.format.FormatUtils;
import org.joda.time.tz.DefaultNameProvider;
import org.joda.time.tz.FixedDateTimeZone;
import org.joda.time.tz.NameProvider;
import org.joda.time.tz.Provider;
import org.joda.time.tz.UTCProvider;
import org.joda.time.tz.ZoneInfoProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DateTimeZone
implements Serializable {
    private static final long serialVersionUID = 5546345482340108586L;
    public static final DateTimeZone UTC = new FixedDateTimeZone("UTC", "UTC", 0, 0);
    private static Provider cProvider;
    private static NameProvider cNameProvider;
    private static Set<String> cAvailableIDs;
    private static volatile DateTimeZone cDefault;
    private static DateTimeFormatter cOffsetFormatter;
    private static Map<String, SoftReference<DateTimeZone>> iFixedOffsetCache;
    private static Map<String, String> cZoneIdConversion;
    private final String iID;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static DateTimeZone getDefault() {
        DateTimeZone dateTimeZone = cDefault;
        if (dateTimeZone != null) return dateTimeZone;
        Class<DateTimeZone> clazz = DateTimeZone.class;
        synchronized (DateTimeZone.class) {
            dateTimeZone = cDefault;
            if (dateTimeZone != null) return dateTimeZone;
            DateTimeZone dateTimeZone2 = null;
            try {
                try {
                    String string = System.getProperty("user.timezone");
                    if (string != null) {
                        dateTimeZone2 = DateTimeZone.forID(string);
                    }
                }
                catch (RuntimeException runtimeException) {
                    // empty catch block
                }
                if (dateTimeZone2 == null) {
                    dateTimeZone2 = DateTimeZone.forTimeZone(TimeZone.getDefault());
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            if (dateTimeZone2 == null) {
                dateTimeZone2 = UTC;
            }
            cDefault = dateTimeZone = dateTimeZone2;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return dateTimeZone;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setDefault(DateTimeZone dateTimeZone) throws SecurityException {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new JodaTimePermission("DateTimeZone.setDefault"));
        }
        if (dateTimeZone == null) {
            throw new IllegalArgumentException("The datetime zone must not be null");
        }
        Class<DateTimeZone> clazz = DateTimeZone.class;
        synchronized (DateTimeZone.class) {
            cDefault = dateTimeZone;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    @FromString
    public static DateTimeZone forID(String string) {
        if (string == null) {
            return DateTimeZone.getDefault();
        }
        if (string.equals("UTC")) {
            return UTC;
        }
        DateTimeZone dateTimeZone = cProvider.getZone(string);
        if (dateTimeZone != null) {
            return dateTimeZone;
        }
        if (string.startsWith("+") || string.startsWith("-")) {
            int n = DateTimeZone.parseOffset(string);
            if ((long)n == 0L) {
                return UTC;
            }
            string = DateTimeZone.printOffset(n);
            return DateTimeZone.fixedOffsetZone(string, n);
        }
        throw new IllegalArgumentException("The datetime zone id '" + string + "' is not recognised");
    }

    public static DateTimeZone forOffsetHours(int n) throws IllegalArgumentException {
        return DateTimeZone.forOffsetHoursMinutes(n, 0);
    }

    public static DateTimeZone forOffsetHoursMinutes(int n, int n2) throws IllegalArgumentException {
        if (n == 0 && n2 == 0) {
            return UTC;
        }
        if (n2 < 0 || n2 > 59) {
            throw new IllegalArgumentException("Minutes out of range: " + n2);
        }
        int n3 = 0;
        try {
            int n4 = FieldUtils.safeMultiply(n, 60);
            n2 = n4 < 0 ? FieldUtils.safeAdd(n4, -n2) : FieldUtils.safeAdd(n4, n2);
            n3 = FieldUtils.safeMultiply(n2, 60000);
        }
        catch (ArithmeticException arithmeticException) {
            throw new IllegalArgumentException("Offset is too large");
        }
        return DateTimeZone.forOffsetMillis(n3);
    }

    public static DateTimeZone forOffsetMillis(int n) {
        String string = DateTimeZone.printOffset(n);
        return DateTimeZone.fixedOffsetZone(string, n);
    }

    public static DateTimeZone forTimeZone(TimeZone timeZone) {
        if (timeZone == null) {
            return DateTimeZone.getDefault();
        }
        String string = timeZone.getID();
        if (string.equals("UTC")) {
            return UTC;
        }
        DateTimeZone dateTimeZone = null;
        String string2 = DateTimeZone.getConvertedId(string);
        if (string2 != null) {
            dateTimeZone = cProvider.getZone(string2);
        }
        if (dateTimeZone == null) {
            dateTimeZone = cProvider.getZone(string);
        }
        if (dateTimeZone != null) {
            return dateTimeZone;
        }
        if (string2 == null && ((string2 = timeZone.getID()).startsWith("GMT+") || string2.startsWith("GMT-"))) {
            int n = DateTimeZone.parseOffset(string2 = string2.substring(3));
            if ((long)n == 0L) {
                return UTC;
            }
            string2 = DateTimeZone.printOffset(n);
            return DateTimeZone.fixedOffsetZone(string2, n);
        }
        throw new IllegalArgumentException("The datetime zone id '" + string + "' is not recognised");
    }

    private static synchronized DateTimeZone fixedOffsetZone(String string, int n) {
        DateTimeZone dateTimeZone;
        Reference reference;
        if (n == 0) {
            return UTC;
        }
        if (iFixedOffsetCache == null) {
            iFixedOffsetCache = new HashMap<String, SoftReference<DateTimeZone>>();
        }
        if ((reference = (Reference)iFixedOffsetCache.get(string)) != null && (dateTimeZone = (DateTimeZone)reference.get()) != null) {
            return dateTimeZone;
        }
        dateTimeZone = new FixedDateTimeZone(string, null, n, n);
        iFixedOffsetCache.put(string, new SoftReference<DateTimeZone>(dateTimeZone));
        return dateTimeZone;
    }

    public static Set<String> getAvailableIDs() {
        return cAvailableIDs;
    }

    public static Provider getProvider() {
        return cProvider;
    }

    public static void setProvider(Provider provider) throws SecurityException {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new JodaTimePermission("DateTimeZone.setProvider"));
        }
        DateTimeZone.setProvider0(provider);
    }

    private static void setProvider0(Provider provider) {
        Set<String> set;
        if (provider == null) {
            provider = DateTimeZone.getDefaultProvider();
        }
        if ((set = provider.getAvailableIDs()) == null || set.size() == 0) {
            throw new IllegalArgumentException("The provider doesn't have any available ids");
        }
        if (!set.contains("UTC")) {
            throw new IllegalArgumentException("The provider doesn't support UTC");
        }
        if (!UTC.equals(provider.getZone("UTC"))) {
            throw new IllegalArgumentException("Invalid UTC zone provided");
        }
        cProvider = provider;
        cAvailableIDs = set;
    }

    private static Provider getDefaultProvider() {
        Provider provider = null;
        try {
            String string = System.getProperty("org.joda.time.DateTimeZone.Provider");
            if (string != null) {
                try {
                    provider = (Provider)Class.forName(string).newInstance();
                }
                catch (Exception exception) {
                    Thread thread = Thread.currentThread();
                    thread.getThreadGroup().uncaughtException(thread, exception);
                }
            }
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        if (provider == null) {
            try {
                provider = new ZoneInfoProvider("org/joda/time/tz/data");
            }
            catch (Exception exception) {
                Thread thread = Thread.currentThread();
                thread.getThreadGroup().uncaughtException(thread, exception);
            }
        }
        if (provider == null) {
            provider = new UTCProvider();
        }
        return provider;
    }

    public static NameProvider getNameProvider() {
        return cNameProvider;
    }

    public static void setNameProvider(NameProvider nameProvider) throws SecurityException {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new JodaTimePermission("DateTimeZone.setNameProvider"));
        }
        DateTimeZone.setNameProvider0(nameProvider);
    }

    private static void setNameProvider0(NameProvider nameProvider) {
        if (nameProvider == null) {
            nameProvider = DateTimeZone.getDefaultNameProvider();
        }
        cNameProvider = nameProvider;
    }

    private static NameProvider getDefaultNameProvider() {
        NameProvider nameProvider = null;
        try {
            String string = System.getProperty("org.joda.time.DateTimeZone.NameProvider");
            if (string != null) {
                try {
                    nameProvider = (NameProvider)Class.forName(string).newInstance();
                }
                catch (Exception exception) {
                    Thread thread = Thread.currentThread();
                    thread.getThreadGroup().uncaughtException(thread, exception);
                }
            }
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        if (nameProvider == null) {
            nameProvider = new DefaultNameProvider();
        }
        return nameProvider;
    }

    private static synchronized String getConvertedId(String string) {
        Map<String, String> map = cZoneIdConversion;
        if (map == null) {
            map = new HashMap<String, String>();
            map.put("GMT", "UTC");
            map.put("WET", "WET");
            map.put("CET", "CET");
            map.put("MET", "CET");
            map.put("ECT", "CET");
            map.put("EET", "EET");
            map.put("MIT", "Pacific/Apia");
            map.put("HST", "Pacific/Honolulu");
            map.put("AST", "America/Anchorage");
            map.put("PST", "America/Los_Angeles");
            map.put("MST", "America/Denver");
            map.put("PNT", "America/Phoenix");
            map.put("CST", "America/Chicago");
            map.put("EST", "America/New_York");
            map.put("IET", "America/Indiana/Indianapolis");
            map.put("PRT", "America/Puerto_Rico");
            map.put("CNT", "America/St_Johns");
            map.put("AGT", "America/Argentina/Buenos_Aires");
            map.put("BET", "America/Sao_Paulo");
            map.put("ART", "Africa/Cairo");
            map.put("CAT", "Africa/Harare");
            map.put("EAT", "Africa/Addis_Ababa");
            map.put("NET", "Asia/Yerevan");
            map.put("PLT", "Asia/Karachi");
            map.put("IST", "Asia/Kolkata");
            map.put("BST", "Asia/Dhaka");
            map.put("VST", "Asia/Ho_Chi_Minh");
            map.put("CTT", "Asia/Shanghai");
            map.put("JST", "Asia/Tokyo");
            map.put("ACT", "Australia/Darwin");
            map.put("AET", "Australia/Sydney");
            map.put("SST", "Pacific/Guadalcanal");
            map.put("NST", "Pacific/Auckland");
            cZoneIdConversion = map;
        }
        return map.get(string);
    }

    private static int parseOffset(String string) {
        BaseChronology baseChronology = new BaseChronology(){

            public DateTimeZone getZone() {
                return null;
            }

            public Chronology withUTC() {
                return this;
            }

            public Chronology withZone(DateTimeZone dateTimeZone) {
                return this;
            }

            public String toString() {
                return this.getClass().getName();
            }
        };
        return -((int)DateTimeZone.offsetFormatter().withChronology(baseChronology).parseMillis(string));
    }

    private static String printOffset(int n) {
        StringBuffer stringBuffer = new StringBuffer();
        if (n >= 0) {
            stringBuffer.append('+');
        } else {
            stringBuffer.append('-');
            n = -n;
        }
        int n2 = n / 3600000;
        FormatUtils.appendPaddedInteger(stringBuffer, n2, 2);
        int n3 = (n -= n2 * 3600000) / 60000;
        stringBuffer.append(':');
        FormatUtils.appendPaddedInteger(stringBuffer, n3, 2);
        if ((n -= n3 * 60000) == 0) {
            return stringBuffer.toString();
        }
        int n4 = n / 1000;
        stringBuffer.append(':');
        FormatUtils.appendPaddedInteger(stringBuffer, n4, 2);
        if ((n -= n4 * 1000) == 0) {
            return stringBuffer.toString();
        }
        stringBuffer.append('.');
        FormatUtils.appendPaddedInteger(stringBuffer, n, 3);
        return stringBuffer.toString();
    }

    private static synchronized DateTimeFormatter offsetFormatter() {
        if (cOffsetFormatter == null) {
            cOffsetFormatter = new DateTimeFormatterBuilder().appendTimeZoneOffset(null, true, 2, 4).toFormatter();
        }
        return cOffsetFormatter;
    }

    protected DateTimeZone(String string) {
        if (string == null) {
            throw new IllegalArgumentException("Id must not be null");
        }
        this.iID = string;
    }

    @ToString
    public final String getID() {
        return this.iID;
    }

    public abstract String getNameKey(long var1);

    public final String getShortName(long l) {
        return this.getShortName(l, null);
    }

    public String getShortName(long l, Locale locale) {
        String string;
        if (locale == null) {
            locale = Locale.getDefault();
        }
        if ((string = this.getNameKey(l)) == null) {
            return this.iID;
        }
        String string2 = cNameProvider.getShortName(locale, this.iID, string);
        if (string2 != null) {
            return string2;
        }
        return DateTimeZone.printOffset(this.getOffset(l));
    }

    public final String getName(long l) {
        return this.getName(l, null);
    }

    public String getName(long l, Locale locale) {
        String string;
        if (locale == null) {
            locale = Locale.getDefault();
        }
        if ((string = this.getNameKey(l)) == null) {
            return this.iID;
        }
        String string2 = cNameProvider.getName(locale, this.iID, string);
        if (string2 != null) {
            return string2;
        }
        return DateTimeZone.printOffset(this.getOffset(l));
    }

    public abstract int getOffset(long var1);

    public final int getOffset(ReadableInstant readableInstant) {
        if (readableInstant == null) {
            return this.getOffset(DateTimeUtils.currentTimeMillis());
        }
        return this.getOffset(readableInstant.getMillis());
    }

    public abstract int getStandardOffset(long var1);

    public boolean isStandardOffset(long l) {
        return this.getOffset(l) == this.getStandardOffset(l);
    }

    public int getOffsetFromLocal(long l) {
        int n;
        int n2;
        long l2;
        long l3;
        int n3;
        int n4 = this.getOffset(l);
        if (n4 != (n3 = this.getOffset(l3 = l - (long)n4))) {
            long l4;
            long l5;
            if (n4 - n3 < 0 && (l5 = this.nextTransition(l3)) != (l4 = this.nextTransition(l - (long)n3))) {
                return n4;
            }
        } else if (n4 >= 0 && (l2 = this.previousTransition(l3)) < l3 && l3 - l2 <= (long)(n2 = (n = this.getOffset(l2)) - n4)) {
            return n;
        }
        return n3;
    }

    public long convertUTCToLocal(long l) {
        int n = this.getOffset(l);
        long l2 = l + (long)n;
        if ((l ^ l2) < 0L && (l ^ (long)n) >= 0L) {
            throw new ArithmeticException("Adding time zone offset caused overflow");
        }
        return l2;
    }

    public long convertLocalToUTC(long l, boolean bl, long l2) {
        int n = this.getOffset(l2);
        long l3 = l - (long)n;
        int n2 = this.getOffset(l3);
        if (n2 == n) {
            return l3;
        }
        return this.convertLocalToUTC(l, bl);
    }

    public long convertLocalToUTC(long l, boolean bl) {
        long l2;
        int n;
        int n2 = this.getOffset(l);
        if (n2 != (n = this.getOffset(l - (long)n2)) && (bl || n2 < 0)) {
            long l3;
            l2 = this.nextTransition(l - (long)n2);
            if (l2 == l - (long)n2) {
                l2 = Long.MAX_VALUE;
            }
            if ((l3 = this.nextTransition(l - (long)n)) == l - (long)n) {
                l3 = Long.MAX_VALUE;
            }
            if (l2 != l3) {
                if (bl) {
                    throw new IllegalArgumentException("Illegal instant due to time zone offset transition: " + DateTimeFormat.forPattern("yyyy-MM-dd'T'HH:mm:ss.SSS").print(new Instant(l)) + " (" + this.getID() + ")");
                }
                n = n2;
            }
        }
        if ((l ^ (l2 = l - (long)n)) < 0L && (l ^ (long)n) < 0L) {
            throw new ArithmeticException("Subtracting time zone offset caused overflow");
        }
        return l2;
    }

    public long getMillisKeepLocal(DateTimeZone dateTimeZone, long l) {
        if (dateTimeZone == null) {
            dateTimeZone = DateTimeZone.getDefault();
        }
        if (dateTimeZone == this) {
            return l;
        }
        long l2 = this.convertUTCToLocal(l);
        return dateTimeZone.convertLocalToUTC(l2, false, l);
    }

    public boolean isLocalDateTimeGap(LocalDateTime localDateTime) {
        if (this.isFixed()) {
            return false;
        }
        try {
            localDateTime.toDateTime(this);
            return false;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return true;
        }
    }

    public long adjustOffset(long l, boolean bl) {
        long l2;
        long l3 = l - 10800000L;
        long l4 = l + 10800000L;
        long l5 = this.getOffset(l3);
        if (l5 <= (l2 = (long)this.getOffset(l4))) {
            return l;
        }
        long l6 = l5 - l2;
        long l7 = this.nextTransition(l3);
        long l8 = l7 - l6;
        long l9 = l7 + l6;
        if (l < l8 || l >= l9) {
            return l;
        }
        long l10 = l - l8;
        if (l10 >= l6) {
            return bl ? l : l - l6;
        }
        return bl ? l + l6 : l;
    }

    public abstract boolean isFixed();

    public abstract long nextTransition(long var1);

    public abstract long previousTransition(long var1);

    public TimeZone toTimeZone() {
        return TimeZone.getTimeZone(this.iID);
    }

    public abstract boolean equals(Object var1);

    public int hashCode() {
        return 57 + this.getID().hashCode();
    }

    public String toString() {
        return this.getID();
    }

    protected Object writeReplace() throws ObjectStreamException {
        return new Stub(this.iID);
    }

    static {
        DateTimeZone.setProvider0(null);
        DateTimeZone.setNameProvider0(null);
    }

    private static final class Stub
    implements Serializable {
        private static final long serialVersionUID = -6471952376487863581L;
        private transient String iID;

        Stub(String string) {
            this.iID = string;
        }

        private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
            objectOutputStream.writeUTF(this.iID);
        }

        private void readObject(ObjectInputStream objectInputStream) throws IOException {
            this.iID = objectInputStream.readUTF();
        }

        private Object readResolve() throws ObjectStreamException {
            return DateTimeZone.forID(this.iID);
        }
    }
}

