/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.types.date;

import java.util.HashMap;
import java.util.Map;

public enum CalendarUnit {
    DAY("DAY"),
    WEEK("WEEK"),
    MONTH("MONTH"),
    QUARTER("QUARTER"),
    SEMI("SEMI"),
    YEAR("YEAR");

    private String unitName;
    private static Map<String, CalendarUnit> allUnits;

    static {
        allUnits = new HashMap<String, CalendarUnit>();
        allUnits.put(DAY.toString(), DAY);
        allUnits.put(WEEK.toString(), WEEK);
        allUnits.put(MONTH.toString(), MONTH);
        allUnits.put(QUARTER.toString(), QUARTER);
        allUnits.put(SEMI.toString(), SEMI);
        allUnits.put(YEAR.toString(), YEAR);
    }

    private CalendarUnit(String unitName) {
        this.unitName = unitName;
    }

    public String getUnitName() {
        return this.unitName;
    }

    public static CalendarUnit fromValue(String unitName) {
        if (unitName == null) {
            return null;
        }
        return allUnits.get(unitName);
    }

    public String toString() {
        return this.getUnitName();
    }
}

