/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.util;

import java.net.URLStreamHandlerFactory;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.SimpleJasperReportsContext;
import net.sf.jasperreports.engine.util.FileResolver;
import net.sf.jasperreports.repo.DefaultRepositoryService;
import net.sf.jasperreports.repo.RepositoryService;

public class LocalJasperReportsContext
extends SimpleJasperReportsContext {
    private List<RepositoryService> localRepositoryServices;
    private DefaultRepositoryService localRepositoryService;

    public LocalJasperReportsContext(JasperReportsContext parent) {
        super(parent);
    }

    public static JasperReportsContext getLocalContext(JasperReportsContext jasperReportsContext, Map<String, Object> parameterValues) {
        if (parameterValues.containsKey("REPORT_CLASS_LOADER") || parameterValues.containsKey("REPORT_URL_HANDLER_FACTORY") || parameterValues.containsKey("REPORT_FILE_RESOLVER")) {
            LocalJasperReportsContext localJasperReportsContext = new LocalJasperReportsContext(jasperReportsContext);
            if (parameterValues.containsKey("REPORT_CLASS_LOADER")) {
                localJasperReportsContext.setClassLoader((ClassLoader)parameterValues.get("REPORT_CLASS_LOADER"));
            }
            if (parameterValues.containsKey("REPORT_URL_HANDLER_FACTORY")) {
                localJasperReportsContext.setURLStreamHandlerFactory((URLStreamHandlerFactory)parameterValues.get("REPORT_URL_HANDLER_FACTORY"));
            }
            if (parameterValues.containsKey("REPORT_FILE_RESOLVER")) {
                localJasperReportsContext.setFileResolver((FileResolver)parameterValues.get("REPORT_FILE_RESOLVER"));
            }
            return localJasperReportsContext;
        }
        return jasperReportsContext;
    }

    private DefaultRepositoryService getLocalRepositoryService() {
        if (this.localRepositoryService == null) {
            this.localRepositoryService = new DefaultRepositoryService(this);
        }
        return this.localRepositoryService;
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.getLocalRepositoryService().setClassLoader(classLoader);
    }

    public void setURLStreamHandlerFactory(URLStreamHandlerFactory urlHandlerFactory) {
        this.getLocalRepositoryService().setURLStreamHandlerFactory(urlHandlerFactory);
    }

    public void setFileResolver(FileResolver fileResolver) {
        this.getLocalRepositoryService().setFileResolver(fileResolver);
    }

    @Override
    public <T> List<T> getExtensions(Class<T> extensionType) {
        if (this.localRepositoryService != null && RepositoryService.class.equals(extensionType)) {
            List<RepositoryService> repoServices;
            if (this.localRepositoryServices == null && (repoServices = super.getExtensions(RepositoryService.class)) != null && repoServices.size() > 0) {
                this.localRepositoryServices = new ArrayList<RepositoryService>();
                for (RepositoryService repoService : repoServices) {
                    if (repoService instanceof DefaultRepositoryService) {
                        this.localRepositoryServices.add(this.localRepositoryService);
                        continue;
                    }
                    this.localRepositoryServices.add(repoService);
                }
            }
            return this.localRepositoryServices;
        }
        return super.getExtensions(extensionType);
    }
}

