/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.fill;

import java.util.ArrayList;
import java.util.List;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.fill.FillListener;

public class CompositeFillListener
implements FillListener {
    private final List<FillListener> listeners = new ArrayList<FillListener>();

    public static FillListener addListener(FillListener existingListener, FillListener listener) {
        if (existingListener == null) {
            return listener;
        }
        if (listener == null) {
            return existingListener;
        }
        if (existingListener instanceof CompositeFillListener) {
            ((CompositeFillListener)existingListener).listeners.add(listener);
            return existingListener;
        }
        CompositeFillListener newListener = new CompositeFillListener();
        newListener.listeners.add(existingListener);
        newListener.listeners.add(listener);
        return newListener;
    }

    @Override
    public void pageGenerated(JasperPrint jasperPrint, int pageIndex) {
        for (FillListener listener : this.listeners) {
            listener.pageGenerated(jasperPrint, pageIndex);
        }
    }

    @Override
    public void pageUpdated(JasperPrint jasperPrint, int pageIndex) {
        for (FillListener listener : this.listeners) {
            listener.pageUpdated(jasperPrint, pageIndex);
        }
    }
}

