/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.export;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.font.TextAttribute;
import java.awt.geom.Dimension2D;
import java.io.IOException;
import java.io.Writer;
import java.text.AttributedCharacterIterator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import java.util.Map;
import net.sf.jasperreports.engine.DefaultJasperReportsContext;
import net.sf.jasperreports.engine.ImageMapRenderable;
import net.sf.jasperreports.engine.JRAbstractExporter;
import net.sf.jasperreports.engine.JRBoxContainer;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRExporterParameter;
import net.sf.jasperreports.engine.JRGenericPrintElement;
import net.sf.jasperreports.engine.JRImageRenderer;
import net.sf.jasperreports.engine.JRLineBox;
import net.sf.jasperreports.engine.JRPen;
import net.sf.jasperreports.engine.JRPrintElement;
import net.sf.jasperreports.engine.JRPrintElementIndex;
import net.sf.jasperreports.engine.JRPrintEllipse;
import net.sf.jasperreports.engine.JRPrintFrame;
import net.sf.jasperreports.engine.JRPrintGraphicElement;
import net.sf.jasperreports.engine.JRPrintHyperlink;
import net.sf.jasperreports.engine.JRPrintHyperlinkParameter;
import net.sf.jasperreports.engine.JRPrintImage;
import net.sf.jasperreports.engine.JRPrintImageArea;
import net.sf.jasperreports.engine.JRPrintImageAreaHyperlink;
import net.sf.jasperreports.engine.JRPrintLine;
import net.sf.jasperreports.engine.JRPrintPage;
import net.sf.jasperreports.engine.JRPrintRectangle;
import net.sf.jasperreports.engine.JRPrintText;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.JRWrappingSvgRenderer;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.Renderable;
import net.sf.jasperreports.engine.RenderableUtil;
import net.sf.jasperreports.engine.base.JRBasePrintText;
import net.sf.jasperreports.engine.export.AbstractHtmlExporter;
import net.sf.jasperreports.engine.export.DefaultHyperlinkTargetProducerFactory;
import net.sf.jasperreports.engine.export.GenericElementHandlerEnviroment;
import net.sf.jasperreports.engine.export.GenericElementHtmlHandler;
import net.sf.jasperreports.engine.export.HtmlFont;
import net.sf.jasperreports.engine.export.HtmlFontUtil;
import net.sf.jasperreports.engine.export.HtmlResourceHandler;
import net.sf.jasperreports.engine.export.HyperlinkUtil;
import net.sf.jasperreports.engine.export.JRExportProgressMonitor;
import net.sf.jasperreports.engine.export.JRHtmlExporterContext;
import net.sf.jasperreports.engine.export.JRHyperlinkProducer;
import net.sf.jasperreports.engine.export.JRHyperlinkTargetProducer;
import net.sf.jasperreports.engine.export.JRHyperlinkTargetProducerFactory;
import net.sf.jasperreports.engine.fonts.FontFamily;
import net.sf.jasperreports.engine.fonts.FontInfo;
import net.sf.jasperreports.engine.fonts.FontUtil;
import net.sf.jasperreports.engine.type.HyperlinkTargetEnum;
import net.sf.jasperreports.engine.type.HyperlinkTypeEnum;
import net.sf.jasperreports.engine.type.LineDirectionEnum;
import net.sf.jasperreports.engine.type.LineSpacingEnum;
import net.sf.jasperreports.engine.type.LineStyleEnum;
import net.sf.jasperreports.engine.type.ModeEnum;
import net.sf.jasperreports.engine.type.RenderableTypeEnum;
import net.sf.jasperreports.engine.type.RotationEnum;
import net.sf.jasperreports.engine.type.RunDirectionEnum;
import net.sf.jasperreports.engine.type.ScaleImageEnum;
import net.sf.jasperreports.engine.util.JRBoxUtil;
import net.sf.jasperreports.engine.util.JRColorUtil;
import net.sf.jasperreports.engine.util.JRStringUtil;
import net.sf.jasperreports.engine.util.JRStyledText;
import net.sf.jasperreports.engine.util.JRTextAttribute;
import net.sf.jasperreports.engine.util.Pair;
import net.sf.jasperreports.export.ExporterInputItem;
import net.sf.jasperreports.export.HtmlExporterConfiguration;
import net.sf.jasperreports.export.HtmlExporterOutput;
import net.sf.jasperreports.export.HtmlReportConfiguration;
import net.sf.jasperreports.export.WriterExporterOutput;
import net.sf.jasperreports.export.parameters.ParametersHtmlExporterOutput;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JRXhtmlExporter
extends AbstractHtmlExporter<HtmlReportConfiguration, HtmlExporterConfiguration> {
    private static final Log log = LogFactory.getLog(JRXhtmlExporter.class);
    private static final String XHTML_EXPORTER_PROPERTIES_PREFIX = "net.sf.jasperreports.export.xhtml.";
    public static final String PROPERTY_IGNORE_HYPERLINK = "net.sf.jasperreports.export.xhtml.ignore.hyperlink";
    public static final String XHTML_EXPORTER_KEY = "net.sf.jasperreports.xhtml";
    protected Writer writer;
    protected Map<String, String> rendererToImagePathMap;
    protected Map<Pair<String, Rectangle>, String> imageMaps;
    protected Map<String, HtmlFont> fontsToProcess;
    protected int reportIndex;
    protected int pageIndex;
    protected List<FrameInfo> frameInfoStack;
    protected int elementIndex;
    protected int topLimit;
    protected int leftLimit;
    protected int rightLimit;
    protected int bottomLimit;
    protected JRHyperlinkTargetProducerFactory targetProducerFactory;
    protected boolean hyperlinkStarted;
    private static /* synthetic */ int[] $SWITCH_TABLE$net$sf$jasperreports$engine$type$HyperlinkTargetEnum;

    public JRXhtmlExporter() {
        this(DefaultJasperReportsContext.getInstance());
    }

    public JRXhtmlExporter(JasperReportsContext jasperReportsContext) {
        super(jasperReportsContext);
        this.exporterContext = new ExporterContext();
        this.targetProducerFactory = new DefaultHyperlinkTargetProducerFactory(jasperReportsContext);
    }

    @Override
    protected Class<HtmlExporterConfiguration> getConfigurationInterface() {
        return HtmlExporterConfiguration.class;
    }

    @Override
    protected Class<HtmlReportConfiguration> getItemConfigurationInterface() {
        return HtmlReportConfiguration.class;
    }

    @Override
    protected void ensureOutput() {
        if (this.exporterOutput == null) {
            this.exporterOutput = new ParametersHtmlExporterOutput(this.getJasperReportsContext(), this.getParameters(), this.getCurrentJasperPrint());
        }
    }

    @Override
    public void exportReport() throws JRException {
        this.ensureJasperReportsContext();
        this.ensureInput();
        this.rendererToImagePathMap = new HashMap<String, String>();
        this.imageMaps = new HashMap<Pair<String, Rectangle>, String>();
        this.fontsToProcess = new HashMap<String, HtmlFont>();
        this.initExport();
        this.ensureOutput();
        this.writer = ((HtmlExporterOutput)this.getExporterOutput()).getWriter();
        try {
            try {
                this.exportReportToWriter();
            }
            catch (IOException e) {
                throw new JRException("Error writing to output writer : " + this.jasperPrint.getName(), e);
            }
        }
        finally {
            ((HtmlExporterOutput)this.getExporterOutput()).close();
            this.resetExportContext();
        }
    }

    @Override
    protected void initExport() {
        super.initExport();
    }

    @Override
    protected void initReport() {
        super.initReport();
    }

    protected void exportReportToWriter() throws JRException, IOException {
        HtmlExporterConfiguration configuration = (HtmlExporterConfiguration)this.getCurrentConfiguration();
        String htmlHeader = configuration.getHtmlHeader();
        String betweenPagesHtml = configuration.getBetweenPagesHtml();
        String htmlFooter = configuration.getHtmlFooter();
        if (htmlHeader == null) {
            String encoding = ((WriterExporterOutput)this.getExporterOutput()).getEncoding();
            this.writer.write("<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Transitional//EN\" \"http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd\">\n");
            this.writer.write("<html>\n");
            this.writer.write("<head>\n");
            this.writer.write("  <title></title>\n");
            this.writer.write("  <meta http-equiv=\"Content-Type\" content=\"text/html; charset=" + encoding + "\"/>\n");
            this.writer.write("  <style type=\"text/css\">\n");
            this.writer.write("    a {text-decoration: none}\n");
            this.writer.write("  </style>\n");
            this.writer.write("</head>\n");
            this.writer.write("<body text=\"#000000\" link=\"#000000\" alink=\"#000000\" vlink=\"#000000\">\n");
            this.writer.write("<table width=\"100%\" cellpadding=\"0\" cellspacing=\"0\" border=\"0\">\n");
            this.writer.write("<tr><td width=\"50%\">&nbsp;</td><td align=\"center\">\n");
            this.writer.write("\n");
        } else {
            this.writer.write(htmlHeader);
        }
        List<ExporterInputItem> items = this.exporterInput.getItems();
        this.reportIndex = 0;
        while (this.reportIndex < items.size()) {
            ExporterInputItem item = items.get(this.reportIndex);
            this.setCurrentExporterInputItem(item);
            List<JRPrintPage> pages = this.jasperPrint.getPages();
            if (pages != null && pages.size() > 0) {
                JRAbstractExporter.PageRange pageRange = this.getPageRange();
                int startPageIndex = pageRange == null || pageRange.getStartPageIndex() == null ? 0 : pageRange.getStartPageIndex();
                int endPageIndex = pageRange == null || pageRange.getEndPageIndex() == null ? pages.size() - 1 : pageRange.getEndPageIndex();
                JRPrintPage page = null;
                this.pageIndex = startPageIndex;
                while (this.pageIndex <= endPageIndex) {
                    if (Thread.interrupted()) {
                        throw new JRException("Current thread interrupted.");
                    }
                    page = pages.get(this.pageIndex);
                    this.writer.write("<a name=\"JR_PAGE_ANCHOR_" + this.reportIndex + "_" + (this.pageIndex + 1) + "\"></a>\n");
                    this.exportPage(page);
                    if (this.reportIndex < items.size() - 1 || this.pageIndex < endPageIndex) {
                        if (betweenPagesHtml == null) {
                            this.writer.write("<br/>\n<br/>\n");
                        } else {
                            this.writer.write(betweenPagesHtml);
                        }
                    }
                    this.writer.write("\n");
                    ++this.pageIndex;
                }
            }
            ++this.reportIndex;
        }
        if (this.fontsToProcess != null && this.fontsToProcess.size() > 0) {
            HtmlResourceHandler fontHandler = ((HtmlExporterOutput)this.getExporterOutput()).getFontHandler() == null ? this.getFontHandler() : ((HtmlExporterOutput)this.getExporterOutput()).getFontHandler();
            for (HtmlFont htmlFont : this.fontsToProcess.values()) {
                this.writer.write("<link class=\"jrWebFont\" rel=\"stylesheet\" href=\"" + fontHandler.getResourcePath(htmlFont.getId()) + "\">\n");
            }
        }
        this.writer.write("<![if IE]>\n");
        this.writer.write("<script>\n");
        this.writer.write("var links = document.querySelectorAll('link.jrWebFont');\n");
        this.writer.write("setTimeout(function(){ if (links) { for (var i = 0; i < links.length; i++) { links.item(i).href = links.item(i).href; } } }, 0);\n");
        this.writer.write("</script>\n");
        this.writer.write("<![endif]>\n");
        if (htmlFooter == null) {
            this.writer.write("</td><td width=\"50%\">&nbsp;</td></tr>\n");
            this.writer.write("</table>\n");
            this.writer.write("</body>\n");
            this.writer.write("</html>\n");
        } else {
            this.writer.write(htmlFooter);
        }
        this.writer.flush();
    }

    protected void exportPage(JRPrintPage page) throws JRException, IOException {
        this.topLimit = this.jasperPrint.getPageHeight();
        this.leftLimit = this.jasperPrint.getPageWidth();
        this.rightLimit = 0;
        this.bottomLimit = 0;
        this.setPageLimits(page.getElements());
        HtmlReportConfiguration configuration = (HtmlReportConfiguration)this.getCurrentItemConfiguration();
        boolean isIgnorePageMargins = configuration.isIgnorePageMargins();
        if (!isIgnorePageMargins) {
            this.topLimit = 0;
        }
        if (!isIgnorePageMargins) {
            this.leftLimit = 0;
        }
        if (this.jasperPrint.getPageWidth() > this.rightLimit && !isIgnorePageMargins) {
            this.rightLimit = this.jasperPrint.getPageWidth();
        }
        if (this.jasperPrint.getPageHeight() > this.bottomLimit && !isIgnorePageMargins) {
            this.bottomLimit = this.jasperPrint.getPageHeight();
        }
        if (this.topLimit > this.bottomLimit) {
            this.topLimit = this.bottomLimit;
        }
        if (this.leftLimit > this.rightLimit) {
            this.leftLimit = this.rightLimit;
        }
        boolean isWhitePageBackground = configuration.isWhitePageBackground();
        this.writer.write("<div class=\"jrPage\" style=\"" + (isWhitePageBackground ? "background-color: #FFFFFF;" : "") + "position:relative;width:" + this.toSizeUnit(this.rightLimit - this.leftLimit) + ";height:" + this.toSizeUnit(this.bottomLimit - this.topLimit) + ";\">\n");
        this.frameInfoStack = new ArrayList<FrameInfo>();
        this.exportElements(page.getElements());
        this.writer.write("</div>");
        JRExportProgressMonitor progressMonitor = configuration.getProgressMonitor();
        if (progressMonitor != null) {
            progressMonitor.afterPageExport();
        }
    }

    protected void exportElements(List<JRPrintElement> elements) throws IOException, JRException {
        if (elements != null && elements.size() > 0) {
            int i = 0;
            while (i < elements.size()) {
                this.elementIndex = i;
                JRPrintElement element = elements.get(i);
                if (this.filter == null || this.filter.isToExport(element)) {
                    if (element instanceof JRPrintLine) {
                        this.exportLine((JRPrintLine)element);
                    } else if (element instanceof JRPrintRectangle) {
                        this.exportRectangle((JRPrintRectangle)element);
                    } else if (element instanceof JRPrintEllipse) {
                        this.exportRectangle((JRPrintEllipse)element);
                    } else if (element instanceof JRPrintImage) {
                        this.exportImage((JRPrintImage)element);
                    } else if (element instanceof JRPrintText) {
                        this.exportText((JRPrintText)element);
                    } else if (element instanceof JRPrintFrame) {
                        this.exportFrame((JRPrintFrame)element);
                    } else if (element instanceof JRGenericPrintElement) {
                        this.exportGenericElement((JRGenericPrintElement)element);
                    }
                }
                ++i;
            }
        }
    }

    protected void exportLine(JRPrintLine line) throws IOException {
        this.writer.write("<span");
        this.appendId(line);
        StringBuffer styleBuffer = new StringBuffer();
        this.appendPositionStyle((JRPrintElement)line, line.getLinePen(), styleBuffer);
        this.appendSizeStyle((JRPrintElement)line, line.getLinePen(), styleBuffer);
        this.appendBackcolorStyle(line, styleBuffer);
        String side = null;
        float ratio = line.getWidth() / line.getHeight();
        side = ratio > 1.0f ? (line.getDirectionValue() == LineDirectionEnum.TOP_DOWN ? "top" : "bottom") : (line.getDirectionValue() == LineDirectionEnum.TOP_DOWN ? "left" : "right");
        this.appendPen(styleBuffer, line.getLinePen(), side);
        if (styleBuffer.length() > 0) {
            this.writer.write(" style=\"");
            this.writer.write(styleBuffer.toString());
            this.writer.write("\"");
        }
        this.writer.write("></span>\n");
    }

    protected void exportRectangle(JRPrintGraphicElement element) throws IOException {
        this.writer.write("<span");
        this.appendId(element);
        StringBuffer styleBuffer = new StringBuffer();
        this.appendPositionStyle((JRPrintElement)element, element.getLinePen(), styleBuffer);
        this.appendSizeStyle((JRPrintElement)element, element.getLinePen(), styleBuffer);
        this.appendBackcolorStyle(element, styleBuffer);
        this.appendPen(styleBuffer, element.getLinePen(), null);
        if (styleBuffer.length() > 0) {
            this.writer.write(" style=\"");
            this.writer.write(styleBuffer.toString());
            this.writer.write("\"");
        }
        this.writer.write("></span>\n");
    }

    protected void exportStyledText(JRPrintText printText, JRStyledText styledText, String tooltip) throws IOException {
        Locale locale = this.getTextLocale(printText);
        LineSpacingEnum lineSpacing = printText.getParagraph().getLineSpacing();
        Float lineSpacingSize = printText.getParagraph().getLineSpacingSize();
        float lineSpacingFactor = printText.getLineSpacingFactor();
        Color backcolor = printText.getBackcolor();
        String text = styledText.getText();
        int runLimit = 0;
        AttributedCharacterIterator iterator = styledText.getAttributedString().getIterator();
        boolean first = true;
        boolean startedSpan = false;
        while (runLimit < styledText.length() && (runLimit = iterator.getRunLimit()) <= styledText.length()) {
            if (first && runLimit < styledText.length() && tooltip != null) {
                startedSpan = true;
                this.writer.write("<span title=\"");
                this.writer.write(JRStringUtil.xmlEncode(tooltip));
                this.writer.write("\">");
                tooltip = null;
            }
            first = false;
            this.exportStyledTextRun(iterator.getAttributes(), text.substring(iterator.getIndex(), runLimit), tooltip, locale, lineSpacing, lineSpacingSize, lineSpacingFactor, backcolor);
            iterator.setIndex(runLimit);
        }
        if (startedSpan) {
            this.writer.write("</span>");
        }
    }

    protected void exportStyledTextRun(Map<AttributedCharacterIterator.Attribute, Object> attributes, String text, String tooltip, Locale locale, LineSpacingEnum lineSpacing, Float lineSpacingSize, float lineSpacingFactor, Color backcolor) throws IOException {
        Color runBackcolor;
        String fontFamilyAttr;
        boolean isBold = TextAttribute.WEIGHT_BOLD.equals(attributes.get(TextAttribute.WEIGHT));
        boolean isItalic = TextAttribute.POSTURE_OBLIQUE.equals(attributes.get(TextAttribute.POSTURE));
        String fontFamily = fontFamilyAttr = (String)attributes.get(TextAttribute.FAMILY);
        FontInfo fontInfo = FontUtil.getInstance(this.jasperReportsContext).getFontInfo(fontFamilyAttr, locale);
        if (fontInfo != null) {
            FontFamily family = fontInfo.getFontFamily();
            String exportFont = family.getExportFont(this.getExporterKey());
            if (exportFont == null) {
                HtmlFont htmlFont;
                HtmlResourceHandler resourceHandler;
                HtmlResourceHandler fontHandler = ((HtmlExporterOutput)this.getExporterOutput()).getFontHandler() == null ? this.getFontHandler() : ((HtmlExporterOutput)this.getExporterOutput()).getFontHandler();
                HtmlResourceHandler htmlResourceHandler = resourceHandler = ((HtmlExporterOutput)this.getExporterOutput()).getResourceHandler() == null ? this.getResourceHandler() : ((HtmlExporterOutput)this.getExporterOutput()).getResourceHandler();
                if (fontHandler != null && resourceHandler != null && (htmlFont = HtmlFont.getInstance(locale, fontInfo, isBold, isItalic)) != null) {
                    if (!this.fontsToProcess.containsKey(htmlFont.getId())) {
                        this.fontsToProcess.put(htmlFont.getId(), htmlFont);
                        HtmlFontUtil.handleFont(resourceHandler, htmlFont);
                    }
                    fontFamily = htmlFont.getId();
                }
            } else {
                fontFamily = exportFont;
            }
        }
        boolean localHyperlink = false;
        JRPrintHyperlink hyperlink = (JRPrintHyperlink)attributes.get(JRTextAttribute.HYPERLINK);
        if (!this.hyperlinkStarted && hyperlink != null) {
            this.startHyperlink(hyperlink);
            localHyperlink = true;
        }
        this.writer.write("<span style=\"font-family: ");
        this.writer.write(fontFamily);
        this.writer.write("; ");
        Color forecolor = (Color)attributes.get(TextAttribute.FOREGROUND);
        if (!this.hyperlinkStarted || !Color.black.equals(forecolor)) {
            this.writer.write("color: ");
            this.writer.write(JRColorUtil.getCssColor(forecolor));
            this.writer.write("; ");
        }
        if ((runBackcolor = (Color)attributes.get(TextAttribute.BACKGROUND)) != null && !runBackcolor.equals(backcolor)) {
            this.writer.write("background-color: ");
            this.writer.write(JRColorUtil.getCssColor(runBackcolor));
            this.writer.write("; ");
        }
        this.writer.write("font-size: ");
        this.writer.write(this.toSizeUnit(((Float)attributes.get(TextAttribute.SIZE)).floatValue()));
        this.writer.write(";");
        switch (lineSpacing) {
            default: {
                if (lineSpacingFactor == 0.0f) {
                    this.writer.write(" line-height: 1; *line-height: normal;");
                    break;
                }
                this.writer.write(" line-height: " + lineSpacingFactor + ";");
                break;
            }
            case ONE_AND_HALF: {
                if (lineSpacingFactor == 0.0f) {
                    this.writer.write(" line-height: 1.5;");
                    break;
                }
                this.writer.write(" line-height: " + lineSpacingFactor + ";");
                break;
            }
            case DOUBLE: {
                if (lineSpacingFactor == 0.0f) {
                    this.writer.write(" line-height: 2.0;");
                    break;
                }
                this.writer.write(" line-height: " + lineSpacingFactor + ";");
                break;
            }
            case PROPORTIONAL: {
                if (lineSpacingSize == null) break;
                this.writer.write(" line-height: " + lineSpacingSize.floatValue() + ";");
                break;
            }
            case AT_LEAST: 
            case FIXED: {
                if (lineSpacingSize == null) break;
                this.writer.write(" line-height: " + lineSpacingSize.floatValue() + "px;");
            }
        }
        if (isBold) {
            this.writer.write(" font-weight: bold;");
        }
        if (isItalic) {
            this.writer.write(" font-style: italic;");
        }
        if (TextAttribute.UNDERLINE_ON.equals(attributes.get(TextAttribute.UNDERLINE))) {
            this.writer.write(" text-decoration: underline;");
        }
        if (TextAttribute.STRIKETHROUGH_ON.equals(attributes.get(TextAttribute.STRIKETHROUGH))) {
            this.writer.write(" text-decoration: line-through;");
        }
        if (TextAttribute.SUPERSCRIPT_SUPER.equals(attributes.get(TextAttribute.SUPERSCRIPT))) {
            this.writer.write(" vertical-align: super;");
        } else if (TextAttribute.SUPERSCRIPT_SUB.equals(attributes.get(TextAttribute.SUPERSCRIPT))) {
            this.writer.write(" vertical-align: sub;");
        }
        this.writer.write("\"");
        if (tooltip != null) {
            this.writer.write(" title=\"");
            this.writer.write(JRStringUtil.xmlEncode(tooltip));
            this.writer.write("\"");
        }
        this.writer.write(">");
        this.writer.write(JRStringUtil.htmlEncode(text));
        this.writer.write("</span>");
        if (localHyperlink) {
            this.endHyperlink();
        }
    }

    protected void exportText(JRPrintText text) throws IOException {
        JRStyledText styledText = this.getStyledText(text);
        int textLength = 0;
        if (styledText != null) {
            textLength = styledText.length();
        }
        if (text.getAnchorName() != null) {
            this.writer.write("<a name=\"");
            this.writer.write(text.getAnchorName());
            this.writer.write("\"></a>");
        }
        this.writer.write("<div");
        this.appendId(text);
        if (text.getRunDirectionValue() == RunDirectionEnum.RTL) {
            this.writer.write(" dir=\"rtl\"");
        }
        StringBuffer styleBuffer = new StringBuffer();
        StringBuffer divStyleBuffer = new StringBuffer();
        String rotationValue = null;
        if (text.getRotationValue() == RotationEnum.NONE) {
            this.appendPositionStyle((JRPrintElement)text, text, divStyleBuffer);
            this.appendSizeStyle((JRPrintElement)text, text, divStyleBuffer);
            this.appendBorderStyle(text.getLineBox(), divStyleBuffer);
            this.appendPositionStyle(text.getLineBox().getLeftPadding() - this.getInsideBorderOffset(text.getLineBox().getLeftPen().getLineWidth().floatValue(), false), text.getLineBox().getTopPadding() - this.getInsideBorderOffset(text.getLineBox().getTopPen().getLineWidth().floatValue(), false), styleBuffer);
            this.appendSizeStyle(text.getWidth() - text.getLineBox().getLeftPadding() - text.getLineBox().getRightPadding(), text.getHeight() - text.getLineBox().getTopPadding() - text.getLineBox().getBottomPadding(), styleBuffer);
        } else {
            JRBasePrintText rotatedText = new JRBasePrintText(text.getDefaultStyleProvider());
            rotatedText.setUUID(text.getUUID());
            rotatedText.setX(text.getX());
            rotatedText.setY(text.getY());
            rotatedText.setWidth(text.getWidth());
            rotatedText.setHeight(text.getHeight());
            rotatedText.copyBox(text.getLineBox());
            JRBoxUtil.rotate(rotatedText.getLineBox(), text.getRotationValue());
            int rotationIE = 0;
            int rotationAngle = 0;
            int translateX = 0;
            int translateY = 0;
            switch (text.getRotationValue()) {
                case LEFT: {
                    translateX = -(text.getHeight() - text.getLineBox().getTopPadding() - text.getLineBox().getBottomPadding() - (text.getWidth() - text.getLineBox().getLeftPadding() - text.getLineBox().getRightPadding())) / 2;
                    translateY = (text.getHeight() - text.getLineBox().getTopPadding() - text.getLineBox().getBottomPadding() - (text.getWidth() - text.getLineBox().getLeftPadding() - text.getLineBox().getRightPadding())) / 2;
                    rotatedText.setWidth(text.getHeight());
                    rotatedText.setHeight(text.getWidth());
                    rotationIE = 3;
                    rotationAngle = -90;
                    rotationValue = "left";
                    break;
                }
                case RIGHT: {
                    translateX = -(text.getHeight() - text.getLineBox().getTopPadding() - text.getLineBox().getBottomPadding() - (text.getWidth() - text.getLineBox().getLeftPadding() - text.getLineBox().getRightPadding())) / 2;
                    translateY = (text.getHeight() - text.getLineBox().getTopPadding() - text.getLineBox().getBottomPadding() - (text.getWidth() - text.getLineBox().getLeftPadding() - text.getLineBox().getRightPadding())) / 2;
                    rotatedText.setWidth(text.getHeight());
                    rotatedText.setHeight(text.getWidth());
                    rotationIE = 1;
                    rotationAngle = 90;
                    rotationValue = "right";
                    break;
                }
                case UPSIDE_DOWN: {
                    rotationIE = 2;
                    rotationAngle = 180;
                    rotationValue = "upsideDown";
                }
            }
            this.appendPositionStyle((JRPrintElement)text, text, divStyleBuffer);
            this.appendSizeStyle((JRPrintElement)text, text, divStyleBuffer);
            this.appendBorderStyle(text.getLineBox(), divStyleBuffer);
            this.appendPositionStyle(text.getLineBox().getLeftPadding() - this.getInsideBorderOffset(text.getLineBox().getLeftPen().getLineWidth().floatValue(), false), text.getLineBox().getTopPadding() - this.getInsideBorderOffset(text.getLineBox().getTopPen().getLineWidth().floatValue(), false), styleBuffer);
            this.appendSizeStyle(rotatedText.getWidth() - rotatedText.getLineBox().getLeftPadding() - rotatedText.getLineBox().getRightPadding(), rotatedText.getHeight() - rotatedText.getLineBox().getTopPadding() - rotatedText.getLineBox().getBottomPadding(), styleBuffer);
            styleBuffer.append("-webkit-transform: translate(" + translateX + "px," + translateY + "px) ");
            styleBuffer.append("rotate(" + rotationAngle + "deg); ");
            styleBuffer.append("-moz-transform: translate(" + translateX + "px," + translateY + "px) ");
            styleBuffer.append("rotate(" + rotationAngle + "deg); ");
            styleBuffer.append("-ms-transform: translate(" + translateX + "px," + translateY + "px) ");
            styleBuffer.append("rotate(" + rotationAngle + "deg); ");
            styleBuffer.append("-o-transform: translate(" + translateX + "px," + translateY + "px) ");
            styleBuffer.append("rotate(" + rotationAngle + "deg); ");
            styleBuffer.append("filter: progid:DXImageTransform.Microsoft.BasicImage(rotation=" + rotationIE + "); ");
        }
        this.appendBackcolorStyle(text, divStyleBuffer);
        String verticalAlignment = "top";
        switch (text.getVerticalAlignmentValue()) {
            case BOTTOM: {
                verticalAlignment = "bottom";
                break;
            }
            case MIDDLE: {
                verticalAlignment = "middle";
                break;
            }
            default: {
                verticalAlignment = "top";
            }
        }
        String horizontalAlignment = "left";
        if (textLength > 0) {
            switch (text.getHorizontalAlignmentValue()) {
                case RIGHT: {
                    horizontalAlignment = "right";
                    break;
                }
                case CENTER: {
                    horizontalAlignment = "center";
                    break;
                }
                case JUSTIFIED: {
                    horizontalAlignment = "justify";
                    break;
                }
                default: {
                    horizontalAlignment = "left";
                }
            }
            styleBuffer.append("text-align: ");
            styleBuffer.append(horizontalAlignment);
            styleBuffer.append(";");
            styleBuffer.append(" display:table;");
        }
        if (((HtmlReportConfiguration)this.getCurrentItemConfiguration()).isWrapBreakWord().booleanValue()) {
            styleBuffer.append("word-wrap: break-word; ");
        }
        styleBuffer.append("text-indent: " + text.getParagraph().getFirstLineIndent() + "px; ");
        if (text.getLineBreakOffsets() != null) {
            styleBuffer.append("white-space: nowrap; ");
        }
        divStyleBuffer.append("overflow: hidden;");
        if (divStyleBuffer.length() > 0) {
            this.writer.write(" style=\"");
            this.writer.write(divStyleBuffer.toString());
            this.writer.write("\"");
        }
        this.writer.write("><span");
        if (rotationValue != null) {
            this.writer.write(" class=\"rotated\" data-rotation=\"" + rotationValue + "\"");
        }
        if (styleBuffer.length() > 0) {
            this.writer.write(" style=\"");
            this.writer.write(styleBuffer.toString());
            this.writer.write("\"");
        }
        this.writer.write(">");
        this.writer.write("<span style=\"display:table-cell;vertical-align:");
        this.writer.write(verticalAlignment);
        this.writer.write(";\">");
        this.startHyperlink(text);
        if (textLength > 0) {
            this.exportStyledText(text, styledText, text.getHyperlinkTooltip());
        }
        this.endHyperlink();
        this.writer.write("</span>");
        this.writer.write("</span></div>\n");
    }

    protected boolean startHyperlink(JRPrintHyperlink link) throws IOException {
        String href = this.getHyperlinkURL(link);
        if (href != null) {
            this.writer.write("<a href=\"");
            this.writer.write(href);
            this.writer.write("\"");
            String target = this.getHyperlinkTarget(link);
            if (target != null) {
                this.writer.write(" target=\"");
                this.writer.write(target);
                this.writer.write("\"");
            }
            if (link.getHyperlinkTooltip() != null) {
                this.writer.write(" title=\"");
                this.writer.write(JRStringUtil.xmlEncode(link.getHyperlinkTooltip()));
                this.writer.write("\"");
            }
            this.writer.write(">");
        }
        this.hyperlinkStarted = href != null;
        return this.hyperlinkStarted;
    }

    protected String getHyperlinkTarget(JRPrintHyperlink link) {
        String target;
        block11: {
            JRHyperlinkTargetProducer producer;
            block10: {
                target = null;
                producer = this.targetProducerFactory.getHyperlinkTargetProducer(link.getLinkTarget());
                if (producer != null) break block10;
                switch (JRXhtmlExporter.$SWITCH_TABLE$net$sf$jasperreports$engine$type$HyperlinkTargetEnum()[link.getHyperlinkTargetValue().ordinal()]) {
                    case 3: {
                        target = "_blank";
                        break;
                    }
                    case 4: {
                        target = "_parent";
                        break;
                    }
                    case 5: {
                        target = "_top";
                        break;
                    }
                    case 6: {
                        List<JRPrintHyperlinkParameter> parameters;
                        boolean paramFound = false;
                        List<JRPrintHyperlinkParameter> list = parameters = link.getHyperlinkParameters() == null ? null : link.getHyperlinkParameters().getParameters();
                        if (parameters != null) {
                            for (JRPrintHyperlinkParameter parameter : parameters) {
                                if (!link.getLinkTarget().equals(parameter.getName())) continue;
                                target = parameter.getValue() == null ? null : parameter.getValue().toString();
                                paramFound = true;
                                break;
                            }
                        }
                        if (paramFound) break block11;
                        target = link.getLinkTarget();
                    }
                    default: {
                        break;
                    }
                    {
                    }
                }
                break block11;
            }
            target = producer.getHyperlinkTarget(link);
        }
        return target;
    }

    protected String getHyperlinkURL(JRPrintHyperlink link) {
        String href;
        block13: {
            JRHyperlinkProducer customHandler;
            block14: {
                href = null;
                Boolean ignoreHyperlink = HyperlinkUtil.getIgnoreHyperlink(PROPERTY_IGNORE_HYPERLINK, link);
                if (ignoreHyperlink == null) {
                    ignoreHyperlink = this.getPropertiesUtil().getBooleanProperty(this.jasperPrint, PROPERTY_IGNORE_HYPERLINK, false);
                }
                if (ignoreHyperlink.booleanValue()) break block13;
                customHandler = this.getHyperlinkProducer(link);
                if (customHandler != null) break block14;
                switch (link.getHyperlinkTypeValue()) {
                    case REFERENCE: {
                        if (link.getHyperlinkReference() != null) {
                            href = link.getHyperlinkReference();
                            break;
                        }
                        break block13;
                    }
                    case LOCAL_ANCHOR: {
                        if (link.getHyperlinkAnchor() != null) {
                            href = "#" + link.getHyperlinkAnchor();
                            break;
                        }
                        break block13;
                    }
                    case LOCAL_PAGE: {
                        if (link.getHyperlinkPage() != null) {
                            href = "#JR_PAGE_ANCHOR_" + this.reportIndex + "_" + link.getHyperlinkPage().toString();
                            break;
                        }
                        break block13;
                    }
                    case REMOTE_ANCHOR: {
                        if (link.getHyperlinkReference() != null && link.getHyperlinkAnchor() != null) {
                            href = String.valueOf(link.getHyperlinkReference()) + "#" + link.getHyperlinkAnchor();
                            break;
                        }
                        break block13;
                    }
                    case REMOTE_PAGE: {
                        if (link.getHyperlinkReference() != null && link.getHyperlinkPage() != null) {
                            href = String.valueOf(link.getHyperlinkReference()) + "#" + "JR_PAGE_ANCHOR_" + "0_" + link.getHyperlinkPage().toString();
                            break;
                        }
                        break block13;
                    }
                }
                break block13;
            }
            href = customHandler.getHyperlink(link);
        }
        return href;
    }

    protected void endHyperlink() throws IOException {
        if (this.hyperlinkStarted) {
            this.writer.write("</a>");
        }
        this.hyperlinkStarted = false;
    }

    protected boolean appendBorderStyle(JRLineBox box, StringBuffer styleBuffer) {
        boolean addedToStyle = false;
        if (box != null) {
            LineStyleEnum tps = box.getTopPen().getLineStyleValue();
            LineStyleEnum lps = box.getLeftPen().getLineStyleValue();
            LineStyleEnum bps = box.getBottomPen().getLineStyleValue();
            LineStyleEnum rps = box.getRightPen().getLineStyleValue();
            float tpw = box.getTopPen().getLineWidth().floatValue();
            float lpw = box.getLeftPen().getLineWidth().floatValue();
            float bpw = box.getBottomPen().getLineWidth().floatValue();
            float rpw = box.getRightPen().getLineWidth().floatValue();
            if (0.0f < tpw && tpw < 1.0f) {
                tpw = 1.0f;
            }
            if (0.0f < lpw && lpw < 1.0f) {
                lpw = 1.0f;
            }
            if (0.0f < bpw && bpw < 1.0f) {
                bpw = 1.0f;
            }
            if (0.0f < rpw && rpw < 1.0f) {
                rpw = 1.0f;
            }
            Color tpc = box.getTopPen().getLineColor();
            if (tps == lps && tps == bps && tps == rps && tpw == lpw && tpw == bpw && tpw == rpw && tpc.equals(box.getLeftPen().getLineColor()) && tpc.equals(box.getBottomPen().getLineColor()) && tpc.equals(box.getRightPen().getLineColor())) {
                addedToStyle |= this.appendPen(styleBuffer, box.getTopPen(), null);
            } else {
                addedToStyle |= this.appendPen(styleBuffer, box.getTopPen(), "top");
                addedToStyle |= this.appendPen(styleBuffer, box.getLeftPen(), "left");
                addedToStyle |= this.appendPen(styleBuffer, box.getBottomPen(), "bottom");
                addedToStyle |= this.appendPen(styleBuffer, box.getRightPen(), "right");
            }
            Integer tp = box.getTopPadding();
            Integer lp = box.getLeftPadding();
            Integer bp = box.getBottomPadding();
            Integer rp = box.getRightPadding();
            if (tp == lp && tp == bp && tp == rp) {
                addedToStyle |= this.appendPadding(styleBuffer, tp, null);
            } else {
                addedToStyle |= this.appendPadding(styleBuffer, box.getTopPadding(), "top");
                addedToStyle |= this.appendPadding(styleBuffer, box.getLeftPadding(), "left");
                addedToStyle |= this.appendPadding(styleBuffer, box.getBottomPadding(), "bottom");
                addedToStyle |= this.appendPadding(styleBuffer, box.getRightPadding(), "right");
            }
        }
        return addedToStyle;
    }

    protected int getInsideBorderOffset(float borderWidth, boolean small) {
        int intBorderWidth = (int)borderWidth;
        if (0.0f < borderWidth && borderWidth < 1.0f) {
            intBorderWidth = 1;
        }
        return intBorderWidth / 2 + (small ? 0 : intBorderWidth % 2);
    }

    protected void appendSizeStyle(JRPrintElement element, JRBoxContainer boxContainer, StringBuffer styleBuffer) {
        JRLineBox box;
        int widthDiff = 0;
        int heightDiff = 0;
        JRLineBox jRLineBox = box = boxContainer == null ? null : boxContainer.getLineBox();
        if (box != null) {
            widthDiff = box.getLeftPadding() + box.getRightPadding() + this.getInsideBorderOffset(box.getLeftPen().getLineWidth().floatValue(), false) + this.getInsideBorderOffset(box.getRightPen().getLineWidth().floatValue(), true);
            heightDiff = box.getTopPadding() + box.getBottomPadding() + this.getInsideBorderOffset(box.getTopPen().getLineWidth().floatValue(), false) + this.getInsideBorderOffset(box.getBottomPen().getLineWidth().floatValue(), true);
        }
        int width = element.getWidth() - widthDiff;
        int height = element.getHeight() - heightDiff;
        this.appendSizeStyle(width < 0 ? 0 : width, height < 0 ? 0 : height, styleBuffer);
    }

    protected void appendSizeStyle(JRPrintElement element, JRPen pen, StringBuffer styleBuffer) {
        int diff = 0;
        if (pen != null) {
            diff = this.getInsideBorderOffset(pen.getLineWidth().floatValue(), false) + this.getInsideBorderOffset(pen.getLineWidth().floatValue(), true);
        }
        this.appendSizeStyle(element.getWidth() - diff, element.getHeight() - diff, styleBuffer);
    }

    protected void appendSizeStyle(int width, int height, StringBuffer styleBuffer) {
        styleBuffer.append("width:");
        styleBuffer.append(this.toSizeUnit(width));
        styleBuffer.append(";");
        styleBuffer.append("height:");
        styleBuffer.append(this.toSizeUnit(height));
        styleBuffer.append(";");
    }

    protected void appendPositionStyle(JRPrintElement element, JRBoxContainer boxContainer, StringBuffer styleBuffer) {
        JRLineBox box;
        int leftOffset = 0;
        int topOffset = 0;
        JRLineBox jRLineBox = box = boxContainer == null ? null : boxContainer.getLineBox();
        if (box != null) {
            leftOffset = this.getInsideBorderOffset(box.getLeftPen().getLineWidth().floatValue(), true);
            topOffset = this.getInsideBorderOffset(box.getTopPen().getLineWidth().floatValue(), true);
        }
        FrameInfo frameInfo = this.frameInfoStack.size() == 0 ? null : this.frameInfoStack.get(this.frameInfoStack.size() - 1);
        this.appendPositionStyle(element.getX() - leftOffset - (frameInfo == null ? this.leftLimit : frameInfo.leftInsideBorderOffset), element.getY() - topOffset - (frameInfo == null ? this.topLimit : frameInfo.topInsideBorderOffset), styleBuffer);
    }

    protected void appendPositionStyle(JRPrintElement element, JRPen pen, StringBuffer styleBuffer) {
        int offset = 0;
        if (pen != null) {
            offset = this.getInsideBorderOffset(pen.getLineWidth().floatValue(), true);
        }
        FrameInfo frameInfo = this.frameInfoStack.size() == 0 ? null : this.frameInfoStack.get(this.frameInfoStack.size() - 1);
        this.appendPositionStyle(element.getX() - offset - (frameInfo == null ? this.leftLimit : frameInfo.leftInsideBorderOffset), element.getY() - offset - (frameInfo == null ? this.topLimit : frameInfo.topInsideBorderOffset), styleBuffer);
    }

    protected void appendPositionStyle(int x, int y, StringBuffer styleBuffer) {
        styleBuffer.append("position:absolute;");
        styleBuffer.append("left:");
        styleBuffer.append(this.toSizeUnit(x));
        styleBuffer.append(";");
        styleBuffer.append("top:");
        styleBuffer.append(this.toSizeUnit(y));
        styleBuffer.append(";");
    }

    protected void appendBackcolorStyle(JRPrintElement element, StringBuffer styleBuffer) {
        if (element.getModeValue() == ModeEnum.OPAQUE) {
            styleBuffer.append("background-color: ");
            styleBuffer.append(JRColorUtil.getCssColor(element.getBackcolor()));
            styleBuffer.append("; ");
        }
    }

    protected void exportImage(JRPrintImage image) throws JRException, IOException {
        Renderable renderer;
        this.writer.write("<span");
        this.appendId(image);
        float xAlignFactor = 0.0f;
        switch (image.getHorizontalAlignmentValue()) {
            case RIGHT: {
                xAlignFactor = 1.0f;
                break;
            }
            case CENTER: {
                xAlignFactor = 0.5f;
                break;
            }
            default: {
                xAlignFactor = 0.0f;
            }
        }
        float yAlignFactor = 0.0f;
        switch (image.getVerticalAlignmentValue()) {
            case BOTTOM: {
                yAlignFactor = 1.0f;
                break;
            }
            case MIDDLE: {
                yAlignFactor = 0.5f;
                break;
            }
            default: {
                yAlignFactor = 0.0f;
            }
        }
        StringBuffer styleBuffer = new StringBuffer();
        this.appendPositionStyle((JRPrintElement)image, image, styleBuffer);
        this.appendSizeStyle((JRPrintElement)image, image, styleBuffer);
        this.appendBackcolorStyle(image, styleBuffer);
        boolean addedToStyle = this.appendBorderStyle(image.getLineBox(), styleBuffer);
        if (!addedToStyle) {
            this.appendPen(styleBuffer, image.getLinePen(), null);
        }
        if (styleBuffer.length() > 0) {
            this.writer.write(" style=\"");
            this.writer.write(styleBuffer.toString());
            this.writer.write("\"");
        }
        this.writer.write(">");
        if (image.getAnchorName() != null) {
            this.writer.write("<a name=\"");
            this.writer.write(image.getAnchorName());
            this.writer.write("\"></a>");
        }
        Renderable originalRenderer = renderer = image.getRenderable();
        boolean imageMapRenderer = renderer != null && renderer instanceof ImageMapRenderable && ((ImageMapRenderable)renderer).hasImageAreaHyperlinks();
        boolean hasHyperlinks = false;
        if (renderer != null) {
            int availableImageHeight;
            if (imageMapRenderer) {
                hasHyperlinks = true;
                this.hyperlinkStarted = false;
            } else {
                hasHyperlinks = this.startHyperlink(image);
            }
            this.writer.write("<img");
            String imagePath = null;
            String imageMapName = null;
            List<JRPrintImageAreaHyperlink> imageMapAreas = null;
            ScaleImageEnum scaleImage = image.getScaleImageValue();
            if (renderer != null) {
                if (renderer.getTypeValue() == RenderableTypeEnum.IMAGE && this.rendererToImagePathMap.containsKey(renderer.getId())) {
                    imagePath = this.rendererToImagePathMap.get(renderer.getId());
                } else {
                    if (image.isLazy()) {
                        imagePath = ((JRImageRenderer)renderer).getImageLocation();
                    } else {
                        HtmlResourceHandler imageHandler;
                        HtmlResourceHandler htmlResourceHandler = imageHandler = this.getImageHandler() == null ? ((HtmlExporterOutput)this.getExporterOutput()).getImageHandler() : this.getImageHandler();
                        if (imageHandler != null) {
                            JRPrintElementIndex imageIndex = this.getElementIndex();
                            String imageName = JRXhtmlExporter.getImageName(imageIndex);
                            if (renderer.getTypeValue() == RenderableTypeEnum.SVG) {
                                renderer = new JRWrappingSvgRenderer(renderer, (Dimension2D)new Dimension(image.getWidth(), image.getHeight()), ModeEnum.OPAQUE == image.getModeValue() ? image.getBackcolor() : null);
                            }
                            byte[] imageData = renderer.getImageData(this.jasperReportsContext);
                            if (imageHandler != null) {
                                imageHandler.handleResource(imageName, imageData);
                                imagePath = imageHandler.getResourcePath(imageName);
                            }
                        }
                    }
                    this.rendererToImagePathMap.put(renderer.getId(), imagePath);
                }
                if (imageMapRenderer) {
                    Rectangle renderingArea = new Rectangle(image.getWidth(), image.getHeight());
                    if (renderer.getTypeValue() == RenderableTypeEnum.IMAGE) {
                        imageMapName = this.imageMaps.get(new Pair<String, Rectangle>(renderer.getId(), renderingArea));
                    }
                    if (imageMapName == null) {
                        imageMapName = "map_" + this.getElementIndex().toString();
                        imageMapAreas = ((ImageMapRenderable)originalRenderer).getImageAreaHyperlinks(renderingArea);
                        if (renderer.getTypeValue() == RenderableTypeEnum.IMAGE) {
                            this.imageMaps.put(new Pair<String, Rectangle>(renderer.getId(), renderingArea), imageMapName);
                        }
                    }
                }
            }
            this.writer.write(" src=\"");
            if (imagePath != null) {
                this.writer.write(imagePath);
            }
            this.writer.write("\"");
            int availableImageWidth = image.getWidth() - image.getLineBox().getLeftPadding() - image.getLineBox().getRightPadding();
            if (availableImageWidth < 0) {
                availableImageWidth = 0;
            }
            if ((availableImageHeight = image.getHeight() - image.getLineBox().getTopPadding() - image.getLineBox().getBottomPadding()) < 0) {
                availableImageHeight = 0;
            }
            switch (scaleImage) {
                case FILL_FRAME: {
                    int leftDiff = 0;
                    int topDiff = 0;
                    int widthDiff = 0;
                    int heightDiff = 0;
                    JRLineBox box = image.getLineBox();
                    if (box != null) {
                        leftDiff = box.getLeftPadding();
                        topDiff = box.getTopPadding();
                        widthDiff = this.getInsideBorderOffset(box.getLeftPen().getLineWidth().floatValue(), false) + this.getInsideBorderOffset(box.getRightPen().getLineWidth().floatValue(), true);
                        heightDiff = this.getInsideBorderOffset(box.getTopPen().getLineWidth().floatValue(), false) + this.getInsideBorderOffset(box.getBottomPen().getLineWidth().floatValue(), true);
                    }
                    this.writer.write(" style=\"position:absolute;left:");
                    this.writer.write(this.toSizeUnit(leftDiff));
                    this.writer.write(";top:");
                    this.writer.write(this.toSizeUnit(topDiff));
                    this.writer.write(";width:");
                    this.writer.write(this.toSizeUnit(availableImageWidth - widthDiff));
                    this.writer.write(";height:");
                    this.writer.write(this.toSizeUnit(availableImageHeight - heightDiff));
                    this.writer.write("\"");
                    break;
                }
                case CLIP: {
                    double normalWidth = availableImageWidth;
                    double normalHeight = availableImageHeight;
                    if (!image.isLazy()) {
                        Dimension2D dimension;
                        Renderable tmpRenderer = RenderableUtil.getInstance(this.jasperReportsContext).getOnErrorRendererForDimension(renderer, image.getOnErrorTypeValue());
                        Dimension2D dimension2D = dimension = tmpRenderer == null ? null : tmpRenderer.getDimension(this.jasperReportsContext);
                        if (tmpRenderer == renderer && dimension != null) {
                            normalWidth = dimension.getWidth();
                            normalHeight = dimension.getHeight();
                        }
                    }
                    int leftDiff = 0;
                    int topDiff = 0;
                    int widthDiff = 0;
                    int heightDiff = 0;
                    JRLineBox box = image.getLineBox();
                    if (box != null) {
                        leftDiff = box.getLeftPadding();
                        topDiff = box.getTopPadding();
                        widthDiff = this.getInsideBorderOffset(box.getLeftPen().getLineWidth().floatValue(), false) + this.getInsideBorderOffset(box.getRightPen().getLineWidth().floatValue(), true);
                        heightDiff = this.getInsideBorderOffset(box.getTopPen().getLineWidth().floatValue(), false) + this.getInsideBorderOffset(box.getBottomPen().getLineWidth().floatValue(), true);
                    }
                    this.writer.write(" style=\"position:absolute;left:");
                    this.writer.write(this.toSizeUnit((int)((double)leftDiff + (double)xAlignFactor * ((double)(availableImageWidth - widthDiff) - normalWidth))));
                    this.writer.write(";top:");
                    this.writer.write(this.toSizeUnit((int)((double)topDiff + (double)yAlignFactor * ((double)(availableImageHeight - heightDiff) - normalHeight))));
                    this.writer.write(";width:");
                    this.writer.write(this.toSizeUnit((int)normalWidth));
                    this.writer.write(";height:");
                    this.writer.write(this.toSizeUnit((int)normalHeight));
                    this.writer.write(";clip:rect(");
                    this.writer.write(this.toSizeUnit((int)((double)yAlignFactor * (normalHeight - (double)availableImageHeight + (double)heightDiff))));
                    this.writer.write(",");
                    this.writer.write(this.toSizeUnit((int)((double)xAlignFactor * normalWidth + (double)((1.0f - xAlignFactor) * (float)(availableImageWidth - widthDiff)))));
                    this.writer.write(",");
                    this.writer.write(this.toSizeUnit((int)((double)yAlignFactor * normalHeight + (double)((1.0f - yAlignFactor) * (float)(availableImageHeight - heightDiff)))));
                    this.writer.write(",");
                    this.writer.write(this.toSizeUnit((int)((double)xAlignFactor * (normalWidth - (double)availableImageWidth + (double)widthDiff))));
                    this.writer.write(")\"");
                    break;
                }
                default: {
                    double normalWidth = availableImageWidth;
                    double normalHeight = availableImageHeight;
                    if (!image.isLazy()) {
                        Dimension2D dimension;
                        Renderable tmpRenderer = RenderableUtil.getInstance(this.jasperReportsContext).getOnErrorRendererForDimension(renderer, image.getOnErrorTypeValue());
                        Dimension2D dimension2D = dimension = tmpRenderer == null ? null : tmpRenderer.getDimension(this.jasperReportsContext);
                        if (tmpRenderer == renderer && dimension != null) {
                            normalWidth = dimension.getWidth();
                            normalHeight = dimension.getHeight();
                        }
                    }
                    int leftDiff = 0;
                    int topDiff = 0;
                    int widthDiff = 0;
                    int heightDiff = 0;
                    JRLineBox box = image.getLineBox();
                    if (box != null) {
                        leftDiff = box.getLeftPadding();
                        topDiff = box.getTopPadding();
                        widthDiff = this.getInsideBorderOffset(box.getLeftPen().getLineWidth().floatValue(), false) + this.getInsideBorderOffset(box.getRightPen().getLineWidth().floatValue(), true);
                        heightDiff = this.getInsideBorderOffset(box.getTopPen().getLineWidth().floatValue(), false) + this.getInsideBorderOffset(box.getBottomPen().getLineWidth().floatValue(), true);
                    }
                    if (availableImageHeight <= 0) break;
                    double ratio = normalWidth / normalHeight;
                    if (ratio > (double)availableImageWidth / (double)availableImageHeight) {
                        this.writer.write(" style=\"position:absolute;left:");
                        this.writer.write(this.toSizeUnit(leftDiff));
                        this.writer.write(";top:");
                        this.writer.write(this.toSizeUnit((int)((double)topDiff + (double)yAlignFactor * ((double)(availableImageHeight - heightDiff) - (double)(availableImageWidth - widthDiff) / ratio))));
                        this.writer.write(";width:");
                        this.writer.write(this.toSizeUnit(availableImageWidth - widthDiff));
                        this.writer.write("\"");
                        break;
                    }
                    this.writer.write(" style=\"position:absolute;left:");
                    this.writer.write(this.toSizeUnit((int)((double)leftDiff + (double)xAlignFactor * ((double)(availableImageWidth - widthDiff) - ratio * (double)(availableImageHeight - heightDiff)))));
                    this.writer.write(";top:");
                    this.writer.write(this.toSizeUnit(topDiff));
                    this.writer.write(";height:");
                    this.writer.write(this.toSizeUnit(availableImageHeight - heightDiff));
                    this.writer.write("\"");
                }
            }
            if (imageMapName != null) {
                this.writer.write(" usemap=\"#" + imageMapName + "\"");
            }
            this.writer.write(" alt=\"\"");
            if (hasHyperlinks) {
                this.writer.write(" border=\"0\"");
            }
            if (image.getHyperlinkTooltip() != null) {
                this.writer.write(" title=\"");
                this.writer.write(JRStringUtil.xmlEncode(image.getHyperlinkTooltip()));
                this.writer.write("\"");
            }
            this.writer.write("/>");
            this.endHyperlink();
            if (imageMapAreas != null) {
                this.writer.write("\n");
                this.writeImageMap(imageMapName, image, imageMapAreas);
            }
        }
        this.writer.write("</span>\n");
    }

    protected JRPrintElementIndex getElementIndex() {
        StringBuffer sbuffer = new StringBuffer();
        int i = 0;
        while (i < this.frameInfoStack.size()) {
            FrameInfo frameInfo = this.frameInfoStack.get(i);
            Integer frameIndex = frameInfo.elementIndex;
            sbuffer.append(frameIndex).append("_");
            ++i;
        }
        JRPrintElementIndex imageIndex = new JRPrintElementIndex(this.reportIndex, this.pageIndex, sbuffer.append(this.elementIndex).toString());
        return imageIndex;
    }

    protected void writeImageMap(String imageMapName, JRPrintImage image, List<JRPrintImageAreaHyperlink> imageMapAreas) throws IOException {
        this.writer.write("<map name=\"" + imageMapName + "\">\n");
        ListIterator<JRPrintImageAreaHyperlink> it = imageMapAreas.listIterator(imageMapAreas.size());
        while (it.hasPrevious()) {
            JRPrintImageAreaHyperlink areaHyperlink = it.previous();
            JRPrintImageArea area = areaHyperlink.getArea();
            this.writer.write("  <area shape=\"" + JRPrintImageArea.getHtmlShape(area.getShape()) + "\"");
            this.writeImageAreaCoordinates(area.getCoordinates());
            this.writeImageAreaHyperlink(areaHyperlink.getHyperlink());
            this.writer.write("/>\n");
        }
        if (image.getHyperlinkTypeValue() != HyperlinkTypeEnum.NONE) {
            this.writer.write("  <area shape=\"default\"");
            int[] nArray = new int[4];
            nArray[2] = image.getWidth();
            nArray[3] = image.getHeight();
            this.writeImageAreaCoordinates(nArray);
            this.writeImageAreaHyperlink(image);
            this.writer.write("/>\n");
        }
        this.writer.write("</map>\n");
    }

    protected void writeImageAreaCoordinates(int[] coords) throws IOException {
        if (coords != null && coords.length > 0) {
            StringBuffer coordsEnum = new StringBuffer(coords.length * 4);
            coordsEnum.append(this.toZoom(coords[0]));
            int i = 1;
            while (i < coords.length) {
                coordsEnum.append(',');
                coordsEnum.append(this.toZoom(coords[i]));
                ++i;
            }
            this.writer.write(" coords=\"" + coordsEnum + "\"");
        }
    }

    protected void writeImageAreaHyperlink(JRPrintHyperlink hyperlink) throws IOException {
        String href = this.getHyperlinkURL(hyperlink);
        if (href == null) {
            this.writer.write(" nohref=\"nohref\"");
        } else {
            this.writer.write(" href=\"" + href + "\"");
            String target = this.getHyperlinkTarget(hyperlink);
            if (target != null) {
                this.writer.write(" target=\"");
                this.writer.write(target);
                this.writer.write("\"");
            }
        }
        if (hyperlink.getHyperlinkTooltip() != null) {
            this.writer.write(" title=\"");
            this.writer.write(JRStringUtil.xmlEncode(hyperlink.getHyperlinkTooltip()));
            this.writer.write("\"");
        }
    }

    private boolean appendPadding(StringBuffer sb, Integer padding, String side) {
        boolean addedToStyle = false;
        if (padding > 0) {
            sb.append("padding");
            if (side != null) {
                sb.append("-");
                sb.append(side);
            }
            sb.append(": ");
            sb.append(this.toSizeUnit(padding));
            sb.append("; ");
            addedToStyle = true;
        }
        return addedToStyle;
    }

    private boolean appendPen(StringBuffer sb, JRPen pen, String side) {
        boolean addedToStyle = false;
        float borderWidth = pen.getLineWidth().floatValue();
        if (0.0f < borderWidth && borderWidth < 1.0f) {
            borderWidth = 1.0f;
        }
        String borderStyle = null;
        switch (pen.getLineStyleValue()) {
            case DOUBLE: {
                borderStyle = "double";
                break;
            }
            case DOTTED: {
                borderStyle = "dotted";
                break;
            }
            case DASHED: {
                borderStyle = "dashed";
                break;
            }
            default: {
                borderStyle = "solid";
            }
        }
        if (borderWidth > 0.0f) {
            sb.append("border");
            if (side != null) {
                sb.append("-");
                sb.append(side);
            }
            sb.append(": ");
            sb.append(this.toSizeUnit((int)borderWidth));
            sb.append(" ");
            sb.append(borderStyle);
            sb.append(" ");
            sb.append(JRColorUtil.getCssColor(pen.getLineColor()));
            sb.append("; ");
            addedToStyle = true;
        }
        return addedToStyle;
    }

    private void appendId(JRPrintElement element) throws IOException {
        String dataAttr = this.getDataAttributes(element);
        if (dataAttr != null) {
            this.writer.write(dataAttr);
        }
    }

    public String getDataAttributes(JRPrintElement element) {
        String cellId;
        String columnUuid;
        String clazz;
        StringBuffer sbuffer = new StringBuffer();
        String id = this.getPropertiesUtil().getProperty(element, "net.sf.jasperreports.export.html.id");
        if (id != null) {
            sbuffer.append(" id=\"" + id + "\"");
        }
        if ((clazz = this.getPropertiesUtil().getProperty(element, "net.sf.jasperreports.export.html.class")) != null) {
            sbuffer.append(" class=\"" + clazz + "\"");
        }
        if ((columnUuid = this.getPropertiesUtil().getProperty(element, "net.sf.jasperreports.export.headertoolbar.columnUUID")) != null) {
            sbuffer.append(" data-coluuid=\"" + columnUuid + "\"");
        }
        if ((cellId = this.getPropertiesUtil().getProperty(element, "net.sf.jasperreports.export.headertoolbar.cellID")) != null) {
            sbuffer.append(" data-cellid=\"" + cellId + "\"");
        }
        return sbuffer.length() > 0 ? sbuffer.toString() : null;
    }

    private void setPageLimits(List<JRPrintElement> elements) throws IOException, JRException {
        if (elements != null && elements.size() > 0) {
            int i = 0;
            while (i < elements.size()) {
                this.elementIndex = i;
                JRPrintElement element = elements.get(i);
                if (this.filter == null || this.filter.isToExport(element)) {
                    this.topLimit = element.getY() < this.topLimit ? element.getY() : this.topLimit;
                    this.leftLimit = element.getX() < this.leftLimit ? element.getX() : this.leftLimit;
                    this.rightLimit = element.getX() + element.getWidth() > this.rightLimit ? element.getX() + element.getWidth() : this.rightLimit;
                    this.bottomLimit = element.getY() + element.getHeight() > this.bottomLimit ? element.getY() + element.getHeight() : this.bottomLimit;
                }
                ++i;
            }
        }
    }

    public void exportFrame(JRPrintFrame frame) throws IOException, JRException {
        this.writer.write("<div");
        this.appendId(frame);
        StringBuffer styleBuffer = new StringBuffer();
        this.appendPositionStyle((JRPrintElement)frame, frame, styleBuffer);
        this.appendSizeStyle((JRPrintElement)frame, frame, styleBuffer);
        this.appendBackcolorStyle(frame, styleBuffer);
        this.appendBorderStyle(frame.getLineBox(), styleBuffer);
        if (styleBuffer.length() > 0) {
            this.writer.write(" style=\"");
            this.writer.write(styleBuffer.toString());
            this.writer.write("\"");
        }
        if (frame.getPropertiesMap() != null && frame.getPropertiesMap().containsProperty("net.sf.jasperreports.export.headertoolbar.tableUUID")) {
            this.writer.write(" data-uuid=\"");
            this.writer.write(frame.getPropertiesMap().getProperty("net.sf.jasperreports.export.headertoolbar.tableUUID"));
            this.writer.write("\"");
            this.writer.write(" class=\"jrtableframe\"");
        }
        this.writer.write(">\n");
        FrameInfo frameInfo = new FrameInfo();
        frameInfo.elementIndex = this.elementIndex;
        JRLineBox box = frame.getLineBox();
        if (box != null) {
            frameInfo.leftInsideBorderOffset = -box.getLeftPadding().intValue() + this.getInsideBorderOffset(box.getLeftPen().getLineWidth().floatValue(), false);
            frameInfo.topInsideBorderOffset = -box.getTopPadding().intValue() + this.getInsideBorderOffset(box.getTopPen().getLineWidth().floatValue(), false);
        }
        this.frameInfoStack.add(frameInfo);
        this.exportElements(frame.getElements());
        this.frameInfoStack.remove(this.frameInfoStack.size() - 1);
        this.writer.write("</div>\n");
    }

    protected void exportGenericElement(JRGenericPrintElement element) throws IOException {
        String htmlFragment;
        GenericElementHtmlHandler handler = (GenericElementHtmlHandler)GenericElementHandlerEnviroment.getInstance(this.getJasperReportsContext()).getElementHandler(element.getGenericType(), XHTML_EXPORTER_KEY);
        if (handler == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("No XHTML generic element handler for " + element.getGenericType()));
            }
        } else if (handler.toExport(element) && (htmlFragment = handler.getHtmlFragment((JRHtmlExporterContext)this.exporterContext, element)) != null) {
            this.writer.write(htmlFragment);
        }
    }

    public Map<JRExporterParameter, Object> getExportParameters() {
        return this.parameters;
    }

    @Override
    public String getExporterPropertiesPrefix() {
        return XHTML_EXPORTER_PROPERTIES_PREFIX;
    }

    public JasperPrint getExportedReport() {
        return this.jasperPrint;
    }

    public String toSizeUnit(float size) {
        Number number = Float.valueOf(this.toZoom(size));
        if ((float)((Number)number).intValue() == ((Number)number).floatValue()) {
            number = ((Number)number).intValue();
        }
        return String.valueOf(String.valueOf(number)) + ((HtmlReportConfiguration)this.getCurrentItemConfiguration()).getSizeUnit().getName();
    }

    public String toSizeUnit(int size) {
        return this.toSizeUnit((float)size);
    }

    public float toZoom(float size) {
        float zoom = 1.0f;
        Float zoomRatio = ((HtmlReportConfiguration)this.getCurrentItemConfiguration()).getZoomRatio();
        if (zoomRatio != null && (zoom = zoomRatio.floatValue()) <= 0.0f) {
            throw new JRRuntimeException("Invalid zoom ratio : " + zoom);
        }
        return zoom * size;
    }

    public int toZoom(int size) {
        return (int)this.toZoom((float)size);
    }

    @Override
    protected JRStyledText getStyledText(JRPrintText textElement, boolean setBackcolor) {
        short[] lineBreakOffsets;
        JRStyledText styledText = super.getStyledText(textElement, setBackcolor);
        if (styledText != null && (lineBreakOffsets = textElement.getLineBreakOffsets()) != null && lineBreakOffsets.length > 0) {
            styledText = styledText.cloneText();
            styledText.insert("\n", lineBreakOffsets);
        }
        return styledText;
    }

    @Override
    public String getExporterKey() {
        return XHTML_EXPORTER_KEY;
    }

    static /* synthetic */ int[] $SWITCH_TABLE$net$sf$jasperreports$engine$type$HyperlinkTargetEnum() {
        if ($SWITCH_TABLE$net$sf$jasperreports$engine$type$HyperlinkTargetEnum != null) {
            return $SWITCH_TABLE$net$sf$jasperreports$engine$type$HyperlinkTargetEnum;
        }
        int[] nArray = new int[HyperlinkTargetEnum.values().length];
        try {
            nArray[HyperlinkTargetEnum.BLANK.ordinal()] = 3;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[HyperlinkTargetEnum.CUSTOM.ordinal()] = 6;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[HyperlinkTargetEnum.NONE.ordinal()] = 1;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[HyperlinkTargetEnum.PARENT.ordinal()] = 4;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[HyperlinkTargetEnum.SELF.ordinal()] = 2;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[HyperlinkTargetEnum.TOP.ordinal()] = 5;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        $SWITCH_TABLE$net$sf$jasperreports$engine$type$HyperlinkTargetEnum = nArray;
        return nArray;
    }

    protected class ExporterContext
    extends JRAbstractExporter.BaseExporterContext
    implements JRHtmlExporterContext {
        protected ExporterContext() {
        }

        @Override
        public String getExportPropertiesPrefix() {
            return JRXhtmlExporter.XHTML_EXPORTER_PROPERTIES_PREFIX;
        }

        @Override
        public String getHyperlinkURL(JRPrintHyperlink link) {
            return JRXhtmlExporter.this.getHyperlinkURL(link);
        }
    }

    private static class FrameInfo {
        protected int elementIndex;
        protected int leftInsideBorderOffset;
        protected int topInsideBorderOffset;

        private FrameInfo() {
        }
    }
}

