/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.crosstabs.interactive;

import net.sf.jasperreports.crosstabs.JRCrosstabColumnGroup;
import net.sf.jasperreports.crosstabs.JRCrosstabRowGroup;
import net.sf.jasperreports.crosstabs.design.JRDesignCrosstab;
import net.sf.jasperreports.crosstabs.design.JRDesignCrosstabBucket;
import net.sf.jasperreports.crosstabs.design.JRDesignCrosstabDataset;
import net.sf.jasperreports.engine.analytics.dataset.BucketOrder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CrosstabOrderAttributes {
    private static final Log log = LogFactory.getLog(CrosstabOrderAttributes.class);
    private JRDesignCrosstab crosstab;
    private boolean dataPreSorted;
    private BucketOrder[] rowGroupOrders;
    private BucketOrder[] colGroupOrders;
    private String orderByColumnProp;

    public CrosstabOrderAttributes(JRDesignCrosstab crosstab) {
        this.crosstab = crosstab;
        this.dataPreSorted = crosstab.getDataset().isDataPreSorted();
        JRCrosstabRowGroup[] rowGroups = crosstab.getRowGroups();
        this.rowGroupOrders = new BucketOrder[rowGroups.length];
        int i = 0;
        while (i < rowGroups.length) {
            this.rowGroupOrders[i] = rowGroups[i].getBucket().getOrder();
            ++i;
        }
        JRCrosstabColumnGroup[] colGroups = crosstab.getColumnGroups();
        this.colGroupOrders = new BucketOrder[colGroups.length];
        int i2 = 0;
        while (i2 < colGroups.length) {
            this.colGroupOrders[i2] = colGroups[i2].getBucket().getOrder();
            ++i2;
        }
        this.orderByColumnProp = crosstab.getPropertiesMap().getProperty("net.sf.jasperreports.crosstab.order.by.column");
        if (log.isDebugEnabled()) {
            log.debug((Object)("crosstab " + crosstab.getUUID() + " has order attributes " + this.toString()));
        }
    }

    public void prepareSorting() {
        if (this.dataPreSorted) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("crosstab " + this.crosstab.getUUID() + " has the presorted flag set, converting to order NONE"));
            }
            ((JRDesignCrosstabDataset)this.crosstab.getDataset()).setDataPreSorted(false);
            JRCrosstabRowGroup[] rowGroups = this.crosstab.getRowGroups();
            int i = 0;
            while (i < rowGroups.length) {
                ((JRDesignCrosstabBucket)rowGroups[i].getBucket()).setOrder(BucketOrder.NONE);
                ++i;
            }
            JRCrosstabColumnGroup[] colGroups = this.crosstab.getColumnGroups();
            int i2 = 0;
            while (i2 < colGroups.length) {
                ((JRDesignCrosstabBucket)colGroups[i2].getBucket()).setOrder(BucketOrder.NONE);
                ++i2;
            }
        }
    }

    public void restore() {
        if (log.isDebugEnabled()) {
            log.debug((Object)("restoring crosstab " + this.crosstab.getUUID() + " order attributes"));
        }
        ((JRDesignCrosstabDataset)this.crosstab.getDataset()).setDataPreSorted(this.dataPreSorted);
        JRCrosstabRowGroup[] rowGroups = this.crosstab.getRowGroups();
        int i = 0;
        while (i < rowGroups.length) {
            ((JRDesignCrosstabBucket)rowGroups[i].getBucket()).setOrder(this.rowGroupOrders[i]);
            ++i;
        }
        JRCrosstabColumnGroup[] colGroups = this.crosstab.getColumnGroups();
        int i2 = 0;
        while (i2 < colGroups.length) {
            ((JRDesignCrosstabBucket)colGroups[i2].getBucket()).setOrder(this.colGroupOrders[i2]);
            ++i2;
        }
        this.crosstab.getPropertiesMap().setProperty("net.sf.jasperreports.crosstab.order.by.column", this.orderByColumnProp);
    }

    public String toString() {
        StringBuilder string = new StringBuilder();
        string.append("{").append(this.dataPreSorted).append(",[");
        int i = 0;
        while (i < this.rowGroupOrders.length) {
            string.append(this.rowGroupOrders[i].getName()).append(",");
            ++i;
        }
        string.append("],[");
        i = 0;
        while (i < this.colGroupOrders.length) {
            string.append(this.colGroupOrders[i].getName()).append(",");
            ++i;
        }
        string.append("],").append(this.orderByColumnProp).append("}");
        return string.toString();
    }
}

