/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.components.spiderchart;

import net.sf.jasperreports.charts.design.JRDesignCategorySeries;
import net.sf.jasperreports.charts.xml.JRCategorySeriesFactory;
import net.sf.jasperreports.components.charts.ChartSettings;
import net.sf.jasperreports.components.charts.ChartSettingsXmlFactory;
import net.sf.jasperreports.components.spiderchart.SpiderChartXmlFactory;
import net.sf.jasperreports.components.spiderchart.SpiderDataset;
import net.sf.jasperreports.components.spiderchart.SpiderDatasetXmlFactory;
import net.sf.jasperreports.components.spiderchart.SpiderPlot;
import net.sf.jasperreports.components.spiderchart.SpiderPlotXmlFactory;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.JRFont;
import net.sf.jasperreports.engine.component.XmlDigesterConfigurer;
import net.sf.jasperreports.engine.design.JRDesignExpression;
import net.sf.jasperreports.engine.xml.JRElementDatasetFactory;
import net.sf.jasperreports.engine.xml.JRExpressionFactory;
import net.sf.jasperreports.engine.xml.JRFontFactory;
import org.apache.commons.digester.Digester;

public class SpiderChartDigester
implements XmlDigesterConfigurer {
    @Override
    public void configureDigester(Digester digester) {
        SpiderChartDigester.addSpiderChartRules(digester);
    }

    public static void addSpiderChartRules(Digester digester) {
        String componentNamespace = digester.getRuleNamespaceURI();
        String jrNamespace = "http://jasperreports.sourceforge.net/jasperreports";
        String spiderChartPattern = "*/componentElement/spiderChart";
        digester.addFactoryCreate(spiderChartPattern, SpiderChartXmlFactory.class.getName());
        String chartSettingsPattern = String.valueOf(spiderChartPattern) + "/chartSettings";
        digester.addFactoryCreate(chartSettingsPattern, ChartSettingsXmlFactory.class.getName());
        digester.addSetNext(chartSettingsPattern, "setChartSettings", ChartSettings.class.getName());
        digester.setRuleNamespaceURI(jrNamespace);
        String chartTitlePattern = String.valueOf(chartSettingsPattern) + "/chartTitle";
        digester.addFactoryCreate(chartTitlePattern, ChartSettingsXmlFactory.ChartTitleFactory.class.getName());
        digester.addFactoryCreate(String.valueOf(chartTitlePattern) + "/font", JRFontFactory.ChartFontFactory.class.getName());
        digester.addSetNext(String.valueOf(chartTitlePattern) + "/font", "setTitleFont", JRFont.class.getName());
        digester.addFactoryCreate(String.valueOf(chartTitlePattern) + "/titleExpression", JRExpressionFactory.StringExpressionFactory.class);
        digester.addSetNext(String.valueOf(chartTitlePattern) + "/titleExpression", "setTitleExpression", JRDesignExpression.class.getName());
        digester.addCallMethod(String.valueOf(chartTitlePattern) + "/titleExpression", "setText", 0);
        String chartSubtitlePattern = String.valueOf(chartSettingsPattern) + "/chartSubtitle";
        digester.addFactoryCreate(chartSubtitlePattern, ChartSettingsXmlFactory.ChartSubtitleFactory.class.getName());
        digester.addFactoryCreate(String.valueOf(chartSubtitlePattern) + "/font", JRFontFactory.ChartFontFactory.class.getName());
        digester.addSetNext(String.valueOf(chartSubtitlePattern) + "/font", "setSubtitleFont", JRFont.class.getName());
        digester.addFactoryCreate(String.valueOf(chartSubtitlePattern) + "/subtitleExpression", JRExpressionFactory.StringExpressionFactory.class);
        digester.addSetNext(String.valueOf(chartSubtitlePattern) + "/subtitleExpression", "setSubtitleExpression", JRDesignExpression.class.getName());
        digester.addCallMethod(String.valueOf(chartSubtitlePattern) + "/subtitleExpression", "setText", 0);
        digester.addFactoryCreate(String.valueOf(chartSettingsPattern) + "/chartLegend", ChartSettingsXmlFactory.ChartLegendFactory.class.getName());
        digester.addFactoryCreate(String.valueOf(chartSettingsPattern) + "/chartLegend/font", JRFontFactory.ChartFontFactory.class.getName());
        digester.addSetNext(String.valueOf(chartSettingsPattern) + "/chartLegend/font", "setLegendFont", JRFont.class.getName());
        digester.setRuleNamespaceURI(componentNamespace);
        String spiderDatasetPattern = String.valueOf(spiderChartPattern) + "/spiderDataset";
        digester.addFactoryCreate(spiderDatasetPattern, SpiderDatasetXmlFactory.class.getName());
        digester.addSetNext(spiderDatasetPattern, "setDataset", SpiderDataset.class.getName());
        digester.setRuleNamespaceURI(jrNamespace);
        String datasetPattern = String.valueOf(spiderDatasetPattern) + "/dataset";
        digester.addFactoryCreate(datasetPattern, JRElementDatasetFactory.class.getName());
        String datasetIncrementWhenExpressionPath = String.valueOf(datasetPattern) + "incrementWhenExpression";
        digester.addFactoryCreate(datasetIncrementWhenExpressionPath, JRExpressionFactory.BooleanExpressionFactory.class.getName());
        digester.addSetNext(datasetIncrementWhenExpressionPath, "setIncrementWhenExpression", JRExpression.class.getName());
        digester.addCallMethod(datasetIncrementWhenExpressionPath, "setText", 0);
        String seriesPattern = String.valueOf(spiderDatasetPattern) + "/categorySeries";
        digester.addFactoryCreate(seriesPattern, JRCategorySeriesFactory.class.getName());
        digester.addSetNext(seriesPattern, "addCategorySeries", JRDesignCategorySeries.class.getName());
        digester.addFactoryCreate(String.valueOf(seriesPattern) + "/seriesExpression", JRExpressionFactory.ComparableExpressionFactory.class);
        digester.addSetNext(String.valueOf(seriesPattern) + "/seriesExpression", "setSeriesExpression", JRDesignExpression.class.getName());
        digester.addCallMethod(String.valueOf(seriesPattern) + "/seriesExpression", "setText", 0);
        digester.addFactoryCreate(String.valueOf(seriesPattern) + "/categoryExpression", JRExpressionFactory.ComparableExpressionFactory.class);
        digester.addSetNext(String.valueOf(seriesPattern) + "/categoryExpression", "setCategoryExpression", JRDesignExpression.class.getName());
        digester.addCallMethod(String.valueOf(seriesPattern) + "/categoryExpression", "setText", 0);
        digester.addFactoryCreate(String.valueOf(seriesPattern) + "/labelExpression", JRExpressionFactory.StringExpressionFactory.class);
        digester.addSetNext(String.valueOf(seriesPattern) + "/labelExpression", "setLabelExpression", JRDesignExpression.class.getName());
        digester.addCallMethod(String.valueOf(seriesPattern) + "/labelExpression", "setText", 0);
        digester.addFactoryCreate(String.valueOf(seriesPattern) + "/valueExpression", JRExpressionFactory.NumberExpressionFactory.class);
        digester.addSetNext(String.valueOf(seriesPattern) + "/valueExpression", "setValueExpression", JRDesignExpression.class.getName());
        digester.addCallMethod(String.valueOf(seriesPattern) + "/valueExpression", "setText", 0);
        digester.setRuleNamespaceURI(componentNamespace);
        String plotPattern = String.valueOf(spiderChartPattern) + "/spiderPlot";
        digester.addFactoryCreate(plotPattern, SpiderPlotXmlFactory.class.getName());
        digester.addSetNext(plotPattern, "setPlot", SpiderPlot.class.getName());
        digester.setRuleNamespaceURI(jrNamespace);
        String labelFontPattern = String.valueOf(plotPattern) + "/labelFont/font";
        digester.addFactoryCreate(labelFontPattern, JRFontFactory.ChartFontFactory.class.getName());
        digester.addSetNext(labelFontPattern, "setLabelFont", JRFont.class.getName());
        digester.setRuleNamespaceURI(componentNamespace);
        String maxValueExpressionPattern = String.valueOf(plotPattern) + "/maxValueExpression";
        digester.addFactoryCreate(maxValueExpressionPattern, JRExpressionFactory.DoubleExpressionFactory.class);
        digester.addSetNext(maxValueExpressionPattern, "setMaxValueExpression", JRDesignExpression.class.getName());
        digester.addCallMethod(maxValueExpressionPattern, "setText", 0);
    }
}

