/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.ant;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import net.sf.jasperreports.ant.JRBaseAntTask;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JasperExportManager;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.util.JRLoader;
import org.apache.tools.ant.AntClassLoader;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.types.Resource;
import org.apache.tools.ant.types.resources.FileResource;
import org.apache.tools.ant.util.FileNameMapper;
import org.apache.tools.ant.util.RegexpPatternMapper;
import org.apache.tools.ant.util.SourceFileScanner;

public class JRAntXmlExportTask
extends JRBaseAntTask {
    private Path src;
    private File destdir;
    private Path classpath;
    private Map<String, String> reportFilesMap;

    public void setSrcdir(Path srcdir) {
        if (this.src == null) {
            this.src = srcdir;
        } else {
            this.src.append(srcdir);
        }
    }

    public Path createSrc() {
        if (this.src == null) {
            this.src = new Path(this.getProject());
        }
        return this.src.createPath();
    }

    public void setDestdir(File destdir) {
        this.destdir = destdir;
    }

    public Path createClasspath() {
        if (this.classpath == null) {
            this.classpath = new Path(this.getProject());
        }
        return this.classpath.createPath();
    }

    public void execute() throws BuildException {
        this.checkParameters();
        this.reportFilesMap = new HashMap<String, String>();
        AntClassLoader classLoader = null;
        if (this.classpath != null) {
            this.jasperReportsContext.setProperty("net.sf.jasperreports.compiler.classpath", String.valueOf(this.classpath));
            ClassLoader parentClassLoader = ((Object)((Object)this)).getClass().getClassLoader();
            classLoader = new AntClassLoader(parentClassLoader, this.getProject(), this.classpath, true);
            classLoader.setThreadContextLoader();
        }
        try {
            this.scanSrc();
            this.export();
        }
        finally {
            if (classLoader != null) {
                classLoader.resetThreadContextLoader();
            }
        }
    }

    protected void checkParameters() throws BuildException {
        if (this.src == null || this.src.size() == 0) {
            throw new BuildException("The srcdir attribute must be set.", this.getLocation());
        }
        if (this.destdir != null && !this.destdir.isDirectory()) {
            throw new BuildException("The destination directory \"" + this.destdir + "\" does not exist " + "or is not a directory.", this.getLocation());
        }
    }

    protected void scanSrc() throws BuildException {
        for (Resource resource : this.src) {
            FileResource fileResource;
            FileResource fileResource2 = fileResource = resource instanceof FileResource ? (FileResource)resource : null;
            if (fileResource == null) continue;
            File file = fileResource.getFile();
            if (file.isDirectory()) {
                DirectoryScanner ds = this.getDirectoryScanner(file);
                String[] files = ds.getIncludedFiles();
                this.scanDir(file, this.destdir != null ? this.destdir : file, files);
                continue;
            }
            String[] files = new String[]{fileResource.getName()};
            this.scanDir(fileResource.getBaseDir(), this.destdir != null ? this.destdir : fileResource.getBaseDir(), files);
        }
    }

    protected void scanDir(File srcdir, File destdir, String[] files) {
        RegexpPatternMapper mapper = new RegexpPatternMapper();
        mapper.setFrom("^(.*)\\.(.*)$");
        mapper.setTo("\\1.jrpxml");
        SourceFileScanner scanner = new SourceFileScanner((Task)this);
        String[] newFiles = scanner.restrict(files, srcdir, destdir, (FileNameMapper)mapper);
        if (newFiles != null && newFiles.length > 0) {
            int i = 0;
            while (i < newFiles.length) {
                this.reportFilesMap.put(new File(srcdir, newFiles[i]).getAbsolutePath(), new File(destdir, mapper.mapFileName(newFiles[i])[0]).getAbsolutePath());
                ++i;
            }
        }
    }

    protected void export() throws BuildException {
        Set<String> files = this.reportFilesMap.keySet();
        if (files != null && files.size() > 0) {
            boolean isError = false;
            System.out.println("Exporting " + files.size() + " report files.");
            String srcFileName2 = null;
            String destFileName = null;
            File destFileParent = null;
            for (String srcFileName2 : files) {
                destFileName = this.reportFilesMap.get(srcFileName2);
                destFileParent = new File(destFileName).getParentFile();
                if (!destFileParent.exists()) {
                    destFileParent.mkdirs();
                }
                try {
                    System.out.print("File : " + srcFileName2 + " ... ");
                    JasperPrint jasperPrint = (JasperPrint)JRLoader.loadObjectFromFile(srcFileName2);
                    JasperExportManager.getInstance(this.jasperReportsContext).exportToXmlFile(jasperPrint, destFileName, false);
                    System.out.println("OK.");
                }
                catch (JRException e) {
                    System.out.println("FAILED.");
                    System.out.println("Error updating report design : " + srcFileName2);
                    e.printStackTrace(System.out);
                    isError = true;
                }
            }
            if (isError) {
                throw new BuildException("Errors were encountered when updating report designs.");
            }
        }
    }
}

