/*
 * Decompiled with CFR 0.152.
 */
package mondrian.rolap.aggmatcher;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import mondrian.olap.MondrianDef;
import mondrian.olap.Util;
import mondrian.rolap.RolapAggregator;
import mondrian.rolap.RolapStar;
import mondrian.rolap.aggmatcher.JdbcSchema;
import mondrian.rolap.sql.SqlQuery;
import org.apache.log4j.Logger;

public class AggGen {
    private static final Logger LOGGER = Logger.getLogger(AggGen.class);
    private final String cubeName;
    private final RolapStar star;
    private final RolapStar.Column[] columns;
    private final Map<RolapStar.Table, List<JdbcSchema.Table.Column.Usage>> collapsedColumnUsages = new HashMap<RolapStar.Table, List<JdbcSchema.Table.Column.Usage>>();
    private final Set<JdbcSchema.Table.Column.Usage> notLostColumnUsages = new HashSet<JdbcSchema.Table.Column.Usage>();
    private final List<JdbcSchema.Table.Column.Usage> measures = new ArrayList<JdbcSchema.Table.Column.Usage>();
    private boolean isReady;
    private static final String AGG_LOST_PREFIX = "agg_l_XXX_";
    private static final String AGG_COLLAPSED_PREFIX = "agg_c_XXX_";

    public AggGen(String cubeName, RolapStar star, RolapStar.Column[] columns) {
        this.cubeName = cubeName;
        this.star = star;
        this.columns = columns;
        this.init();
    }

    private Logger getLogger() {
        return LOGGER;
    }

    public boolean isReady() {
        return this.isReady;
    }

    protected RolapStar.Table getFactTable() {
        return this.star.getFactTable();
    }

    protected String getFactTableName() {
        return this.getFactTable().getAlias();
    }

    protected SqlQuery getSqlQuery() {
        return this.star.getSqlQuery();
    }

    protected String getFactCount() {
        return "fact_count";
    }

    protected JdbcSchema.Table getTable(JdbcSchema db, RolapStar.Table rt) {
        JdbcSchema.Table jt = this.getTable(db, rt.getAlias());
        return jt == null ? this.getTable(db, rt.getTableName()) : jt;
    }

    protected JdbcSchema.Table getTable(JdbcSchema db, String name) {
        return db.getTable(name);
    }

    protected JdbcSchema.Table.Column getColumn(JdbcSchema.Table table, String name) {
        return table.getColumn(name);
    }

    protected String getRolapStarColumnName(RolapStar.Column rColumn) {
        MondrianDef.Expression expr = rColumn.getExpression();
        if (expr instanceof MondrianDef.Column) {
            MondrianDef.Column cx = (MondrianDef.Column)expr;
            return cx.getColumnName();
        }
        return null;
    }

    protected void addForeignKeyToNotLostColumnUsages(JdbcSchema.Table.Column column) {
        JdbcSchema.Table.Column.Usage usage;
        String cname = column.getName();
        for (JdbcSchema.Table.Column.Usage usage2 : this.notLostColumnUsages) {
            JdbcSchema.Table.Column c = usage2.getColumn();
            if (!cname.equals(c.getName())) continue;
            return;
        }
        if (column.hasUsage(JdbcSchema.UsageType.FOREIGN_KEY)) {
            Iterator<JdbcSchema.Table.Column.Usage> it = column.getUsages(JdbcSchema.UsageType.FOREIGN_KEY);
            it.hasNext();
            usage = it.next();
        } else {
            usage = column.newUsage(JdbcSchema.UsageType.FOREIGN_KEY);
            usage.setSymbolicName(JdbcSchema.UsageType.FOREIGN_KEY.name());
        }
        this.notLostColumnUsages.add(usage);
    }

    private void init() {
        JdbcSchema db = JdbcSchema.makeDB(this.star.getDataSource());
        try {
            db.load();
        }
        catch (SQLException ex) {
            this.getLogger().error((Object)ex);
            return;
        }
        JdbcSchema.Table factTable = this.getTable(db, this.getFactTableName());
        if (factTable == null) {
            this.getLogger().warn((Object)("Init: No fact table with name \"" + this.getFactTableName() + "\""));
            return;
        }
        try {
            factTable.load();
        }
        catch (SQLException ex) {
            this.getLogger().error((Object)ex);
            return;
        }
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug((Object)("Init: RolapStar:" + Util.nl + this.getFactTable() + Util.nl + "FactTable:" + Util.nl + factTable));
        }
        for (RolapStar.Column column : this.columns) {
            MondrianDef.Expression left;
            RolapStar.Table table;
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug((Object)("Init: Column: " + column));
            }
            if ((table = column.getTable()).getParentTable() == null) {
                if (!this.addSpecialCollapsedColumn(db, column)) {
                    return;
                }
                MondrianDef.Expression expr = column.getExpression();
                if (!(expr instanceof MondrianDef.Column)) continue;
                MondrianDef.Column exprColumn = (MondrianDef.Column)expr;
                String name = exprColumn.getColumnName();
                JdbcSchema.Table.Column c = this.getColumn(factTable, name);
                if (c == null) {
                    this.getLogger().warn((Object)("Init: FactTable:" + this.getFactTableName() + Util.nl + "No Column with name \"" + name + "\""));
                    return;
                }
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug((Object)("  Jdbc Column: c=" + c));
                }
                this.addForeignKeyToNotLostColumnUsages(c);
                continue;
            }
            if (!this.addCollapsedColumn(db, column)) {
                return;
            }
            while (table.getParentTable().getParentTable() != null) {
                table = table.getParentTable();
            }
            RolapStar.Condition cond = table.getJoinCondition();
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug((Object)("  RolapStar.Condition: cond=" + cond));
            }
            if (!((left = cond.getLeft()) instanceof MondrianDef.Column)) continue;
            MondrianDef.Column leftColumn = (MondrianDef.Column)left;
            String name = leftColumn.getColumnName();
            JdbcSchema.Table.Column c = this.getColumn(factTable, name);
            if (c == null) {
                this.getLogger().warn((Object)("Init: FactTable:" + this.getFactTableName() + Util.nl + "No Column with name \"" + name + "\""));
                return;
            }
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug((Object)("  Jdbc Column: c=" + c));
            }
            this.addForeignKeyToNotLostColumnUsages(c);
        }
        for (RolapStar.Column rColumn : this.getFactTable().getColumns()) {
            String name = this.getRolapStarColumnName(rColumn);
            if (name == null) {
                this.getLogger().warn((Object)("Init: For fact table \"" + this.getFactTableName() + "\", could not get column name for RolapStar.Column: " + rColumn));
                return;
            }
            if (!(rColumn instanceof RolapStar.Measure)) {
                this.getLogger().warn((Object)("not a measure: " + name));
                continue;
            }
            RolapStar.Measure rMeasure = (RolapStar.Measure)rColumn;
            if (!rMeasure.getCubeName().equals(this.cubeName)) continue;
            RolapAggregator aggregator = rMeasure.getAggregator();
            JdbcSchema.Table.Column c = this.getColumn(factTable, name);
            if (c == null) {
                this.getLogger().warn((Object)("For RolapStar: \"" + this.getFactTable().getAlias() + "\" measure with name, " + name + ", is not a column name. " + "The measure's column name may be an expression" + " and currently AggGen does not handle expressions." + " You will have to add this measure to the" + " aggregate table definition by hand."));
                continue;
            }
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug((Object)("  Jdbc Column m=" + c));
            }
            JdbcSchema.Table.Column.Usage usage = null;
            if (c.hasUsage(JdbcSchema.UsageType.MEASURE)) {
                Iterator<JdbcSchema.Table.Column.Usage> uit = c.getUsages(JdbcSchema.UsageType.MEASURE);
                while (uit.hasNext()) {
                    JdbcSchema.Table.Column.Usage tmpUsage = uit.next();
                    if (tmpUsage.getAggregator() != aggregator || !tmpUsage.getSymbolicName().equals(rColumn.getName())) continue;
                    usage = tmpUsage;
                    break;
                }
            }
            if (usage == null) {
                usage = c.newUsage(JdbcSchema.UsageType.MEASURE);
                usage.setAggregator(aggregator);
                usage.setSymbolicName(rColumn.getName());
            }
            this.measures.add(usage);
        }
        this.isReady = true;
    }

    private boolean addSpecialCollapsedColumn(JdbcSchema db, RolapStar.Column rColumn) {
        JdbcSchema.Table.Column c;
        String rname = this.getRolapStarColumnName(rColumn);
        if (rname == null) {
            this.getLogger().warn((Object)("Adding Special Collapsed Column: For fact table \"" + this.getFactTableName() + "\", could not get column name for RolapStar.Column: " + rColumn));
            return false;
        }
        RolapStar.Table rt = rColumn.getTable();
        JdbcSchema.Table jt = this.getTable(db, rt);
        if (jt == null) {
            this.getLogger().warn((Object)("Adding Special Collapsed Column: For fact table \"" + this.getFactTableName() + "\", could not get jdbc schema table " + "for RolapStar.Table with alias \"" + rt.getAlias() + "\""));
            return false;
        }
        try {
            jt.load();
        }
        catch (SQLException ex) {
            this.getLogger().error((Object)ex);
            return false;
        }
        List<JdbcSchema.Table.Column.Usage> list = this.collapsedColumnUsages.get(rt);
        if (list == null) {
            list = new ArrayList<JdbcSchema.Table.Column.Usage>();
            this.collapsedColumnUsages.put(rt, list);
        }
        if ((c = this.getColumn(jt, rname)) == null) {
            this.getLogger().warn((Object)("Adding Special Collapsed Column: For fact table \"" + this.getFactTableName() + "\", could not get jdbc schema column " + "for RolapStar.Table with alias \"" + rt.getAlias() + "\" and column name \"" + rname + "\""));
            return false;
        }
        list.add(c.newUsage(JdbcSchema.UsageType.FOREIGN_KEY));
        RolapStar.Column prColumn = rColumn;
        while (prColumn.getParentColumn() != null) {
            rname = this.getRolapStarColumnName(prColumn = prColumn.getParentColumn());
            if (rname == null) {
                this.getLogger().warn((Object)("Adding Special Collapsed Column: For fact table \"" + this.getFactTableName() + "\", could not get parent column name" + "for RolapStar.Column \"" + prColumn + "\" for RolapStar.Table with alias \"" + rt.getAlias() + "\""));
                return false;
            }
            c = this.getColumn(jt, rname);
            if (c == null) {
                this.getLogger().warn((Object)("Can not find column: " + rname));
                break;
            }
            list.add(c.newUsage(JdbcSchema.UsageType.FOREIGN_KEY));
        }
        return true;
    }

    private boolean addCollapsedColumn(JdbcSchema db, RolapStar.Column rColumn) {
        List<JdbcSchema.Table.Column.Usage> l;
        String rname = this.getRolapStarColumnName(rColumn);
        if (rname == null) {
            this.getLogger().warn((Object)("Adding Collapsed Column: For fact table \"" + this.getFactTableName() + "\", could not get column name for RolapStar.Column: " + rColumn));
            return false;
        }
        RolapStar.Table rt = rColumn.getTable();
        JdbcSchema.Table jt = this.getTable(db, rt);
        if (jt == null) {
            this.getLogger().warn((Object)("Adding Collapsed Column: For fact table \"" + this.getFactTableName() + "\", could not get jdbc schema table " + "for RolapStar.Table with alias \"" + rt.getAlias() + "\""));
            return false;
        }
        try {
            jt.load();
        }
        catch (SQLException ex) {
            this.getLogger().error((Object)ex);
            return false;
        }
        try {
            jt.load();
        }
        catch (SQLException sqle) {
            this.getLogger().error((Object)sqle);
            return false;
        }
        ArrayList<JdbcSchema.Table.Column.Usage> list = new ArrayList<JdbcSchema.Table.Column.Usage>();
        for (RolapStar.Column rc : rt.getColumns()) {
            if (rc.isNameColumn()) continue;
            String name = this.getRolapStarColumnName(rc);
            if (name == null) {
                this.getLogger().warn((Object)("Adding Collapsed Column: For fact table \"" + this.getFactTableName() + "\", could not get column name" + " for RolapStar.Column \"" + rc + "\" for RolapStar.Table with alias \"" + rt.getAlias() + "\""));
                return false;
            }
            JdbcSchema.Table.Column c = this.getColumn(jt, name);
            if (c == null) {
                this.getLogger().warn((Object)("Can not find column: " + name));
                break;
            }
            JdbcSchema.Table.Column.Usage usage = c.newUsage(JdbcSchema.UsageType.FOREIGN_KEY);
            usage.usagePrefix = rc.getUsagePrefix();
            list.add(usage);
            if (!rname.equals(name)) continue;
            break;
        }
        if ((l = this.collapsedColumnUsages.get(rt)) == null || l.size() < list.size()) {
            this.collapsedColumnUsages.put(rt, list);
        }
        return true;
    }

    String makeLostAggregateTableName(String factTableName) {
        return AGG_LOST_PREFIX + factTableName;
    }

    String makeCollapsedAggregateTableName(String factTableName) {
        return AGG_COLLAPSED_PREFIX + factTableName;
    }

    public String createLost() {
        StringWriter sw = new StringWriter(512);
        PrintWriter pw = new PrintWriter(sw);
        String prefix = "    ";
        pw.print("CREATE TABLE ");
        pw.print(this.makeLostAggregateTableName(this.getFactTableName()));
        pw.println(" (");
        for (JdbcSchema.Table.Column.Usage usage : this.notLostColumnUsages) {
            this.addColumnCreate(pw, prefix, usage);
        }
        for (JdbcSchema.Table.Column.Usage usage : this.measures) {
            this.addColumnCreate(pw, prefix, usage);
        }
        pw.print(prefix);
        pw.print(this.getFactCount());
        pw.println(" INTEGER NOT NULL");
        pw.println(");");
        return sw.toString();
    }

    public String insertIntoLost() {
        JdbcSchema.Table.Column c;
        StringWriter sw = new StringWriter(512);
        PrintWriter pw = new PrintWriter(sw);
        String prefix = "    ";
        String factTableName = this.getFactTableName();
        SqlQuery sqlQuery = this.getSqlQuery();
        pw.print("INSERT INTO ");
        pw.print(this.makeLostAggregateTableName(this.getFactTableName()));
        pw.println(" (");
        for (JdbcSchema.Table.Column.Usage usage : this.notLostColumnUsages) {
            c = usage.getColumn();
            pw.print(prefix);
            pw.print(c.getName());
            pw.println(',');
        }
        for (JdbcSchema.Table.Column.Usage usage : this.measures) {
            c = usage.getColumn();
            pw.print(prefix);
            String name = this.getUsageName(usage);
            pw.print(name);
            pw.println(',');
        }
        pw.print(prefix);
        pw.print(this.getFactCount());
        pw.println(")");
        pw.println("SELECT");
        for (JdbcSchema.Table.Column.Usage usage : this.notLostColumnUsages) {
            c = usage.getColumn();
            pw.print(prefix);
            pw.print(sqlQuery.getDialect().quoteIdentifier(factTableName, c.getName()));
            pw.print(" AS ");
            pw.print(sqlQuery.getDialect().quoteIdentifier(c.getName()));
            pw.println(',');
        }
        for (JdbcSchema.Table.Column.Usage usage : this.measures) {
            c = usage.getColumn();
            RolapAggregator agg = usage.getAggregator();
            pw.print(prefix);
            pw.print(agg.getExpression(sqlQuery.getDialect().quoteIdentifier(factTableName, c.getName())));
            pw.print(" AS ");
            pw.print(sqlQuery.getDialect().quoteIdentifier(c.getName()));
            pw.println(',');
        }
        pw.print(prefix);
        pw.print("COUNT(*) AS ");
        pw.println(sqlQuery.getDialect().quoteIdentifier(this.getFactCount()));
        pw.println("FROM ");
        pw.print(prefix);
        pw.print(sqlQuery.getDialect().quoteIdentifier(factTableName));
        pw.print(" ");
        pw.println(sqlQuery.getDialect().quoteIdentifier(factTableName));
        pw.println("GROUP BY ");
        int k = 0;
        for (JdbcSchema.Table.Column.Usage notLostColumnUsage : this.notLostColumnUsages) {
            if (k++ > 0) {
                pw.println(",");
            }
            JdbcSchema.Table.Column.Usage usage = notLostColumnUsage;
            JdbcSchema.Table.Column c2 = usage.getColumn();
            pw.print(prefix);
            pw.print(sqlQuery.getDialect().quoteIdentifier(factTableName, c2.getName()));
        }
        pw.println(';');
        return sw.toString();
    }

    public String createCollapsed() {
        StringWriter sw = new StringWriter(512);
        PrintWriter pw = new PrintWriter(sw);
        String prefix = "    ";
        pw.print("CREATE TABLE ");
        pw.print(this.makeCollapsedAggregateTableName(this.getFactTableName()));
        pw.println(" (");
        for (List<JdbcSchema.Table.Column.Usage> list : this.collapsedColumnUsages.values()) {
            for (JdbcSchema.Table.Column.Usage usage : list) {
                this.addColumnCreate(pw, prefix, usage);
            }
        }
        for (JdbcSchema.Table.Column.Usage usage : this.measures) {
            this.addColumnCreate(pw, prefix, usage);
        }
        pw.print(prefix);
        pw.print(this.getFactCount());
        pw.println(" INTEGER NOT NULL");
        pw.println(");");
        return sw.toString();
    }

    /*
     * WARNING - void declaration
     */
    public String insertIntoCollapsed() {
        StringWriter sw = new StringWriter(512);
        PrintWriter pw = new PrintWriter(sw);
        String prefix = "    ";
        String factTableName = this.getFactTableName();
        SqlQuery sqlQuery = this.getSqlQuery();
        pw.print("INSERT INTO ");
        pw.print(this.makeCollapsedAggregateTableName(this.getFactTableName()));
        pw.println(" (");
        for (List<JdbcSchema.Table.Column.Usage> list : this.collapsedColumnUsages.values()) {
            for (JdbcSchema.Table.Column.Usage usage : list) {
                JdbcSchema.Table.Column c2 = usage.getColumn();
                pw.print(prefix);
                if (usage.usagePrefix != null) {
                    pw.print(usage.usagePrefix);
                }
                pw.print(c2.getName());
                pw.println(',');
            }
        }
        for (JdbcSchema.Table.Column.Usage usage : this.measures) {
            JdbcSchema.Table.Column column = usage.getColumn();
            pw.print(prefix);
            String name = this.getUsageName(usage);
            pw.print(name);
            pw.println(',');
        }
        pw.print(prefix);
        pw.print(this.getFactCount());
        pw.println(")");
        pw.println("SELECT");
        for (List list : this.collapsedColumnUsages.values()) {
            for (JdbcSchema.Table.Column.Usage usage : list) {
                JdbcSchema.Table.Column c = usage.getColumn();
                JdbcSchema.Table t = c.getTable();
                pw.print(prefix);
                pw.print(sqlQuery.getDialect().quoteIdentifier(t.getName(), c.getName()));
                pw.print(" AS ");
                String n = usage.usagePrefix == null ? c.getName() : usage.usagePrefix + c.getName();
                pw.print(sqlQuery.getDialect().quoteIdentifier(n));
                pw.println(',');
            }
        }
        for (JdbcSchema.Table.Column.Usage usage : this.measures) {
            JdbcSchema.Table.Column column = usage.getColumn();
            JdbcSchema.Table t = column.getTable();
            RolapAggregator agg = usage.getAggregator();
            pw.print(prefix);
            pw.print(agg.getExpression(sqlQuery.getDialect().quoteIdentifier(t.getName(), column.getName())));
            pw.print(" AS ");
            pw.print(sqlQuery.getDialect().quoteIdentifier(column.getName()));
            pw.println(',');
        }
        pw.print(prefix);
        pw.print("COUNT(*) AS ");
        pw.println(sqlQuery.getDialect().quoteIdentifier(this.getFactCount()));
        pw.println("FROM ");
        pw.print(prefix);
        pw.print(sqlQuery.getDialect().quoteIdentifier(factTableName));
        pw.print(" ");
        pw.print(sqlQuery.getDialect().quoteIdentifier(factTableName));
        pw.println(',');
        int k = 0;
        for (RolapStar.Table table : this.collapsedColumnUsages.keySet()) {
            void var8_27;
            if (k++ > 0) {
                pw.println(',');
            }
            pw.print(prefix);
            pw.print(sqlQuery.getDialect().quoteIdentifier(table.getAlias()));
            pw.print(" AS ");
            pw.print(sqlQuery.getDialect().quoteIdentifier(table.getAlias()));
            if (table.getParentTable() == null) continue;
            while (var8_27.getParentTable().getParentTable() != null) {
                RolapStar.Table table2 = var8_27.getParentTable();
                pw.println(',');
                pw.print(prefix);
                pw.print(sqlQuery.getDialect().quoteIdentifier(table2.getAlias()));
                pw.print(" AS ");
                pw.print(sqlQuery.getDialect().quoteIdentifier(table2.getAlias()));
            }
        }
        pw.println();
        pw.println("WHERE ");
        k = 0;
        for (RolapStar.Table table : this.collapsedColumnUsages.keySet()) {
            void var8_31;
            RolapStar.Condition cond;
            if (k++ > 0) {
                pw.println(" and");
            }
            if ((cond = table.getJoinCondition()) == null) continue;
            pw.print(prefix);
            pw.print(cond.toString(sqlQuery));
            if (table.getParentTable() == null) continue;
            while (var8_31.getParentTable().getParentTable() != null) {
                RolapStar.Table table3 = var8_31.getParentTable();
                cond = table3.getJoinCondition();
                pw.println(" and");
                pw.print(prefix);
                pw.print(cond.toString(sqlQuery));
            }
        }
        pw.println();
        pw.println("GROUP BY ");
        k = 0;
        for (List<JdbcSchema.Table.Column.Usage> list : this.collapsedColumnUsages.values()) {
            for (JdbcSchema.Table.Column.Usage usage : list) {
                if (k++ > 0) {
                    pw.println(",");
                }
                JdbcSchema.Table.Column c3 = usage.getColumn();
                JdbcSchema.Table t = c3.getTable();
                String n = usage.usagePrefix == null ? c3.getName() : usage.usagePrefix + c3.getName();
                pw.print(prefix);
                pw.print(sqlQuery.getDialect().quoteIdentifier(t.getName(), n));
            }
        }
        pw.println(';');
        return sw.toString();
    }

    private String getUsageName(JdbcSchema.Table.Column.Usage usage) {
        JdbcSchema.Table.Column c = usage.getColumn();
        String name = c.getName();
        if (usage.getUsageType() == JdbcSchema.UsageType.MEASURE && c.hasUsage(JdbcSchema.UsageType.FOREIGN_KEY)) {
            name = usage.getSymbolicName().replace(' ', '_').toUpperCase();
        }
        return name;
    }

    private void addColumnCreate(PrintWriter pw, String prefix, JdbcSchema.Table.Column.Usage usage) {
        JdbcSchema.Table.Column c = usage.getColumn();
        String name = this.getUsageName(usage);
        pw.print(prefix);
        if (usage.usagePrefix != null) {
            pw.print(usage.usagePrefix);
        }
        pw.print(name);
        pw.print(' ');
        pw.print(c.getTypeName().toUpperCase());
        switch (c.getType()) {
            case 2: 
            case 3: {
                pw.print('(');
                pw.print(c.getNumPrecRadix());
                pw.print(",");
                pw.print(c.getDecimalDigits());
                pw.print(')');
                break;
            }
            case 1: 
            case 12: {
                pw.print('(');
                pw.print(c.getCharOctetLength());
                pw.print(')');
                break;
            }
        }
        if (!c.isNullable()) {
            pw.print(" NOT NULL");
        }
        pw.println(',');
    }
}

