/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.applemenu;

import com.apple.eawt.Application;
import com.apple.eawt.ApplicationEvent;
import com.apple.eawt.ApplicationListener;
import java.awt.Dialog;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.beans.Beans;
import java.io.File;
import java.util.Collection;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Action;
import javax.swing.JDialog;
import org.openide.cookies.EditCookie;
import org.openide.cookies.OpenCookie;
import org.openide.cookies.ViewCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.util.Lookup;
import org.openide.util.lookup.Lookups;

class NbApplicationAdapter
implements ApplicationListener {
    private static ApplicationListener al = null;

    private NbApplicationAdapter() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void install() {
        boolean wasDesignTime = Beans.isDesignTime();
        try {
            Beans.setDesignTime(false);
            al = new NbApplicationAdapter();
            Application.getApplication().addApplicationListener(al);
            Application.getApplication().setEnabledAboutMenu(true);
            Application.getApplication().setEnabledPreferencesMenu(true);
        }
        finally {
            Beans.setDesignTime(wasDesignTime);
        }
    }

    static void uninstall() {
        if (al != null) {
            Application.getApplication().removeApplicationListener(al);
            al = null;
        }
    }

    public void handleAbout(ApplicationEvent e) {
        Window[] windows = Dialog.getWindows();
        if (null != windows) {
            for (Window w : windows) {
                JDialog dlg;
                if (!(w instanceof JDialog) || !Boolean.TRUE.equals((dlg = (JDialog)w).getRootPane().getClientProperty("nb.about.dialog")) || !dlg.isVisible()) continue;
                dlg.toFront();
                e.setHandled(true);
                return;
            }
        }
        e.setHandled(this.performAction("Help", "org.netbeans.core.actions.AboutAction"));
    }

    public void handleOpenApplication(ApplicationEvent e) {
    }

    public void handleOpenFile(ApplicationEvent e) {
        FileObject obj;
        boolean result = false;
        String fname = e.getFilename();
        File f = new File(fname);
        if (f.exists() && !f.isDirectory() && (obj = FileUtil.toFileObject((File)f)) != null) {
            try {
                DataObject dob = DataObject.find((FileObject)obj);
                OpenCookie oc = (OpenCookie)dob.getLookup().lookup(OpenCookie.class);
                result = oc != null;
                if (result) {
                    oc.open();
                } else {
                    EditCookie ec = (EditCookie)dob.getLookup().lookup(EditCookie.class);
                    result = ec != null;
                    if (result) {
                        ec.edit();
                    } else {
                        ViewCookie v = (ViewCookie)dob.getLookup().lookup(ViewCookie.class);
                        result = v != null;
                        if (result) {
                            v.view();
                        }
                    }
                }
            }
            catch (DataObjectNotFoundException ex) {
                Logger.getLogger(NbApplicationAdapter.class.getName()).log(Level.INFO, fname, ex);
            }
        }
        e.setHandled(result);
    }

    public void handlePreferences(ApplicationEvent e) {
        e.setHandled(this.performAction("Window", "org.netbeans.modules.options.OptionsWindowAction"));
    }

    public void handlePrintFile(ApplicationEvent e) {
    }

    public void handleQuit(ApplicationEvent e) {
        this.performAction("System", "org.netbeans.core.actions.SystemExit");
        e.setHandled(false);
    }

    public void handleReOpenApplication(ApplicationEvent e) {
    }

    private boolean performAction(String category, String id) {
        Lookup lkUp = Lookups.forPath((String)("Actions/" + category));
        Collection actions = lkUp.lookupAll(Action.class);
        for (Action a : actions) {
            System.out.println(a.getClass().getName());
            if (!a.getClass().getName().equals(id)) continue;
            ActionEvent ae = new ActionEvent(this, 1001, "whatever");
            a.actionPerformed(ae);
            return true;
        }
        System.out.println("Unable to find " + id + " in " + category);
        return false;
    }
}

