/*
 * Decompiled with CFR 0.152.
 */
package rex.graphics;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import rex.graphics.Viewer;
import rex.utils.AppColors;
import rex.utils.I18n;
import rex.utils.LanguageChangedEvent;
import rex.utils.LanguageChangedListener;
import rex.utils.S;

public class Toolbar
extends JPanel
implements LanguageChangedListener {
    private static ImageIcon showRowTotalsIcon = S.getAppIcon("toolbox_show_row_totals.gif");
    private static ImageIcon showColumnTotalsIcon;
    private static ImageIcon hideRowTotalsIcon;
    private static ImageIcon hideColumnTotalsIcon;
    private static ImageIcon showMDXIcon;
    private static ImageIcon hideMDXIcon;
    private static ImageIcon newQueryIcon;
    private static ImageIcon runQueryIcon;
    private static ImageIcon refreshQueryIcon;
    private static ImageIcon addChartIcon;
    private static ImageIcon closeViewerIcon;
    private static ImageIcon exportToHTMLIcon;
    private JLabel showRowTotals;
    private JLabel showColumnTotals;
    private JLabel showMDX;
    private JLabel newQuery;
    private JLabel refreshQuery;
    private JLabel addChart;
    private JLabel closeViewer;
    private JLabel runQuery;
    private JLabel exportToHTML;
    private boolean showRowTotalsOn;
    private boolean showColumnTotalsOn;
    private boolean showMDXOn;
    private Viewer viewer;

    public Toolbar(Viewer _viewer) {
        this.viewer = _viewer;
        this.showRowTotalsOn = false;
        this.showColumnTotalsOn = false;
        this.showMDXOn = false;
        this.showColumnTotals = new JLabel(showColumnTotalsIcon);
        this.showColumnTotals.setToolTipText(I18n.getString("toolTip.showColumnTotals"));
        this.showColumnTotals.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                Toolbar.this.showColumnTotalsOn = !Toolbar.this.showColumnTotalsOn;
                if (Toolbar.this.showColumnTotalsOn) {
                    Toolbar.this.showColumnTotals.setIcon(hideColumnTotalsIcon);
                } else {
                    Toolbar.this.showColumnTotals.setIcon(showColumnTotalsIcon);
                }
                Toolbar.this.viewer.setShowColumnTotalsOn(Toolbar.this.showColumnTotalsOn);
            }
        });
        this.showColumnTotals.setBorder(AppColors.TOOLBAR_LABEL_BORDER);
        this.showRowTotals = new JLabel(showRowTotalsIcon);
        this.showRowTotals.setToolTipText(I18n.getString("toolTip.showRowTotals"));
        this.showRowTotals.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                Toolbar.this.showRowTotalsOn = !Toolbar.this.showRowTotalsOn;
                if (Toolbar.this.showRowTotalsOn) {
                    Toolbar.this.showRowTotals.setIcon(hideRowTotalsIcon);
                } else {
                    Toolbar.this.showRowTotals.setIcon(showRowTotalsIcon);
                }
                Toolbar.this.viewer.setShowRowTotalsOn(Toolbar.this.showRowTotalsOn);
            }
        });
        this.showRowTotals.setBorder(AppColors.TOOLBAR_LABEL_BORDER);
        this.showMDX = new JLabel(showMDXIcon);
        this.showMDX.setToolTipText(I18n.getString("toolTip.showMDX"));
        this.showMDX.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                Toolbar.this.showMDXOn = !Toolbar.this.showMDXOn;
                S.out("showMDXOn is now = " + Toolbar.this.showMDXOn);
                if (Toolbar.this.showMDXOn) {
                    Toolbar.this.viewer.makeMDXViewer();
                    Toolbar.this.showMDX.setIcon(hideMDXIcon);
                } else {
                    Toolbar.this.viewer.removeMDXViewer();
                    Toolbar.this.showMDX.setIcon(showMDXIcon);
                }
            }
        });
        this.showMDX.setBorder(AppColors.TOOLBAR_LABEL_BORDER);
        this.newQuery = new JLabel(newQueryIcon);
        this.newQuery.setToolTipText(I18n.getString("toolTip.dropCurrent"));
        this.newQuery.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                Toolbar.this.viewer.newQuery();
            }
        });
        this.newQuery.setBorder(AppColors.TOOLBAR_LABEL_BORDER);
        this.runQuery = new JLabel(runQueryIcon);
        this.runQuery.setToolTipText(I18n.getString("toolTip.runQuery"));
        this.runQuery.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                Toolbar.this.viewer.refreshQuery();
            }
        });
        this.runQuery.setBorder(AppColors.TOOLBAR_LABEL_BORDER);
        this.refreshQuery = new JLabel(refreshQueryIcon);
        this.refreshQuery.setToolTipText(I18n.getString("toolTip.refreshQuery"));
        this.refreshQuery.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                Toolbar.this.viewer.refreshQuery();
            }
        });
        this.refreshQuery.setBorder(AppColors.TOOLBAR_LABEL_BORDER);
        this.addChart = new JLabel(addChartIcon);
        this.addChart.setToolTipText(I18n.getString("toolTip.addChart"));
        this.addChart.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                Toolbar.this.viewer.addChart();
            }
        });
        this.addChart.setBorder(AppColors.TOOLBAR_LABEL_BORDER);
        this.closeViewer = new JLabel(closeViewerIcon);
        this.closeViewer.setToolTipText(I18n.getString("toolTip.closeThisTab"));
        this.closeViewer.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                Toolbar.this.viewer.closeViewer();
            }
        });
        this.closeViewer.setBorder(AppColors.TOOLBAR_LABEL_BORDER);
        this.exportToHTML = new JLabel(exportToHTMLIcon);
        this.exportToHTML.setToolTipText(I18n.getString("toolTip.exportToHtml"));
        this.exportToHTML.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                JOptionPane.showMessageDialog(null, I18n.getString("msgText.notDone"), I18n.getString("msgTitle.exportToHTML"), 0);
            }
        });
        this.exportToHTML.setBorder(AppColors.TOOLBAR_LABEL_BORDER);
        this.setLayout(new BoxLayout(this, 0));
        this.add(Box.createRigidArea(new Dimension(2, 0)));
        this.add(this.newQuery);
        this.add(Box.createRigidArea(new Dimension(2, 0)));
        this.add(this.exportToHTML);
        this.add(Box.createRigidArea(new Dimension(2, 0)));
        this.add(this.refreshQuery);
        this.add(Box.createRigidArea(new Dimension(2, 0)));
        this.add(this.showMDX);
        this.add(Box.createRigidArea(new Dimension(2, 0)));
        this.add(this.showColumnTotals);
        this.add(Box.createRigidArea(new Dimension(2, 0)));
        this.add(this.showRowTotals);
        this.add(Box.createRigidArea(new Dimension(2, 0)));
        this.add(this.addChart);
        this.add(Box.createRigidArea(new Dimension(2, 0)));
        this.add(this.runQuery);
        this.add(Box.createRigidArea(new Dimension(2, 0)));
        this.add(this.closeViewer);
        this.setBorder(AppColors.TOOLBAR_BORDER);
        this.setOpaque(false);
        I18n.addOnLanguageChangedListener(this);
        this.applyI18n();
    }

    public boolean isShowRowTotalsOn() {
        return this.showRowTotalsOn;
    }

    public boolean isShowColumnTotalsOn() {
        return this.showColumnTotalsOn;
    }

    public boolean isShowMDXOn() {
        return this.showMDXOn;
    }

    @Override
    public void paintComponent(Graphics g) {
        S.paintBackgroundHorizontal(g, this);
        super.paintComponent(g);
    }

    @Override
    public void languageChanged(LanguageChangedEvent evt) {
        this.applyI18n();
    }

    public void applyI18n() {
        this.showColumnTotals.setToolTipText(I18n.getString("toolTip.showColumnTotals"));
        this.showRowTotals.setToolTipText(I18n.getString("toolTip.showRowTotals"));
        this.showMDX.setToolTipText(I18n.getString("toolTip.showMDX"));
        this.newQuery.setToolTipText(I18n.getString("toolTip.dropCurrent"));
        this.refreshQuery.setToolTipText(I18n.getString("toolTip.refreshQuery"));
        this.exportToHTML.setToolTipText(I18n.getString("toolTip.exportToHtml"));
        this.addChart.setToolTipText(I18n.getString("toolTip.addChart"));
        this.closeViewer.setToolTipText(I18n.getString("toolTip.closeThisTab"));
    }

    @Override
    public void removeLanguageListener() {
        I18n.removeOnLanguageChangedListener(this);
    }

    static {
        hideRowTotalsIcon = S.getAppIcon("toolbox_hide_row_totals.gif");
        showColumnTotalsIcon = S.getAppIcon("toolbox_show_column_totals.gif");
        hideColumnTotalsIcon = S.getAppIcon("toolbox_hide_column_totals.gif");
        showMDXIcon = S.getAppIcon("toolbox_show_mdx.gif");
        hideMDXIcon = S.getAppIcon("toolbox_hide_mdx.gif");
        newQueryIcon = S.getAppIcon("toolbox_new_query.gif");
        refreshQueryIcon = S.getAppIcon("toolbox_refresh_query.gif");
        addChartIcon = S.getAppIcon("toolbox_add_chart.gif");
        closeViewerIcon = S.getAppIcon("toolbox_close_viewer.gif");
        exportToHTMLIcon = S.getAppIcon("toolbox_export_to_html.gif");
        runQueryIcon = S.getAppIcon("runquery.gif");
    }
}

