/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs.provider.tar;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.vfs.provider.tar.TarBuffer;
import org.apache.commons.vfs.provider.tar.TarEntry;

class TarInputStream
extends FilterInputStream {
    private TarBuffer m_buffer;
    private TarEntry m_currEntry;
    private boolean m_debug;
    private int m_entryOffset;
    private int m_entrySize;
    private boolean m_hasHitEOF;
    private byte[] m_oneBuf;
    private byte[] m_readBuf;

    TarInputStream(InputStream input) {
        this(input, 10240, 512);
    }

    TarInputStream(InputStream input, int blockSize) {
        this(input, blockSize, 512);
    }

    TarInputStream(InputStream input, int blockSize, int recordSize) {
        super(input);
        this.m_buffer = new TarBuffer(input, blockSize, recordSize);
        this.m_oneBuf = new byte[1];
    }

    public void setDebug(boolean debug) {
        this.m_debug = debug;
        this.m_buffer.setDebug(debug);
    }

    public TarEntry getNextEntry() throws IOException {
        byte[] headerBuf;
        String message;
        if (this.m_hasHitEOF) {
            return null;
        }
        if (this.m_currEntry != null) {
            int numToSkip = this.m_entrySize - this.m_entryOffset;
            if (this.m_debug) {
                message = "TarInputStream: SKIP currENTRY '" + this.m_currEntry.getName() + "' SZ " + this.m_entrySize + " OFF " + this.m_entryOffset + "  skipping " + numToSkip + " bytes";
                this.debug(message);
            }
            if (numToSkip > 0) {
                this.skip(numToSkip);
            }
            this.m_readBuf = null;
        }
        if ((headerBuf = this.m_buffer.readRecord()) == null) {
            if (this.m_debug) {
                this.debug("READ NULL RECORD");
            }
            this.m_hasHitEOF = true;
        } else if (this.m_buffer.isEOFRecord(headerBuf)) {
            if (this.m_debug) {
                this.debug("READ EOF RECORD");
            }
            this.m_hasHitEOF = true;
        }
        if (this.m_hasHitEOF) {
            this.m_currEntry = null;
        } else {
            this.m_currEntry = new TarEntry(headerBuf);
            if (headerBuf[257] != 117 || headerBuf[258] != 115 || headerBuf[259] != 116 || headerBuf[260] != 97 || headerBuf[261] != 114) {
                // empty if block
            }
            if (this.m_debug) {
                message = "TarInputStream: SET CURRENTRY '" + this.m_currEntry.getName() + "' size = " + this.m_currEntry.getSize();
                this.debug(message);
            }
            this.m_entryOffset = 0;
            this.m_entrySize = (int)this.m_currEntry.getSize();
        }
        if (null != this.m_currEntry && this.m_currEntry.isGNULongNameEntry()) {
            StringBuffer longName = new StringBuffer();
            byte[] buffer = new byte[256];
            int length = 0;
            while ((length = this.read(buffer)) >= 0) {
                String str = new String(buffer, 0, length);
                longName.append(str);
            }
            this.getNextEntry();
            if (longName.length() > 0 && longName.charAt(longName.length() - 1) == '\u0000') {
                longName.deleteCharAt(longName.length() - 1);
            }
            this.m_currEntry.setName(longName.toString());
        }
        return this.m_currEntry;
    }

    public int getRecordSize() {
        return this.m_buffer.getRecordSize();
    }

    public int available() throws IOException {
        return this.m_entrySize - this.m_entryOffset;
    }

    public void close() throws IOException {
        this.m_buffer.close();
    }

    public void copyEntryContents(OutputStream output) throws IOException {
        int numRead;
        byte[] buffer = new byte[32768];
        while ((numRead = this.read(buffer, 0, buffer.length)) != -1) {
            output.write(buffer, 0, numRead);
        }
    }

    public void mark(int markLimit) {
    }

    public boolean markSupported() {
        return false;
    }

    public int read() throws IOException {
        int num = this.read(this.m_oneBuf, 0, 1);
        if (num == -1) {
            return num;
        }
        return this.m_oneBuf[0];
    }

    public int read(byte[] buffer) throws IOException {
        return this.read(buffer, 0, buffer.length);
    }

    public int read(byte[] buffer, int offset, int count) throws IOException {
        int position = offset;
        int numToRead = count;
        int totalRead = 0;
        if (this.m_entryOffset >= this.m_entrySize) {
            return -1;
        }
        if (numToRead + this.m_entryOffset > this.m_entrySize) {
            numToRead = this.m_entrySize - this.m_entryOffset;
        }
        if (null != this.m_readBuf) {
            int size = numToRead > this.m_readBuf.length ? this.m_readBuf.length : numToRead;
            System.arraycopy(this.m_readBuf, 0, buffer, position, size);
            if (size >= this.m_readBuf.length) {
                this.m_readBuf = null;
            } else {
                int newLength = this.m_readBuf.length - size;
                byte[] newBuffer = new byte[newLength];
                System.arraycopy(this.m_readBuf, size, newBuffer, 0, newLength);
                this.m_readBuf = newBuffer;
            }
            totalRead += size;
            numToRead -= size;
            position += size;
        }
        while (numToRead > 0) {
            byte[] rec = this.m_buffer.readRecord();
            if (null == rec) {
                String message = "unexpected EOF with " + numToRead + " bytes unread";
                throw new IOException(message);
            }
            int recordLength = rec.length;
            int size = numToRead;
            if (recordLength > size) {
                System.arraycopy(rec, 0, buffer, position, size);
                this.m_readBuf = new byte[recordLength - size];
                System.arraycopy(rec, size, this.m_readBuf, 0, recordLength - size);
            } else {
                size = recordLength;
                System.arraycopy(rec, 0, buffer, position, recordLength);
            }
            totalRead += size;
            numToRead -= size;
            position += size;
        }
        this.m_entryOffset += totalRead;
        return totalRead;
    }

    public void reset() {
    }

    public void skip(int numToSkip) throws IOException {
        int count;
        int numRead;
        byte[] skipBuf = new byte[8192];
        for (int num = numToSkip; num > 0 && (numRead = this.read(skipBuf, 0, count = num > skipBuf.length ? skipBuf.length : num)) != -1; num -= numRead) {
        }
    }

    protected void debug(String message) {
        if (this.m_debug) {
            System.err.println(message);
        }
    }
}

