/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.sql.editor.ui.actions;

import org.netbeans.modules.db.api.sql.execute.SQLExecution;
import org.netbeans.modules.db.sql.editor.ui.actions.SQLExecutionBaseAction;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.Repository;
import org.openide.util.NbBundle;

public class SQLHistoryAction
extends SQLExecutionBaseAction {
    private static final String ICON_PATH = "org/netbeans/modules/db/sql/editor/resources/sql_history_16.png";
    private static final String SQL_HISTORY_FOLDER = "Databases/SQLHISTORY";

    protected String getIconBase() {
        return ICON_PATH;
    }

    protected String getDisplayName(SQLExecution sQLExecution) {
        return NbBundle.getMessage(SQLHistoryAction.class, (String)"LBL_SQLHistoryAction");
    }

    protected void actionPerformed(SQLExecution sQLExecution) {
        FileObject fileObject = Repository.getDefault().getDefaultFileSystem().getRoot().getFileObject(SQL_HISTORY_FOLDER);
        if (fileObject == null || fileObject.getChildren().length == 0) {
            SQLHistoryAction.notifyNoSQLExecuted();
        } else {
            fileObject.refresh(true);
            sQLExecution.showHistory();
        }
    }

    private static void notifyNoSQLExecuted() {
        String string = NbBundle.getMessage(SQLExecutionBaseAction.class, (String)"LBL_NoSQLExecuted");
        NotifyDescriptor.Message message = new NotifyDescriptor.Message((Object)string, 1);
        DialogDisplayer.getDefault().notify((NotifyDescriptor)message);
    }
}

